#ifndef INCLUDED_TEST_H
#define INCLUDED_TEST_H
/* vim: set ts=8 sts=4 sw=4 tw=80 noet: */
/*======================================================================
Copyright (C) 2004,2005,2009,2013 Walter Doekes <walter+tthsum@wjd.nu>
This file is part of tthsum.

tthsum is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

tthsum is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with tthsum.  If not, see <http://www.gnu.org/licenses/>.
======================================================================*/

/**
 * Utility macros for the test suite. You'll find some duplicate code
 * below because macro varargs are not portable.
 */

#include <stdio.h>

#define TESTS(title) \
    void title(unsigned* success, unsigned *failure, unsigned *warning) { \
	printf("+ " #title ": ");
#define TEST(func) \
    do { \
	if (func() == 0) { \
	    printf("."); \
	    ++*success; \
	} else { \
	    printf("F"); \
	    ++*failure; \
	} \
    } while (0)
#define TEST_WARN(func) \
    do { \
	if (func() == 0) { \
	    printf("."); \
	    ++*success; \
	} else { \
	    printf("w"); \
	    ++*warning; \
	} \
    } while (0)
#define ENDTESTS \
	printf("\n"); \
    }

#define FAIL(msg) \
    do { \
	fprintf(stderr, ">>> %s:%i: " msg "\n", __FILE__, __LINE__); \
	return 1; \
    } while(0)

#define FAIL1(msg, a) \
    do { \
	fprintf(stderr, ">>> %s:%i: " msg "\n", __FILE__, __LINE__, a); \
	return 1; \
    } while(0)

#define FAIL2(msg, a, b) \
    do { \
	fprintf(stderr, ">>> %s:%i: " msg "\n", __FILE__, __LINE__, a, b); \
	return 1; \
    } while(0)

#define FAIL3(msg, a, b, c) \
    do { \
	fprintf(stderr, ">>> %s:%i: " msg "\n", __FILE__, __LINE__, a, b, c); \
	return 1; \
    } while(0)

#define TEST_PASS(test, msg) \
    do { \
	if (!(test)) \
	    FAIL(msg); \
    } while(0)

#define TEST_PASS1(test, msg, a) \
    do { \
	if (!(test)) \
	    FAIL1(msg, a); \
    } while(0)

#define TEST_PASS2(test, msg, a, b) \
    do { \
	if (!(test)) \
	    FAIL2(msg, a, b); \
    } while(0)

#define TEST_PASS3(test, msg, a, b, c) \
    do { \
	if (!(test)) \
	    FAIL3(msg, a, b, c); \
    } while(0)

#endif /* INCLUDED_TEST_H */
