// @HEADER
//
// ***********************************************************************
//
//             Xpetra: A linear algebra interface package
//                  Copyright 2012 Sandia Corporation
//
// Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
// the U.S. Government retains certain rights in this software.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
// 1. Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the
// documentation and/or other materials provided with the distribution.
//
// 3. Neither the name of the Corporation nor the names of the
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY SANDIA CORPORATION "AS IS" AND ANY
// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
// PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SANDIA CORPORATION OR THE
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
// EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
// PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
// PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
// LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
// NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// Questions? Contact
//                    Jonathan Hu       (jhu@sandia.gov)
//                    Andrey Prokopenko (aprokop@sandia.gov)
//                    Ray Tuminaro      (rstumin@sandia.gov)
//
// ***********************************************************************
//
// @HEADER
#ifndef XPETRA_TPETRAEXPORT_HPP
#define XPETRA_TPETRAEXPORT_HPP

/* this file is automatically generated - do not edit (see script/tpetra.py) */

#include "Xpetra_TpetraConfigDefs.hpp"

#include "Xpetra_Export.hpp"
#include "Xpetra_Exceptions.hpp"

#include "Xpetra_TpetraMap.hpp"
#include "Tpetra_Export.hpp"

// Note: 'export' is a reserved keyword in C++. Do not use 'export' as a variable name.

namespace Xpetra {

  // TODO: move that elsewhere
  template <class LocalOrdinal, class GlobalOrdinal, class Node>
  const Tpetra::Export<LocalOrdinal,GlobalOrdinal,Node> & toTpetra(const Export<LocalOrdinal,GlobalOrdinal,Node> &);

  template <class LocalOrdinal, class GlobalOrdinal, class Node>
  RCP<const Export<LocalOrdinal,GlobalOrdinal,Node> > toXpetra(const RCP<const Tpetra::Export<LocalOrdinal,GlobalOrdinal,Node> >& exp);

  template <class LocalOrdinal = Export<>::local_ordinal_type,
            class GlobalOrdinal = typename Export<LocalOrdinal>::global_ordinal_type,
            class Node = typename Export<LocalOrdinal, GlobalOrdinal>::node_type>
  class TpetraExport
    : public Export<LocalOrdinal, GlobalOrdinal, Node>
  {

  public:

      //! The specialization of Map used by this class.
      typedef Map<LocalOrdinal,GlobalOrdinal,Node> map_type;

    //! @name Constructor/Destructor Methods
    //@{

    //! Construct a Export object from the source and target Map.
    TpetraExport(const Teuchos::RCP< const map_type > &source, const Teuchos::RCP< const map_type > &target)
      : export_(Teuchos::rcp(new Tpetra::Export< LocalOrdinal, GlobalOrdinal, Node >(toTpetra(source), toTpetra(target)))) {  }

    //! Constructor (with list of parameters).
    TpetraExport(const Teuchos::RCP< const map_type > &source, const Teuchos::RCP< const map_type > &target, const Teuchos::RCP< Teuchos::ParameterList > &plist)
      : export_(Teuchos::rcp(new Tpetra::Export< LocalOrdinal, GlobalOrdinal, Node >(toTpetra(source), toTpetra(target), plist))) {  }

    //! Copy constructor.
    TpetraExport(const Export< LocalOrdinal, GlobalOrdinal, Node > &rhs)
      : export_(Teuchos::rcp(new Tpetra::Export< LocalOrdinal, GlobalOrdinal, Node >(toTpetra(rhs)))) {  }

    //! Destructor.
    ~TpetraExport() {  }

    //@}

    //! @name Export Attribute Methods
    //@{

    //! Number of initial identical IDs.
    size_t getNumSameIDs() const { XPETRA_MONITOR("TpetraExport::getNumSameIDs"); return export_->getNumSameIDs(); }

    //! Number of IDs to permute but not to communicate.
    size_t getNumPermuteIDs() const { XPETRA_MONITOR("TpetraExport::getNumPermuteIDs"); return export_->getNumPermuteIDs(); }

    //! List of local IDs in the source Map that are permuted.
    ArrayView< const LocalOrdinal > getPermuteFromLIDs() const { XPETRA_MONITOR("TpetraExport::getPermuteFromLIDs"); return export_->getPermuteFromLIDs(); }

    //! List of local IDs in the target Map that are permuted.
    ArrayView< const LocalOrdinal > getPermuteToLIDs() const { XPETRA_MONITOR("TpetraExport::getPermuteToLIDs"); return export_->getPermuteToLIDs(); }

    //! Number of entries not on the calling process.
    size_t getNumRemoteIDs() const { XPETRA_MONITOR("TpetraExport::getNumRemoteIDs"); return export_->getNumRemoteIDs(); }

    //! List of entries in the target Map to receive from other processes.
    ArrayView< const LocalOrdinal > getRemoteLIDs() const { XPETRA_MONITOR("TpetraExport::getRemoteLIDs"); return export_->getRemoteLIDs(); }

    //! Number of entries that must be sent by the calling process to other processes.
    size_t getNumExportIDs() const { XPETRA_MONITOR("TpetraExport::getNumExportIDs"); return export_->getNumExportIDs(); }

    //! List of entries in the source Map that will be sent to other processes.
    ArrayView< const LocalOrdinal > getExportLIDs() const { XPETRA_MONITOR("TpetraExport::getExportLIDs"); return export_->getExportLIDs(); }

    //! List of processes to which entries will be sent.
    ArrayView< const int > getExportPIDs() const { XPETRA_MONITOR("TpetraExport::getExportPIDs"); return export_->getExportPIDs(); }

    //! The source Map used to construct this Export.
    Teuchos::RCP< const Map< LocalOrdinal, GlobalOrdinal, Node > > getSourceMap() const { XPETRA_MONITOR("TpetraExport::getSourceMap"); return toXpetra(export_->getSourceMap()); }

    //! The target Map used to construct this Export.
    Teuchos::RCP< const Map< LocalOrdinal, GlobalOrdinal, Node > > getTargetMap() const { XPETRA_MONITOR("TpetraExport::getTargetMap"); return toXpetra(export_->getTargetMap()); }

    //@}

    //! @name I/O Methods
    //@{

    //! Print the Export's data to the given output stream.
    void print(std::ostream &os) const { XPETRA_MONITOR("TpetraExport::print"); export_->print(os); }

    //@}

    //! @name Xpetra specific
    //@{

    //! TpetraExport constructor to wrap a Tpetra::Export object
    TpetraExport(const RCP<const Tpetra::Export< LocalOrdinal, GlobalOrdinal, Node > > &exp) : export_(exp) {  }

    RCP< const Tpetra::Export< LocalOrdinal, GlobalOrdinal, Node > > getTpetra_Export() const { return export_; }

    //@}

  private:

    RCP<const Tpetra::Export< LocalOrdinal, GlobalOrdinal, Node > > export_;

  }; // TpetraExport class

#ifdef HAVE_XPETRA_EPETRA

#if ((defined(EPETRA_HAVE_OMP) && (!defined(HAVE_TPETRA_INST_OPENMP) || !defined(HAVE_TPETRA_INST_INT_INT))) || \
    (!defined(EPETRA_HAVE_OMP) && (!defined(HAVE_TPETRA_INST_SERIAL) || !defined(HAVE_TPETRA_INST_INT_INT))))

  // stub implementation for GO=int and NO=EpetraNode
  template <>
  class TpetraExport<int, int, EpetraNode> : public Export<int, int, EpetraNode>
  {

  public:
      typedef int LocalOrdinal;
      typedef int GlobalOrdinal;
      typedef EpetraNode Node;

      //! The specialization of Map used by this class.
      typedef Map<LocalOrdinal,GlobalOrdinal,Node> map_type;

    //! @name Constructor/Destructor Methods
    //@{

    //! Construct a Export object from the source and target Map.
    TpetraExport(const Teuchos::RCP< const map_type > &source, const Teuchos::RCP< const map_type > &target) {
      XPETRA_TPETRA_ETI_EXCEPTION( typeid(TpetraExport<LocalOrdinal,GlobalOrdinal,EpetraNode>).name() , typeid(TpetraExport<LocalOrdinal,GlobalOrdinal,EpetraNode>).name(), "int", typeid(EpetraNode).name() );
    }

    //! Constructor (with list of parameters).
    TpetraExport(const Teuchos::RCP< const map_type > &source, const Teuchos::RCP< const map_type > &target, const Teuchos::RCP< Teuchos::ParameterList > &plist) {
      XPETRA_TPETRA_ETI_EXCEPTION( typeid(TpetraExport<LocalOrdinal,GlobalOrdinal,EpetraNode>).name() , typeid(TpetraExport<LocalOrdinal,GlobalOrdinal,EpetraNode>).name(), "int", typeid(EpetraNode).name() );
    }

    //! Copy constructor.
    TpetraExport(const Export< LocalOrdinal, GlobalOrdinal, Node > &rhs) {
      XPETRA_TPETRA_ETI_EXCEPTION( typeid(TpetraExport<LocalOrdinal,GlobalOrdinal,EpetraNode>).name() , typeid(TpetraExport<LocalOrdinal,GlobalOrdinal,EpetraNode>).name(), "int", typeid(EpetraNode).name() );
    }

    //! Destructor.
    ~TpetraExport() {  }

    //@}

    //! @name Export Attribute Methods
    //@{

    //! Number of initial identical IDs.
    size_t getNumSameIDs() const { return 0; }

    //! Number of IDs to permute but not to communicate.
    size_t getNumPermuteIDs() const { return 0; }

    //! List of local IDs in the source Map that are permuted.
    ArrayView< const LocalOrdinal > getPermuteFromLIDs() const { return Teuchos::ArrayView<const LocalOrdinal>(); }

    //! List of local IDs in the target Map that are permuted.
    ArrayView< const LocalOrdinal > getPermuteToLIDs() const { return Teuchos::ArrayView< const LocalOrdinal>(); }

    //! Number of entries not on the calling process.
    size_t getNumRemoteIDs() const { return 0; }

    //! List of entries in the target Map to receive from other processes.
    ArrayView< const LocalOrdinal > getRemoteLIDs() const { return Teuchos::ArrayView<const LocalOrdinal>(); }

    //! Number of entries that must be sent by the calling process to other processes.
    size_t getNumExportIDs() const { return 0; }

    //! List of entries in the source Map that will be sent to other processes.
    ArrayView< const LocalOrdinal > getExportLIDs() const { return Teuchos::ArrayView<const LocalOrdinal>(); }

    //! List of processes to which entries will be sent.
    ArrayView< const int > getExportPIDs() const { return Teuchos::ArrayView< const int >(); }

    //! The source Map used to construct this Export.
    Teuchos::RCP< const Map< LocalOrdinal, GlobalOrdinal, Node > > getSourceMap() const { return Teuchos::null; }

    //! The target Map used to construct this Export.
    Teuchos::RCP< const Map< LocalOrdinal, GlobalOrdinal, Node > > getTargetMap() const { return Teuchos::null; }

    //@}

    //! @name I/O Methods
    //@{

    //! Print the Export's data to the given output stream.
    void print(std::ostream &os) const { /* noop */ }

    //@}

    //! @name Xpetra specific
    //@{

    //! TpetraExport constructor to wrap a Tpetra::Export object
    TpetraExport(const RCP<const Tpetra::Export< LocalOrdinal, GlobalOrdinal, Node > > &exp)  {
      XPETRA_TPETRA_ETI_EXCEPTION( typeid(TpetraExport<LocalOrdinal,GlobalOrdinal,EpetraNode>).name() , typeid(TpetraExport<LocalOrdinal,GlobalOrdinal,EpetraNode>).name(), "int", typeid(EpetraNode).name() );
    }

    RCP< const Tpetra::Export< LocalOrdinal, GlobalOrdinal, Node > > getTpetra_Export() const { return Teuchos::null; }

    //@}

  }; // TpetraExport class (specialization for LO=GO=int)
#endif

#if ((defined(EPETRA_HAVE_OMP) && (!defined(HAVE_TPETRA_INST_OPENMP) || !defined(HAVE_TPETRA_INST_INT_LONG_LONG))) || \
    (!defined(EPETRA_HAVE_OMP) && (!defined(HAVE_TPETRA_INST_SERIAL) || !defined(HAVE_TPETRA_INST_INT_LONG_LONG))))

  // stub implementation for GO=long long and NO=EpetraNode
  template <>
  class TpetraExport<int, long long, EpetraNode> : public Export<int, long long, EpetraNode>
  {

  public:
      typedef int LocalOrdinal;
      typedef long long GlobalOrdinal;
      typedef EpetraNode Node;

      //! The specialization of Map used by this class.
      typedef Map<LocalOrdinal,GlobalOrdinal,Node> map_type;

    //! @name Constructor/Destructor Methods
    //@{

    //! Construct a Export object from the source and target Map.
    TpetraExport(const Teuchos::RCP< const map_type > &source, const Teuchos::RCP< const map_type > &target) {
      XPETRA_TPETRA_ETI_EXCEPTION( typeid(TpetraExport<LocalOrdinal,GlobalOrdinal,EpetraNode>).name() , typeid(TpetraExport<LocalOrdinal,GlobalOrdinal,EpetraNode>).name(), "long long", typeid(EpetraNode).name() );
    }

    //! Constructor (with list of parameters).
    TpetraExport(const Teuchos::RCP< const map_type > &source, const Teuchos::RCP< const map_type > &target, const Teuchos::RCP< Teuchos::ParameterList > &plist) {
      XPETRA_TPETRA_ETI_EXCEPTION( typeid(TpetraExport<LocalOrdinal,GlobalOrdinal,EpetraNode>).name() , typeid(TpetraExport<LocalOrdinal,GlobalOrdinal,EpetraNode>).name(), "long long", typeid(EpetraNode).name() );
    }

    //! Copy constructor.
    TpetraExport(const Export< LocalOrdinal, GlobalOrdinal, Node > &rhs) {
      XPETRA_TPETRA_ETI_EXCEPTION( typeid(TpetraExport<LocalOrdinal,GlobalOrdinal,EpetraNode>).name() , typeid(TpetraExport<LocalOrdinal,GlobalOrdinal,EpetraNode>).name(), "long long", typeid(EpetraNode).name() );
    }

    //! Destructor.
    ~TpetraExport() {  }

    //@}

    //! @name Export Attribute Methods
    //@{

    //! Number of initial identical IDs.
    size_t getNumSameIDs() const { return 0; }

    //! Number of IDs to permute but not to communicate.
    size_t getNumPermuteIDs() const { return 0; }

    //! List of local IDs in the source Map that are permuted.
    ArrayView< const LocalOrdinal > getPermuteFromLIDs() const { return Teuchos::ArrayView<const LocalOrdinal>(); }

    //! List of local IDs in the target Map that are permuted.
    ArrayView< const LocalOrdinal > getPermuteToLIDs() const { return Teuchos::ArrayView< const LocalOrdinal>(); }

    //! Number of entries not on the calling process.
    size_t getNumRemoteIDs() const { return 0; }

    //! List of entries in the target Map to receive from other processes.
    ArrayView< const LocalOrdinal > getRemoteLIDs() const { return Teuchos::ArrayView<const LocalOrdinal>(); }

    //! Number of entries that must be sent by the calling process to other processes.
    size_t getNumExportIDs() const { return 0; }

    //! List of entries in the source Map that will be sent to other processes.
    ArrayView< const LocalOrdinal > getExportLIDs() const { return Teuchos::ArrayView<const LocalOrdinal>(); }

    //! List of processes to which entries will be sent.
    ArrayView< const int > getExportPIDs() const { return Teuchos::ArrayView< const int >(); }

    //! The source Map used to construct this Export.
    Teuchos::RCP< const Map< LocalOrdinal, GlobalOrdinal, Node > > getSourceMap() const { return Teuchos::null; }

    //! The target Map used to construct this Export.
    Teuchos::RCP< const Map< LocalOrdinal, GlobalOrdinal, Node > > getTargetMap() const { return Teuchos::null; }

    //@}

    //! @name I/O Methods
    //@{

    //! Print the Export's data to the given output stream.
    void print(std::ostream &os) const { /* noop */ }

    //@}

    //! @name Xpetra specific
    //@{

    //! TpetraExport constructor to wrap a Tpetra::Export object
    TpetraExport(const RCP<const Tpetra::Export< LocalOrdinal, GlobalOrdinal, Node > > &exp)  {
      XPETRA_TPETRA_ETI_EXCEPTION( typeid(TpetraExport<LocalOrdinal,GlobalOrdinal,EpetraNode>).name() , typeid(TpetraExport<LocalOrdinal,GlobalOrdinal,EpetraNode>).name(), "long long", typeid(EpetraNode).name() );
    }

    RCP< const Tpetra::Export< LocalOrdinal, GlobalOrdinal, Node > > getTpetra_Export() const { return Teuchos::null; }

    //@}

  }; // TpetraExport class (specialization for GO=long long, NO=EpetraNode)
#endif

#endif // HAVE_XPETRA_EPETRA

  // TODO: move that elsewhere
  template <class LocalOrdinal, class GlobalOrdinal, class Node>
  const Tpetra::Export<LocalOrdinal,GlobalOrdinal,Node> & toTpetra(const Export<LocalOrdinal,GlobalOrdinal,Node> &exp) {
    // TODO: throw exception
    const TpetraExport<LocalOrdinal,GlobalOrdinal,Node> & tpetraExport = dynamic_cast<const TpetraExport<LocalOrdinal,GlobalOrdinal,Node> &>(exp);
    return *tpetraExport.getTpetra_Export();
  }

  template<class LocalOrdinal, class GlobalOrdinal, class Node>
  RCP<const Export<LocalOrdinal,GlobalOrdinal,Node> > toXpetra(const RCP<const Tpetra::Export<LocalOrdinal,GlobalOrdinal,Node> >& exp) {
    if (!exp.is_null())
      return rcp(new TpetraExport<LocalOrdinal,GlobalOrdinal,Node>(exp));

    return Teuchos::null;
  }
} // Xpetra namespace

#define XPETRA_TPETRAEXPORT_SHORT
#endif // XPETRA_TPETRAEXPORT_HPP
