/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-get.
 *
 *   Swac-get is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Swac-get is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Foobar; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <string>
#include <string.h>
#include <list>
#include <iostream>
#include <stdio.h>

#include "basic.hh"

#include "swac_db.hh"
#include "swac_db.inc"
#include "swac_db_lang.inc"


bool Tswac_db::db_open(char const *path) {
	bool result = db.open(path);
	db.query("PRAGMA synchronous=OFF;");
	return result;
}

void Tswac_db::db_clear() {
	print_action("CLEAR DATABASE");
	db.query("DELETE FROM sounds; DELETE FROM alphaidx; DELETE FROM packages; DELETE FROM packages_available;");
	print_result(true);
}

bool Tswac_db::db_close() {
	return db.close();
}

bool Tswac_db::db_init() {
	print_action("INITIALIZE DATABASE");

	db.query(
	"CREATE TABLE packages ( \
	  `idx` INTEGER PRIMARY KEY AUTOINCREMENT, \
	  `path` varchar(128) NOT NULL default '', \
	  `packid` varchar(32) NOT NULL default '', \
	  `version` varchar(32) NOT NULL default '', \
	  `format` varchar(8) NOT NULL default '', \
	  `name` varchar(64) NOT NULL default '', \
	  `organization` varchar(64) NOT NULL default '', \
	  `organization_url` varchar(128) NOT NULL default '', \
	  `readme` text NOT NULL default '' \
	); \
	\
	CREATE TABLE packages_available ( \
	  `idx` INTEGER PRIMARY KEY AUTOINCREMENT, \
	  `path` varchar(128) NOT NULL default '', \
	  `packid` varchar(32) NOT NULL default '', \
	  `version` varchar(32) NOT NULL default '', \
	  `format` varchar(8) NOT NULL default '', \
	  `name` varchar(64) NOT NULL default '', \
	  `organization` varchar(64) NOT NULL default '', \
	  `organization_url` varchar(128) NOT NULL default '', \
	  `readme` text NOT NULL default '' \
	); \
	\
	CREATE TABLE sources ( \
	  `idx` INTEGER PRIMARY KEY AUTOINCREMENT, \
	  `path` varchar(128) NOT NULL default '', \
	  `selected` varchar(128) NOT NULL default ''\
	); \
	\
	CREATE TABLE alphaidx ( \
	  `idx` INTEGER PRIMARY KEY AUTOINCREMENT, \
	  `str` varchar(64) NOT NULL default '', \
	  `packages_idx` INTEGER NOT NULL default 0, \
	  `sounds_idx` INTEGER NOT NULL default 0 \
	); \
	\
	CREATE TABLE languages ( \
	  `iso_639_3` varchar(3) PRIMARY KEY, \
	  `iso_639_1` varchar(2) NOT NULL default '', \
	  `title` varchar(64) NOT NULL default '' \
	);");

	db_init_sounds();
	db_init_languages();
	
	db.query("\
		CREATE INDEX sounds_swac_text ON sounds(SWAC_TEXT); \
		CREATE INDEX alphaidx_str ON alphaidx(str);\
	");

	print_result(true);
}

