/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_IMPORTCMD_H
#define _SC_IMPORTCMD_H

// sc
#include "ScCmd.h"
#include "svn/svn.h"
class ImportParam;
class CmdResultCallback;

/**
 * Command for importing a fil/folder into a repository.
 */
class ImportCmd : public ScCmd
{
public:
  /**
   * Construct a ImportCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  ImportCmd( ImportParam* param, CmdResultCallback* cb );
  ~ImportCmd();

  void run();

private:
  // in
  ImportParam*       _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_IMPORTCMD_H
