-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

package body Symbol_Set
is

   procedure Initialise (The_Set : out T)
   is
   begin
      Heap.Initialize (The_Set.The_Heap);
      SeqAlgebra.CreateSeq (TheHeap => The_Set.The_Heap,
                            S       => The_Set.The_Symbols);
   end Initialise;

   procedure Add (The_Set : in out T;
                  Sym     : in     Dictionary.Symbol)
   is
   begin
      SeqAlgebra.AddMember
        (TheHeap    => The_Set.The_Heap,
         S          => The_Set.The_Symbols,
         GivenValue => Natural (Dictionary.SymbolRef (Sym)));
   end Add;

   procedure Remove (The_Set : in out T;
                     Sym     : in     Dictionary.Symbol)
   is
   begin
      SeqAlgebra.RemoveMember
        (TheHeap    => The_Set.The_Heap,
         S          => The_Set.The_Symbols,
         GivenValue => Natural (Dictionary.SymbolRef (Sym)));
   end Remove;

   function Contains (The_Set : in T;
                      Sym     : in Dictionary.Symbol)
                     return Boolean
   is
   begin
      return SeqAlgebra.IsMember
        (TheHeap    => The_Set.The_Heap,
         S          => The_Set.The_Symbols,
         GivenValue => Natural (Dictionary.SymbolRef (Sym)));
   end Contains;

end Symbol_Set;
