# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.0.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::AnalysisServices
  #
  # The Azure Analysis Services Web API provides a RESTful set of web services
  # that enables users to create, retrieve, update, and delete Analysis
  # Services servers
  #
  class Servers
    include Azure::ARM::AnalysisServices::Models
    include MsRestAzure

    #
    # Creates and initializes a new instance of the Servers class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [AnalysisServicesManagementClient] reference to the AnalysisServicesManagementClient
    attr_reader :client

    #
    # Gets details about the specified Analysis Services server.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be a minimum of 3 characters, and a maximum of 63.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AnalysisServicesServer] operation results.
    #
    def get_details(resource_group_name, server_name, custom_headers = nil)
      response = get_details_async(resource_group_name, server_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets details about the specified Analysis Services server.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be a minimum of 3 characters, and a maximum of 63.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_details_with_http_info(resource_group_name, server_name, custom_headers = nil)
      get_details_async(resource_group_name, server_name, custom_headers).value!
    end

    #
    # Gets details about the specified Analysis Services server.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be a minimum of 3 characters, and a maximum of 63.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_details_async(resource_group_name, server_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'server_name is nil' if server_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'serverName' => server_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = AnalysisServicesServer.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Provisions the specified Analysis Services server based on the configuration
    # specified in the request.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be a minimum of 3 characters, and a maximum of 63.
    # @param server_parameters [AnalysisServicesServer] Contains the information
    # used to provision the Analysis Services server.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AnalysisServicesServer] operation results.
    #
    def create(resource_group_name, server_name, server_parameters, custom_headers = nil)
      response = create_async(resource_group_name, server_name, server_parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be a minimum of 3 characters, and a maximum of 63.
    # @param server_parameters [AnalysisServicesServer] Contains the information
    # used to provision the Analysis Services server.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_async(resource_group_name, server_name, server_parameters, custom_headers = nil)
      # Send request
      promise = begin_create_async(resource_group_name, server_name, server_parameters, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = AnalysisServicesServer.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Deletes the specified Analysis Services server.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be at least 3 characters in length, and no more than 63.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete(resource_group_name, server_name, custom_headers = nil)
      response = delete_async(resource_group_name, server_name, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be at least 3 characters in length, and no more than 63.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, server_name, custom_headers = nil)
      # Send request
      promise = begin_delete_async(resource_group_name, server_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Updates the current state of the specified Analysis Services server.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be at least 3 characters in length, and no more than 63.
    # @param server_update_parameters [AnalysisServicesServerUpdateParameters]
    # Request object that contains the updated information for the server.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AnalysisServicesServer] operation results.
    #
    def update(resource_group_name, server_name, server_update_parameters, custom_headers = nil)
      response = update_async(resource_group_name, server_name, server_update_parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the current state of the specified Analysis Services server.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be at least 3 characters in length, and no more than 63.
    # @param server_update_parameters [AnalysisServicesServerUpdateParameters]
    # Request object that contains the updated information for the server.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_with_http_info(resource_group_name, server_name, server_update_parameters, custom_headers = nil)
      update_async(resource_group_name, server_name, server_update_parameters, custom_headers).value!
    end

    #
    # Updates the current state of the specified Analysis Services server.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be at least 3 characters in length, and no more than 63.
    # @param server_update_parameters [AnalysisServicesServerUpdateParameters]
    # Request object that contains the updated information for the server.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_async(resource_group_name, server_name, server_update_parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'server_name is nil' if server_name.nil?
      fail ArgumentError, 'server_update_parameters is nil' if server_update_parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = AnalysisServicesServerUpdateParameters.mapper()
      request_content = @client.serialize(request_mapper,  server_update_parameters, 'server_update_parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'serverName' => server_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = AnalysisServicesServer.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Supends operation of the specified Analysis Services server instance.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be at least 3 characters in length, and no more than 63.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def suspend(resource_group_name, server_name, custom_headers = nil)
      response = suspend_async(resource_group_name, server_name, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be at least 3 characters in length, and no more than 63.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def suspend_async(resource_group_name, server_name, custom_headers = nil)
      # Send request
      promise = begin_suspend_async(resource_group_name, server_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Resumes operation of the specified Analysis Services server instance.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be at least 3 characters in length, and no more than 63.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def resume(resource_group_name, server_name, custom_headers = nil)
      response = resume_async(resource_group_name, server_name, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be at least 3 characters in length, and no more than 63.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def resume_async(resource_group_name, server_name, custom_headers = nil)
      # Send request
      promise = begin_resume_async(resource_group_name, server_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Gets all the Analysis Services servers for the given resource group.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AnalysisServicesServers] operation results.
    #
    def list_by_resource_group(resource_group_name, custom_headers = nil)
      response = list_by_resource_group_async(resource_group_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets all the Analysis Services servers for the given resource group.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_with_http_info(resource_group_name, custom_headers = nil)
      list_by_resource_group_async(resource_group_name, custom_headers).value!
    end

    #
    # Gets all the Analysis Services servers for the given resource group.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_async(resource_group_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = AnalysisServicesServers.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all the Analysis Services servers for the given subscription.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AnalysisServicesServers] operation results.
    #
    def list(custom_headers = nil)
      response = list_async(custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists all the Analysis Services servers for the given subscription.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(custom_headers = nil)
      list_async(custom_headers).value!
    end

    #
    # Lists all the Analysis Services servers for the given subscription.
    #
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/providers/Microsoft.AnalysisServices/servers'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = AnalysisServicesServers.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Provisions the specified Analysis Services server based on the configuration
    # specified in the request.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be a minimum of 3 characters, and a maximum of 63.
    # @param server_parameters [AnalysisServicesServer] Contains the information
    # used to provision the Analysis Services server.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [AnalysisServicesServer] operation results.
    #
    def begin_create(resource_group_name, server_name, server_parameters, custom_headers = nil)
      response = begin_create_async(resource_group_name, server_name, server_parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Provisions the specified Analysis Services server based on the configuration
    # specified in the request.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be a minimum of 3 characters, and a maximum of 63.
    # @param server_parameters [AnalysisServicesServer] Contains the information
    # used to provision the Analysis Services server.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_with_http_info(resource_group_name, server_name, server_parameters, custom_headers = nil)
      begin_create_async(resource_group_name, server_name, server_parameters, custom_headers).value!
    end

    #
    # Provisions the specified Analysis Services server based on the configuration
    # specified in the request.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be a minimum of 3 characters, and a maximum of 63.
    # @param server_parameters [AnalysisServicesServer] Contains the information
    # used to provision the Analysis Services server.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_async(resource_group_name, server_name, server_parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'server_name is nil' if server_name.nil?
      fail ArgumentError, 'server_parameters is nil' if server_parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = AnalysisServicesServer.mapper()
      request_content = @client.serialize(request_mapper,  server_parameters, 'server_parameters')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'serverName' => server_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = AnalysisServicesServer.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = AnalysisServicesServer.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes the specified Analysis Services server.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be at least 3 characters in length, and no more than 63.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete(resource_group_name, server_name, custom_headers = nil)
      response = begin_delete_async(resource_group_name, server_name, custom_headers).value!
      nil
    end

    #
    # Deletes the specified Analysis Services server.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be at least 3 characters in length, and no more than 63.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, server_name, custom_headers = nil)
      begin_delete_async(resource_group_name, server_name, custom_headers).value!
    end

    #
    # Deletes the specified Analysis Services server.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be at least 3 characters in length, and no more than 63.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, server_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'server_name is nil' if server_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'serverName' => server_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 204 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Supends operation of the specified Analysis Services server instance.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be at least 3 characters in length, and no more than 63.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_suspend(resource_group_name, server_name, custom_headers = nil)
      response = begin_suspend_async(resource_group_name, server_name, custom_headers).value!
      nil
    end

    #
    # Supends operation of the specified Analysis Services server instance.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be at least 3 characters in length, and no more than 63.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_suspend_with_http_info(resource_group_name, server_name, custom_headers = nil)
      begin_suspend_async(resource_group_name, server_name, custom_headers).value!
    end

    #
    # Supends operation of the specified Analysis Services server instance.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be at least 3 characters in length, and no more than 63.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_suspend_async(resource_group_name, server_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'server_name is nil' if server_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}/suspend'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'serverName' => server_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Resumes operation of the specified Analysis Services server instance.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be at least 3 characters in length, and no more than 63.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_resume(resource_group_name, server_name, custom_headers = nil)
      response = begin_resume_async(resource_group_name, server_name, custom_headers).value!
      nil
    end

    #
    # Resumes operation of the specified Analysis Services server instance.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be at least 3 characters in length, and no more than 63.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_resume_with_http_info(resource_group_name, server_name, custom_headers = nil)
      begin_resume_async(resource_group_name, server_name, custom_headers).value!
    end

    #
    # Resumes operation of the specified Analysis Services server instance.
    #
    # @param resource_group_name [String] The name of the Azure Resource group of
    # which a given Analysis Services server is part. This name must be at least 1
    # character in length, and no more than 90.
    # @param server_name [String] The name of the Analysis Services server. It must
    # be at least 3 characters in length, and no more than 63.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_resume_async(resource_group_name, server_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'server_name is nil' if server_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AnalysisServices/servers/{serverName}/resume'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'serverName' => server_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

  end
end
