#ifndef _RHEOLEF_FIELD_EVALUATE_H
#define _RHEOLEF_FIELD_EVALUATE_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
// 
// evaluate a field on a predefined point set: hat_x[q], q=0..nq
// See also piola_transformation.h
//
#include "rheolef/field.h"
#include "rheolef/basis_on_pointset.h"
namespace rheolef { 

// -----------------------------------------------------
// scalar-valued case:
// -----------------------------------------------------
template<class T, class M>
T
field_evaluate (
  const field_basic<T,M>&       uh,
  const basis_on_pointset<T>&   bops,
  reference_element             hat_K,
  const std::vector<size_t>&    dis_idof,
  size_t                        q);

// -----------------------------------------------------
// vector-valued case:
// -----------------------------------------------------
template<class T, class M>
point_basic<T>
vector_field_evaluate (
  const field_basic<T,M>&       uh,
  const basis_on_pointset<T>&   bops,
  reference_element             hat_K,
  const std::vector<size_t>&    dis_idof_tab,
  size_t                        q);
// -----------------------------------------------------
// tensor-valued case:
// -----------------------------------------------------
template<class T, class M>
tensor_basic<T>
tensor_field_evaluate (
  const field_basic<T,M>&       uh,
  const basis_on_pointset<T>&   bops,
  reference_element             hat_K,
  const std::vector<size_t>&    dis_idof_tab,
  size_t                        q);
// -----------------------------------------------------
// generic interface
// -----------------------------------------------------
template<class T, class M>
inline
void
general_field_evaluate (
  const field_basic<T,M>&       uh,
  const basis_on_pointset<T>&   bops,
  reference_element             hat_K,
  const std::vector<size_t>&    dis_idof,
  size_t                        q,
  T&                            value)
{
  value = field_evaluate (uh, bops, hat_K, dis_idof, q);
}
template<class T, class M>
inline
void
general_field_evaluate (
  const field_basic<T,M>&       uh,
  const basis_on_pointset<T>&   bops,
  reference_element             hat_K,
  const std::vector<size_t>&    dis_idof,
  size_t                        q,
  point_basic<T>&               value)
{
  value = vector_field_evaluate (uh, bops, hat_K, dis_idof, q);
}
template<class T, class M>
inline
void
general_field_evaluate (
  const field_basic<T,M>&       uh,
  const basis_on_pointset<T>&   bops,
  reference_element             hat_K,
  const std::vector<size_t>&    dis_idof,
  size_t                        q,
  tensor_basic<T>&              value)
{
  value = tensor_field_evaluate (uh, bops, hat_K, dis_idof, q);
}
template<class T, class M>
inline
void
general_field_evaluate (
  const field_basic<T,M>&       uh,
  const basis_on_pointset<T>&   bops,
  reference_element             hat_K,
  const std::vector<size_t>&    dis_idof,
  size_t                        q,
  tensor3_basic<T>&              value)
{
  fatal_macro ("tensor3: not yet");
#ifdef TODO
  value = tensor3_field_evaluate (uh, bops, hat_K, dis_idof, q);
#endif // TODO
}
template<class T, class M>
inline
void
general_field_evaluate (
  const field_basic<T,M>&       uh,
  const basis_on_pointset<T>&   bops,
  reference_element             hat_K,
  const std::vector<size_t>&    dis_idof,
  size_t                        q,
  tensor4_basic<T>&              value)
{
  fatal_macro ("tensor4: not yet");
#ifdef TODO
  value = tensor4_field_evaluate (uh, bops, hat_K, dis_idof, q);
#endif // TODO
}
// -----------------------------------------------------
// homogeneous multi-component case: get the i-th value
// -----------------------------------------------------
template<class T, class M>
T
field_component_evaluate (
  const field_basic<T,M>&       uh,
  const basis_on_pointset<T>&   bops,
  reference_element             hat_K,
  const std::vector<size_t>&    dis_idof_tab,
  size_t                        q,
  size_t                        i_comp);

}// namespace rheolef
#endif // _RHEOLEF_FIELD_EVALUATE_H
