% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{nodeplotdefault}
\alias{nodeplotdefault}
\title{Generates a default node-label function}
\usage{
nodeplotdefault(size=2L, hjust=-0.2)
}
\arguments{
\item{size}{(Optional). Numeric. Should be positive. The 
size parameter used to control the text size of taxa labels.
Default is \code{2}. These are ggplot2 sizes.}

\item{hjust}{(Optional). The horizontal justification of the
node labels. Default is \code{-0.2}.}
}
\value{
A function that can add a node-label layer to a graphic.
}
\description{
Is not a labeling function itself, but returns one.
The returned function is capable of adding
whatever label is on a node. Note that the function that 
is returned has two completely different arguments to those listed here:
the plot object already built by earlier steps in
\code{\link{plot_tree}}, and the \code{\link{data.frame}}
that contains the relevant plotting data for the nodes
(especially \code{x, y, label}),
respectively. 
See \code{\link{nodeplotboot}} for a more sophisticated example.
The main purpose of this and \code{\link{nodeplotboot}} is to
provide a useful default function generator for arbitrary and
bootstrap node labels, respectively, and also to act as 
examples of functions that will successfully interact with 
\code{\link{plot_tree}} to add node labels to the graphic.
}
\examples{
nodeplotdefault()
nodeplotdefault(3, -0.4)
}
\seealso{
\code{\link{nodeplotboot}}

\code{\link{nodeplotblank}}

\code{\link{plot_tree}}
}

