% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbhelpers.R
\name{listEnsDbs}
\alias{listEnsDbs}
\title{List EnsDb databases in a MySQL server}
\usage{
listEnsDbs(dbcon, host, port, user, pass)
}
\arguments{
\item{dbcon}{A \code{DBIConnection} object providing access to a MySQL
database. Either \code{dbcon} or all of the other arguments have to be
specified.}

\item{host}{Character specifying the host on which the MySQL server is
running.}

\item{port}{The port of the MySQL server (usually \code{3306}).}

\item{user}{The username for the MySQL server.}

\item{pass}{The password for the MySQL server.}
}
\value{
A \code{data.frame} listing the database names, organism name
and Ensembl version of the EnsDb databases found on the server.
}
\description{
The \code{listEnsDbs} function lists EnsDb databases in a
MySQL server.
}
\details{
The use of this function requires that the \code{RMySQL} package
is installed and that the user has either access to a MySQL server with
already installed EnsDb databases, or write access to a MySQL server in
which case EnsDb databases could be added with the \code{\link{useMySQL}}
method. EnsDb databases follow the same naming conventions than the EnsDb
packages, with the exception that the name is all lower case and that
\code{"."} is replaced by \code{"_"}.
}
\examples{
\dontrun{
library(RMySQL)
dbcon <- dbConnect(MySQL(), host = "localhost", user = my_user, pass = my_pass)
listEnsDbs(dbcon)
}
}
\author{
Johannes Rainer
}
\seealso{
\code{\link{useMySQL}}
}

