# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .sub_resource import SubResource


class ApplicationGatewayBackendHttpSettings(SubResource):
    """Backend address pool settings of application gateway.

    :param id: Resource Id
    :type id: str
    :param port: Port
    :type port: int
    :param protocol: Protocol. Possible values include: 'Http', 'Https'
    :type protocol: str or :class:`ApplicationGatewayProtocol
     <azure.mgmt.network.models.ApplicationGatewayProtocol>`
    :param cookie_based_affinity: Cookie affinity. Possible values include:
     'Enabled', 'Disabled'
    :type cookie_based_affinity: str or
     :class:`ApplicationGatewayCookieBasedAffinity
     <azure.mgmt.network.models.ApplicationGatewayCookieBasedAffinity>`
    :param request_timeout: Request timeout
    :type request_timeout: int
    :param probe: Probe resource of application gateway
    :type probe: :class:`SubResource <azure.mgmt.network.models.SubResource>`
    :param authentication_certificates: Array of references to Application
     Gateway Authentication Certificates
    :type authentication_certificates: list of :class:`SubResource
     <azure.mgmt.network.models.SubResource>`
    :param provisioning_state: Provisioning state of the backend http
     settings resource Updating/Deleting/Failed
    :type provisioning_state: str
    :param name: Name of the resource that is unique within a resource group.
     This name can be used to access the resource
    :type name: str
    :param etag: A unique read-only string that changes whenever the resource
     is updated
    :type etag: str
    """ 

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'port': {'key': 'properties.port', 'type': 'int'},
        'protocol': {'key': 'properties.protocol', 'type': 'str'},
        'cookie_based_affinity': {'key': 'properties.cookieBasedAffinity', 'type': 'str'},
        'request_timeout': {'key': 'properties.requestTimeout', 'type': 'int'},
        'probe': {'key': 'properties.probe', 'type': 'SubResource'},
        'authentication_certificates': {'key': 'properties.authenticationCertificates', 'type': '[SubResource]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, id=None, port=None, protocol=None, cookie_based_affinity=None, request_timeout=None, probe=None, authentication_certificates=None, provisioning_state=None, name=None, etag=None):
        super(ApplicationGatewayBackendHttpSettings, self).__init__(id=id)
        self.port = port
        self.protocol = protocol
        self.cookie_based_affinity = cookie_based_affinity
        self.request_timeout = request_timeout
        self.probe = probe
        self.authentication_certificates = authentication_certificates
        self.provisioning_state = provisioning_state
        self.name = name
        self.etag = etag
