# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class KeyCredential(Model):
    """Active Directory Key Credential information.

    :param start_date: start date
    :type start_date: datetime
    :param end_date: end date
    :type end_date: datetime
    :param value: value
    :type value: str
    :param key_id: key Id
    :type key_id: str
    :param usage: usage. Acceptable values are 'Verify' and 'Sign'.
    :type usage: str
    :param type: type. Acceptable values are 'AsymmetricX509Cert' and
     'Symmetric'.
    :type type: str
    """ 

    _attribute_map = {
        'start_date': {'key': 'startDate', 'type': 'iso-8601'},
        'end_date': {'key': 'endDate', 'type': 'iso-8601'},
        'value': {'key': 'value', 'type': 'str'},
        'key_id': {'key': 'keyId', 'type': 'str'},
        'usage': {'key': 'usage', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, start_date=None, end_date=None, value=None, key_id=None, usage=None, type=None):
        self.start_date = start_date
        self.end_date = end_date
        self.value = value
        self.key_id = key_id
        self.usage = usage
        self.type = type
