//                                               -*- C++ -*-
/**
 *  @brief The external header file of OpenTURNS for subdir OrthogonalBasis
 *
 *  Copyright 2005-2015 Airbus-EDF-IMACS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef OPENTURNS_OTORTHOGONALBASIS_HXX
#define OPENTURNS_OTORTHOGONALBASIS_HXX

#include "AdaptiveStieltjesAlgorithm.hxx"
#include "ChebychevAlgorithm.hxx"
#include "GramSchmidtAlgorithm.hxx"
#include "OrthogonalUniVariatePolynomial.hxx"
#include "CharlierFactory.hxx"
#include "HermiteFactory.hxx"
#include "JacobiFactory.hxx"
#include "KrawtchoukFactory.hxx"
#include "LaguerreFactory.hxx"
#include "LegendreFactory.hxx"
#include "MeixnerFactory.hxx"
#include "OrthogonalBasis.hxx"
#include "OrthogonalFunctionFactory.hxx"
#include "OrthogonalProductPolynomialFactory.hxx"
#include "OrthogonalUniVariatePolynomialFactory.hxx"
#include "OrthogonalUniVariatePolynomialFamily.hxx"
#include "OrthonormalizationAlgorithm.hxx"
#include "OrthonormalizationAlgorithmImplementation.hxx"
#include "StandardDistributionPolynomialFactory.hxx"

#endif /* OPENTURNS_OTORTHOGONALBASIS_HXX */
