//                                               -*- C++ -*-
/**
 *  @brief The external header file of OpenTURNS for subdir Common
 *
 *  Copyright 2005-2015 Airbus-EDF-IMACS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef OPENTURNS_OTCOMMON_HXX
#define OPENTURNS_OTCOMMON_HXX

#include "AtomicFunctions.hxx"
//#include "BinaryStorageManager.hxx"
#include "Catalog.hxx"
#include "ComparisonOperator.hxx"
#include "ComparisonOperatorImplementation.hxx"
#include "Equal.hxx"
#include "Exception.hxx"
#include "Greater.hxx"
#include "GreaterOrEqual.hxx"
#include "IdFactory.hxx"
#include "InterfaceObject.hxx"
#include "Less.hxx"
#include "LessOrEqual.hxx"
#include "Lockable.hxx"
#include "Log.hxx"
#include "Memory.hxx"
#include "Os.hxx"
#include "OSS.hxx"
#include "Object.hxx"
#include "Path.hxx"
#include "PersistentObject.hxx"
#include "PersistentObjectFactory.hxx"
#include "PlatformInfo.hxx"
#include "Pointer.hxx"
#include "ResourceMap.hxx"
#include "SharedPointer.hxx"
#include "StorageManager.hxx"
#include "Study.hxx"
#include "TypedCollectionInterfaceObject.hxx"
#include "TypedInterfaceObject.hxx"
#include "OTconfig.hxx"
#ifdef OPENTURNS_HAVE_LIBXML2
#include "XMLStorageManager.hxx"
#include "XMLchar_traits.hxx"
#endif

#endif /* OPENTURNS_OTCOMMON_HXX */
