/*
 * Copyright (C) 2013, 2015 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef DFGFiltrationResult_h
#define DFGFiltrationResult_h

#if ENABLE(DFG_JIT)

namespace JSC { namespace DFG {

// Tells you if an operation that filters type (i.e. does a type check/speculation) will always
// exit. Formally, this means that the proven type of a value prior to the filter was not
// bottom (i.e. not "clear" or "SpecEmpty") but becomes bottom as a result of executing the
// filter.
//
// Note that per this definition, a filter will not return Contradiction if the node's proven
// type was already bottom. This is necessary because we have this yucky convention of using
// a proven type of bottom for nodes that don't hold JS values, like Phi nodes in ThreadedCPS
// and storage nodes.
enum FiltrationResult {
    // Means that this operation may not always exit.
    FiltrationOK,

    // Means taht this operation will always exit.
    Contradiction
};

} } // namespace JSC::DFG

#endif // ENABLE(DFG_JIT)

#endif // DFGFiltrationResult_h

