#ifndef mdrag_DEFINED
#define mdrag_DEFINED

#include <MMotifOnly.hpp>
#include <Drag.h>

class MDragWidget : public MDrawingArea
{
public:
	void    init(MWidget *parent, const char *name, ...);

	Icon 	addIcon(const char* cl, const char* name, int x, int y, 
			XtPointer data = NULL);

	Icon	findIconByName(const char* classe, const char* name, Boolean folder = False)
		{ if (folder) return DragFindIconByNameFolders (widget, classe, name); 
		  else return DragFindIconByName (widget, classe, name); }

	void	deleteIcon(Icon id)
		{ DragDeleteIcon(widget,id); }

	void	deleteAllIcons()
		{ DragDeleteAllIcons(widget); }

	Pixmap	getIconPixmap(Icon id)
		{ return DragGetIconPixmap (widget, id); }

	const char*  getIconName(Icon id)
		{ return DragGetIconName (widget, id); }

	const char*  getIconClass(Icon id)
		{ return DragGetIconClass (widget, id); }

	void	cleanUpIcons()
		{ DragCleanUpIcons(widget); }

	void	setFontTag(const char *tag)
		{ DragSetFontTag(widget,tag); }

	void	sortIconsByName()
		{ DragSortIcons(widget, DragSortByName); }
	void	sortIconsByClass()
		{ DragSortIcons(widget, DragSortByClass); }
	void	sortIcons(DragSortProc proc = NULL)
		{ DragSortIcons(widget, proc); }

	void toggleSizeIcons() 
		{ DragToggleSizeIcons(widget); }

	Boolean areSmallIconsUsed()
		{ return DragAreSmallIconsUsed(widget); }
	void    useSmallIcons(Boolean use)
		{ DragUseSmallIcons(widget, use); }

	void    showIcon(Icon icon, Boolean vis)
		{ DragShowIcon(widget, icon, vis); }

	void    showLast() 
		{ DragShowLast(widget); }

	void	selectIcon(Icon id, Boolean sel,Boolean expand=True)
		{ DragSelectIcon (widget, id, sel, expand); }

	XtPointer getIconData(Icon id)
		{ return DragGetIconData (widget, id); }

	void	setIconData(Icon id, XtPointer idata)
		{ DragSetIconData (widget, id, idata); }

	void	setIconName(Icon id, const char* name)
		{ DragSetIconName (widget, id, name); }

	Icon    findIconByPosition(Position x, Position y)
		{ return DragFindIconByPosition (widget, x, y); }

	void    findPositionIcon(Icon icon, Position *x, Position *y)
		{ DragFindPositionIcon(widget, icon, x, y); }

	void    acceptDropCallback(XtCallbackProc cb, XtPointer datum)
		{ DragAcceptDropCallback(widget, cb,  datum); }

	void 	openIcon(Icon id, Boolean opened)
		{ DragOpenIcon(widget, id, opened); }

	void    scanIcons(DragScanProc cb, XtPointer datum, Boolean folder = False)
		{ if (folder) DragScanIconsFolders(widget, cb, datum); 
		  else DragScanIcons(widget, cb, datum); }

	static MDragWidget  *iconToWidget(Icon icon)
		{ return (MDragWidget *) returnObject(DragIconToWidget(icon)); }

	Boolean isIconSelected(Icon icon)
		{ return DragIsIconSelected(widget, icon); }

	void setIconColor(Icon icon, Pixel pix)
		{ DragSetIconColor(widget, icon, pix); }

	void setParent(MDragWidget parent)
		{ setValue(XmNparentFolder, (XtPointer)parent.widget); }

	void displayIcon(Icon icon,int flags = DRAG_DISPLAY_NO_EFFECT)
		{ DragDisplayIcon(widget, icon, flags); }

	void addIconPixmap(Icon icon,const char* name,int dx = -1,int dy = -1)
		{ DragAddIconPixmap(widget, icon,name,dx,dy); }
};

#endif
