/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-webmail-mailbox.h"

#include "mn-webmail-mailbox-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 24 "src/mn-webmail-mailbox.gob"

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <glib/gi18n.h>
#include <gmime/gmime.h>
#include "mn-mailbox-private.h"
#include "mn-authenticated-mailbox-private.h"
#include "mn-message-mime.h"
#include "mn-util.h"

#line 41 "mn-webmail-mailbox.c"
/* self casting macros */
#define SELF(x) MN_WEBMAIL_MAILBOX(x)
#define SELF_CONST(x) MN_WEBMAIL_MAILBOX_CONST(x)
#define IS_SELF(x) MN_IS_WEBMAIL_MAILBOX(x)
#define TYPE_SELF MN_TYPE_WEBMAIL_MAILBOX
#define SELF_CLASS(x) MN_WEBMAIL_MAILBOX_CLASS(x)

#define SELF_GET_CLASS(x) MN_WEBMAIL_MAILBOX_GET_CLASS(x)

/* self typedefs */
typedef MNWebmailMailbox Self;
typedef MNWebmailMailboxClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
#line 0 "src/mn-webmail-mailbox.gob"
static void mn_webmail_mailbox_init (MNWebmailMailbox * o);
#line 60 "mn-webmail-mailbox.c"
#line 0 "src/mn-webmail-mailbox.gob"
static void mn_webmail_mailbox_class_init (MNWebmailMailboxClass * c);
#line 63 "mn-webmail-mailbox.c"
#line 50 "src/mn-webmail-mailbox.gob"
static void ___1_mn_webmail_mailbox_seal (MNMailbox * mailbox);
#line 66 "mn-webmail-mailbox.c"
#line 73 "src/mn-webmail-mailbox.gob"
static int mn_webmail_mailbox_create_temporary_file (char ** filename, GError ** err);
#line 69 "mn-webmail-mailbox.c"
#line 163 "src/mn-webmail-mailbox.gob"
static char * mn_webmail_mailbox_get_error_message (MNWebmailMailbox * self, const char * helper_stdout, const char * helper_stderr, gboolean * is_auth_failure);
#line 72 "mn-webmail-mailbox.c"
#line 169 "src/mn-webmail-mailbox.gob"
static void mn_webmail_mailbox_print_multiline_text (MNWebmailMailbox * self, const char * text, const char * line_prefix);
#line 75 "mn-webmail-mailbox.c"
#line 196 "src/mn-webmail-mailbox.gob"
static void mn_webmail_mailbox_print_output (MNWebmailMailbox * self, const char * header, const char * contents);
#line 78 "mn-webmail-mailbox.c"
#line 318 "src/mn-webmail-mailbox.gob"
static gboolean mn_webmail_mailbox_webmail_check (MNWebmailMailbox * self, GError ** err);
#line 81 "mn-webmail-mailbox.c"
#line 321 "src/mn-webmail-mailbox.gob"
static void ___d_mn_webmail_mailbox_authenticated_check (MNAuthenticatedMailbox * mailbox);
#line 84 "mn-webmail-mailbox.c"

enum {
	PROP_0,
	PROP_FOLDER
};

/* pointer to the class of our parent */
static MNAuthenticatedMailboxClass *parent_class = NULL;

/* Short form macros */
#define self_parse_username mn_webmail_mailbox_parse_username
#define self_create_temporary_file mn_webmail_mailbox_create_temporary_file
#define self_create_spool_file mn_webmail_mailbox_create_spool_file
#define self_write_temporary_file mn_webmail_mailbox_write_temporary_file
#define self_get_error_message mn_webmail_mailbox_get_error_message
#define self_print_multiline_text mn_webmail_mailbox_print_multiline_text
#define self_print_config mn_webmail_mailbox_print_config
#define self_print_output mn_webmail_mailbox_print_output
#define self_run_helper mn_webmail_mailbox_run_helper
#define self_read_spool_file mn_webmail_mailbox_read_spool_file
#define self_webmail_check mn_webmail_mailbox_webmail_check
#define self_build_name mn_webmail_mailbox_build_name
GType
mn_webmail_mailbox_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNWebmailMailboxClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_webmail_mailbox_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNWebmailMailbox),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_webmail_mailbox_init,
			NULL
		};

		type = g_type_register_static (MN_TYPE_AUTHENTICATED_MAILBOX, "MNWebmailMailbox", &info, (GTypeFlags)G_TYPE_FLAG_ABSTRACT);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNWebmailMailbox *)g_object_new(mn_webmail_mailbox_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNWebmailMailbox * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNWebmailMailbox *
GET_NEW_VARG (const char *first, ...)
{
	MNWebmailMailbox *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNWebmailMailbox *)g_object_new_valist (mn_webmail_mailbox_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Webmail:Mailbox::finalize"
	MNWebmailMailbox *self G_GNUC_UNUSED = MN_WEBMAIL_MAILBOX (obj_self);
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 43 "src/mn-webmail-mailbox.gob"
	if(self->folder) { g_free ((gpointer) self->folder); self->folder = NULL; }
#line 159 "mn-webmail-mailbox.c"
}
#undef __GOB_FUNCTION__

static void 
mn_webmail_mailbox_init (MNWebmailMailbox * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Webmail:Mailbox::init"
}
#undef __GOB_FUNCTION__
static void 
mn_webmail_mailbox_class_init (MNWebmailMailboxClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Webmail:Mailbox::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;
	MNMailboxClass *mn_mailbox_class = (MNMailboxClass *)c;
	MNAuthenticatedMailboxClass *mn_authenticated_mailbox_class = (MNAuthenticatedMailboxClass *)c;

	parent_class = g_type_class_ref (MN_TYPE_AUTHENTICATED_MAILBOX);

#line 50 "src/mn-webmail-mailbox.gob"
	mn_mailbox_class->seal = ___1_mn_webmail_mailbox_seal;
#line 181 "mn-webmail-mailbox.c"
	c->get_error_message = NULL;
	c->webmail_check = NULL;
#line 321 "src/mn-webmail-mailbox.gob"
	mn_authenticated_mailbox_class->authenticated_check = ___d_mn_webmail_mailbox_authenticated_check;
#line 186 "mn-webmail-mailbox.c"
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_string
		("folder" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 "Inbox" /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | MN_MAILBOX_PARAM_REQUIRED | MN_MAILBOX_PARAM_LOAD_SAVE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_FOLDER,
		param_spec);
    }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Webmail:Mailbox::set_property"
{
	MNWebmailMailbox *self G_GNUC_UNUSED;

	self = MN_WEBMAIL_MAILBOX (object);

	switch (property_id) {
	case PROP_FOLDER:
		{
#line 44 "src/mn-webmail-mailbox.gob"
{ char *old = self->folder; self->folder = g_value_dup_string (VAL); g_free (old); }
#line 222 "mn-webmail-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Webmail:Mailbox::get_property"
{
	MNWebmailMailbox *self G_GNUC_UNUSED;

	self = MN_WEBMAIL_MAILBOX (object);

	switch (property_id) {
	case PROP_FOLDER:
		{
#line 44 "src/mn-webmail-mailbox.gob"
g_value_set_string (VAL, self->folder);
#line 253 "mn-webmail-mailbox.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__



#line 50 "src/mn-webmail-mailbox.gob"
static void 
___1_mn_webmail_mailbox_seal (MNMailbox * mailbox G_GNUC_UNUSED)
#line 273 "mn-webmail-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_MAILBOX_CLASS(parent_class)->seal) \
		(* MN_MAILBOX_CLASS(parent_class)->seal)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:Webmail:Mailbox::seal"
{
#line 52 "src/mn-webmail-mailbox.gob"
	
    MNAuthenticatedMailbox *auth_mailbox = MN_AUTHENTICATED_MAILBOX(mailbox);
    Self *self = SELF(mailbox);

    PARENT_HANDLER(mailbox);

    if (! mailbox->runtime_name)
      mailbox->runtime_name = self_build_name(SELF_GET_CLASS(self), MN_AUTHENTICATED_MAILBOX(mailbox)->username, self->folder);

    if (! auth_mailbox->keyring_domain)
      auth_mailbox->keyring_domain = g_strdup(MN_WEBMAIL_MAILBOX_CLASS(SELF_GET_CLASS(self))->default_domain);
  }}
#line 293 "mn-webmail-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 65 "src/mn-webmail-mailbox.gob"
void 
mn_webmail_mailbox_parse_username (MNWebmailMailbox * self, char ** username, char ** domain)
{
#line 301 "mn-webmail-mailbox.c"
#define __GOB_FUNCTION__ "MN:Webmail:Mailbox::parse_username"
#line 65 "src/mn-webmail-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 65 "src/mn-webmail-mailbox.gob"
	g_return_if_fail (MN_IS_WEBMAIL_MAILBOX (self));
#line 65 "src/mn-webmail-mailbox.gob"
	g_return_if_fail (username != NULL);
#line 65 "src/mn-webmail-mailbox.gob"
	g_return_if_fail (domain != NULL);
#line 311 "mn-webmail-mailbox.c"
{
#line 67 "src/mn-webmail-mailbox.gob"
	
    mn_authenticated_mailbox_parse_username(MN_AUTHENTICATED_MAILBOX(self), username, domain);
    if (! *domain)
      *domain = g_strdup(MN_WEBMAIL_MAILBOX_CLASS(SELF_GET_CLASS(self))->default_domain);
  }}
#line 319 "mn-webmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 73 "src/mn-webmail-mailbox.gob"
static int 
mn_webmail_mailbox_create_temporary_file (char ** filename, GError ** err)
{
#line 326 "mn-webmail-mailbox.c"
#define __GOB_FUNCTION__ "MN:Webmail:Mailbox::create_temporary_file"
#line 73 "src/mn-webmail-mailbox.gob"
	g_return_val_if_fail (filename != NULL, (int )0);
#line 330 "mn-webmail-mailbox.c"
{
#line 75 "src/mn-webmail-mailbox.gob"
	
    int fd;
    char *_filename;
    GError *tmp_err = NULL;

    /* GetLive chokes on the hyphen in "mail-notification", so use "mn" */
    fd = g_file_open_tmp("mn.XXXXXX", &_filename, &tmp_err);
    if (fd == -1)
      {
	g_set_error(err, 0, 0, _("unable to create a temporary file: %s"), tmp_err->message);
	g_error_free(tmp_err);
	return -1;
      }

    if (fchmod(fd, S_IRUSR | S_IWUSR) < 0)
      {
	g_set_error(err, 0, 0, _("unable to change the permissions of the temporary file: %s"), g_strerror(errno));
	g_free(_filename);
	close(fd);
	return -1;
      }

    *filename = _filename;
    return fd;
  }}
#line 358 "mn-webmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 101 "src/mn-webmail-mailbox.gob"
char * 
mn_webmail_mailbox_create_spool_file (GError ** err)
{
#line 365 "mn-webmail-mailbox.c"
#define __GOB_FUNCTION__ "MN:Webmail:Mailbox::create_spool_file"
{
#line 103 "src/mn-webmail-mailbox.gob"
	
    int fd;
    char *filename;

    fd = self_create_temporary_file(&filename, err);
    if (fd == -1)
      return NULL;

    close(fd);

    return filename;
  }}
#line 381 "mn-webmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 116 "src/mn-webmail-mailbox.gob"
char * 
mn_webmail_mailbox_write_temporary_file (const char * contents, const char * encoding, GError ** err)
{
#line 388 "mn-webmail-mailbox.c"
#define __GOB_FUNCTION__ "MN:Webmail:Mailbox::write_temporary_file"
#line 116 "src/mn-webmail-mailbox.gob"
	g_return_val_if_fail (contents != NULL, (char * )0);
#line 116 "src/mn-webmail-mailbox.gob"
	g_return_val_if_fail (encoding != NULL, (char * )0);
#line 394 "mn-webmail-mailbox.c"
{
#line 120 "src/mn-webmail-mailbox.gob"
	
    int fd;
    GError *tmp_err = NULL;
    char *filename;
    GIOChannel *channel;
    gsize bytes_written;

    fd = self_create_temporary_file(&filename, err);
    if (fd == -1)
      return NULL;

    channel = g_io_channel_unix_new(fd);

    if (g_io_channel_set_encoding(channel, encoding, &tmp_err) != G_IO_STATUS_NORMAL)
      {
	g_set_error(err, 0, 0, _("unable to set encoding of %s: %s"), filename, tmp_err->message);
	goto error;
      }

    if (g_io_channel_write_chars(channel, contents, -1, &bytes_written, &tmp_err) != G_IO_STATUS_NORMAL)
      {
	g_set_error(err, 0, 0, _("unable to write to %s: %s"), filename, tmp_err->message);
	goto error;
      }

    if (g_io_channel_shutdown(channel, TRUE, &tmp_err) != G_IO_STATUS_NORMAL)
      {
	g_set_error(err, 0, 0, _("unable to close %s: %s"), filename, tmp_err->message);
	goto error_noshutdown;
      }

    g_io_channel_unref(channel);

    return filename;

  error:
    g_io_channel_shutdown(channel, FALSE, NULL);
  error_noshutdown:
    g_io_channel_unref(channel);
    g_free(filename);
    return NULL;
  }}
#line 439 "mn-webmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 163 "src/mn-webmail-mailbox.gob"
static char * 
mn_webmail_mailbox_get_error_message (MNWebmailMailbox * self, const char * helper_stdout, const char * helper_stderr, gboolean * is_auth_failure)
{
#line 446 "mn-webmail-mailbox.c"
	MNWebmailMailboxClass *klass;
#line 163 "src/mn-webmail-mailbox.gob"
	g_return_val_if_fail (self != NULL, (char * )0);
#line 163 "src/mn-webmail-mailbox.gob"
	g_return_val_if_fail (MN_IS_WEBMAIL_MAILBOX (self), (char * )0);
#line 163 "src/mn-webmail-mailbox.gob"
	g_return_val_if_fail (is_auth_failure != NULL, (char * )0);
#line 454 "mn-webmail-mailbox.c"
	klass = MN_WEBMAIL_MAILBOX_GET_CLASS(self);

	if(klass->get_error_message)
		return (*klass->get_error_message)(self,helper_stdout,helper_stderr,is_auth_failure);
	else
		return (char * )(0);
}

#line 169 "src/mn-webmail-mailbox.gob"
static void 
mn_webmail_mailbox_print_multiline_text (MNWebmailMailbox * self, const char * text, const char * line_prefix)
{
#line 467 "mn-webmail-mailbox.c"
#define __GOB_FUNCTION__ "MN:Webmail:Mailbox::print_multiline_text"
#line 169 "src/mn-webmail-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 169 "src/mn-webmail-mailbox.gob"
	g_return_if_fail (MN_IS_WEBMAIL_MAILBOX (self));
#line 169 "src/mn-webmail-mailbox.gob"
	g_return_if_fail (text != NULL);
#line 169 "src/mn-webmail-mailbox.gob"
	g_return_if_fail (line_prefix != NULL);
#line 477 "mn-webmail-mailbox.c"
{
#line 173 "src/mn-webmail-mailbox.gob"
	
    char **lines;
    int i;

    lines = g_strsplit(text, "\n", 0);
    for (i = 0; lines[i]; i++)
      {
	// do not print the empty last line
	if (! lines[i + 1] && ! lines[i][0])
	  break;

	mn_mailbox_notice(MN_MAILBOX(self), "%s%s", line_prefix, lines[i]);
      }
    g_strfreev(lines);
  }}
#line 495 "mn-webmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 189 "src/mn-webmail-mailbox.gob"
void 
mn_webmail_mailbox_print_config (MNWebmailMailbox * self, const char * config)
{
#line 502 "mn-webmail-mailbox.c"
#define __GOB_FUNCTION__ "MN:Webmail:Mailbox::print_config"
#line 189 "src/mn-webmail-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 189 "src/mn-webmail-mailbox.gob"
	g_return_if_fail (MN_IS_WEBMAIL_MAILBOX (self));
#line 189 "src/mn-webmail-mailbox.gob"
	g_return_if_fail (config != NULL);
#line 510 "mn-webmail-mailbox.c"
{
#line 191 "src/mn-webmail-mailbox.gob"
	
    mn_mailbox_notice(MN_MAILBOX(self), _("configuration:"));
    self_print_multiline_text(self, config, "> ");
  }}
#line 517 "mn-webmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 196 "src/mn-webmail-mailbox.gob"
static void 
mn_webmail_mailbox_print_output (MNWebmailMailbox * self, const char * header, const char * contents)
{
#line 524 "mn-webmail-mailbox.c"
#define __GOB_FUNCTION__ "MN:Webmail:Mailbox::print_output"
#line 196 "src/mn-webmail-mailbox.gob"
	g_return_if_fail (self != NULL);
#line 196 "src/mn-webmail-mailbox.gob"
	g_return_if_fail (MN_IS_WEBMAIL_MAILBOX (self));
#line 196 "src/mn-webmail-mailbox.gob"
	g_return_if_fail (header != NULL);
#line 532 "mn-webmail-mailbox.c"
{
#line 200 "src/mn-webmail-mailbox.gob"
	
    if (! contents || ! *contents)
      return;

    mn_mailbox_notice(MN_MAILBOX(self), "%s", header);
    self_print_multiline_text(self, contents, "< ");
  }}
#line 542 "mn-webmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 208 "src/mn-webmail-mailbox.gob"
gboolean 
mn_webmail_mailbox_run_helper (MNWebmailMailbox * self, const char * name, const char * command, GError ** err)
{
#line 549 "mn-webmail-mailbox.c"
#define __GOB_FUNCTION__ "MN:Webmail:Mailbox::run_helper"
#line 208 "src/mn-webmail-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 208 "src/mn-webmail-mailbox.gob"
	g_return_val_if_fail (MN_IS_WEBMAIL_MAILBOX (self), (gboolean )0);
#line 208 "src/mn-webmail-mailbox.gob"
	g_return_val_if_fail (name != NULL, (gboolean )0);
#line 208 "src/mn-webmail-mailbox.gob"
	g_return_val_if_fail (command != NULL, (gboolean )0);
#line 559 "mn-webmail-mailbox.c"
{
#line 213 "src/mn-webmail-mailbox.gob"
	
    GError *tmp_err = NULL;
    char *helper_stdout;
    char *helper_stderr;
    int exit_status;
    gboolean status = FALSE;

    mn_mailbox_notice(MN_MAILBOX(self), _("running %s"), command);

    if (! g_spawn_command_line_sync(command, &helper_stdout, &helper_stderr, &exit_status, &tmp_err))
      {
	g_set_error(err, 0, 0, _("cannot execute \"%s\": %s"), name, tmp_err->message);
	g_error_free(tmp_err);
	return FALSE;
      }

    self_print_output(self, _("standard output:"), helper_stdout);
    self_print_output(self, _("standard error output:"), helper_stderr);

    if (WEXITSTATUS(exit_status) != 0)
      {
	char *message;
	gboolean is_auth_failure = FALSE;

	message = self_get_error_message(self,
					 helper_stdout,
					 helper_stderr,
					 &is_auth_failure);
	if (message)
	  {
	    g_set_error(err, 0, 0, "%s", message);
	    g_free(message);
	  }
	else
	  /* translators: %s is a program name, as in "unknown fetchyahoo failure" */
	  g_set_error(err, 0, 0, _("unknown %s failure"), name);

	if (is_auth_failure && MN_AUTHENTICATED_MAILBOX(self)->auth_prompted)
	  mn_authenticated_mailbox_auth_failed(MN_AUTHENTICATED_MAILBOX(self));

	goto end;
      }

    status = TRUE;

  end:
    g_free(helper_stdout);
    g_free(helper_stderr);

    return status;
  }}
#line 613 "mn-webmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 265 "src/mn-webmail-mailbox.gob"
gboolean 
mn_webmail_mailbox_read_spool_file (MNWebmailMailbox * self, const char * spool_file, GError ** err)
{
#line 620 "mn-webmail-mailbox.c"
#define __GOB_FUNCTION__ "MN:Webmail:Mailbox::read_spool_file"
#line 265 "src/mn-webmail-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 265 "src/mn-webmail-mailbox.gob"
	g_return_val_if_fail (MN_IS_WEBMAIL_MAILBOX (self), (gboolean )0);
#line 265 "src/mn-webmail-mailbox.gob"
	g_return_val_if_fail (spool_file != NULL, (gboolean )0);
#line 628 "mn-webmail-mailbox.c"
{
#line 267 "src/mn-webmail-mailbox.gob"
	
    int fd;
    GMimeStream *stream;
    GMimeParser *parser;
    GSList *messages = NULL;

    fd = open(spool_file, O_RDONLY);
    if (fd < 0)
      {
	g_set_error(err, 0, 0, _("unable to open %s: %s"), spool_file, strerror(errno));
	return FALSE;
      }

    stream = g_mime_stream_fs_new(fd);

    parser = g_mime_parser_new_with_stream(stream);
    g_object_unref(stream);
    g_mime_parser_set_scan_from(parser, TRUE);

    while (! g_mime_parser_eos(parser))
      {
	GMimeMessage *mime_message;

	mime_message = g_mime_parser_construct_message(parser);
	if (mime_message)
	  {
	    MNMessage *message;

	    message = mn_message_new_from_mime_message(MN_MAILBOX(self), mime_message, NULL, 0, TRUE);
	    g_object_unref(mime_message);

	    if (message)
	      messages = g_slist_prepend(messages, message);
	  }
      }

    g_object_unref(parser);

    /* the fd is owned by the stream and closed by it */

    GDK_THREADS_ENTER();

    mn_mailbox_set_messages(MN_MAILBOX(self), messages);
    mn_g_object_slist_free(messages);

    gdk_flush();
    GDK_THREADS_LEAVE();

    return TRUE;
  }}
#line 681 "mn-webmail-mailbox.c"
#undef __GOB_FUNCTION__

#line 318 "src/mn-webmail-mailbox.gob"
static gboolean 
mn_webmail_mailbox_webmail_check (MNWebmailMailbox * self, GError ** err)
{
#line 688 "mn-webmail-mailbox.c"
	MNWebmailMailboxClass *klass;
#line 318 "src/mn-webmail-mailbox.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 318 "src/mn-webmail-mailbox.gob"
	g_return_val_if_fail (MN_IS_WEBMAIL_MAILBOX (self), (gboolean )0);
#line 694 "mn-webmail-mailbox.c"
	klass = MN_WEBMAIL_MAILBOX_GET_CLASS(self);

	if(klass->webmail_check)
		return (*klass->webmail_check)(self,err);
	else
		return (gboolean )(0);
}

#line 321 "src/mn-webmail-mailbox.gob"
static void 
___d_mn_webmail_mailbox_authenticated_check (MNAuthenticatedMailbox * mailbox G_GNUC_UNUSED)
#line 706 "mn-webmail-mailbox.c"
#define PARENT_HANDLER(___mailbox) \
	{ if(MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->authenticated_check) \
		(* MN_AUTHENTICATED_MAILBOX_CLASS(parent_class)->authenticated_check)(___mailbox); }
{
#define __GOB_FUNCTION__ "MN:Webmail:Mailbox::authenticated_check"
{
#line 323 "src/mn-webmail-mailbox.gob"
	
    Self *self = SELF(mailbox);
    GError *err = NULL;

    PARENT_HANDLER(mailbox);

  again:
    if (! mn_authenticated_mailbox_fill_password(mailbox, TRUE))
      return;

    if (! self_webmail_check(self, &err))
      {
	if (mailbox->auth_prompted && mailbox->auth_failed)
	  {
	    g_clear_error(&err);
	    goto again;
	  }

	GDK_THREADS_ENTER();

	mn_mailbox_set_error(MN_MAILBOX(self), "%s", err->message);
	g_error_free(err);

	gdk_flush();
	GDK_THREADS_LEAVE();
      }
  }}
#line 741 "mn-webmail-mailbox.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 351 "src/mn-webmail-mailbox.gob"
char * 
mn_webmail_mailbox_build_name (MNWebmailMailboxClass * class, const char * username, const char * folder)
{
#line 749 "mn-webmail-mailbox.c"
#define __GOB_FUNCTION__ "MN:Webmail:Mailbox::build_name"
#line 351 "src/mn-webmail-mailbox.gob"
	g_return_val_if_fail (class != NULL, (char * )0);
#line 351 "src/mn-webmail-mailbox.gob"
	g_return_val_if_fail (username != NULL, (char * )0);
#line 755 "mn-webmail-mailbox.c"
{
#line 355 "src/mn-webmail-mailbox.gob"
	
    GString *name;

    name = g_string_new(NULL);

    if (strchr(username, '@'))
      g_string_append(name, username);
    else
      g_string_append_printf(name, "%s@%s", username, class->default_domain);

    if (folder && strcmp(folder, "Inbox"))
      g_string_append_printf(name, "/%s", folder);

    return g_string_free(name, FALSE);
  }}
#line 773 "mn-webmail-mailbox.c"
#undef __GOB_FUNCTION__
