/*
  This file is part of MADNESS.
  
  Copyright (C) 2007,2010 Oak Ridge National Laboratory
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
  
  For more information please contact:
  
  Robert J. Harrison
  Oak Ridge National Laboratory
  One Bethel Valley Road
  P.O. Box 2008, MS-6367
  
  email: harrisonrj@ornl.gov
  tel:   865-241-3937
  fax:   865-572-0680
  
  $Id$
*/
#include <madness/mra/mra.h>

using std::cout;
using std::endl;
using std::max;

namespace madness {
    using std::abs;

    bool test_rnlp() {
        long i, n, l;
        Tensor<double> r;
        double maxerr = 0.0;
        const double pi = 3.14159265358979323846264338328;
        double exact, err;
        {
            //cout << "Testing accuracy of rnlp against results from Maple" << endl;
            double a = 1e-4;
            GaussianConvolution1D<double> g(8,sqrt(a/pi),a,0,false);
            n = 0;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.64057956799766339e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -3.19741057080945913e-12;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -2.81799864246383464e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 0;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.64170777792480805e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -1.06615886053515213e-12;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -2.82194856723151343e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 0;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.64170777792480805e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.06615886053515213e-12;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -2.82194856723151343e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 0;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.64057956799766339e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 3.19741057080945913e-12;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -2.81799864246383464e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 0;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.63832382494524470e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 5.32546574080415871e-12;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -2.81010590087371315e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.41047267328181405e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -1.22018791972360980e-17;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.41047377521394878e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -4.06729836170390096e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.41047377521394878e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 4.06729836170390096e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.41047267328181405e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.22018791972360980e-17;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.41047046942012737e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 2.03364123692283645e-17;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.52618488461890419e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.52618489537996637e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.52618489537996637e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.52618488461890419e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.52618486309677983e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.81546224281108936e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.81546224291617701e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.81546224291617701e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.81546224281108936e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.81546224260091135e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20386556073330313e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20386556073340579e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20386556073340579e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20386556073330313e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20386556073309815e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966390183355599e-06;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966390183355769e-06;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966390183355769e-06;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966390183355599e-06;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966390183355430e-06;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
        }
        {
            double a = 1e-2;
            GaussianConvolution1D<double> g(8,sqrt(a/pi),a,0,false);
            n = 0;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.51198365960967815e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -3.07636514759748877e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -2.39004237222238520e-12;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 3.05711391835261338e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 0;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.62314580091424487e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -1.06031221284974586e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -2.77004995102873103e-12;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 1.09765925398799329e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 0;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.62314580091424487e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.06031221284974586e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -2.77004995102873103e-12;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -1.09765925398799329e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 0;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.51198365960967815e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 3.07636514759748877e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -2.39004237222238520e-12;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -3.05711391835261338e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 0;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.29620851243244872e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 4.79304691694024367e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -1.69661200992196493e-12;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -4.36848047760689648e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.41034540671661907e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -1.22000442699401760e-12;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -4.20320972136612724e-20;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.41045559353827048e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -4.06721097934550646e-13;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -4.20550942666829470e-20;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.41045559353827048e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 4.06721097934550646e-13;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -4.20550942666829470e-20;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.41034540671661907e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.22000442699401760e-12;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -4.20320972136612724e-20;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.41012505889650305e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 2.03281124249789191e-12;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -4.19861192757157094e-20;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.52618364171646210e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -4.65465182972746039e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.52618471782244636e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -1.55155139906883680e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.52618471782244636e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.55155139906883680e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.52618364171646210e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 4.65465182972746039e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.52618148950547801e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 7.75774515795399146e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.81546223067336716e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.81546224118221681e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.81546224118221681e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.81546223067336716e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.81546220965566786e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20386556072144996e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20386556073171247e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20386556073171247e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20386556072144996e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20386556070092493e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966390183344046e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966390183354075e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966390183354075e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966390183344046e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966390183323988e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
        }
        {
            double a = 1e0;
            GaussianConvolution1D<double> g(8,sqrt(a/pi),a,0,false);
            n = 0;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 7.63107360346189367e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.39326380508023582e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -3.96841677858563145e-06;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 8.75661865077648466e-10;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 8.82410737907618627e-12;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -1.30949951473492010e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 0;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 4.21350396474857447e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -6.17983307932157278e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 4.43199670152667480e-06;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 3.35647464179302069e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = -3.57967506112678285e-11;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -1.36118274898628887e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 0;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 4.21350396474857447e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 6.17983307932157278e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 4.43199670152667480e-06;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -3.35647464179302069e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = -3.57967506112678285e-11;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 1.36118274898628887e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 0;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 7.63107360346189367e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -1.39326380508023582e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -3.96841677858563145e-06;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -8.75661865077648466e-10;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 8.82410737907618627e-12;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 1.30949951473492010e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 0;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.32782224202434003e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -3.68552701680425695e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 4.13775061144892418e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 1.60042507022451686e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 1.96088571198545215e-12;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 1.41367897661257123e-15;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.39768454157893490e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -1.20177712692920616e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -3.94868219678417840e-13;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 7.31566593570543275e-20;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.40863955444774147e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -4.05848287082555859e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -4.17520807696470182e-13;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 2.51168860115838423e-20;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.40863955444774147e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 4.05848287082555859e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -4.17520807696470182e-13;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -2.51168860115838423e-20;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.39768454157893490e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.20177712692920616e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -3.94868219678417840e-13;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -7.32150795271814975e-20;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.37602944516084069e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.95125817624941723e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -3.51139113424138104e-13;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -1.15110485207894889e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.52605935399162088e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -4.65437839301828836e-13;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.52616696215172984e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -1.55153837798979186e-13;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.52616696215172984e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.55153837798979186e-13;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.52605935399162088e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 4.65437839301828836e-13;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.52584414752294961e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 7.75650823576525769e-13;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.81546101690129993e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -1.77560940279273474e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.81546206778619640e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -5.91869918524889379e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.81546206778619640e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 5.91869918524889379e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.81546101690129993e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.77560940279273474e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.81545891513188171e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 2.95934782871507479e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20386555953612550e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20386556056238053e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20386556056238053e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20386555953612550e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20386555748361586e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966390182186538e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966390183188666e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966390183188666e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966390182186538e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966390180182065e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
        }
        {
            double a = 1e2;
            GaussianConvolution1D<double> g(8,sqrt(a/pi),a,0,false);
            n = 0;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.00000000000000000e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 6.10756752342258014e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -1.93454443422216120e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -6.74867032786444360e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 1.24739852592635793e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 1.43294933024935476e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 0;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.00000000000000000e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -6.10756752342258014e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -1.93454443422216120e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 6.74867032786444360e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 1.24739852592635793e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -1.43294933024935476e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.99318492136080461e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -2.08696368094917623e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 2.60447168323340892e-06;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -9.04034504985510627e-10;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = -2.14998633928712021e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 5.58835531816329497e-17;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.24648176437683600e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -3.27908149234218621e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -1.67276950422990212e-06;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 1.64624909472826329e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 6.70688497777513430e-15;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -9.05569878193988709e-17;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.24648176437683600e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 3.27908149234218621e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -1.67276950422990212e-06;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -1.64624909472826329e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 6.70688497777513430e-15;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 9.05569878193988709e-17;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.99318492136080461e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 2.08696368094917623e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 2.60447168323340892e-06;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 9.04034504985510627e-10;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = -2.14998633928712021e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -5.58835531816329497e-17;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.38179858827323476e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -1.04763936483394230e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -8.32772220224538394e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -1.89437614141419528e-10;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 2.88769508210870525e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 2.21803339122174113e-17;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.51365573776570017e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -4.62710590578847031e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -6.11623077961541036e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.52439220749447890e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -1.55023685987324124e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -6.24931708968097842e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.52439220749447890e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.55023685987324124e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -6.24931708968097842e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.51365573776570017e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 4.62710590578847031e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -6.11623077961541036e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.49228081923241285e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 7.63366360227468385e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -5.85369846273186721e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.81533964065561448e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -1.77556865689395017e-13;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.81544472821516045e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -5.91867978227500295e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.81544472821516045e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 5.91867978227500295e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.81533964065561448e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.77556865689395017e-13;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.81512946929470659e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 2.95916350513851956e-13;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20386544100369154e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -6.77341329040006257e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20386554362917535e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -2.25780460536204789e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20386554362917535e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 2.25780460536204789e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20386544100369154e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 6.77341329040006257e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20386523575273816e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.12890203983799996e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966390066432148e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966390166652414e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966390166652414e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966390066432148e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966389865991790e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
        }
        {
            double a = 1e4;
            GaussianConvolution1D<double> g(8,sqrt(a/pi),a,0,false);
            n = 0;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.00000000000000000e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.23528272214066237e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 1.41178217654244809e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 1.26724337383508057e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 9.24808666820860048e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 5.16058662037806704e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 0;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.00000000000000000e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -1.23528272214066237e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 1.41178217654244809e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -1.26724337383508057e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 9.24808666820860048e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -5.16058662037806704e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.93406055705484376e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 4.39497184635340733e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 4.08935561473207502e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 2.66300430413872028e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 1.33508873895376489e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 5.08640731141814058e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.00000000000000000e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.34688631911635626e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -3.48488099568184218e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 2.62343309407099060e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 1.42392358397174803e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -5.74390741499019122e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.00000000000000000e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -1.34688631911635626e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -3.48488099568184218e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -2.62343309407099060e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 1.42392358397174803e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 5.74390741499019122e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.93406055705484376e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -4.39497184635340733e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 4.08935561473207502e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -2.66300430413872028e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 1.33508873895567407e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -5.08640731150656195e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.49146408254436480e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -2.50647102869495280e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 2.64278820712894470e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 3.15088994971621284e-11;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = -3.70274884997262088e-15;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 2.02622223000723244e-20;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.35475425674241334e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -1.42579697710634181e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -4.61160183056987646e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 4.87550411609523399e-11;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 2.47120513789010578e-15;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -1.86594916521298455e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.35475425674241334e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.42579697710634181e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -4.61160183056987646e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -4.87550411609523399e-11;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 2.47120513789010578e-15;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 1.86594916521298455e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.49146408254436480e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 2.50647102869495280e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 2.64278820712894470e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -3.15088994971621284e-11;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = -3.70274884997262088e-15;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -2.02622223000727306e-20;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.37408108427214515e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.09038475936154631e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 3.68884880267772498e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 3.66150600926587787e-11;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 3.77722151485774017e-16;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -1.03592207658699442e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.80321162122826961e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -1.77149821469458344e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -9.25065232468101948e-15;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.81371108109231360e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -5.91673982825609260e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -9.32840028258958169e-15;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.81371108109231360e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 5.91673982825609260e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -9.32840028258958169e-15;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.80321162122826961e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.77149821469458344e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -9.25065232468101948e-15;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.78225020949705004e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 2.94078061354701635e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -9.09598921287351880e-15;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20385358779692841e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -6.77335257389880792e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20386385030982762e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -2.25780171409048271e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20386385030982762e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 2.25780171409048271e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20385358779692841e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 6.77335257389880792e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20383306291449504e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.12887457303027408e-13;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966378490998915e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -2.58385225835037511e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966388513019073e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -8.61284112227903377e-20;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966388513019073e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 8.61284112227903377e-20;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966378490998915e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 2.58385225835037511e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966358446959223e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 4.30642016947285981e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
        }
        {
            double a = 1e6;
            GaussianConvolution1D<double> g(8,sqrt(a/pi),a,0,false);
            n = 0;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.00000000000000000e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.31393925175791226e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 1.76043401220533680e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 2.07091850787566534e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 2.28733404941548857e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 2.42623389685600399e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 0;
            l=0;
            r = g.rnlp(n,l);
            i = 9;
            exact = -2.07091850787566534e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 2.28733404941548857e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -2.42623389685600399e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=0;
            r = g.rnlp(n,l);
            i = 9;
            exact = -3.50842272140536116e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 1.68215019539905630e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -1.77563550367174916e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.64684064677916715e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 4.77372027143066234e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 2.48546774012851273e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 6.34469829004409155e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 8.20364207845620860e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 5.02838600880059851e-10;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 7.99999973531593511e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.28136988133445895e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -2.97337646440325010e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 2.42595127151247827e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = -1.01342125713415232e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 1.19548791588270655e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 7.99999973531593511e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -1.28136988133445895e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -2.97337646440325010e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -2.42595127151247827e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = -1.01342125713415232e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -1.19548791588270655e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.64684064677916715e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -4.77372027143066234e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 2.48546774012851273e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -6.34469829004409155e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 8.20364207845620860e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -5.02838600880059851e-10;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 7.68112666770073726e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -1.40335952063720378e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -2.16852188536233089e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 2.27739586876326983e-12;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = -9.64560459462787522e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.64340268954690671e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -5.72613518237629813e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -8.32996156019435581e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 1.22452367554029254e-12;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 3.28001683556767755e-17;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 8.64340268954690671e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 5.72613518237629813e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -8.32996156019435581e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -1.22452367554029254e-12;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 3.28001683556767755e-17;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 7.68112666770073726e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.40335952063720378e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -2.16852188536233089e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -2.27739586876326983e-12;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = -9.64560459462787522e-18;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 6.06603017048240378e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.52348873733158482e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 4.50962719862293780e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -9.54505770868048384e-13;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = -3.34357728315444496e-17;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20266863365880416e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -6.76728333900617373e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -1.38645113252605220e-15;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20369453020092898e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -2.25751260692224813e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -1.39098307532258949e-15;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20369453020092898e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 2.25751260692224813e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -1.39098307532258949e-15;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20266863365880416e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 6.76728333900617373e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -1.38645113252605220e-15;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.20061827312391323e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.12613077452750488e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -1.37740622815052894e-15;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50965220949072187e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -2.58384321086449390e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966223149730427e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -8.61283681394682842e-15;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50966223149730427e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 8.61283681394682842e-15;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50965220949072187e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 2.58384321086449390e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50963216553224777e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 4.30637924047538213e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
        }
        {
            double a = 1e8;
            GaussianConvolution1D<double> g(8,sqrt(a/pi),a,0,false);
            n = 0;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.00000000000000000e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.32198023075050020e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 1.79850757146013485e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 2.16840442140282663e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 2.47807154022197462e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 2.74638507267385013e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 0;
            l=0;
            r = g.rnlp(n,l);
            i = 9;
            exact = -2.16840442140282663e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 2.47807154022197462e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -2.74638507267385013e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=0;
            r = g.rnlp(n,l);
            i = 12;
            exact = 8.66639007453691868e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -8.91729870909936828e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=0;
            r = g.rnlp(n,l);
            i = 9;
            exact = -6.97748517721321448e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 1.97852113142792607e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 2.44271302079553987e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.77621741053728029e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.80561296694321666e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 2.14965049420876670e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 2.87273668988151739e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = -5.78715292978526717e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 3.75446225456850381e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.19822378257343587e+01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -2.59910355189205866e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 1.88940266256636957e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -6.48224605439561008e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 8.95940657127647480e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -2.01590163575141197e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.19822378257343587e+01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 2.59910355189205866e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 1.88940266256636957e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 6.48224605439561008e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 8.95940657127647480e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 2.01590163575141197e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.77621741053728029e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -1.80561296694321666e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 2.14965049420876670e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -2.87273668988151739e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = -5.78715292978526717e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -3.75446225456850381e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.60267034903721741e-10;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -2.56247390565564865e-10;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 1.00204874077533328e-10;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -1.68527185127306691e-11;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 1.32633156186227036e-12;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -4.97857828210297353e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.08775684768582366e+01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -6.18391032576240027e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -9.17718829164970323e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 7.27641771748153090e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 1.45035821991845720e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.18688012530858096e+01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -2.22880079087442982e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -1.33180134100535050e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 2.89311654858050329e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 3.32835978333160121e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.18688012530858096e+01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 2.22880079087442982e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -1.33180134100535050e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -2.89311654858050329e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 3.32835978333160121e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.08775684768582366e+01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 6.18391032576240027e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -9.17718829164970323e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -7.27641771748153090e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 1.45035821991845720e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.90278525861057943e+01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 8.78775137729619093e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -2.52594114788140973e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -8.24285673816764725e-14;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = -1.10123909261290486e-19;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50849480740676434e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -2.58293860288335944e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -2.07063600559659463e-16;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50949687272003708e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -8.61240599236203343e-10;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -2.07327540364256062e-16;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50949687272003708e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 8.61240599236203343e-10;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -2.07327540364256062e-16;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50849480740676434e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 2.58293860288335944e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -2.07063600559659463e-16;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.50649122351290821e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 4.30228801910451485e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -2.06536152937712491e-16;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
        }
        {
            double a = 1e10;
            GaussianConvolution1D<double> g(8,sqrt(a/pi),a,0,false);
            n = 0;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.00000000000000000e-01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.32278609519677226e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 1.80234849054933588e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 2.17834302709225502e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = 2.49780041123299235e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 2.78011463893526400e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 4;
            l=0;
            r = g.rnlp(n,l);
            i = 12;
            exact = 9.85994473913733493e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -1.08963047031019240e+01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 8;
            l=0;
            r = g.rnlp(n,l);
            i = 12;
            exact = 3.17378652019804868e+01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -3.10371707224047384e+01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 12;
            l=0;
            r = g.rnlp(n,l);
            i = 9;
            exact = -3.55193478516153949e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = -8.76624415465518325e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 4.45211896310375366e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.95753699701407591e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 1.01817522582965636e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -4.26716664222736262e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 9.05830429656977076e-06;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = -4.09146442457520497e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 2.46678858892003107e-10;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.24040427814888830e+02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -6.51252735045721654e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 7.18690903438790468e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -4.13584998317234614e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = -1.74068139575386427e-06;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 5.03038032706968060e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 1.24040427814888830e+02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 6.51252735045721654e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 7.18690903438790468e-02;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 4.13584998317234614e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = -1.74068139575386427e-06;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -5.03038032706968060e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 3.95753699701407591e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -1.01817522582965636e+00;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -4.26716664222736262e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -9.05830429656977076e-06;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = -4.09146442457520497e-08;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = -2.46678858892003107e-10;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 16;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 2.03517586076878889e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -1.49274934514448811e-03;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = 9.66085723513747846e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -9.25718189118173804e-07;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 12;
            exact = -1.51883153358735018e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 15;
            exact = 2.59891477668870922e-12;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=-2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.39414070815156137e+01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -2.49387003254647314e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -1.78376303140302747e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 1.87233252628364406e-15;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=-1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.49300601109782676e+01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = -8.56943996085143253e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -2.03858147916271143e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = 6.67700051743989307e-16;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=0;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.49300601109782676e+01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 8.56943996085143253e-05;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -2.03858147916271143e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -6.67700051743989307e-16;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=1;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.39414070815156137e+01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 2.49387003254647314e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -1.78376303140302747e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -1.87233252628364406e-15;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            n = 20;
            l=2;
            r = g.rnlp(n,l);
            i = 0;
            exact = 5.20171632178656012e+01;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 3;
            exact = 3.90952885279176158e-04;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 6;
            exact = -1.31483311173371317e-09;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
            i = 9;
            exact = -2.71474799023069306e-15;
            err = abs(r(i)-exact);
            //cout << a << " " << n << " " << l << " " << i << " " << exact << " " << r(i) << " " << err << endl;
            maxerr = max(maxerr,err);
        }
        //cout << "MAXERR " << maxerr << endl;
        return (maxerr < 2e-13);
    }
}
