package test.parser.ps;

import static org.junit.Assert.assertEquals;
import net.sf.latexdraw.parsers.ps.InvalidFormatPSFunctionException;
import net.sf.latexdraw.parsers.ps.PSDupCommand;

import org.junit.Test;

public class TestPSDupCommand extends TestPSCommand<PSDupCommand> {
	@Override protected PSDupCommand createCmd() { return new PSDupCommand(); }

	@Override @Test
	public void testExecuteVal0() throws InvalidFormatPSFunctionException {
		dequeue.push(0.0);
		cmd.execute(dequeue, 0.0);
		assertEquals(0.0,dequeue.peek(),0.0);
		assertEquals(2,dequeue.size());
	}

	@Override @Test
	public void testExecuteValNeg() throws InvalidFormatPSFunctionException {
		dequeue.push(-10.0);
		cmd.execute(dequeue, 0.0);
		assertEquals(-10.0,dequeue.peek(),0.0);
		assertEquals(2,dequeue.size());
	}

	@Override @Test
	public void testExecuteValPos() throws InvalidFormatPSFunctionException {
		dequeue.push(10.0);
		cmd.execute(dequeue, 0.0);
		assertEquals(10.0,dequeue.peek(),0.0);
		assertEquals(2,dequeue.size());
	}

	@Override @Test(expected=InvalidFormatPSFunctionException.class)
	public void testExecuteInvalidDequeueSize() throws InvalidFormatPSFunctionException {
		cmd.execute(dequeue, 0.0);
	}
}
