/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.xiphias.dom;

import java.util.ArrayList;

import org.dbdoclet.progress.ProgressEvent;
import org.dbdoclet.progress.ProgressListener;
import org.dbdoclet.progress.ProgressManager;
import org.w3c.dom.Node;

public abstract class AbstractNodeVisitor implements INodeVisitor {

	protected final ArrayList<ProgressListener> listeners;
	private ProgressManager pm;

	public AbstractNodeVisitor() {
		this.listeners = new ArrayList<ProgressListener>();
		pm = new ProgressManager(listeners);
	}

	public AbstractNodeVisitor(ArrayList<ProgressListener> listeners) {
		this.listeners = listeners;
		pm = new ProgressManager(listeners);
	}

	protected void fireProgressEvent(String msg, int stage) {
		
		ProgressEvent event = new ProgressEvent(msg);
		event.setStage(stage);
		pm.fireProgressEvent(event);
	}

	public abstract void accept(Node node) throws Exception;

	protected void removeNodes(ArrayList<Node> nodeList) {
		
		for (Node node : nodeList) {
			
			Node parent = node.getParentNode();
			
			if (parent != null) {
				parent.removeChild(node);
			}
		}
	}

}