// Generated by gmmproc 2.50.0 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_TOC_H
#define _GSTREAMERMM_TOC_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <gstreamermm/miniobject.h>
#include <gstreamermm/taglist.h>


namespace Gst
{
class TocEntry;

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var TocScope TOC_SCOPE_GLOBAL
 * Global TOC representing all selectable options
 * (this is what applications are usually interested in).
 * 
 *  @var TocScope TOC_SCOPE_CURRENT
 * TOC for the currently active/selected stream
 * (this is a TOC representing the current stream from start to EOS,
 * and is what a TOC writer / muxer is usually interested in; it will
 * usually be a subset of the global TOC, e.g. just the chapters of
 * the current title, or the chapters selected for playback from the
 * current title).
 * 
 *  @enum TocScope
 * 
 * The scope of a TOC.
 *
 * @ingroup gstreamermmEnums
 */
enum TocScope
{
  TOC_SCOPE_GLOBAL = 1,
  TOC_SCOPE_CURRENT
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::TocScope> : public Glib::Value_Enum<Gst::TocScope>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** 
 *  @var TocEntryType TOC_ENTRY_TYPE_ANGLE
 * Entry is an angle (i.e.\ an alternative).
 * 
 *  @var TocEntryType TOC_ENTRY_TYPE_VERSION
 * Entry is a version (i.e. alternative).
 * 
 *  @var TocEntryType TOC_ENTRY_TYPE_EDITION
 * Entry is an edition (i.e. alternative).
 * 
 *  @var TocEntryType TOC_ENTRY_TYPE_INVALID
 * Invalid entry type value.
 * 
 *  @var TocEntryType TOC_ENTRY_TYPE_TITLE
 * Entry is a title (i.e. a part of a sequence).
 * 
 *  @var TocEntryType TOC_ENTRY_TYPE_TRACK
 * Entry is a track (i.e. a part of a sequence).
 * 
 *  @var TocEntryType TOC_ENTRY_TYPE_CHAPTER
 * Entry is a chapter (i.e. a part of a sequence).
 * 
 *  @enum TocEntryType
 * 
 * The different types of TOC entries (see Gst::TocEntry).
 * 
 * There are two types of TOC entries: alternatives or parts in a sequence.
 *
 * @ingroup gstreamermmEnums
 */
enum TocEntryType
{
  TOC_ENTRY_TYPE_ANGLE = -3,
  TOC_ENTRY_TYPE_VERSION,
  TOC_ENTRY_TYPE_EDITION,
  TOC_ENTRY_TYPE_INVALID,
  TOC_ENTRY_TYPE_TITLE,
  TOC_ENTRY_TYPE_TRACK,
  TOC_ENTRY_TYPE_CHAPTER
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::TocEntryType> : public Glib::Value_Enum<Gst::TocEntryType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** 
 *  @var TocLoopType TOC_LOOP_NONE
 * Single forward playback.
 * 
 *  @var TocLoopType TOC_LOOP_FORWARD
 * Repeat forward.
 * 
 *  @var TocLoopType TOC_LOOP_REVERSE
 * Repeat backward.
 * 
 *  @var TocLoopType TOC_LOOP_PING_PONG
 * Repeat forward and backward.
 * 
 *  @enum TocLoopType
 * 
 * How a Gst::TocEntry should be repeated. By default, entries are played a
 * single time.
 *
 * @ingroup gstreamermmEnums
 */
enum TocLoopType
{
  TOC_LOOP_NONE,
  TOC_LOOP_FORWARD,
  TOC_LOOP_REVERSE,
  TOC_LOOP_PING_PONG
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::TocLoopType> : public Glib::Value_Enum<Gst::TocLoopType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{


/** Gst::Toc lets you to inform other elements in pipeline or application that playing
 * source has some kind of table of contents (TOC). These may be chapters, editions,
 * angles or other types. For example: DVD chapters, Matroska chapters or cue sheet
 * TOC. Such TOC will be useful for applications to display instead of just a
 * playlist.
 *
 * Using TOC is very easy. Firstly, create Gst::Toc structure which represents root
 * contents of the source. You can also attach TOC-specific tags to it. Then fill
 * it with Gst::TocEntry entries by appending them to the Gst::Toc using
 * append_entry(), and appending subentries to a Gst::TocEntry using
 * append_sub_entry().
 *
 * Note that root level of the TOC can contain only either editions or chapters. You
 * should not mix them together at the same level. Otherwise you will get serialization
 * /deserialization errors. Make sure that no one of the entries has negative start and
 *  stop values.
 *
 * Use Gst::EventToc class to create TOC event, and parse_toc() to
 * parse received TOC event. Use Gst::EventTocSelect to create a new TOC select event,
 * and parse_toc_select() to parse received TOC select event. The same rule for
 * the messages: MessageToc to create new TOC message, and
 * parse() to parse received TOC message.
 *
 * TOCs can have global scope or current scope. Global scope TOCs contain
 * all entries that can possibly be selected using a toc select event, and
 * are what an application is usually interested in. TOCs with current scope
 * only contain the parts of the TOC relevant to the currently selected/playing
 * stream; the current scope TOC is used by downstream elements such as muxers
 * to write correct TOC entries when transcoding files, for example. When
 * playing a DVD, the global TOC would contain a hierarchy of all titles,
 * chapters and angles, for example, while the current TOC would only contain
 * the chapters for the currently playing title if playback of a specific
 * title was requested.
 *
 * Applications and plugins should not rely on TOCs having a certain kind of
 * structure, but should allow for different alternatives. For example, a
 * simple CUE sheet embedded in a file may be presented as a flat list of
 * track entries, or could have a top-level edition node (or some other
 * alternative type entry) with track entries underneath that node; or even
 * multiple top-level edition nodes (or some other alternative type entries)
 * each with track entries underneath, in case the source file has extracted
 * a track listing from different sources).
 */
class Toc : public MiniObject
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = Toc;
  using BaseObjectType = GstToc;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GstToc*       gobj();

  ///Provides access to the underlying C instance.
  const GstToc* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstToc* gobj_copy() const;

  Toc() = delete;

  // noncopyable
  Toc(const Toc&) = delete;
  Toc& operator=(const Toc&) = delete;

protected:
  // Do not derive this.  Gst::Toc can neither be constructed nor deleted.

  void operator delete(void*, std::size_t);

private:

public:
  
  /** Appends the Gst::TocEntry @a entry to @a toc.
   * 
   * @param entry A Gst::TocEntry.
   */
  void append_entry(Glib::RefPtr<Gst::TocEntry> entry);
  
  void dump();
  
  void dump() const;

  
  /** Set a Gst::TagList with tags for the complete @a toc.
   * 
   * @param tags A Gst::TagList or <tt>nullptr</tt>.
   */
  void set_tags(const Gst::TagList& tags);
 

  /** Gets the tags for @a toc.
   * 
   * @return A Gst::TagList for @a entry.
   */
  Gst::TagList get_tags() const;

  
  /** @return Scope of @a toc.
   */
  Gst::TocScope get_scope() const;
  
  /** Find Gst::TocEntry with given @a uid in the @a toc.
   * 
   * @param uid UID to find Gst::TocEntry with.
   * @return Gst::TocEntry with specified
   *  @a uid from the @a toc, or <tt>nullptr</tt> if not found.
   */
  Glib::RefPtr<Gst::TocEntry> find_entry(const Glib::ustring& uid) const;


};

class TocEntry : public MiniObject
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = TocEntry;
  using BaseObjectType = GstTocEntry;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GstTocEntry*       gobj();

  ///Provides access to the underlying C instance.
  const GstTocEntry* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstTocEntry* gobj_copy() const;

  TocEntry() = delete;

  // noncopyable
  TocEntry(const TocEntry&) = delete;
  TocEntry& operator=(const TocEntry&) = delete;

protected:
  // Do not derive this.  Gst::TocEntry can neither be constructed nor deleted.

  void operator delete(void*, std::size_t);

private:

public:
  
  /** @return  @a entry's entry type.
   */
  TocEntryType get_entry_type();
  
  /** Gets the UID of @a entry.
   * 
   * @return The UID of @a entry.
   */
  Glib::ustring get_uid();
  
  /** Appends the Gst::TocEntry @a entry to @a entry.
   * 
   * @param entry A Gst::TocEntry.
   */
  void append_sub_entry(Glib::RefPtr<Gst::TocEntry> entry);

  
  /** @return <tt>true</tt> if @a entry's type is an alternative type, otherwise <tt>false</tt>.
   */
  bool is_alternative();
  
  /** @return <tt>true</tt> if @a entry's type is an alternative type, otherwise <tt>false</tt>.
   */
  bool is_alternative() const;

  
  /** @return <tt>true</tt> if @a entry's type is a sequence type, otherwise <tt>false</tt>.
   */
  bool is_sequence();
  
  /** @return <tt>true</tt> if @a entry's type is a sequence type, otherwise <tt>false</tt>.
   */
  bool is_sequence() const;

  
  /** Gets the parent Gst::TocEntry of @a entry.
   * 
   * @return The parent Gst::TocEntry of @a entry.
   */
  Glib::RefPtr<Gst::TocEntry> get_parent();
  
  /** Set @a start and @a stop values for the @a entry.
   * 
   * @param start Start value to set.
   * @param stop Stop value to set.
   */
  void set_start_stop_times(gint64 start, gint64 stop);

  
  /** Get @a start and @a stop values from the @a entry and write them into appropriate
   * storages.
   * 
   * @param start The storage for the start value, leave
   * <tt>nullptr</tt> if not need.
   * @param stop The storage for the stop value, leave
   * <tt>nullptr</tt> if not need.
   * @return <tt>true</tt> if all non-<tt>nullptr</tt> storage pointers were filled with appropriate
   * values, <tt>false</tt> otherwise.
   */
  bool get_start_stop_times(gint64& start, gint64& stop);
  
  /** Get @a start and @a stop values from the @a entry and write them into appropriate
   * storages.
   * 
   * @param start The storage for the start value, leave
   * <tt>nullptr</tt> if not need.
   * @param stop The storage for the stop value, leave
   * <tt>nullptr</tt> if not need.
   * @return <tt>true</tt> if all non-<tt>nullptr</tt> storage pointers were filled with appropriate
   * values, <tt>false</tt> otherwise.
   */
  bool get_start_stop_times(gint64& start, gint64& stop) const;

  
  /** Get @a loop_type and @a repeat_count values from the @a entry and write them into
   * appropriate storages. Loops are e.g. used by sampled instruments. GStreamer
   * is not automatically applying the loop. The application can process this
   * meta data and use it e.g. to send a seek-event to loop a section.
   * 
   * @param loop_type The storage for the loop_type
   * value, leave <tt>nullptr</tt> if not need.
   * @param repeat_count The storage for the repeat_count
   * value, leave <tt>nullptr</tt> if not need.
   * @return <tt>true</tt> if all non-<tt>nullptr</tt> storage pointers were filled with appropriate
   * values, <tt>false</tt> otherwise.
   */
  bool get_loop(Gst::TocLoopType& loop_type, gint& repeat_count) const;
  
  /** Set @a loop_type and @a repeat_count values for the @a entry.
   * 
   * @param loop_type Loop_type value to set.
   * @param repeat_count Repeat_count value to set.
   */
  void set_loop(Gst::TocLoopType loop_type, gint repeat_count);

  
  /** Gets the parent Gst::Toc of @a entry.
   * 
   * @return The parent Gst::Toc of @a entry.
   */
  Glib::RefPtr<Gst::Toc> get_toc() const;


};


}


namespace Glib
{

  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Toc
   */
  Glib::RefPtr<Gst::Toc> wrap(GstToc* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::TocEntry
   */
  Glib::RefPtr<Gst::TocEntry> wrap(GstTocEntry* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_TOC_H */

