// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/devtools/clouderrorreporting/v1beta1/common.proto
// DO NOT EDIT!

/*
Package google_devtools_clouderrorreporting_v1beta1 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/devtools/clouderrorreporting/v1beta1/common.proto
	google.golang.org/genproto/googleapis/devtools/clouderrorreporting/v1beta1/error_group_service.proto
	google.golang.org/genproto/googleapis/devtools/clouderrorreporting/v1beta1/error_stats_service.proto
	google.golang.org/genproto/googleapis/devtools/clouderrorreporting/v1beta1/report_errors_service.proto

It has these top-level messages:
	ErrorGroup
	TrackingIssue
	ErrorEvent
	ServiceContext
	ErrorContext
	HttpRequestContext
	SourceLocation
	GetGroupRequest
	UpdateGroupRequest
	ListGroupStatsRequest
	ListGroupStatsResponse
	ErrorGroupStats
	TimedCount
	ListEventsRequest
	ListEventsResponse
	QueryTimeRange
	ServiceContextFilter
	DeleteEventsRequest
	DeleteEventsResponse
	ReportErrorEventRequest
	ReportErrorEventResponse
	ReportedErrorEvent
*/
package google_devtools_clouderrorreporting_v1beta1 // import "google.golang.org/genproto/googleapis/devtools/clouderrorreporting/v1beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_protobuf1 "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Description of a group of similar error events.
type ErrorGroup struct {
	// The group resource name.
	// Example: <code>projects/my-project-123/groups/my-groupid</code>
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Group IDs are unique for a given project. If the same kind of error
	// occurs in different service contexts, it will receive the same group ID.
	GroupId string `protobuf:"bytes,2,opt,name=group_id,json=groupId" json:"group_id,omitempty"`
	// Associated tracking issues.
	TrackingIssues []*TrackingIssue `protobuf:"bytes,3,rep,name=tracking_issues,json=trackingIssues" json:"tracking_issues,omitempty"`
}

func (m *ErrorGroup) Reset()                    { *m = ErrorGroup{} }
func (m *ErrorGroup) String() string            { return proto.CompactTextString(m) }
func (*ErrorGroup) ProtoMessage()               {}
func (*ErrorGroup) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *ErrorGroup) GetTrackingIssues() []*TrackingIssue {
	if m != nil {
		return m.TrackingIssues
	}
	return nil
}

// Information related to tracking the progress on resolving the error.
type TrackingIssue struct {
	// A URL pointing to a related entry in an issue tracking system.
	// Example: https://github.com/user/project/issues/4
	Url string `protobuf:"bytes,1,opt,name=url" json:"url,omitempty"`
}

func (m *TrackingIssue) Reset()                    { *m = TrackingIssue{} }
func (m *TrackingIssue) String() string            { return proto.CompactTextString(m) }
func (*TrackingIssue) ProtoMessage()               {}
func (*TrackingIssue) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// An error event which is returned by the Error Reporting system.
type ErrorEvent struct {
	// Time when the event occurred as provided in the error report.
	// If the report did not contain a timestamp, the time the error was received
	// by the Error Reporting system is used.
	EventTime *google_protobuf1.Timestamp `protobuf:"bytes,1,opt,name=event_time,json=eventTime" json:"event_time,omitempty"`
	// The `ServiceContext` for which this error was reported.
	ServiceContext *ServiceContext `protobuf:"bytes,2,opt,name=service_context,json=serviceContext" json:"service_context,omitempty"`
	// The stack trace that was reported or logged by the service.
	Message string `protobuf:"bytes,3,opt,name=message" json:"message,omitempty"`
	// Data about the context in which the error occurred.
	Context *ErrorContext `protobuf:"bytes,5,opt,name=context" json:"context,omitempty"`
}

func (m *ErrorEvent) Reset()                    { *m = ErrorEvent{} }
func (m *ErrorEvent) String() string            { return proto.CompactTextString(m) }
func (*ErrorEvent) ProtoMessage()               {}
func (*ErrorEvent) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *ErrorEvent) GetEventTime() *google_protobuf1.Timestamp {
	if m != nil {
		return m.EventTime
	}
	return nil
}

func (m *ErrorEvent) GetServiceContext() *ServiceContext {
	if m != nil {
		return m.ServiceContext
	}
	return nil
}

func (m *ErrorEvent) GetContext() *ErrorContext {
	if m != nil {
		return m.Context
	}
	return nil
}

// Describes a running service that sends errors.
// Its version changes over time and multiple versions can run in parallel.
type ServiceContext struct {
	// An identifier of the service, such as the name of the
	// executable, job, or Google App Engine service name. This field is expected
	// to have a low number of values that are relatively stable over time, as
	// opposed to `version`, which can be changed whenever new code is deployed.
	//
	// Contains the service name for error reports extracted from Google
	// App Engine logs or `default` if the App Engine default service is used.
	Service string `protobuf:"bytes,2,opt,name=service" json:"service,omitempty"`
	// Represents the source code version that the developer provided,
	// which could represent a version label or a Git SHA-1 hash, for example.
	Version string `protobuf:"bytes,3,opt,name=version" json:"version,omitempty"`
}

func (m *ServiceContext) Reset()                    { *m = ServiceContext{} }
func (m *ServiceContext) String() string            { return proto.CompactTextString(m) }
func (*ServiceContext) ProtoMessage()               {}
func (*ServiceContext) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

// A description of the context in which an error occurred.
// This data should be provided by the application when reporting an error,
// unless the
// error report has been generated automatically from Google App Engine logs.
type ErrorContext struct {
	// The HTTP request which was processed when the error was
	// triggered.
	HttpRequest *HttpRequestContext `protobuf:"bytes,1,opt,name=http_request,json=httpRequest" json:"http_request,omitempty"`
	// The user who caused or was affected by the crash.
	// This can be a user ID, an email address, or an arbitrary token that
	// uniquely identifies the user.
	// When sending an error report, leave this field empty if the user was not
	// logged in. In this case the
	// Error Reporting system will use other data, such as remote IP address, to
	// distinguish affected users. See `affected_users_count` in
	// `ErrorGroupStats`.
	User string `protobuf:"bytes,2,opt,name=user" json:"user,omitempty"`
	// The location in the source code where the decision was made to
	// report the error, usually the place where it was logged.
	// For a logged exception this would be the source line where the
	// exception is logged, usually close to the place where it was
	// caught. This value is in contrast to `Exception.cause_location`,
	// which describes the source line where the exception was thrown.
	ReportLocation *SourceLocation `protobuf:"bytes,3,opt,name=report_location,json=reportLocation" json:"report_location,omitempty"`
}

func (m *ErrorContext) Reset()                    { *m = ErrorContext{} }
func (m *ErrorContext) String() string            { return proto.CompactTextString(m) }
func (*ErrorContext) ProtoMessage()               {}
func (*ErrorContext) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *ErrorContext) GetHttpRequest() *HttpRequestContext {
	if m != nil {
		return m.HttpRequest
	}
	return nil
}

func (m *ErrorContext) GetReportLocation() *SourceLocation {
	if m != nil {
		return m.ReportLocation
	}
	return nil
}

// HTTP request data that is related to a reported error.
// This data should be provided by the application when reporting an error,
// unless the
// error report has been generated automatically from Google App Engine logs.
type HttpRequestContext struct {
	// The type of HTTP request, such as `GET`, `POST`, etc.
	Method string `protobuf:"bytes,1,opt,name=method" json:"method,omitempty"`
	// The URL of the request.
	Url string `protobuf:"bytes,2,opt,name=url" json:"url,omitempty"`
	// The user agent information that is provided with the request.
	UserAgent string `protobuf:"bytes,3,opt,name=user_agent,json=userAgent" json:"user_agent,omitempty"`
	// The referrer information that is provided with the request.
	Referrer string `protobuf:"bytes,4,opt,name=referrer" json:"referrer,omitempty"`
	// The HTTP response status code for the request.
	ResponseStatusCode int32 `protobuf:"varint,5,opt,name=response_status_code,json=responseStatusCode" json:"response_status_code,omitempty"`
	// The IP address from which the request originated.
	// This can be IPv4, IPv6, or a token which is derived from the
	// IP address, depending on the data that has been provided
	// in the error report.
	RemoteIp string `protobuf:"bytes,6,opt,name=remote_ip,json=remoteIp" json:"remote_ip,omitempty"`
}

func (m *HttpRequestContext) Reset()                    { *m = HttpRequestContext{} }
func (m *HttpRequestContext) String() string            { return proto.CompactTextString(m) }
func (*HttpRequestContext) ProtoMessage()               {}
func (*HttpRequestContext) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

// Indicates a location in the source code of the service for which
// errors are reported.
// This data should be provided by the application when reporting an error,
// unless the error report has been generated automatically from Google App
// Engine logs. All fields are optional.
type SourceLocation struct {
	// The source code filename, which can include a truncated relative
	// path, or a full path from a production machine.
	FilePath string `protobuf:"bytes,1,opt,name=file_path,json=filePath" json:"file_path,omitempty"`
	// 1-based. 0 indicates that the line number is unknown.
	LineNumber int32 `protobuf:"varint,2,opt,name=line_number,json=lineNumber" json:"line_number,omitempty"`
	// Human-readable name of a function or method.
	// The value can include optional context like the class or package name.
	// For example, `my.package.MyClass.method` in case of Java.
	FunctionName string `protobuf:"bytes,4,opt,name=function_name,json=functionName" json:"function_name,omitempty"`
}

func (m *SourceLocation) Reset()                    { *m = SourceLocation{} }
func (m *SourceLocation) String() string            { return proto.CompactTextString(m) }
func (*SourceLocation) ProtoMessage()               {}
func (*SourceLocation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func init() {
	proto.RegisterType((*ErrorGroup)(nil), "google.devtools.clouderrorreporting.v1beta1.ErrorGroup")
	proto.RegisterType((*TrackingIssue)(nil), "google.devtools.clouderrorreporting.v1beta1.TrackingIssue")
	proto.RegisterType((*ErrorEvent)(nil), "google.devtools.clouderrorreporting.v1beta1.ErrorEvent")
	proto.RegisterType((*ServiceContext)(nil), "google.devtools.clouderrorreporting.v1beta1.ServiceContext")
	proto.RegisterType((*ErrorContext)(nil), "google.devtools.clouderrorreporting.v1beta1.ErrorContext")
	proto.RegisterType((*HttpRequestContext)(nil), "google.devtools.clouderrorreporting.v1beta1.HttpRequestContext")
	proto.RegisterType((*SourceLocation)(nil), "google.devtools.clouderrorreporting.v1beta1.SourceLocation")
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/devtools/clouderrorreporting/v1beta1/common.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 651 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x94, 0x54, 0xcd, 0x6e, 0x13, 0x31,
	0x10, 0x56, 0x9a, 0xfe, 0x65, 0xd2, 0xa6, 0xc8, 0x42, 0x68, 0x09, 0x42, 0x94, 0xe5, 0x52, 0x09,
	0x69, 0x97, 0x96, 0x53, 0xe9, 0x01, 0x68, 0xa9, 0x20, 0x12, 0xaa, 0xaa, 0x4d, 0x25, 0x8e, 0x2b,
	0x67, 0x77, 0xb2, 0xb1, 0xd8, 0xb5, 0x8d, 0xed, 0x8d, 0xe0, 0x5d, 0x38, 0xf0, 0x38, 0x3c, 0x0c,
	0x0f, 0x81, 0xec, 0xb5, 0xfb, 0xa3, 0x72, 0x20, 0x37, 0x7f, 0xf3, 0xf3, 0xcd, 0x37, 0xe3, 0xb1,
	0xe1, 0x4b, 0x25, 0x44, 0x55, 0x63, 0x52, 0x89, 0x9a, 0xf2, 0x2a, 0x11, 0xaa, 0x4a, 0x2b, 0xe4,
	0x52, 0x09, 0x23, 0xd2, 0xce, 0x45, 0x25, 0xd3, 0x69, 0x89, 0x4b, 0x23, 0x44, 0xad, 0xd3, 0xa2,
	0x16, 0x6d, 0x89, 0x4a, 0x09, 0xa5, 0x50, 0x0a, 0x65, 0x18, 0xaf, 0xd2, 0xe5, 0xe1, 0x0c, 0x0d,
	0x3d, 0x4c, 0x0b, 0xd1, 0x34, 0x82, 0x27, 0x2e, 0x99, 0xbc, 0xf4, 0xc4, 0x21, 0x33, 0xf9, 0x47,
	0x66, 0xe2, 0x33, 0xc7, 0x93, 0xff, 0x53, 0x41, 0x25, 0x4b, 0x35, 0xaa, 0x25, 0x2b, 0xb0, 0x10,
	0x7c, 0xce, 0xaa, 0x94, 0x72, 0x2e, 0x0c, 0x35, 0x4c, 0x70, 0xdd, 0xd5, 0x1d, 0x9f, 0x54, 0xcc,
	0x2c, 0xda, 0x59, 0x52, 0x88, 0x26, 0xed, 0xe8, 0x52, 0xe7, 0x98, 0xb5, 0xf3, 0x54, 0x9a, 0x1f,
	0x12, 0x75, 0x6a, 0x58, 0x83, 0xda, 0xd0, 0x46, 0xde, 0x9c, 0xba, 0xe4, 0xf8, 0x57, 0x0f, 0xe0,
	0xdc, 0x4a, 0xfc, 0xa8, 0x44, 0x2b, 0x09, 0x81, 0x75, 0x4e, 0x1b, 0x8c, 0x7a, 0xfb, 0xbd, 0x83,
	0x41, 0xe6, 0xce, 0xe4, 0x31, 0x6c, 0x57, 0xd6, 0x99, 0xb3, 0x32, 0x5a, 0x73, 0xf6, 0x2d, 0x87,
	0x27, 0x25, 0x29, 0x60, 0xcf, 0x28, 0x5a, 0x7c, 0x65, 0xbc, 0xca, 0x99, 0xd6, 0x2d, 0xea, 0xa8,
	0xbf, 0xdf, 0x3f, 0x18, 0x1e, 0xbd, 0x49, 0x56, 0x18, 0x46, 0x72, 0xe5, 0x39, 0x26, 0x96, 0x22,
	0x1b, 0x99, 0xdb, 0x50, 0xc7, 0xcf, 0x61, 0xf7, 0x4e, 0x00, 0x79, 0x00, 0xfd, 0x56, 0xd5, 0x5e,
	0xa3, 0x3d, 0xc6, 0x3f, 0xd7, 0x7c, 0x17, 0xe7, 0x4b, 0xe4, 0x86, 0x1c, 0x03, 0xa0, 0x3d, 0xe4,
	0xb6, 0x5b, 0x17, 0x37, 0x3c, 0x1a, 0x07, 0x45, 0x61, 0x36, 0xc9, 0x55, 0x18, 0x45, 0x36, 0x70,
	0xd1, 0x16, 0x93, 0x12, 0xf6, 0xfc, 0xbc, 0xf3, 0x42, 0x70, 0x83, 0xdf, 0x8d, 0xeb, 0x79, 0x78,
	0x74, 0xb2, 0x52, 0x47, 0xd3, 0x8e, 0xe3, 0xac, 0xa3, 0xc8, 0x46, 0xfa, 0x0e, 0x26, 0x11, 0x6c,
	0x35, 0xa8, 0x35, 0xad, 0x30, 0xea, 0x77, 0x13, 0xf5, 0x90, 0x4c, 0x61, 0x2b, 0xd4, 0xdd, 0x70,
	0x75, 0x8f, 0x57, 0xaa, 0xeb, 0x86, 0x10, 0xaa, 0x06, 0xa6, 0xf8, 0x03, 0x8c, 0xa6, 0xf7, 0x04,
	0x78, 0x49, 0xe1, 0x4a, 0x3d, 0xb4, 0x9e, 0x25, 0x2a, 0xcd, 0x04, 0x0f, 0xd2, 0x3c, 0x8c, 0xff,
	0xf4, 0x60, 0xe7, 0x36, 0x3f, 0x99, 0xc1, 0xce, 0xc2, 0x18, 0x99, 0x2b, 0xfc, 0xd6, 0xa2, 0x36,
	0x7e, 0xd0, 0x6f, 0x57, 0x12, 0xfc, 0xc9, 0x18, 0x99, 0x75, 0xf9, 0x41, 0xf6, 0x70, 0x71, 0x63,
	0xb3, 0x0b, 0xd9, 0x6a, 0x54, 0x5e, 0xa5, 0x3b, 0xdb, 0x3b, 0xea, 0x88, 0xf2, 0x5a, 0x14, 0xee,
	0x29, 0x38, 0xa9, 0x2b, 0xdf, 0x91, 0x68, 0x55, 0x81, 0x9f, 0x3d, 0x45, 0x36, 0xea, 0x22, 0x02,
	0x8e, 0x7f, 0xf7, 0x80, 0xdc, 0x57, 0x47, 0x1e, 0xc1, 0x66, 0x83, 0x66, 0x21, 0x4a, 0xbf, 0x7f,
	0x1e, 0x85, 0xa5, 0x5c, 0xbb, 0x5e, 0x4a, 0xf2, 0x14, 0xc0, 0xca, 0xcd, 0x69, 0x85, 0xdc, 0xf8,
	0x61, 0x0e, 0xac, 0xe5, 0xbd, 0x35, 0x90, 0x31, 0x6c, 0x2b, 0x9c, 0xa3, 0x52, 0xa8, 0xa2, 0x75,
	0xe7, 0xbc, 0xc6, 0xe4, 0x15, 0x3c, 0x54, 0xa8, 0xa5, 0xe0, 0x1a, 0x73, 0x6d, 0xa8, 0x69, 0x75,
	0x5e, 0x88, 0x12, 0xdd, 0x4a, 0x6c, 0x64, 0x24, 0xf8, 0xa6, 0xce, 0x75, 0x26, 0x4a, 0x24, 0x4f,
	0x60, 0xa0, 0xb0, 0x11, 0x06, 0x73, 0x26, 0xa3, 0xcd, 0x40, 0x67, 0x0d, 0x13, 0x19, 0x6b, 0x18,
	0xdd, 0x6d, 0xd6, 0x86, 0xcf, 0x59, 0x8d, 0xb9, 0xa4, 0x66, 0xe1, 0x1b, 0xd9, 0xb6, 0x86, 0x4b,
	0x6a, 0x16, 0xe4, 0x19, 0x0c, 0x6b, 0xc6, 0x31, 0xe7, 0x6d, 0x33, 0xf3, 0xa3, 0xdf, 0xc8, 0xc0,
	0x9a, 0x2e, 0x9c, 0x85, 0xbc, 0x80, 0xdd, 0x79, 0xcb, 0x0b, 0xcb, 0x94, 0xbb, 0xef, 0xa2, 0xd3,
	0xbf, 0x13, 0x8c, 0x17, 0xb4, 0xc1, 0xd3, 0x77, 0x60, 0xbf, 0xc7, 0x55, 0x6e, 0xe4, 0x74, 0x78,
	0xe6, 0xfe, 0xd3, 0x4b, 0xfb, 0x42, 0x2f, 0x7b, 0xb3, 0x4d, 0xf7, 0x54, 0x5f, 0xff, 0x0d, 0x00,
	0x00, 0xff, 0xff, 0xa2, 0xb2, 0x2c, 0x2b, 0xb2, 0x05, 0x00, 0x00,
}
