// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/appengine/v1/appengine.proto
// DO NOT EDIT!

/*
Package google_appengine_v1 is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/appengine/v1/appengine.proto
	google.golang.org/genproto/googleapis/appengine/v1/application.proto
	google.golang.org/genproto/googleapis/appengine/v1/app_yaml.proto
	google.golang.org/genproto/googleapis/appengine/v1/deploy.proto
	google.golang.org/genproto/googleapis/appengine/v1/instance.proto
	google.golang.org/genproto/googleapis/appengine/v1/location.proto
	google.golang.org/genproto/googleapis/appengine/v1/operation.proto
	google.golang.org/genproto/googleapis/appengine/v1/service.proto
	google.golang.org/genproto/googleapis/appengine/v1/version.proto

It has these top-level messages:
	GetApplicationRequest
	RepairApplicationRequest
	ListServicesRequest
	ListServicesResponse
	GetServiceRequest
	UpdateServiceRequest
	DeleteServiceRequest
	ListVersionsRequest
	ListVersionsResponse
	GetVersionRequest
	CreateVersionRequest
	UpdateVersionRequest
	DeleteVersionRequest
	ListInstancesRequest
	ListInstancesResponse
	GetInstanceRequest
	DeleteInstanceRequest
	DebugInstanceRequest
	Application
	UrlDispatchRule
	ApiConfigHandler
	ErrorHandler
	UrlMap
	StaticFilesHandler
	ScriptHandler
	ApiEndpointHandler
	HealthCheck
	Library
	Deployment
	FileInfo
	ContainerInfo
	ZipInfo
	Instance
	LocationMetadata
	OperationMetadataV1
	Service
	TrafficSplit
	Version
	AutomaticScaling
	BasicScaling
	ManualScaling
	CpuUtilization
	RequestUtilization
	DiskUtilization
	NetworkUtilization
	Network
	Resources
*/
package google_appengine_v1 // import "google.golang.org/genproto/googleapis/appengine/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import _ "google.golang.org/genproto/googleapis/iam/v1"
import _ "google.golang.org/genproto/googleapis/iam/v1"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import _ "github.com/golang/protobuf/ptypes/empty"
import google_protobuf5 "google.golang.org/genproto/protobuf"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Fields that should be returned when [Version][google.appengine.v1.Version] resources
// are retreived.
type VersionView int32

const (
	// Basic version information including scaling and inbound services,
	// but not detailed deployment information.
	VersionView_BASIC VersionView = 0
	// The information from `BASIC`, plus detailed information about the
	// deployment. This format is required when creating resources, but
	// is not returned in `Get` or `List` by default.
	VersionView_FULL VersionView = 1
)

var VersionView_name = map[int32]string{
	0: "BASIC",
	1: "FULL",
}
var VersionView_value = map[string]int32{
	"BASIC": 0,
	"FULL":  1,
}

func (x VersionView) String() string {
	return proto.EnumName(VersionView_name, int32(x))
}
func (VersionView) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Request message for `Applications.GetApplication`.
type GetApplicationRequest struct {
	// Name of the Application resource to get. Example: `apps/myapp`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetApplicationRequest) Reset()                    { *m = GetApplicationRequest{} }
func (m *GetApplicationRequest) String() string            { return proto.CompactTextString(m) }
func (*GetApplicationRequest) ProtoMessage()               {}
func (*GetApplicationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Request message for 'Applications.RepairApplication'.
type RepairApplicationRequest struct {
	// Name of the application to repair. Example: `apps/myapp`
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *RepairApplicationRequest) Reset()                    { *m = RepairApplicationRequest{} }
func (m *RepairApplicationRequest) String() string            { return proto.CompactTextString(m) }
func (*RepairApplicationRequest) ProtoMessage()               {}
func (*RepairApplicationRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Request message for `Services.ListServices`.
type ListServicesRequest struct {
	// Name of the parent Application resource. Example: `apps/myapp`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Maximum results to return per page.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Continuation token for fetching the next page of results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListServicesRequest) Reset()                    { *m = ListServicesRequest{} }
func (m *ListServicesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListServicesRequest) ProtoMessage()               {}
func (*ListServicesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// Response message for `Services.ListServices`.
type ListServicesResponse struct {
	// The services belonging to the requested application.
	Services []*Service `protobuf:"bytes,1,rep,name=services" json:"services,omitempty"`
	// Continuation token for fetching the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListServicesResponse) Reset()                    { *m = ListServicesResponse{} }
func (m *ListServicesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListServicesResponse) ProtoMessage()               {}
func (*ListServicesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *ListServicesResponse) GetServices() []*Service {
	if m != nil {
		return m.Services
	}
	return nil
}

// Request message for `Services.GetService`.
type GetServiceRequest struct {
	// Name of the resource requested. Example: `apps/myapp/services/default`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetServiceRequest) Reset()                    { *m = GetServiceRequest{} }
func (m *GetServiceRequest) String() string            { return proto.CompactTextString(m) }
func (*GetServiceRequest) ProtoMessage()               {}
func (*GetServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

// Request message for `Services.UpdateService`.
type UpdateServiceRequest struct {
	// Name of the resource to update. Example: `apps/myapp/services/default`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// A Service resource containing the updated service. Only fields set in the
	// field mask will be updated.
	Service *Service `protobuf:"bytes,2,opt,name=service" json:"service,omitempty"`
	// Standard field mask for the set of fields to be updated.
	UpdateMask *google_protobuf5.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
	// Set to `true` to gradually shift traffic from one version to another
	// single version. By default, traffic is shifted immediately.
	// For gradual traffic migration, the target version
	// must be located within instances that are configured for both
	// [warmup requests](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#inboundservicetype)
	// and
	// [automatic scaling](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#automaticscaling).
	// You must specify the
	// [`shardBy`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services#shardby)
	// field in the Service resource. Gradual traffic migration is not
	// supported in the App Engine flexible environment. For examples, see
	// [Migrating and Splitting Traffic](https://cloud.google.com/appengine/docs/admin-api/migrating-splitting-traffic).
	MigrateTraffic bool `protobuf:"varint,4,opt,name=migrate_traffic,json=migrateTraffic" json:"migrate_traffic,omitempty"`
}

func (m *UpdateServiceRequest) Reset()                    { *m = UpdateServiceRequest{} }
func (m *UpdateServiceRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateServiceRequest) ProtoMessage()               {}
func (*UpdateServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *UpdateServiceRequest) GetService() *Service {
	if m != nil {
		return m.Service
	}
	return nil
}

func (m *UpdateServiceRequest) GetUpdateMask() *google_protobuf5.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for `Services.DeleteService`.
type DeleteServiceRequest struct {
	// Name of the resource requested. Example: `apps/myapp/services/default`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteServiceRequest) Reset()                    { *m = DeleteServiceRequest{} }
func (m *DeleteServiceRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteServiceRequest) ProtoMessage()               {}
func (*DeleteServiceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

// Request message for `Versions.ListVersions`.
type ListVersionsRequest struct {
	// Name of the parent Service resource. Example:
	// `apps/myapp/services/default`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Controls the set of fields returned in the `List` response.
	View VersionView `protobuf:"varint,2,opt,name=view,enum=google.appengine.v1.VersionView" json:"view,omitempty"`
	// Maximum results to return per page.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Continuation token for fetching the next page of results.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListVersionsRequest) Reset()                    { *m = ListVersionsRequest{} }
func (m *ListVersionsRequest) String() string            { return proto.CompactTextString(m) }
func (*ListVersionsRequest) ProtoMessage()               {}
func (*ListVersionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

// Response message for `Versions.ListVersions`.
type ListVersionsResponse struct {
	// The versions belonging to the requested service.
	Versions []*Version `protobuf:"bytes,1,rep,name=versions" json:"versions,omitempty"`
	// Continuation token for fetching the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListVersionsResponse) Reset()                    { *m = ListVersionsResponse{} }
func (m *ListVersionsResponse) String() string            { return proto.CompactTextString(m) }
func (*ListVersionsResponse) ProtoMessage()               {}
func (*ListVersionsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *ListVersionsResponse) GetVersions() []*Version {
	if m != nil {
		return m.Versions
	}
	return nil
}

// Request message for `Versions.GetVersion`.
type GetVersionRequest struct {
	// Name of the resource requested. Example:
	// `apps/myapp/services/default/versions/v1`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Controls the set of fields returned in the `Get` response.
	View VersionView `protobuf:"varint,2,opt,name=view,enum=google.appengine.v1.VersionView" json:"view,omitempty"`
}

func (m *GetVersionRequest) Reset()                    { *m = GetVersionRequest{} }
func (m *GetVersionRequest) String() string            { return proto.CompactTextString(m) }
func (*GetVersionRequest) ProtoMessage()               {}
func (*GetVersionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

// Request message for `Versions.CreateVersion`.
type CreateVersionRequest struct {
	// Name of the parent resource to create this version under. Example:
	// `apps/myapp/services/default`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Application deployment configuration.
	Version *Version `protobuf:"bytes,2,opt,name=version" json:"version,omitempty"`
}

func (m *CreateVersionRequest) Reset()                    { *m = CreateVersionRequest{} }
func (m *CreateVersionRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateVersionRequest) ProtoMessage()               {}
func (*CreateVersionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *CreateVersionRequest) GetVersion() *Version {
	if m != nil {
		return m.Version
	}
	return nil
}

// Request message for `Versions.UpdateVersion`.
type UpdateVersionRequest struct {
	// Name of the resource to update. Example:
	// `apps/myapp/services/default/versions/1`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// A Version containing the updated resource. Only fields set in the field
	// mask will be updated.
	Version *Version `protobuf:"bytes,2,opt,name=version" json:"version,omitempty"`
	// Standard field mask for the set of fields to be updated.
	UpdateMask *google_protobuf5.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateVersionRequest) Reset()                    { *m = UpdateVersionRequest{} }
func (m *UpdateVersionRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateVersionRequest) ProtoMessage()               {}
func (*UpdateVersionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *UpdateVersionRequest) GetVersion() *Version {
	if m != nil {
		return m.Version
	}
	return nil
}

func (m *UpdateVersionRequest) GetUpdateMask() *google_protobuf5.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for `Versions.DeleteVersion`.
type DeleteVersionRequest struct {
	// Name of the resource requested. Example:
	// `apps/myapp/services/default/versions/v1`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteVersionRequest) Reset()                    { *m = DeleteVersionRequest{} }
func (m *DeleteVersionRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteVersionRequest) ProtoMessage()               {}
func (*DeleteVersionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

// Request message for `Instances.ListInstances`.
type ListInstancesRequest struct {
	// Name of the parent Version resource. Example:
	// `apps/myapp/services/default/versions/v1`.
	Parent string `protobuf:"bytes,1,opt,name=parent" json:"parent,omitempty"`
	// Maximum results to return per page.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// Continuation token for fetching the next page of results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
}

func (m *ListInstancesRequest) Reset()                    { *m = ListInstancesRequest{} }
func (m *ListInstancesRequest) String() string            { return proto.CompactTextString(m) }
func (*ListInstancesRequest) ProtoMessage()               {}
func (*ListInstancesRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

// Response message for `Instances.ListInstances`.
type ListInstancesResponse struct {
	// The instances belonging to the requested version.
	Instances []*Instance `protobuf:"bytes,1,rep,name=instances" json:"instances,omitempty"`
	// Continuation token for fetching the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *ListInstancesResponse) Reset()                    { *m = ListInstancesResponse{} }
func (m *ListInstancesResponse) String() string            { return proto.CompactTextString(m) }
func (*ListInstancesResponse) ProtoMessage()               {}
func (*ListInstancesResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *ListInstancesResponse) GetInstances() []*Instance {
	if m != nil {
		return m.Instances
	}
	return nil
}

// Request message for `Instances.GetInstance`.
type GetInstanceRequest struct {
	// Name of the resource requested. Example:
	// `apps/myapp/services/default/versions/v1/instances/instance-1`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *GetInstanceRequest) Reset()                    { *m = GetInstanceRequest{} }
func (m *GetInstanceRequest) String() string            { return proto.CompactTextString(m) }
func (*GetInstanceRequest) ProtoMessage()               {}
func (*GetInstanceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

// Request message for `Instances.DeleteInstance`.
type DeleteInstanceRequest struct {
	// Name of the resource requested. Example:
	// `apps/myapp/services/default/versions/v1/instances/instance-1`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DeleteInstanceRequest) Reset()                    { *m = DeleteInstanceRequest{} }
func (m *DeleteInstanceRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteInstanceRequest) ProtoMessage()               {}
func (*DeleteInstanceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

// Request message for `Instances.DebugInstance`.
type DebugInstanceRequest struct {
	// Name of the resource requested. Example:
	// `apps/myapp/services/default/versions/v1/instances/instance-1`.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
}

func (m *DebugInstanceRequest) Reset()                    { *m = DebugInstanceRequest{} }
func (m *DebugInstanceRequest) String() string            { return proto.CompactTextString(m) }
func (*DebugInstanceRequest) ProtoMessage()               {}
func (*DebugInstanceRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func init() {
	proto.RegisterType((*GetApplicationRequest)(nil), "google.appengine.v1.GetApplicationRequest")
	proto.RegisterType((*RepairApplicationRequest)(nil), "google.appengine.v1.RepairApplicationRequest")
	proto.RegisterType((*ListServicesRequest)(nil), "google.appengine.v1.ListServicesRequest")
	proto.RegisterType((*ListServicesResponse)(nil), "google.appengine.v1.ListServicesResponse")
	proto.RegisterType((*GetServiceRequest)(nil), "google.appengine.v1.GetServiceRequest")
	proto.RegisterType((*UpdateServiceRequest)(nil), "google.appengine.v1.UpdateServiceRequest")
	proto.RegisterType((*DeleteServiceRequest)(nil), "google.appengine.v1.DeleteServiceRequest")
	proto.RegisterType((*ListVersionsRequest)(nil), "google.appengine.v1.ListVersionsRequest")
	proto.RegisterType((*ListVersionsResponse)(nil), "google.appengine.v1.ListVersionsResponse")
	proto.RegisterType((*GetVersionRequest)(nil), "google.appengine.v1.GetVersionRequest")
	proto.RegisterType((*CreateVersionRequest)(nil), "google.appengine.v1.CreateVersionRequest")
	proto.RegisterType((*UpdateVersionRequest)(nil), "google.appengine.v1.UpdateVersionRequest")
	proto.RegisterType((*DeleteVersionRequest)(nil), "google.appengine.v1.DeleteVersionRequest")
	proto.RegisterType((*ListInstancesRequest)(nil), "google.appengine.v1.ListInstancesRequest")
	proto.RegisterType((*ListInstancesResponse)(nil), "google.appengine.v1.ListInstancesResponse")
	proto.RegisterType((*GetInstanceRequest)(nil), "google.appengine.v1.GetInstanceRequest")
	proto.RegisterType((*DeleteInstanceRequest)(nil), "google.appengine.v1.DeleteInstanceRequest")
	proto.RegisterType((*DebugInstanceRequest)(nil), "google.appengine.v1.DebugInstanceRequest")
	proto.RegisterEnum("google.appengine.v1.VersionView", VersionView_name, VersionView_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Instances service

type InstancesClient interface {
	// Lists the instances of a version.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Gets instance information.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Stops a running instance.
	DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Enables debugging on a VM instance. This allows you to use the SSH
	// command to connect to the virtual machine where the instance lives.
	// While in "debug mode", the instance continues to serve live traffic.
	// You should delete the instance when you are done debugging and then
	// allow the system to take over and determine if another instance
	// should be started.
	//
	// Only applicable for instances in App Engine flexible environment.
	DebugInstance(ctx context.Context, in *DebugInstanceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
}

type instancesClient struct {
	cc *grpc.ClientConn
}

func NewInstancesClient(cc *grpc.ClientConn) InstancesClient {
	return &instancesClient{cc}
}

func (c *instancesClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := grpc.Invoke(ctx, "/google.appengine.v1.Instances/ListInstances", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := grpc.Invoke(ctx, "/google.appengine.v1.Instances/GetInstance", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.appengine.v1.Instances/DeleteInstance", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) DebugInstance(ctx context.Context, in *DebugInstanceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.appengine.v1.Instances/DebugInstance", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Instances service

type InstancesServer interface {
	// Lists the instances of a version.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Gets instance information.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Stops a running instance.
	DeleteInstance(context.Context, *DeleteInstanceRequest) (*google_longrunning.Operation, error)
	// Enables debugging on a VM instance. This allows you to use the SSH
	// command to connect to the virtual machine where the instance lives.
	// While in "debug mode", the instance continues to serve live traffic.
	// You should delete the instance when you are done debugging and then
	// allow the system to take over and determine if another instance
	// should be started.
	//
	// Only applicable for instances in App Engine flexible environment.
	DebugInstance(context.Context, *DebugInstanceRequest) (*google_longrunning.Operation, error)
}

func RegisterInstancesServer(s *grpc.Server, srv InstancesServer) {
	s.RegisterService(&_Instances_serviceDesc, srv)
}

func _Instances_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.appengine.v1.Instances/ListInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.appengine.v1.Instances/GetInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_DeleteInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).DeleteInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.appengine.v1.Instances/DeleteInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).DeleteInstance(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_DebugInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DebugInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).DebugInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.appengine.v1.Instances/DebugInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).DebugInstance(ctx, req.(*DebugInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Instances_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.appengine.v1.Instances",
	HandlerType: (*InstancesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInstances",
			Handler:    _Instances_ListInstances_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _Instances_GetInstance_Handler,
		},
		{
			MethodName: "DeleteInstance",
			Handler:    _Instances_DeleteInstance_Handler,
		},
		{
			MethodName: "DebugInstance",
			Handler:    _Instances_DebugInstance_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/appengine/v1/appengine.proto",
}

// Client API for Versions service

type VersionsClient interface {
	// Lists the versions of a service.
	ListVersions(ctx context.Context, in *ListVersionsRequest, opts ...grpc.CallOption) (*ListVersionsResponse, error)
	// Gets the specified Version resource.
	// By default, only a `BASIC_VIEW` will be returned.
	// Specify the `FULL_VIEW` parameter to get the full resource.
	GetVersion(ctx context.Context, in *GetVersionRequest, opts ...grpc.CallOption) (*Version, error)
	// Deploys code and resource files to a new version.
	CreateVersion(ctx context.Context, in *CreateVersionRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Updates the specified Version resource.
	// You can specify the following fields depending on the App Engine
	// environment and type of scaling that the version resource uses:
	//
	// * [`serving_status`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.serving_status):
	//   For Version resources that use basic scaling, manual scaling, or run in
	//   the App Engine flexible environment.
	// * [`instance_class`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.instance_class):
	//   For Version resources that run in the App Engine standard environment.
	// * [`automatic_scaling.min_idle_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling):
	//   For Version resources that use automatic scaling and run in the App
	//   Engine standard environment.
	// * [`automatic_scaling.max_idle_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling):
	//   For Version resources that use automatic scaling and run in the App
	//   Engine standard environment.
	UpdateVersion(ctx context.Context, in *UpdateVersionRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Deletes an existing Version resource.
	DeleteVersion(ctx context.Context, in *DeleteVersionRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
}

type versionsClient struct {
	cc *grpc.ClientConn
}

func NewVersionsClient(cc *grpc.ClientConn) VersionsClient {
	return &versionsClient{cc}
}

func (c *versionsClient) ListVersions(ctx context.Context, in *ListVersionsRequest, opts ...grpc.CallOption) (*ListVersionsResponse, error) {
	out := new(ListVersionsResponse)
	err := grpc.Invoke(ctx, "/google.appengine.v1.Versions/ListVersions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *versionsClient) GetVersion(ctx context.Context, in *GetVersionRequest, opts ...grpc.CallOption) (*Version, error) {
	out := new(Version)
	err := grpc.Invoke(ctx, "/google.appengine.v1.Versions/GetVersion", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *versionsClient) CreateVersion(ctx context.Context, in *CreateVersionRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.appengine.v1.Versions/CreateVersion", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *versionsClient) UpdateVersion(ctx context.Context, in *UpdateVersionRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.appengine.v1.Versions/UpdateVersion", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *versionsClient) DeleteVersion(ctx context.Context, in *DeleteVersionRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.appengine.v1.Versions/DeleteVersion", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Versions service

type VersionsServer interface {
	// Lists the versions of a service.
	ListVersions(context.Context, *ListVersionsRequest) (*ListVersionsResponse, error)
	// Gets the specified Version resource.
	// By default, only a `BASIC_VIEW` will be returned.
	// Specify the `FULL_VIEW` parameter to get the full resource.
	GetVersion(context.Context, *GetVersionRequest) (*Version, error)
	// Deploys code and resource files to a new version.
	CreateVersion(context.Context, *CreateVersionRequest) (*google_longrunning.Operation, error)
	// Updates the specified Version resource.
	// You can specify the following fields depending on the App Engine
	// environment and type of scaling that the version resource uses:
	//
	// * [`serving_status`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.serving_status):
	//   For Version resources that use basic scaling, manual scaling, or run in
	//   the App Engine flexible environment.
	// * [`instance_class`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.instance_class):
	//   For Version resources that run in the App Engine standard environment.
	// * [`automatic_scaling.min_idle_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling):
	//   For Version resources that use automatic scaling and run in the App
	//   Engine standard environment.
	// * [`automatic_scaling.max_idle_instances`](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#Version.FIELDS.automatic_scaling):
	//   For Version resources that use automatic scaling and run in the App
	//   Engine standard environment.
	UpdateVersion(context.Context, *UpdateVersionRequest) (*google_longrunning.Operation, error)
	// Deletes an existing Version resource.
	DeleteVersion(context.Context, *DeleteVersionRequest) (*google_longrunning.Operation, error)
}

func RegisterVersionsServer(s *grpc.Server, srv VersionsServer) {
	s.RegisterService(&_Versions_serviceDesc, srv)
}

func _Versions_ListVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VersionsServer).ListVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.appengine.v1.Versions/ListVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VersionsServer).ListVersions(ctx, req.(*ListVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Versions_GetVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VersionsServer).GetVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.appengine.v1.Versions/GetVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VersionsServer).GetVersion(ctx, req.(*GetVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Versions_CreateVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VersionsServer).CreateVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.appengine.v1.Versions/CreateVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VersionsServer).CreateVersion(ctx, req.(*CreateVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Versions_UpdateVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VersionsServer).UpdateVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.appengine.v1.Versions/UpdateVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VersionsServer).UpdateVersion(ctx, req.(*UpdateVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Versions_DeleteVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VersionsServer).DeleteVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.appengine.v1.Versions/DeleteVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VersionsServer).DeleteVersion(ctx, req.(*DeleteVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Versions_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.appengine.v1.Versions",
	HandlerType: (*VersionsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListVersions",
			Handler:    _Versions_ListVersions_Handler,
		},
		{
			MethodName: "GetVersion",
			Handler:    _Versions_GetVersion_Handler,
		},
		{
			MethodName: "CreateVersion",
			Handler:    _Versions_CreateVersion_Handler,
		},
		{
			MethodName: "UpdateVersion",
			Handler:    _Versions_UpdateVersion_Handler,
		},
		{
			MethodName: "DeleteVersion",
			Handler:    _Versions_DeleteVersion_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/appengine/v1/appengine.proto",
}

// Client API for Services service

type ServicesClient interface {
	// Lists all the services in the application.
	ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error)
	// Gets the current configuration of the specified service.
	GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*Service, error)
	// Updates the configuration of the specified service.
	UpdateService(ctx context.Context, in *UpdateServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Deletes the specified service and all enclosed versions.
	DeleteService(ctx context.Context, in *DeleteServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
}

type servicesClient struct {
	cc *grpc.ClientConn
}

func NewServicesClient(cc *grpc.ClientConn) ServicesClient {
	return &servicesClient{cc}
}

func (c *servicesClient) ListServices(ctx context.Context, in *ListServicesRequest, opts ...grpc.CallOption) (*ListServicesResponse, error) {
	out := new(ListServicesResponse)
	err := grpc.Invoke(ctx, "/google.appengine.v1.Services/ListServices", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *servicesClient) GetService(ctx context.Context, in *GetServiceRequest, opts ...grpc.CallOption) (*Service, error) {
	out := new(Service)
	err := grpc.Invoke(ctx, "/google.appengine.v1.Services/GetService", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *servicesClient) UpdateService(ctx context.Context, in *UpdateServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.appengine.v1.Services/UpdateService", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *servicesClient) DeleteService(ctx context.Context, in *DeleteServiceRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.appengine.v1.Services/DeleteService", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Services service

type ServicesServer interface {
	// Lists all the services in the application.
	ListServices(context.Context, *ListServicesRequest) (*ListServicesResponse, error)
	// Gets the current configuration of the specified service.
	GetService(context.Context, *GetServiceRequest) (*Service, error)
	// Updates the configuration of the specified service.
	UpdateService(context.Context, *UpdateServiceRequest) (*google_longrunning.Operation, error)
	// Deletes the specified service and all enclosed versions.
	DeleteService(context.Context, *DeleteServiceRequest) (*google_longrunning.Operation, error)
}

func RegisterServicesServer(s *grpc.Server, srv ServicesServer) {
	s.RegisterService(&_Services_serviceDesc, srv)
}

func _Services_ListServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServicesServer).ListServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.appengine.v1.Services/ListServices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServicesServer).ListServices(ctx, req.(*ListServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Services_GetService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServicesServer).GetService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.appengine.v1.Services/GetService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServicesServer).GetService(ctx, req.(*GetServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Services_UpdateService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServicesServer).UpdateService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.appengine.v1.Services/UpdateService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServicesServer).UpdateService(ctx, req.(*UpdateServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Services_DeleteService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ServicesServer).DeleteService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.appengine.v1.Services/DeleteService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ServicesServer).DeleteService(ctx, req.(*DeleteServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Services_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.appengine.v1.Services",
	HandlerType: (*ServicesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListServices",
			Handler:    _Services_ListServices_Handler,
		},
		{
			MethodName: "GetService",
			Handler:    _Services_GetService_Handler,
		},
		{
			MethodName: "UpdateService",
			Handler:    _Services_UpdateService_Handler,
		},
		{
			MethodName: "DeleteService",
			Handler:    _Services_DeleteService_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/appengine/v1/appengine.proto",
}

// Client API for Applications service

type ApplicationsClient interface {
	// Gets information about an application.
	GetApplication(ctx context.Context, in *GetApplicationRequest, opts ...grpc.CallOption) (*Application, error)
	// Recreates the required App Engine features for the application in your
	// project, for example a Cloud Storage bucket or App Engine service account.
	// Use this method if you receive an error message about a missing feature,
	// for example "*Error retrieving the App Engine service account*".
	RepairApplication(ctx context.Context, in *RepairApplicationRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
}

type applicationsClient struct {
	cc *grpc.ClientConn
}

func NewApplicationsClient(cc *grpc.ClientConn) ApplicationsClient {
	return &applicationsClient{cc}
}

func (c *applicationsClient) GetApplication(ctx context.Context, in *GetApplicationRequest, opts ...grpc.CallOption) (*Application, error) {
	out := new(Application)
	err := grpc.Invoke(ctx, "/google.appengine.v1.Applications/GetApplication", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *applicationsClient) RepairApplication(ctx context.Context, in *RepairApplicationRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.appengine.v1.Applications/RepairApplication", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Applications service

type ApplicationsServer interface {
	// Gets information about an application.
	GetApplication(context.Context, *GetApplicationRequest) (*Application, error)
	// Recreates the required App Engine features for the application in your
	// project, for example a Cloud Storage bucket or App Engine service account.
	// Use this method if you receive an error message about a missing feature,
	// for example "*Error retrieving the App Engine service account*".
	RepairApplication(context.Context, *RepairApplicationRequest) (*google_longrunning.Operation, error)
}

func RegisterApplicationsServer(s *grpc.Server, srv ApplicationsServer) {
	s.RegisterService(&_Applications_serviceDesc, srv)
}

func _Applications_GetApplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationsServer).GetApplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.appengine.v1.Applications/GetApplication",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationsServer).GetApplication(ctx, req.(*GetApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Applications_RepairApplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RepairApplicationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ApplicationsServer).RepairApplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.appengine.v1.Applications/RepairApplication",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ApplicationsServer).RepairApplication(ctx, req.(*RepairApplicationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Applications_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.appengine.v1.Applications",
	HandlerType: (*ApplicationsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetApplication",
			Handler:    _Applications_GetApplication_Handler,
		},
		{
			MethodName: "RepairApplication",
			Handler:    _Applications_RepairApplication_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google.golang.org/genproto/googleapis/appengine/v1/appengine.proto",
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/appengine/v1/appengine.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 1160 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xb4, 0x57, 0x5f, 0x6f, 0xdb, 0x54,
	0x14, 0xc7, 0x6d, 0xba, 0xa5, 0xa7, 0x6b, 0xb7, 0xde, 0xb6, 0x10, 0xcc, 0x8a, 0x22, 0x83, 0x96,
	0xd4, 0xd5, 0x62, 0xcd, 0x1d, 0xd3, 0x96, 0x6a, 0x88, 0x76, 0xd5, 0xaa, 0x4a, 0x45, 0x54, 0xee,
	0xb6, 0x37, 0x54, 0xb9, 0xe9, 0x8d, 0xb9, 0x34, 0xb1, 0x8d, 0xed, 0x64, 0xed, 0x20, 0x42, 0x62,
	0x12, 0x02, 0x1e, 0x37, 0x1e, 0x78, 0x40, 0xda, 0x03, 0x5f, 0x86, 0x77, 0xbe, 0x00, 0x0f, 0x7c,
	0x10, 0xe4, 0xeb, 0x7b, 0xed, 0xd8, 0xf1, 0x3f, 0x32, 0xf1, 0x12, 0xc5, 0xd7, 0xe7, 0xcf, 0xef,
	0xfc, 0xce, 0xcf, 0x3e, 0xc7, 0xb0, 0x6b, 0x58, 0x96, 0xd1, 0xc3, 0x2d, 0xc3, 0xea, 0xe9, 0xa6,
	0xd1, 0xb2, 0x1c, 0x43, 0x31, 0xb0, 0x69, 0x3b, 0x96, 0x67, 0x29, 0xc1, 0x2d, 0xdd, 0x26, 0xae,
	0xa2, 0xdb, 0x36, 0x36, 0x0d, 0x62, 0x62, 0x65, 0x78, 0x27, 0xba, 0x68, 0x51, 0x3b, 0xb4, 0xc2,
	0x62, 0x44, 0xe7, 0xc3, 0x3b, 0xe2, 0x41, 0xd9, 0xc0, 0x44, 0x71, 0xb1, 0x33, 0x24, 0x1d, 0xdc,
	0xb1, 0xcc, 0x2e, 0x31, 0x14, 0xdd, 0x34, 0x2d, 0x4f, 0xf7, 0x88, 0x65, 0xba, 0x41, 0x7c, 0x71,
	0x6f, 0x3a, 0x8c, 0x3d, 0xd2, 0xa1, 0x61, 0x58, 0x94, 0x9d, 0x29, 0xa2, 0x10, 0xd3, 0xf5, 0x74,
	0xb3, 0xc3, 0x0a, 0x15, 0x3f, 0x9b, 0x22, 0x04, 0x2b, 0xee, 0x2d, 0x22, 0x0c, 0xb1, 0xe3, 0x46,
	0x65, 0x3c, 0x2c, 0x17, 0x81, 0xe8, 0x7d, 0x5a, 0x80, 0xde, 0x3f, 0xb1, 0xad, 0x1e, 0xe9, 0x5c,
	0x32, 0xf7, 0x07, 0xff, 0xc9, 0x3d, 0xe6, 0x5a, 0x52, 0x2a, 0x3d, 0xcb, 0x34, 0x9c, 0x81, 0x69,
	0x12, 0xd3, 0x50, 0x2c, 0x1b, 0x3b, 0xb1, 0x56, 0x6e, 0x19, 0xc4, 0xfb, 0x6a, 0x70, 0xda, 0xea,
	0x58, 0x7d, 0x25, 0x88, 0xa3, 0xd0, 0x1b, 0xa7, 0x83, 0xae, 0x62, 0x7b, 0x97, 0x36, 0x76, 0x15,
	0xdc, 0xb7, 0xbd, 0xcb, 0xe0, 0x97, 0x39, 0xdd, 0xcd, 0x49, 0x1c, 0x7a, 0x77, 0x09, 0xee, 0x9d,
	0x9d, 0xf4, 0x75, 0xf7, 0x3c, 0xf0, 0x92, 0x36, 0x61, 0x6d, 0x1f, 0x7b, 0x3b, 0x91, 0x0e, 0x34,
	0xfc, 0xcd, 0x00, 0xbb, 0x1e, 0x42, 0x50, 0x31, 0xf5, 0x3e, 0xae, 0x09, 0x75, 0xa1, 0x39, 0xaf,
	0xd1, 0xff, 0x52, 0x0b, 0x6a, 0x1a, 0xb6, 0x75, 0xe2, 0x94, 0xb4, 0x27, 0xb0, 0x72, 0x48, 0x5c,
	0xef, 0x38, 0x68, 0xae, 0xcb, 0x4d, 0xdf, 0x85, 0x2b, 0xb6, 0xee, 0x60, 0xd3, 0x63, 0xc6, 0xec,
	0x0a, 0x7d, 0x00, 0xf3, 0xb6, 0x6e, 0xe0, 0x13, 0x97, 0xbc, 0xc0, 0xb5, 0x99, 0xba, 0xd0, 0x9c,
	0xd3, 0xaa, 0xfe, 0xc1, 0x31, 0x79, 0x81, 0xd1, 0x3a, 0x00, 0xbd, 0xe9, 0x59, 0xe7, 0xd8, 0xac,
	0xcd, 0x52, 0x47, 0x6a, 0xfe, 0xc4, 0x3f, 0x90, 0x2e, 0x60, 0x35, 0x9e, 0xca, 0xb5, 0x2d, 0xd3,
	0xc5, 0xe8, 0x3e, 0x54, 0x99, 0xb6, 0xdc, 0x9a, 0x50, 0x9f, 0x6d, 0x2e, 0xa8, 0x37, 0x5b, 0x29,
	0x0f, 0x62, 0x8b, 0x39, 0x6a, 0xa1, 0x35, 0xba, 0x05, 0xd7, 0x4d, 0x7c, 0xe1, 0x9d, 0x8c, 0x65,
	0x9d, 0xa1, 0x59, 0x17, 0xfd, 0xe3, 0xa3, 0x30, 0x73, 0x03, 0x96, 0xf7, 0x31, 0x4f, 0x9c, 0xc7,
	0xc6, 0x9f, 0x02, 0xac, 0x3e, 0xb5, 0xcf, 0x74, 0x0f, 0x17, 0x1b, 0xa3, 0x7b, 0x70, 0x95, 0x21,
	0xa1, 0x59, 0x8b, 0x60, 0x73, 0x63, 0xb4, 0x0d, 0x0b, 0x03, 0x9a, 0x83, 0x36, 0x99, 0xf2, 0xb4,
	0xa0, 0x8a, 0xdc, 0x97, 0xeb, 0xa0, 0xf5, 0xd8, 0xd7, 0xc1, 0xe7, 0xba, 0x7b, 0xae, 0x41, 0x60,
	0xee, 0xff, 0x47, 0x0d, 0xb8, 0xde, 0x27, 0x86, 0xe3, 0x7b, 0x7b, 0x8e, 0xde, 0xed, 0x92, 0x4e,
	0xad, 0x52, 0x17, 0x9a, 0x55, 0x6d, 0x89, 0x1d, 0x3f, 0x09, 0x4e, 0x25, 0x19, 0x56, 0xf7, 0x70,
	0x0f, 0x97, 0xa9, 0x44, 0x7a, 0x23, 0x04, 0x2a, 0x78, 0x16, 0x3c, 0xa0, 0x85, 0x2a, 0xb8, 0x0b,
	0x95, 0x21, 0xc1, 0xcf, 0x69, 0xd9, 0x4b, 0x6a, 0x3d, 0xb5, 0x6c, 0x16, 0xeb, 0x19, 0xc1, 0xcf,
	0x35, 0x6a, 0x1d, 0xd7, 0xce, 0x6c, 0xae, 0x76, 0x2a, 0x19, 0xda, 0x89, 0x00, 0x46, 0xda, 0x61,
	0x6f, 0x95, 0x7c, 0xed, 0x30, 0x47, 0x2d, 0xb4, 0x2e, 0xad, 0x9d, 0x2f, 0xa9, 0x76, 0xb8, 0x7f,
	0x8e, 0x1c, 0xa6, 0x22, 0x45, 0xea, 0xc2, 0xea, 0x23, 0x07, 0xeb, 0x1e, 0x4e, 0x64, 0xc8, 0xa2,
	0xfe, 0x1e, 0x5c, 0x65, 0x25, 0xe4, 0x8a, 0x8e, 0x47, 0xe3, 0xc6, 0x7e, 0x8b, 0x99, 0xb2, 0x4b,
	0x94, 0x32, 0x65, 0x92, 0xb7, 0x52, 0x76, 0x24, 0xd8, 0x62, 0x80, 0xd2, 0xd7, 0x81, 0x1c, 0x0e,
	0xd8, 0x54, 0xfb, 0x5f, 0x5f, 0x5b, 0xdf, 0xc1, 0x5a, 0x22, 0x17, 0xd3, 0xde, 0x36, 0xcc, 0xf3,
	0xb1, 0xca, 0xc5, 0xb7, 0x9e, 0xca, 0x13, 0x77, 0xd5, 0x22, 0xfb, 0xd2, 0xf2, 0x6b, 0x02, 0xda,
	0xc7, 0x61, 0xf2, 0x3c, 0x4e, 0x36, 0x61, 0x2d, 0xe0, 0xaf, 0x8c, 0x31, 0x25, 0xfb, 0x74, 0x60,
	0x94, 0xb0, 0x95, 0x25, 0x58, 0x18, 0xd3, 0x2d, 0x9a, 0x87, 0xb9, 0xdd, 0x9d, 0xe3, 0x83, 0x47,
	0x37, 0xde, 0x41, 0x55, 0xa8, 0x3c, 0x7e, 0x7a, 0x78, 0x78, 0x43, 0x50, 0x5f, 0xce, 0xc1, 0x7c,
	0xc8, 0x10, 0xfa, 0x43, 0x80, 0xc5, 0x18, 0x67, 0x68, 0x23, 0x95, 0x98, 0xb4, 0x1e, 0x8a, 0x72,
	0x19, 0xd3, 0xa0, 0x05, 0xd2, 0xf6, 0x0f, 0x7f, 0xfd, 0xf3, 0x7a, 0xe6, 0x13, 0xb4, 0xe5, 0xcf,
	0xf8, 0x6f, 0x83, 0x66, 0x3f, 0xd4, 0x6d, 0xdb, 0x55, 0x64, 0xbe, 0xaf, 0xf8, 0x7f, 0xf9, 0x43,
	0xaf, 0xc8, 0x23, 0x25, 0x6a, 0xc1, 0x2b, 0x01, 0x16, 0xc6, 0xb8, 0x45, 0x8d, 0xd4, 0xc4, 0x93,
	0xec, 0x8b, 0xf9, 0x5d, 0x4e, 0x80, 0xf2, 0x29, 0xcc, 0x85, 0x14, 0x21, 0x52, 0xe4, 0x11, 0xfa,
	0x4d, 0x80, 0xa5, 0x78, 0x1b, 0x51, 0x3a, 0x21, 0xa9, 0xbd, 0x8e, 0xa0, 0x8d, 0x2d, 0x2f, 0xad,
	0x2f, 0xf8, 0xf2, 0xc2, 0xa1, 0xc9, 0x53, 0x41, 0x7b, 0x23, 0xc0, 0x62, 0x4c, 0x34, 0x19, 0x5d,
	0x4d, 0x13, 0x56, 0x11, 0xb0, 0x3d, 0x0a, 0xec, 0x53, 0xe9, 0xc1, 0x14, 0xc0, 0xda, 0x67, 0x7e,
	0xc2, 0xb6, 0x20, 0xab, 0x7f, 0xcf, 0x41, 0x95, 0x8f, 0x08, 0xf4, 0xab, 0x00, 0xd7, 0xc6, 0x67,
	0x06, 0x6a, 0x66, 0x0a, 0x2b, 0x31, 0xf7, 0xc4, 0x8d, 0x12, 0x96, 0x4c, 0x81, 0x0a, 0x05, 0xbe,
	0x81, 0x1a, 0xb9, 0x0a, 0x1c, 0x85, 0xd8, 0xd1, 0x4b, 0x01, 0x20, 0x1a, 0x28, 0xe8, 0x56, 0x96,
	0xe8, 0xe2, 0x6f, 0x41, 0x31, 0xf7, 0x0d, 0x9c, 0x40, 0x51, 0x48, 0xdf, 0x08, 0xbd, 0x16, 0x60,
	0x31, 0x36, 0x77, 0x32, 0x7a, 0x99, 0x36, 0x9b, 0x8a, 0x7a, 0x79, 0x9f, 0x82, 0x51, 0xa5, 0xb2,
	0x94, 0xb4, 0xc3, 0xf9, 0xe1, 0xa3, 0x8a, 0x0d, 0xa9, 0x0c, 0x54, 0x69, 0x83, 0xac, 0x24, 0x2a,
	0xb5, 0x2c, 0x45, 0x11, 0xaa, 0x5f, 0xa8, 0xee, 0xc7, 0x26, 0x53, 0xa6, 0xee, 0x27, 0xa7, 0x57,
	0x11, 0x2a, 0xd6, 0x38, 0xb9, 0x2c, 0x2a, 0xf5, 0xf7, 0x0a, 0x54, 0xf9, 0x06, 0x8d, 0x7e, 0x66,
	0x12, 0x0f, 0x0f, 0xb2, 0x25, 0x9e, 0x58, 0xf0, 0x73, 0x24, 0x9e, 0xdc, 0xcf, 0xa5, 0x8f, 0x29,
	0xc6, 0x0f, 0xd1, 0xcd, 0xc9, 0x7e, 0x8e, 0x42, 0x98, 0xe8, 0x82, 0xca, 0x9a, 0x39, 0x67, 0xcb,
	0x3a, 0xbe, 0x8d, 0x8a, 0xb9, 0x2b, 0x73, 0x22, 0x73, 0x3a, 0x3b, 0x23, 0xf4, 0x53, 0xa8, 0x1a,
	0x9e, 0x3d, 0x4f, 0x35, 0x09, 0x00, 0x05, 0xfd, 0xb9, 0x4d, 0x11, 0x34, 0xd4, 0x5c, 0x04, 0xed,
	0x70, 0xb5, 0xff, 0x9e, 0x2b, 0x25, 0x1f, 0x49, 0xda, 0x62, 0x5e, 0x84, 0x84, 0x71, 0x21, 0xe7,
	0x22, 0x51, 0x5f, 0xcd, 0xc0, 0xb5, 0xb1, 0x2f, 0x3f, 0x17, 0x5d, 0xc2, 0x52, 0xfc, 0xe3, 0x31,
	0x63, 0x9c, 0xa4, 0x7e, 0x61, 0x8a, 0xe9, 0x5b, 0xec, 0x98, 0xa1, 0xf4, 0x3e, 0x85, 0xb5, 0x82,
	0x96, 0x93, 0xb0, 0x46, 0xe8, 0x47, 0x01, 0x96, 0x27, 0xbe, 0x45, 0xd1, 0xed, 0xd4, 0x90, 0x59,
	0xdf, 0xac, 0x45, 0xac, 0x7c, 0x44, 0xd3, 0xaf, 0x4b, 0xb5, 0x89, 0xf4, 0x6d, 0x87, 0x86, 0x6c,
	0x0b, 0xf2, 0xee, 0x26, 0xbc, 0xd7, 0xb1, 0xfa, 0x69, 0x79, 0x77, 0x97, 0x76, 0xf8, 0xd5, 0x91,
	0xbf, 0x9d, 0x1e, 0x09, 0xa7, 0x57, 0xe8, 0x9a, 0xba, 0xf5, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff,
	0xfd, 0x69, 0x15, 0xc5, 0x50, 0x12, 0x00, 0x00,
}
