
#include "../Binding_pch.h"


#include <glbinding/gl/functions.h>

using namespace glbinding;


namespace gl
{


void glUniform1d(GLint location, GLdouble x)
{
    return Binding::Uniform1d(location, x);
}

void glUniform1dv(GLint location, GLsizei count, const GLdouble * value)
{
    return Binding::Uniform1dv(location, count, value);
}

void glUniform1f(GLint location, GLfloat v0)
{
    return Binding::Uniform1f(location, v0);
}

void glUniform1fARB(GLint location, GLfloat v0)
{
    return Binding::Uniform1fARB(location, v0);
}

void glUniform1fv(GLint location, GLsizei count, const GLfloat * value)
{
    return Binding::Uniform1fv(location, count, value);
}

void glUniform1fvARB(GLint location, GLsizei count, const GLfloat * value)
{
    return Binding::Uniform1fvARB(location, count, value);
}

void glUniform1i(GLint location, GLint v0)
{
    return Binding::Uniform1i(location, v0);
}

void glUniform1i64ARB(GLint location, GLint64 x)
{
    return Binding::Uniform1i64ARB(location, x);
}

void glUniform1i64NV(GLint location, GLint64EXT x)
{
    return Binding::Uniform1i64NV(location, x);
}

void glUniform1i64vARB(GLint location, GLsizei count, const GLint64 * value)
{
    return Binding::Uniform1i64vARB(location, count, value);
}

void glUniform1i64vNV(GLint location, GLsizei count, const GLint64EXT * value)
{
    return Binding::Uniform1i64vNV(location, count, value);
}

void glUniform1iARB(GLint location, GLint v0)
{
    return Binding::Uniform1iARB(location, v0);
}

void glUniform1iv(GLint location, GLsizei count, const GLint * value)
{
    return Binding::Uniform1iv(location, count, value);
}

void glUniform1ivARB(GLint location, GLsizei count, const GLint * value)
{
    return Binding::Uniform1ivARB(location, count, value);
}

void glUniform1ui(GLint location, GLuint v0)
{
    return Binding::Uniform1ui(location, v0);
}

void glUniform1ui64ARB(GLint location, GLuint64 x)
{
    return Binding::Uniform1ui64ARB(location, x);
}

void glUniform1ui64NV(GLint location, GLuint64EXT x)
{
    return Binding::Uniform1ui64NV(location, x);
}

void glUniform1ui64vARB(GLint location, GLsizei count, const GLuint64 * value)
{
    return Binding::Uniform1ui64vARB(location, count, value);
}

void glUniform1ui64vNV(GLint location, GLsizei count, const GLuint64EXT * value)
{
    return Binding::Uniform1ui64vNV(location, count, value);
}

void glUniform1uiEXT(GLint location, GLuint v0)
{
    return Binding::Uniform1uiEXT(location, v0);
}

void glUniform1uiv(GLint location, GLsizei count, const GLuint * value)
{
    return Binding::Uniform1uiv(location, count, value);
}

void glUniform1uivEXT(GLint location, GLsizei count, const GLuint * value)
{
    return Binding::Uniform1uivEXT(location, count, value);
}

void glUniform2d(GLint location, GLdouble x, GLdouble y)
{
    return Binding::Uniform2d(location, x, y);
}

void glUniform2dv(GLint location, GLsizei count, const GLdouble * value)
{
    return Binding::Uniform2dv(location, count, value);
}

void glUniform2f(GLint location, GLfloat v0, GLfloat v1)
{
    return Binding::Uniform2f(location, v0, v1);
}

void glUniform2fARB(GLint location, GLfloat v0, GLfloat v1)
{
    return Binding::Uniform2fARB(location, v0, v1);
}

void glUniform2fv(GLint location, GLsizei count, const GLfloat * value)
{
    return Binding::Uniform2fv(location, count, value);
}

void glUniform2fvARB(GLint location, GLsizei count, const GLfloat * value)
{
    return Binding::Uniform2fvARB(location, count, value);
}

void glUniform2i(GLint location, GLint v0, GLint v1)
{
    return Binding::Uniform2i(location, v0, v1);
}

void glUniform2i64ARB(GLint location, GLint64 x, GLint64 y)
{
    return Binding::Uniform2i64ARB(location, x, y);
}

void glUniform2i64NV(GLint location, GLint64EXT x, GLint64EXT y)
{
    return Binding::Uniform2i64NV(location, x, y);
}

void glUniform2i64vARB(GLint location, GLsizei count, const GLint64 * value)
{
    return Binding::Uniform2i64vARB(location, count, value);
}

void glUniform2i64vNV(GLint location, GLsizei count, const GLint64EXT * value)
{
    return Binding::Uniform2i64vNV(location, count, value);
}

void glUniform2iARB(GLint location, GLint v0, GLint v1)
{
    return Binding::Uniform2iARB(location, v0, v1);
}

void glUniform2iv(GLint location, GLsizei count, const GLint * value)
{
    return Binding::Uniform2iv(location, count, value);
}

void glUniform2ivARB(GLint location, GLsizei count, const GLint * value)
{
    return Binding::Uniform2ivARB(location, count, value);
}

void glUniform2ui(GLint location, GLuint v0, GLuint v1)
{
    return Binding::Uniform2ui(location, v0, v1);
}

void glUniform2ui64ARB(GLint location, GLuint64 x, GLuint64 y)
{
    return Binding::Uniform2ui64ARB(location, x, y);
}

void glUniform2ui64NV(GLint location, GLuint64EXT x, GLuint64EXT y)
{
    return Binding::Uniform2ui64NV(location, x, y);
}

void glUniform2ui64vARB(GLint location, GLsizei count, const GLuint64 * value)
{
    return Binding::Uniform2ui64vARB(location, count, value);
}

void glUniform2ui64vNV(GLint location, GLsizei count, const GLuint64EXT * value)
{
    return Binding::Uniform2ui64vNV(location, count, value);
}

void glUniform2uiEXT(GLint location, GLuint v0, GLuint v1)
{
    return Binding::Uniform2uiEXT(location, v0, v1);
}

void glUniform2uiv(GLint location, GLsizei count, const GLuint * value)
{
    return Binding::Uniform2uiv(location, count, value);
}

void glUniform2uivEXT(GLint location, GLsizei count, const GLuint * value)
{
    return Binding::Uniform2uivEXT(location, count, value);
}

void glUniform3d(GLint location, GLdouble x, GLdouble y, GLdouble z)
{
    return Binding::Uniform3d(location, x, y, z);
}

void glUniform3dv(GLint location, GLsizei count, const GLdouble * value)
{
    return Binding::Uniform3dv(location, count, value);
}

void glUniform3f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
    return Binding::Uniform3f(location, v0, v1, v2);
}

void glUniform3fARB(GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
    return Binding::Uniform3fARB(location, v0, v1, v2);
}

void glUniform3fv(GLint location, GLsizei count, const GLfloat * value)
{
    return Binding::Uniform3fv(location, count, value);
}

void glUniform3fvARB(GLint location, GLsizei count, const GLfloat * value)
{
    return Binding::Uniform3fvARB(location, count, value);
}

void glUniform3i(GLint location, GLint v0, GLint v1, GLint v2)
{
    return Binding::Uniform3i(location, v0, v1, v2);
}

void glUniform3i64ARB(GLint location, GLint64 x, GLint64 y, GLint64 z)
{
    return Binding::Uniform3i64ARB(location, x, y, z);
}

void glUniform3i64NV(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z)
{
    return Binding::Uniform3i64NV(location, x, y, z);
}

void glUniform3i64vARB(GLint location, GLsizei count, const GLint64 * value)
{
    return Binding::Uniform3i64vARB(location, count, value);
}

void glUniform3i64vNV(GLint location, GLsizei count, const GLint64EXT * value)
{
    return Binding::Uniform3i64vNV(location, count, value);
}

void glUniform3iARB(GLint location, GLint v0, GLint v1, GLint v2)
{
    return Binding::Uniform3iARB(location, v0, v1, v2);
}

void glUniform3iv(GLint location, GLsizei count, const GLint * value)
{
    return Binding::Uniform3iv(location, count, value);
}

void glUniform3ivARB(GLint location, GLsizei count, const GLint * value)
{
    return Binding::Uniform3ivARB(location, count, value);
}

void glUniform3ui(GLint location, GLuint v0, GLuint v1, GLuint v2)
{
    return Binding::Uniform3ui(location, v0, v1, v2);
}

void glUniform3ui64ARB(GLint location, GLuint64 x, GLuint64 y, GLuint64 z)
{
    return Binding::Uniform3ui64ARB(location, x, y, z);
}

void glUniform3ui64NV(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z)
{
    return Binding::Uniform3ui64NV(location, x, y, z);
}

void glUniform3ui64vARB(GLint location, GLsizei count, const GLuint64 * value)
{
    return Binding::Uniform3ui64vARB(location, count, value);
}

void glUniform3ui64vNV(GLint location, GLsizei count, const GLuint64EXT * value)
{
    return Binding::Uniform3ui64vNV(location, count, value);
}

void glUniform3uiEXT(GLint location, GLuint v0, GLuint v1, GLuint v2)
{
    return Binding::Uniform3uiEXT(location, v0, v1, v2);
}

void glUniform3uiv(GLint location, GLsizei count, const GLuint * value)
{
    return Binding::Uniform3uiv(location, count, value);
}

void glUniform3uivEXT(GLint location, GLsizei count, const GLuint * value)
{
    return Binding::Uniform3uivEXT(location, count, value);
}

void glUniform4d(GLint location, GLdouble x, GLdouble y, GLdouble z, GLdouble w)
{
    return Binding::Uniform4d(location, x, y, z, w);
}

void glUniform4dv(GLint location, GLsizei count, const GLdouble * value)
{
    return Binding::Uniform4dv(location, count, value);
}

void glUniform4f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
    return Binding::Uniform4f(location, v0, v1, v2, v3);
}

void glUniform4fARB(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
    return Binding::Uniform4fARB(location, v0, v1, v2, v3);
}

void glUniform4fv(GLint location, GLsizei count, const GLfloat * value)
{
    return Binding::Uniform4fv(location, count, value);
}

void glUniform4fvARB(GLint location, GLsizei count, const GLfloat * value)
{
    return Binding::Uniform4fvARB(location, count, value);
}

void glUniform4i(GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
    return Binding::Uniform4i(location, v0, v1, v2, v3);
}

void glUniform4i64ARB(GLint location, GLint64 x, GLint64 y, GLint64 z, GLint64 w)
{
    return Binding::Uniform4i64ARB(location, x, y, z, w);
}

void glUniform4i64NV(GLint location, GLint64EXT x, GLint64EXT y, GLint64EXT z, GLint64EXT w)
{
    return Binding::Uniform4i64NV(location, x, y, z, w);
}

void glUniform4i64vARB(GLint location, GLsizei count, const GLint64 * value)
{
    return Binding::Uniform4i64vARB(location, count, value);
}

void glUniform4i64vNV(GLint location, GLsizei count, const GLint64EXT * value)
{
    return Binding::Uniform4i64vNV(location, count, value);
}

void glUniform4iARB(GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
    return Binding::Uniform4iARB(location, v0, v1, v2, v3);
}

void glUniform4iv(GLint location, GLsizei count, const GLint * value)
{
    return Binding::Uniform4iv(location, count, value);
}

void glUniform4ivARB(GLint location, GLsizei count, const GLint * value)
{
    return Binding::Uniform4ivARB(location, count, value);
}

void glUniform4ui(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
    return Binding::Uniform4ui(location, v0, v1, v2, v3);
}

void glUniform4ui64ARB(GLint location, GLuint64 x, GLuint64 y, GLuint64 z, GLuint64 w)
{
    return Binding::Uniform4ui64ARB(location, x, y, z, w);
}

void glUniform4ui64NV(GLint location, GLuint64EXT x, GLuint64EXT y, GLuint64EXT z, GLuint64EXT w)
{
    return Binding::Uniform4ui64NV(location, x, y, z, w);
}

void glUniform4ui64vARB(GLint location, GLsizei count, const GLuint64 * value)
{
    return Binding::Uniform4ui64vARB(location, count, value);
}

void glUniform4ui64vNV(GLint location, GLsizei count, const GLuint64EXT * value)
{
    return Binding::Uniform4ui64vNV(location, count, value);
}

void glUniform4uiEXT(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
    return Binding::Uniform4uiEXT(location, v0, v1, v2, v3);
}

void glUniform4uiv(GLint location, GLsizei count, const GLuint * value)
{
    return Binding::Uniform4uiv(location, count, value);
}

void glUniform4uivEXT(GLint location, GLsizei count, const GLuint * value)
{
    return Binding::Uniform4uivEXT(location, count, value);
}

void glUniformBlockBinding(GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding)
{
    return Binding::UniformBlockBinding(program, uniformBlockIndex, uniformBlockBinding);
}

void glUniformBufferEXT(GLuint program, GLint location, GLuint buffer)
{
    return Binding::UniformBufferEXT(program, location, buffer);
}

void glUniformHandleui64ARB(GLint location, GLuint64 value)
{
    return Binding::UniformHandleui64ARB(location, value);
}

void glUniformHandleui64NV(GLint location, GLuint64 value)
{
    return Binding::UniformHandleui64NV(location, value);
}

void glUniformHandleui64vARB(GLint location, GLsizei count, const GLuint64 * value)
{
    return Binding::UniformHandleui64vARB(location, count, value);
}

void glUniformHandleui64vNV(GLint location, GLsizei count, const GLuint64 * value)
{
    return Binding::UniformHandleui64vNV(location, count, value);
}

void glUniformMatrix2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
    return Binding::UniformMatrix2dv(location, count, transpose, value);
}

void glUniformMatrix2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
    return Binding::UniformMatrix2fv(location, count, transpose, value);
}

void glUniformMatrix2fvARB(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
    return Binding::UniformMatrix2fvARB(location, count, transpose, value);
}

void glUniformMatrix2x3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
    return Binding::UniformMatrix2x3dv(location, count, transpose, value);
}

void glUniformMatrix2x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
    return Binding::UniformMatrix2x3fv(location, count, transpose, value);
}

void glUniformMatrix2x4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
    return Binding::UniformMatrix2x4dv(location, count, transpose, value);
}

void glUniformMatrix2x4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
    return Binding::UniformMatrix2x4fv(location, count, transpose, value);
}

void glUniformMatrix3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
    return Binding::UniformMatrix3dv(location, count, transpose, value);
}

void glUniformMatrix3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
    return Binding::UniformMatrix3fv(location, count, transpose, value);
}

void glUniformMatrix3fvARB(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
    return Binding::UniformMatrix3fvARB(location, count, transpose, value);
}

void glUniformMatrix3x2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
    return Binding::UniformMatrix3x2dv(location, count, transpose, value);
}

void glUniformMatrix3x2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
    return Binding::UniformMatrix3x2fv(location, count, transpose, value);
}

void glUniformMatrix3x4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
    return Binding::UniformMatrix3x4dv(location, count, transpose, value);
}

void glUniformMatrix3x4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
    return Binding::UniformMatrix3x4fv(location, count, transpose, value);
}

void glUniformMatrix4dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
    return Binding::UniformMatrix4dv(location, count, transpose, value);
}

void glUniformMatrix4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
    return Binding::UniformMatrix4fv(location, count, transpose, value);
}

void glUniformMatrix4fvARB(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
    return Binding::UniformMatrix4fvARB(location, count, transpose, value);
}

void glUniformMatrix4x2dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
    return Binding::UniformMatrix4x2dv(location, count, transpose, value);
}

void glUniformMatrix4x2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
    return Binding::UniformMatrix4x2fv(location, count, transpose, value);
}

void glUniformMatrix4x3dv(GLint location, GLsizei count, GLboolean transpose, const GLdouble * value)
{
    return Binding::UniformMatrix4x3dv(location, count, transpose, value);
}

void glUniformMatrix4x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat * value)
{
    return Binding::UniformMatrix4x3fv(location, count, transpose, value);
}

void glUniformSubroutinesuiv(GLenum shadertype, GLsizei count, const GLuint * indices)
{
    return Binding::UniformSubroutinesuiv(shadertype, count, indices);
}

void glUniformui64NV(GLint location, GLuint64EXT value)
{
    return Binding::Uniformui64NV(location, value);
}

void glUniformui64vNV(GLint location, GLsizei count, const GLuint64EXT * value)
{
    return Binding::Uniformui64vNV(location, count, value);
}

void glUnlockArraysEXT()
{
    return Binding::UnlockArraysEXT();
}

GLboolean glUnmapBuffer(GLenum target)
{
    return Binding::UnmapBuffer(target);
}

GLboolean glUnmapBufferARB(GLenum target)
{
    return Binding::UnmapBufferARB(target);
}

GLboolean glUnmapNamedBuffer(GLuint buffer)
{
    return Binding::UnmapNamedBuffer(buffer);
}

GLboolean glUnmapNamedBufferEXT(GLuint buffer)
{
    return Binding::UnmapNamedBufferEXT(buffer);
}

void glUnmapObjectBufferATI(GLuint buffer)
{
    return Binding::UnmapObjectBufferATI(buffer);
}

void glUnmapTexture2DINTEL(GLuint texture, GLint level)
{
    return Binding::UnmapTexture2DINTEL(texture, level);
}

void glUpdateObjectBufferATI(GLuint buffer, GLuint offset, GLsizei size, const void * pointer, GLenum preserve)
{
    return Binding::UpdateObjectBufferATI(buffer, offset, size, pointer, preserve);
}

void glUseProgram(GLuint program)
{
    return Binding::UseProgram(program);
}

void glUseProgramObjectARB(GLhandleARB programObj)
{
    return Binding::UseProgramObjectARB(programObj);
}

void glUseProgramStages(GLuint pipeline, UseProgramStageMask stages, GLuint program)
{
    return Binding::UseProgramStages(pipeline, stages, program);
}

void glUseShaderProgramEXT(GLenum type, GLuint program)
{
    return Binding::UseShaderProgramEXT(type, program);
}



} // namespace gl
