static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * This program is free software: you can redistribute it and/or modify       \n"
" * it under the terms of the GNU General Public License as published by       \n"
" * the Free Software Foundation; either version 3 of the License, or          \n"
" * (at your option) any later version.                                        \n"
" *                                                                            \n"
" * This program is distributed in the hope that it will be useful,            \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              \n"
" * GNU General Public License for more details.                               \n"
" *                                                                            \n"
" * You should have received a copy of the GNU General Public License          \n"
" * along with this program.  If not, see <http://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" *                                                                            \n"
" * Exchange one color with the other (settable threshold to convert from      \n"
" * one color-shade to another...might do wonders on certain images, or be     \n"
" * totally useless on others).                                                \n"
" *                                                                            \n"
" * Author: Adam D. Moss <adam@foxbox.org>                                     \n"
" *                                                                            \n"
" * GEGL port: Thomas Manni <thomas.manni@free.fr>                             \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"enum_start (gegl_video_degradation_type)                                      \n"
"  enum_value (GEGL_VIDEO_DEGRADATION_TYPE_STAGGERED, \"staggered\",           \n"
"              N_(\"Staggered\"))                                              \n"
"  enum_value (GEGL_VIDEO_DEGRADATION_TYPE_LARGE_STAGGERED, \"large_staggered\",\n"
"              N_(\"Large staggered\"))                                        \n"
"  enum_value (GEGL_VIDEO_DEGRADATION_TYPE_STRIPED, \"striped\",               \n"
"              N_(\"Striped\"))                                                \n"
"  enum_value (GEGL_VIDEO_DEGRADATION_TYPE_WIDE_STRIPED, \"wide_striped\",     \n"
"              N_(\"Wide striped\"))                                           \n"
"  enum_value (GEGL_VIDEO_DEGRADATION_TYPE_LONG_STAGGERED, \"long_staggered\", \n"
"              N_(\"Long staggered\"))                                         \n"
"  enum_value (GEGL_VIDEO_DEGRADATION_TYPE_3X3, \"3x3\",                       \n"
"              N_(\"3x3\"))                                                    \n"
"  enum_value (GEGL_VIDEO_DEGRADATION_TYPE_LARGE_3X3, \"large_3x3\",           \n"
"              N_(\"Large 3x3\"))                                              \n"
"  enum_value (GEGL_VIDEO_DEGRADATION_TYPE_Hex, \"hex\",                       \n"
"              N_(\"Hex\"))                                                    \n"
"  enum_value (GEGL_VIDEO_DEGRADATION_TYPE_DOTS, \"dots\",                     \n"
"              N_(\"Dots\"))                                                   \n"
"enum_end (GeglVideoDegradationType)                                           \n"
"                                                                              \n"
"property_enum (pattern, _(\"Pattern\"), GeglVideoDegradationType,             \n"
"               gegl_video_degradation_type,                                   \n"
"               GEGL_VIDEO_DEGRADATION_TYPE_STRIPED)                           \n"
"  description (_(\"Type of RGB pattern to use\"))                             \n"
"                                                                              \n"
"property_boolean (additive, _(\"Additive\"), TRUE)                            \n"
"  description(_(\"Whether the function adds the result to the original image.\"))\n"
"                                                                              \n"
"property_boolean (rotated, _(\"Rotated\"), FALSE)                             \n"
"  description(_(\"Whether to rotate the RGB pattern by ninety degrees.\"))    \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_C_SOURCE video-degradation.c                                  \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#define MAX_PATTERNS       9                                                  \n"
"#define MAX_PATTERN_SIZE 108                                                  \n"
"                                                                              \n"
"static const gint   pattern_width[MAX_PATTERNS] = { 2, 4, 1, 1, 2, 3, 6, 6, 5 };\n"
"static const gint   pattern_height[MAX_PATTERNS] = { 6, 12, 3, 6, 12, 3, 6,   \n"
"                                                     18, 15 };                \n"
"                                                                              \n"
"static const gint pattern[MAX_PATTERNS][MAX_PATTERN_SIZE] =                   \n"
"{                                                                             \n"
"  {                                                                           \n"
"    0, 1,                                                                     \n"
"    0, 2,                                                                     \n"
"    1, 2,                                                                     \n"
"    1, 0,                                                                     \n"
"    2, 0,                                                                     \n"
"    2, 1,                                                                     \n"
"  },                                                                          \n"
"  {                                                                           \n"
"    0, 0, 1, 1,                                                               \n"
"    0, 0, 1, 1,                                                               \n"
"    0, 0, 2, 2,                                                               \n"
"    0, 0, 2, 2,                                                               \n"
"    1, 1, 2, 2,                                                               \n"
"    1, 1, 2, 2,                                                               \n"
"    1, 1, 0, 0,                                                               \n"
"    1, 1, 0, 0,                                                               \n"
"    2, 2, 0, 0,                                                               \n"
"    2, 2, 0, 0,                                                               \n"
"    2, 2, 1, 1,                                                               \n"
"    2, 2, 1, 1,                                                               \n"
"  },                                                                          \n"
"  {                                                                           \n"
"    0,                                                                        \n"
"    1,                                                                        \n"
"    2,                                                                        \n"
"  },                                                                          \n"
"  {                                                                           \n"
"    0,                                                                        \n"
"    0,                                                                        \n"
"    1,                                                                        \n"
"    1,                                                                        \n"
"    2,                                                                        \n"
"    2,                                                                        \n"
"  },                                                                          \n"
"  {                                                                           \n"
"    0, 1,                                                                     \n"
"    0, 1,                                                                     \n"
"    0, 2,                                                                     \n"
"    0, 2,                                                                     \n"
"    1, 2,                                                                     \n"
"    1, 2,                                                                     \n"
"    1, 0,                                                                     \n"
"    1, 0,                                                                     \n"
"    2, 0,                                                                     \n"
"    2, 0,                                                                     \n"
"    2, 1,                                                                     \n"
"    2, 1,                                                                     \n"
"  },                                                                          \n"
"  {                                                                           \n"
"    0, 1, 2,                                                                  \n"
"    2, 0, 1,                                                                  \n"
"    1, 2, 0,                                                                  \n"
"  },                                                                          \n"
"  {                                                                           \n"
"    0, 0, 1, 1, 2, 2,                                                         \n"
"    0, 0, 1, 1, 2, 2,                                                         \n"
"    2, 2, 0, 0, 1, 1,                                                         \n"
"    2, 2, 0, 0, 1, 1,                                                         \n"
"    1, 1, 2, 2, 0, 0,                                                         \n"
"    1, 1, 2, 2, 0, 0,                                                         \n"
"  },                                                                          \n"
"  {                                                                           \n"
"    2, 2, 0, 0, 0, 0,                                                         \n"
"    2, 2, 2, 0, 0, 2,                                                         \n"
"    2, 2, 2, 2, 2, 2,                                                         \n"
"    2, 2, 2, 1, 1, 2,                                                         \n"
"    2, 2, 1, 1, 1, 1,                                                         \n"
"    1, 1, 1, 1, 1, 1,                                                         \n"
"    0, 0, 1, 1, 1, 1,                                                         \n"
"    0, 0, 0, 1, 1, 0,                                                         \n"
"    0, 0, 0, 0, 0, 0,                                                         \n"
"    0, 0, 0, 2, 2, 0,                                                         \n"
"    0, 0, 2, 2, 2, 2,                                                         \n"
"    2, 2, 2, 2, 2, 2,                                                         \n"
"    1, 1, 2, 2, 2, 2,                                                         \n"
"    1, 1, 1, 2, 2, 1,                                                         \n"
"    1, 1, 1, 1, 1, 1,                                                         \n"
"    1, 1, 1, 0, 0, 1,                                                         \n"
"    1, 1, 0, 0, 0, 0,                                                         \n"
"    0, 0, 0, 0, 0, 0,                                                         \n"
"  },                                                                          \n"
"  {                                                                           \n"
"    0, 1, 2, 0, 0,                                                            \n"
"    1, 1, 1, 2, 0,                                                            \n"
"    0, 1, 2, 2, 2,                                                            \n"
"    0, 0, 1, 2, 0,                                                            \n"
"    0, 1, 1, 1, 2,                                                            \n"
"    2, 0, 1, 2, 2,                                                            \n"
"    0, 0, 0, 1, 2,                                                            \n"
"    2, 0, 1, 1, 1,                                                            \n"
"    2, 2, 0, 1, 2,                                                            \n"
"    2, 0, 0, 0, 1,                                                            \n"
"    1, 2, 0, 1, 1,                                                            \n"
"    2, 2, 2, 0, 1,                                                            \n"
"    1, 2, 0, 0, 0,                                                            \n"
"    1, 1, 2, 0, 1,                                                            \n"
"    1, 2, 2, 2, 0,                                                            \n"
"  }                                                                           \n"
"};                                                                            \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  const Babl     *format = babl_format (\"R'G'B'A float\");                   \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"cl_process (GeglOperation       *operation,                                   \n"
"            cl_mem               in_buf,                                      \n"
"            cl_mem               out_buf,                                     \n"
"            const size_t         n_pixels,                                    \n"
"            const GeglRectangle *roi,                                         \n"
"            gint                 level)                                       \n"
"{                                                                             \n"
"  GeglOperationClass *operation_class = GEGL_OPERATION_GET_CLASS (operation); \n"
"  GeglClRunData *cl_data = operation_class->cl_data;                          \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  const size_t gbl_size[2] = {roi->width, roi->height};                       \n"
"  const size_t gbl_off[2]  = {roi->x, roi->y};                                \n"
"  cl_int cl_err = 0;                                                          \n"
"  cl_mem filter_pat = NULL;                                                   \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    goto error;                                                               \n"
"  filter_pat = gegl_clCreateBuffer (gegl_cl_get_context (),                   \n"
"                                    CL_MEM_READ_ONLY | CL_MEM_COPY_HOST_PTR,  \n"
"                                    pattern_width[o->pattern] *               \n"
"                                    pattern_height[o->pattern] * sizeof(cl_int),\n"
"                                    (void*)pattern[o->pattern],               \n"
"                                    &cl_err);                                 \n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_cl_set_kernel_args (cl_data->kernel[0],                       \n"
"                                    sizeof(cl_mem), &in_buf,                  \n"
"                                    sizeof(cl_mem), &out_buf,                 \n"
"                                    sizeof(cl_mem), &filter_pat,              \n"
"                                    sizeof(cl_int), &pattern_width[o->pattern],\n"
"                                    sizeof(cl_int), &pattern_height[o->pattern],\n"
"                                    sizeof(cl_int), &o->additive,             \n"
"                                    sizeof(cl_int), &o->rotated,              \n"
"                                    NULL);                                    \n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clEnqueueNDRangeKernel (gegl_cl_get_command_queue (),         \n"
"                                        cl_data->kernel[0], 2,                \n"
"                                        gbl_off, gbl_size, NULL,              \n"
"                                        0, NULL, NULL);                       \n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clFinish (gegl_cl_get_command_queue ());                      \n"
"  CL_CHECK;                                                                   \n"
"  cl_err = gegl_clReleaseMemObject (filter_pat);                              \n"
"  CL_CHECK;                                                                   \n"
"  return FALSE;                                                               \n"
"  error:                                                                      \n"
"    if (filter_pat)                                                           \n"
"      gegl_clReleaseMemObject (filter_pat);                                   \n"
"    return TRUE;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gfloat *input  = in_buf;                                                    \n"
"  gfloat *output = out_buf;                                                   \n"
"  gfloat value;                                                               \n"
"  gint x, y;                                                                  \n"
"  gint real_x, real_y;                                                        \n"
"  gint b;                                                                     \n"
"  gint sel_b;                                                                 \n"
"  gint idx;                                                                   \n"
"                                                                              \n"
"  for (y = 0 ; y < roi->height ; y++)                                         \n"
"    {                                                                         \n"
"      real_y = roi->y + y;                                                    \n"
"      for (x = 0 ; x < roi->width ; x++)                                      \n"
"        {                                                                     \n"
"          real_x = roi->x + x;                                                \n"
"                                                                              \n"
"          if (o->rotated)                                                     \n"
"            {                                                                 \n"
"              sel_b = pattern[o->pattern][pattern_width[o->pattern]*          \n"
"                (real_x % pattern_height[o->pattern]) +                       \n"
"                 real_y % pattern_width[o->pattern] ];                        \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              sel_b = pattern[o->pattern][pattern_width[o->pattern]*          \n"
"                 (real_y % pattern_height[o->pattern]) +                      \n"
"                 real_x % pattern_width[o->pattern] ];                        \n"
"            }                                                                 \n"
"                                                                              \n"
"            for (b = 0; b < 4; b++)                                           \n"
"              {                                                               \n"
"                idx = (x + y * roi->width) * 4 + b;                           \n"
"                if (b < 3 )                                                   \n"
"                  {                                                           \n"
"                    value = (sel_b == b) ? input[idx] : 0.f;                  \n"
"                    if (o->additive)                                          \n"
"                      {                                                       \n"
"                        gfloat temp = value + input[idx];                     \n"
"                        value = MIN (temp, 1.0);                              \n"
"                      }                                                       \n"
"                    output[idx] = value;                                      \n"
"                  }                                                           \n"
"                else                                                          \n"
"                 {                                                            \n"
"                   output[idx] = input[idx];                                  \n"
"                 }                                                            \n"
"              }                                                               \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/video-degradation.cl.h\"                                    \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *filter_class;                                \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_POINT_FILTER_CLASS (klass);                \n"
"                                                                              \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  filter_class->process    = process;                                         \n"
"  filter_class->cl_process = cl_process;                                      \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:video-degradation\",                              \n"
"    \"title\",       _(\"Video Degradation\"),                                \n"
"    \"categories\",  \"distort\",                                             \n"
"    \"license\",     \"GPL3+\",                                               \n"
"    \"description\", _(\"This function simulates the degradation of \"        \n"
"                     \"being on an old low-dotpitch RGB video monitor.\"),    \n"
"    \"cl-source\"  , video_degradation_cl_source,                             \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
