//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: MultiLinearExpressionSum.cpp,v 1.1 2007/06/10 14:59:57 delpinux Exp $

#include <MultiLinearExpressionSum.hpp>

std::ostream&
MultiLinearExpressionSum::
put(std::ostream& os) const
{
  bool first = true;

  for (ListType::const_iterator i = __listPlus.begin();
       i != __listPlus.end(); ++i) {
    if (!first) {
      os << '+';
    } else {
      first = false;
    }
    os << *(*i);

  }
  for (ListType::const_iterator i = __listMinus.begin();
       i != __listMinus.end(); ++i) {
    os << '-' << *(*i);
  }

  return os;
}


void
MultiLinearExpressionSum::
check()
{
  for (ListType::iterator i = __listPlus.begin();
       i != __listPlus.end(); ++i) {
    (*(*i)).check();
  }

  for (ListType::iterator i = __listMinus.begin();
       i != __listMinus.end(); ++i) {
    (*(*i)).check();
  }
}

void
MultiLinearExpressionSum::
execute()
{
  for (ListType::iterator i = __listPlus.begin();
       i != __listPlus.end(); ++i) {
    (*(*i)).execute();
  }

  for (ListType::iterator i = __listMinus.begin();
       i != __listMinus.end(); ++i) {
    (*(*i)).execute();
  }
}
