#include "SessionManager.h"
#include "ClientNotifier.h"
#include <boost/thread/recursive_mutex.hpp>
#include <iostream>

using namespace std;

namespace dcqt_backend {
	
SessionManager* SessionManager::inst = 0;

SessionManager::SessionManager() : sessionIdCounter(0), userIdCounter(1)
{
  ClientManager::getInstance()->addListener(this);
  //pthread_mutex_init( &sessionLock, NULL );
  string file;
  size_t files;
  HashManager::getInstance()->getStats(file,hashBytesStart,files);
  TimerManager::getInstance()->addListener(this);
  HubManager::getInstance()->addListener(this);
  HashManager::getInstance()->setPriority(Thread::NORMAL);
  hashingCompleted = files==0;
}

SessionManager::~SessionManager() 
{
//  pthread_mutex_destroy( &sessionLock );
}

int SessionManager::generateUserId()
{
  if( userIdStack.size() > 0 ) return userIdStack.pop();
  return userIdCounter++;
}

//void SessionManager::aquireLock()
//{
  //pthread_mutex_lock( &sessionLock );
//	sessionLock.do_lock();
//}

//void SessionManager::releaseLock()
//{
 // pthread_mutex_unlock( &sessionLock );
//	sessionLock.do_unlock();
//}

int SessionManager::createSession(const string& url)
{
  Client* client = ClientManager::getInstance()->getClient(url);
  Session* session = new Session(sessionIdCounter++,client,url);
  intSessionMap[session->getId()] = session;
  clientSessionMap[client] = session;
  session->connect();
  return session->getId();
}

void SessionManager::closeSession(int session)
{
  //aquireLock();
  boost::recursive_mutex::scoped_lock sl(sessionLock);
  if( intSessionMap.find(session)!=intSessionMap.end()) {

    Session *s = intSessionMap[session];
    intSessionMap.erase(session);
    ClientManager::getInstance()->putClient(s->getClient());
    delete s;
  }
  //releaseLock();
}

Session* SessionManager::getSession(int aId)
{
  return intSessionMap[aId];
}

Session* SessionManager::getSession(Client* aClient)
{
  return clientSessionMap[aClient];
}

 void SessionManager::on(ClientManagerListener::ClientConnected, Client* c) throw()
{
  cout << "SessionManager::on ClientConnected\n";
}

void SessionManager::on(ClientManagerListener::ClientUpdated, Client* c) throw()
{
  cout << "SessionManager::on ClienUpdated\n";
}

 void SessionManager::on(ClientManagerListener::ClientDisconnected, Client* c) throw()
{
  cout << "SessionManager::on ClientDisconnected\n";
}

void SessionManager::on(TimerManagerListener::Second, u_int32_t) throw()
{
  string file;
  int64_t bytesLeft;
  size_t files;
  HashManager::getInstance()->getStats(file,bytesLeft,files);
  if( bytesLeft > hashBytesStart ) hashBytesStart = bytesLeft;
  
  // Are we hashing?
  if(files > 0 )
    {
      hashingCompleted = false;
      // Calculate progress
      double percentComplete = (hashBytesStart-bytesLeft) / (double)hashBytesStart;
      percentComplete *= 100.0;
      // Notify client
      ClientNotifier::instance()->hashInfo(file,bytesLeft,files,(int)percentComplete);
    }
  else
    {
      // We are not hashing.
      // Does the client know that we are finished?
      if( !hashingCompleted ) {
	hashingCompleted = true;
	// Notify client
	ClientNotifier::instance()->hashInfo(file,0,0,100);
	hashBytesStart = 0;
      }
    }
}

HubEntry::List SessionManager::getPublicHubs()
{
	if(HubManager::getInstance()->isDownloading()) return HubEntry::List(); 	
 	HubEntry::List hubs = HubManager::getInstance()->getPublicHubs();
 	if(hubs.size()==0) HubManager::getInstance()->refresh();
 	return hubs;
}
 
FavoriteHubEntry::List& SessionManager::getFavouriteHubs()
{
    return HubManager::getInstance()->getFavoriteHubs(); 
}

void SessionManager::addFavouriteHub(FavoriteHubEntry& entry)
{
    HubManager::getInstance()->addFavorite(entry);   
    
}

void SessionManager::removeFavouriteHub(string& server)
{
    HubManager::getInstance()->removeFavorite(
        HubManager::getInstance()->getFavoriteHubEntry(server)
        );
}
    
void SessionManager::refreshHublist()
{
	if(HubManager::getInstance()->isDownloading()) return;
	HubManager::getInstance()->refresh();
}
 
void SessionManager::on(HubManagerListener::DownloadStarting, const string& file) throw()
{
// 	XmlRpcUtil::log(1,"HubMgr download starting: %s",file.c_str());
}

void SessionManager::on(HubManagerListener::DownloadFailed, const string& file) throw()
{
// 	XmlRpcUtil::log(1,"HubMgr download failed: %s",file.c_str());

}

void SessionManager::on(HubManagerListener::DownloadFinished, const string& file) throw()
{
// 	XmlRpcUtil::log(1,"HubMgr download finished: %s",file.c_str());
	ClientNotifier::instance()->newHubList();
}

void SessionManager::on(HubManagerListener::FavoriteAdded, const FavoriteHubEntry* e) throw()
{
//     XmlRpcUtil::log(2,"HubMgr favadd");
    ClientNotifier::instance()->favouriteHubAdded(e);
}


void SessionManager::on(HubManagerListener::FavoriteRemoved, const FavoriteHubEntry* e) throw()
{
//     XmlRpcUtil::log(2,"HubMgr favremov");
    ClientNotifier::instance()->favouriteHubRemoved(e->getServer());
}

}
