*
* $Id: d115bd.F,v 1.1.1.1 1996/04/01 15:03:13 mclareni Exp $
*
* $Log: d115bd.F,v $
* Revision 1.1.1.1  1996/04/01 15:03:13  mclareni
* Mathlib gen
*
*
#include "sys/CERNLIB_machine.h"
#include "_gen/pilot.h"
      SUBROUTINE D115BD(IX)
C
C     PURPOSE = TO PRESET IN COMMON THE WEIGHTS AND ABSCISSAE TO BE USED
C               IN THE VERSION OF CHINDP REWRITTEN AS A PURE QUADRATURE
C               FORMULA.
C     PARAMETERS IN COMMON BLOCK / DPCHEB /
C     NUPPER  = N CORRESPONDS TO 2**(N+1) SUB-INTERVALS FOR THE UNFOLDED
C               INTEGRAL.THE MAX NO OF FUNCTION EVALUATIONS THUS BEING
C               1+2**(N+1).THE HIGHEST END-POINT APPROXIMATION IS THUS
C               USING 2**(N+1) INTERVALS WHILE THE HIGHEST MID-POINT AP-
C               PROXIMATION IS USING 2**N INTERVALS.
C     BETQJ   = AN ARRAY CONTAINING THE WEIGHTS OF THE MID-POINT FORMU-
C               LAS 1 THROUGH NUPPER.
C               DIMENSION BETQJ(2**N-1)
C     KISQJ   = AN ARRAY CONTAINING THE ABSCISSAE OF THE MID-POINT FOR-
C               MULAS OF ORDER 1 THROUGH NUPPER.
C               DIMENSION KISQJ(2**N-1)
C     ALFQJ   = AN ARRAY CONTAINING THE WEIGHTS OF THE END-POINT FORMU-
C               LAS OF ORDER 2 THROUGH NUPPER+1.
C               DIMENSION ALFQJ(2**(N+1)+N-2)
      DOUBLE PRECISION BETQJ(511),KISQJ(511),ALFQJ(1031)
      COMMON /DPCHEB/ DB(1022),DK(1022),DA(2062),NUPPER
C     WEIGHTS FOR MID-POINT FORMULAS OF INCREASING ORDER.
      DATA  BETQJ(   1) /  1.00000000000000000000000000000D+00 /
      DATA  BETQJ(   2) /  7.35702260395515841466948120704D-01 /
      DATA  BETQJ(   3) /  2.64297739604484158533051879334D-01 /
      DATA  BETQJ(   4) /  3.85876602222307014804123243059D-01 /
      DATA  BETQJ(   5) /  3.24152519064524354347226001928D-01 /
      DATA  BETQJ(   6) /  2.22987933014578813946163622217D-01 /
      DATA  BETQJ(   7) /  6.69829456985898169024871328027D-02 /
      DATA  BETQJ(   8) /  1.95451247812314056328043989390D-01 /
      DATA  BETQJ(   9) /  1.87749728115074003271038262398D-01 /
      DATA  BETQJ(  10) /  1.73419411771946314043685032788D-01 /
      DATA  BETQJ(  11) /  1.51392461637132121514160672387D-01 /
      DATA  BETQJ(  12) /  1.25129618158383650789100458635D-01 /
      DATA  BETQJ(  13) /  9.17183132052952303704207652611D-02 /
      DATA  BETQJ(  14) /  5.83364640693756828609010881667D-02 /
      DATA  BETQJ(  15) /  1.68027552304789408226497309943D-02 /
      DATA  BETQJ(  16) /  9.80594985676589033777447197877D-02 /
      DATA  BETQJ(  17) /  9.71031678911530281316213864061D-02 /
      DATA  BETQJ(  18) /  9.52478048614739935356359731542D-02 /
      DATA  BETQJ(  19) /  9.24141549899298361190497083983D-02 /
      DATA  BETQJ(  20) /  8.87776328671887213053249411531D-02 /
      DATA  BETQJ(  21) /  8.41709772000224234271393383696D-02 /
      DATA  BETQJ(  22) /  7.88996229454584311507403545426D-02 /
      DATA  BETQJ(  23) /  7.26879094967195191512691495117D-02 /
      DATA  BETQJ(  24) /  6.59967064068230252212299001856D-02 /
      DATA  BETQJ(  25) /  5.84015683263386573195965723726D-02 /
      DATA  BETQJ(  26) /  5.05717199950937712305283256871D-02 /
      DATA  BETQJ(  27) /  4.18497477492846903804802558455D-02 /
      DATA  BETQJ(  28) /  3.32371259531269165399233450800D-02 /
      DATA  BETQJ(  29) /  2.36297784196933961644769427257D-02 /
      DATA  BETQJ(  30) /  1.47483281301253089398722611085D-02 /
      DATA  BETQJ(  31) /  4.20425619990937800536682570484D-03 /
      DATA  BETQJ(  32) /  4.90727880726718415980891084878D-02 /
      DATA  BETQJ(  33) /  4.89538187270302219918765874451D-02 /
      DATA  BETQJ(  34) /  4.87191650601860733395885887677D-02 /
      DATA  BETQJ(  35) /  4.83633810166851452253452027978D-02 /
      DATA  BETQJ(  36) /  4.78963773367738420754453364812D-02 /
      DATA  BETQJ(  37) /  4.73071384670531355840942295809D-02 /
      DATA  BETQJ(  38) /  4.66123725148979115812073230394D-02 /
      DATA  BETQJ(  39) /  4.57952381527398410514181445397D-02 /
      DATA  BETQJ(  40) /  4.48795432396496555252983595043D-02 /
      DATA  BETQJ(  41) /  4.38422111265821629991762767533D-02 /
      DATA  BETQJ(  42) /  4.27146100252825789561513762887D-02 /
      DATA  BETQJ(  43) /  4.14668298365662040962622000776D-02 /
      DATA  BETQJ(  44) /  4.01384634865749515116678397898D-02 /
      DATA  BETQJ(  45) /  3.86919232402970344042509788914D-02 /
      DATA  BETQJ(  46) /  3.71759683898331706728240407611D-02 /
      DATA  BETQJ(  47) /  3.55441501365980202602256533756D-02 /
      DATA  BETQJ(  48) /  3.38557332013510651872721261491D-02 /
      DATA  BETQJ(  49) /  3.20537303036380378017250707345D-02 /
      DATA  BETQJ(  50) /  3.02098511873512716792275523172D-02 /
      DATA  BETQJ(  51) /  2.82541302354714105189132709025D-02 /
      DATA  BETQJ(  52) /  2.62736245410712519298389925720D-02 /
      DATA  BETQJ(  53) /  2.41816922001156436442902565645D-02 /
      DATA  BETQJ(  54) /  2.20852976877565292657597542806D-02 /
      DATA  BETQJ(  55) /  1.98751702056907213872576852565D-02 /
      DATA  BETQJ(  56) /  1.76858732581656407894181269584D-02 /
      DATA  BETQJ(  57) /  1.53750452761919178513758604735D-02 /
      DATA  BETQJ(  58) /  1.31192732300491901026532450411D-02 /
      DATA  BETQJ(  59) /  1.07220736325979534387703172229D-02 /
      DATA  BETQJ(  60) /  8.43412760249206854482470589810D-03 /
      DATA  BETQJ(  61) /  5.95172900008703870671692732424D-03 /
      DATA  BETQJ(  62) /  3.69738253841499004508471217168D-03 /
      DATA  BETQJ(  63) /  1.05128707013347823395014961900D-03 /
      DATA  BETQJ(  64) /  2.45418562116188387260496297048D-02 /
      DATA  BETQJ(  65) /  2.45270263066254975653888819810D-02 /
      DATA  BETQJ(  66) /  2.44975627199956819509230286254D-02 /
      DATA  BETQJ(  67) /  2.44531083928094832204446638185D-02 /
      DATA  BETQJ(  68) /  2.43942528786309582683403706714D-02 /
      DATA  BETQJ(  69) /  2.43202802024583602699031877766D-02 /
      DATA  BETQJ(  70) /  2.42321759161535277724885329314D-02 /
      DATA  BETQJ(  71) /  2.41288613791139859955658040957D-02 /
      DATA  BETQJ(  72) /  2.40117226477459638231191403000D-02 /
      DATA  BETQJ(  73) /  2.38793127021104312496194784775D-02 /
      DATA  BETQJ(  74) /  2.37334245393051077344356764003D-02 /
      DATA  BETQJ(  75) /  2.35722349705309097517753380724D-02 /
      DATA  BETQJ(  76) /  2.33979524334629573169817392702D-02 /
      DATA  BETQJ(  77) /  2.32083675490039832781754285618D-02 /
      DATA  BETQJ(  78) /  2.30061149408342046388124349443D-02 /
      DATA  BETQJ(  79) /  2.27885865785100255109001585576D-02 /
      DATA  BETQJ(  80) /  2.25588565007408867258106568488D-02 /
      DATA  BETQJ(  81) /  2.23139028560822119251310184687D-02 /
      DATA  BETQJ(  82) /  2.20572551165736475607493507979D-02 /
      DATA  BETQJ(  83) /  2.17854593879484783573351057469D-02 /
      DATA  BETQJ(  84) /  2.15025197718956944300528502841D-02 /
      DATA  BETQJ(  85) /  2.12045286212519038436175884656D-02 /
      DATA  BETQJ(  86) /  2.08959875344003629348674036808D-02 /
      DATA  BETQJ(  87) /  2.05725093599767214208305659520D-02 /
      DATA  BETQJ(  88) /  2.02391203559297770861763430568D-02 /
      DATA  BETQJ(  89) /  1.98909233710493123302837828800D-02 /
      DATA  BETQJ(  90) /  1.95335015780047717574608291067D-02 /
      DATA  BETQJ(  91) /  1.91614116867049485550054844476D-02 /
      DATA  BETQJ(  92) /  1.87808321537942523948140885756D-02 /
      DATA  BETQJ(  93) /  1.83857306089932152398660548980D-02 /
      DATA  BETQJ(  94) /  1.79829265993143434853119160656D-02 /
      DATA  BETQJ(  95) /  1.75657474215408115431316290959D-02 /
      DATA  BETQJ(  96) /  1.71417086891475921707885165603D-02 /
      DATA  BETQJ(  97) /  1.67034358120624662587196566345D-02 /
      DATA  BETQJ(  98) /  1.62592069155530264319955837727D-02 /
      DATA  BETQJ(  99) /  1.58008710060142752108674759612D-02 /
      DATA  BETQJ( 100) /  1.53375497352951392179826230910D-02 /
      DATA  BETQJ( 101) /  1.48602246061354140544297955044D-02 /
      DATA  BETQJ( 102) /  1.43789606373328322342683902291D-02 /
      DATA  BETQJ( 103) /  1.38837591223772700634002336840D-02 /
      DATA  BETQJ( 104) /  1.33857530795303093301102240257D-02 /
      DATA  BETQJ( 105) /  1.28738221578470520315100542030D-02 /
      DATA  BETQJ( 106) /  1.23603253695221996627273106373D-02 /
      DATA  BETQJ( 107) /  1.18328401805997896171788486260D-02 /
      DATA  BETQJ( 108) /  1.13051556159236831676615897553D-02 /
      DATA  BETQJ( 109) /  1.07633117403738030438797798891D-02 /
      DATA  BETQJ( 110) /  1.02227969783941265822929513070D-02 /
      DATA  BETQJ( 111) /  9.66779984202341078813853814677D-03 /
      DATA  BETQJ( 112) /  9.11587366366965094979480129643D-03 /
      DATA  BETQJ( 113) /  8.54892285989311756700837566727D-03 /
      DATA  BETQJ( 114) /  7.98707861815326916431578890919D-03 /
      DATA  BETQJ( 115) /  7.40934258857931367234827562389D-03 /
      DATA  BETQJ( 116) /  6.83917513755595560486290704049D-03 /
      DATA  BETQJ( 117) /  6.25174592528465975464235182898D-03 /
      DATA  BETQJ( 118) /  5.67500820317006154854468711772D-03 /
      DATA  BETQJ( 119) /  5.07881031921673156694704764211D-03 /
      DATA  BETQJ( 120) /  4.49754311560217795885716046663D-03 /
      DATA  BETQJ( 121) /  3.89312026107933744698493472524D-03 /
      DATA  BETQJ( 122) /  3.30999617943895642410302805178D-03 /
      DATA  BETQJ( 123) /  2.69689733321337524158314197871D-03 /
      DATA  BETQJ( 124) /  2.11637708445345563059866723008D-03 /
      DATA  BETQJ( 125) /  1.49070822312711073978794789435D-03 /
      DATA  BETQJ( 126) /  9.24989999117407064617002648219D-04 /
      DATA  BETQJ( 127) /  2.62835707201773135684147352078D-04 /
      DATA  BETQJ( 128) /  1.22716160204589327903536263085D-02 /
      DATA  BETQJ( 129) /  1.22697650344649992341129544348D-02 /
      DATA  BETQJ( 130) /  1.22660750451493360705842030748D-02 /
      DATA  BETQJ( 131) /  1.22605231968434275809371838537D-02 /
      DATA  BETQJ( 132) /  1.22531454515061851332111962847D-02 /
      DATA  BETQJ( 133) /  1.22438960692284105390479589010D-02 /
      DATA  BETQJ( 134) /  1.22328350331508308002753373489D-02 /
      DATA  BETQJ( 135) /  1.22198936618430416468903615998D-02 /
      DATA  BETQJ( 136) /  1.22051560296808311793956568499D-02 /
      DATA  BETQJ( 137) /  1.21885304274499258166219270833D-02 /
      DATA  BETQJ( 138) /  1.21701251193171161048341866302D-02 /
      DATA  BETQJ( 139) /  1.21498252526252510306170876419D-02 /
      DATA  BETQJ( 140) /  1.21277634088781096744397876227D-02 /
      DATA  BETQJ( 141) /  1.21038014463613752946509551373D-02 /
      DATA  BETQJ( 142) /  1.20780964210870580423097856925D-02 /
      DATA  BETQJ( 143) /  1.20504867260045794489567138555D-02 /
      DATA  BETQJ( 144) /  1.20211540792204306587041949555D-02 /
      DATA  BETQJ( 145) /  1.19899132005362249303208410566D-02 /
      DATA  BETQJ( 146) /  1.19569706891068836573615107866D-02 /
      DATA  BETQJ( 147) /  1.19221173512071346427964968591D-02 /
      DATA  BETQJ( 148) /  1.18855849184878936299459357025D-02 /
      DATA  BETQJ( 149) /  1.18471400095365831797427026343D-02 /
      DATA  BETQJ( 150) /  1.18070397737527882994251118717D-02 /
      DATA  BETQJ( 151) /  1.17650263326888380406172666903D-02 /
      DATA  BETQJ( 152) /  1.17213825740625174859455543098D-02 /
      DATA  BETQJ( 153) /  1.16758257762417343128997723127D-02 /
      DATA  BETQJ( 154) /  1.16286649228781233394149142187D-02 /
      DATA  BETQJ( 155) /  1.15795920643632894291869824858D-02 /
      DATA  BETQJ( 156) /  1.15289426769114834400764156691D-02 /
      DATA  BETQJ( 157) /  1.14763831574138696728965166265D-02 /
      DATA  BETQJ( 158) /  1.14222759125175147071469434333D-02 /
      DATA  BETQJ( 159) /  1.13662612169929033627154929451D-02 /
      DATA  BETQJ( 160) /  1.13087288895486411649732647516D-02 /
      DATA  BETQJ( 161) /  1.12492925684505939393104519204D-02 /
      DATA  BETQJ( 162) /  1.11883700126939460459557917421D-02 /
      DATA  BETQJ( 163) /  1.11255476608865158158300628266D-02 /
      DATA  BETQJ( 164) /  1.10612717903270506256401433749D-02 /
      DATA  BETQJ( 165) /  1.09951010246583724678203145860D-02 /
      DATA  BETQJ( 166) /  1.09275107908883915316850731383D-02 /
      DATA  BETQJ( 167) /  1.08580312264255546002333428334D-02 /
      DATA  BETQJ( 168) /  1.07871675968292089764135669342D-02 /
      DATA  BETQJ( 169) /  1.07144208217534500131815827113D-02 /
      DATA  BETQJ( 170) /  1.06403267561462156253236150852D-02 /
      DATA  BETQJ( 171) /  1.05643563053057182578115865165D-02 /
      DATA  BETQJ( 172) /  1.04870767315375964446126462946D-02 /
      DATA  BETQJ( 173) /  1.04079280586529427721235735542D-02 /
      DATA  BETQJ( 174) /  1.03275098472127027764366256901D-02 /
      DATA  BETQJ( 175) /  1.02452302957271989922020024697D-02 /
      DATA  BETQJ( 176) /  1.01617222333895606997912990885D-02 /
      DATA  BETQJ( 177) /  1.00763610059531139372513791342D-02 /
      DATA  BETQJ( 178) /  9.98981376851612963583766302792D-03 /
      DATA  BETQJ( 179) /  9.90142189508692189893717041747D-03 /
      DATA  BETQJ( 180) /  9.81188801925314202368520817062D-03 /
      DATA  BETQJ( 181) /  9.72051832379581769229323381848D-03 /
      DATA  BETQJ( 182) /  9.62805217825835481112417136729D-03 /
      DATA  BETQJ( 183) /  9.53375924401054186896424033979D-03 /
      DATA  BETQJ( 184) /  9.43841699981418284786814608800D-03 /
      DATA  BETQJ( 185) /  9.34125713308456020085316541582D-03 /
      DATA  BETQJ( 186) /  9.24309673334300855186033962799D-03 /
      DATA  BETQJ( 187) /  9.14312792579336853187661251515D-03 /
      DATA  BETQJ( 188) /  9.04220905485703205057297586554D-03 /
      DATA  BETQJ( 189) /  8.93949094420729209477172533856D-03 /
      DATA  BETQJ( 190) /  8.83587499639242259732537682991D-03 /
      DATA  BETQJ( 191) /  8.73046882547055979542071467777D-03 /
      DATA  BETQJ( 192) /  8.62421887348086502710249127013D-03 /
      DATA  BETQJ( 193) /  8.51618744751828959000090585810D-03 /
      DATA  BETQJ( 194) /  8.40736821071551337873003383829D-03 /
      DATA  BETQJ( 195) /  8.29677585276114512084646996510D-03 /
      DATA  BETQJ( 196) /  8.18545366547307190371997693030D-03 /
      DATA  BETQJ( 197) /  8.07236616976457473405602817956D-03 /
      DATA  BETQJ( 198) /  7.95860894985950417160624862287D-03 /
      DATA  BETQJ( 199) /  7.84309353294538681560609525723D-03 /
      DATA  BETQJ( 200) /  7.72697075095411865849211159092D-03 /
      DATA  BETQJ( 201) /  7.60909600030248031803498492001D-03 /
      DATA  BETQJ( 202) /  7.49067864943605116585574874141D-03 /
      DATA  BETQJ( 203) /  7.37051446919017056875444470277D-03 /
      DATA  BETQJ( 204) /  7.24987503668925550645270020586D-03 /
      DATA  BETQJ( 205) /  7.12749259013077304330353211236D-03 /
      DATA  BETQJ( 206) /  7.00470503049817167237648541483D-03 /
      DATA  BETQJ( 207) /  6.88017667864654510378398794562D-03 /
      DATA  BETQJ( 208) /  6.75531638946794314032795107256D-03 /
      DATA  BETQJ( 209) /  6.62871562506769716963452338998D-03 /
      DATA  BETQJ( 210) /  6.50185942633288937523391094228D-03 /
      DATA  BETQJ( 211) /  6.37326080223992433502694557539D-03 /
      DATA  BETQJ( 212) /  6.24448692035864764189464503922D-03 /
      DATA  BETQJ( 213) /  6.11396597100715964841910314492D-03 /
      DATA  BETQJ( 214) /  5.98335402910269877272627325066D-03 /
      DATA  BETQJ( 215) /  5.85098718327589465830992553693D-03 /
      DATA  BETQJ( 216) /  5.71861819988377717209078854689D-03 /
      DATA  BETQJ( 217) /  5.58448268236528445205730026958D-03 /
      DATA  BETQJ( 218) /  5.45043908143702485942253735998D-03 /
      DATA  BETQJ( 219) /  5.31461280019448453449517451871D-03 /
      DATA  BETQJ( 220) /  5.17897843642146396423186747433D-03 /
      DATA  BETQJ( 221) /  5.04153985062604616153526344757D-03 /
      DATA  BETQJ( 222) /  4.90440005573709999815025946587D-03 /
      DATA  BETQJ( 223) /  4.76542801792284706172412082706D-03 /
      DATA  BETQJ( 224) /  4.62686967606456064638918302381D-03 /
      DATA  BETQJ( 225) /  4.48644323870202790947375720059D-03 /
      DATA  BETQJ( 226) /  4.34655490277176119595568825569D-03 /
      DATA  BETQJ( 227) /  4.20475307483445391253956481387D-03 /
      DATA  BETQJ( 228) /  4.06362514153909660475660623090D-03 /
      DATA  BETQJ( 229) /  3.92052657317185122280787867864D-03 /
      DATA  BETQJ( 230) /  3.77825154410720308723866808020D-03 /
      DATA  BETQJ( 231) /  3.63393410527470779791406065293D-03 /
      DATA  BETQJ( 232) /  3.49060697716282624656083700490D-03 /
      DATA  BETQJ( 233) /  3.34514717545604009508558319206D-03 /
      DATA  BETQJ( 234) /  3.20086602998440680536482556581D-03 /
      DATA  BETQJ( 235) /  3.05433817637560690281708826928D-03 /
      DATA  BETQJ( 236) /  2.90920508910457652111345464436D-03 /
      DATA  BETQJ( 237) /  2.76168005361046734913885462838D-03 /
      DATA  BETQJ( 238) /  2.61580253370465045242460142188D-03 /
      DATA  BETQJ( 239) /  2.46734580367743848413671820381D-03 /
      DATA  BETQJ( 240) /  2.32083915999355584685690530747D-03 /
      DATA  BETQJ( 241) /  2.17150764800084068063855591316D-03 /
      DATA  BETQJ( 242) /  2.02449906858343515122470734070D-03 /
      DATA  BETQJ( 243) /  1.87433552802763030180554029245D-03 /
      DATA  BETQJ( 244) /  1.72697156624368088050880204633D-03 /
      DATA  BETQJ( 245) /  1.57599404156065367142593095984D-03 /
      DATA  BETQJ( 246) /  1.42845553056979628512663196291D-03 /
      DATA  BETQJ( 247) /  1.27663535041507678716834923192D-03 /
      DATA  BETQJ( 248) /  1.12917062624416689881785535696D-03 /
      DATA  BETQJ( 249) /  9.76379874000982290248157478018D-04 /
      DATA  BETQJ( 250) /  8.29391556842895829911373435502D-04 /
      DATA  BETQJ( 251) /  6.75250395854360382935814434997D-04 /
      DATA  BETQJ( 252) /  5.29585257987185081794473169061D-04 /
      DATA  BETQJ( 253) /  3.72850682372956284262450410198D-04 /
      DATA  BETQJ( 254) /  2.31287781672659184602399864521D-04 /
      DATA  BETQJ( 255) /  6.57097980439170205292065577044D-05 /
      DATA  BETQJ( 256) /  6.13589432043524925308532696322D-03 /
      DATA  BETQJ( 257) /  6.13566312461853941837442986040D-03 /
      DATA  BETQJ( 258) /  6.13520147315754910583320529320D-03 /
      DATA  BETQJ( 259) /  6.13450792044203660550953429444D-03 /
      DATA  BETQJ( 260) /  6.13358468720833176074123257758D-03 /
      DATA  BETQJ( 261) /  6.13242888179256201976987303709D-03 /
      DATA  BETQJ( 262) /  6.13104420615234881221935346822D-03 /
      DATA  BETQJ( 263) /  6.12942632168287953626850816296D-03 /
      DATA  BETQJ( 264) /  6.12758041265960566045333765771D-03 /
      DATA  BETQJ( 265) /  6.12550069220448199738239527763D-03 /
      DATA  BETQJ( 266) /  6.12319382844780817383788425434D-03 /
      DATA  BETQJ( 267) /  6.12065258445943226745164024011D-03 /
      DATA  BETQJ( 268) /  6.11788511420386986865513068774D-03 /
      DATA  BETQJ( 269) /  6.11488272847126912508258332966D-03 /
      DATA  BETQJ( 270) /  6.11165506948449161225196864292D-03 /
      DATA  BETQJ( 271) /  6.10819199307499122320222988104D-03 /
      DATA  BETQJ( 272) /  6.10450463259582901092363908280D-03 /
      DATA  BETQJ( 273) /  6.10058138578613549401136577155D-03 /
      DATA  BETQJ( 274) /  6.09643488045226579721451624882D-03 /
      DATA  BETQJ( 275) /  6.09205205264896951967122440808D-03 /
      DATA  BETQJ( 276) /  6.08744702841431468295307330448D-03 /
      DATA  BETQJ( 277) /  6.08260527806382052942924771751D-03 /
      DATA  BETQJ( 278) /  6.07754243010567029360628928988D-03 /
      DATA  BETQJ( 279) /  6.07224248459356681943318609791D-03 /
      DATA  BETQJ( 280) /  6.06672257720944194603540690679D-03 /
      DATA  BETQJ( 281) /  6.06096523274932052218354555962D-03 /
      DATA  BETQJ( 282) /  6.05498909924359717503330167263D-03 /
      DATA  BETQJ( 283) /  6.04877522075533377791005280305D-03 /
      DATA  BETQJ( 284) /  6.04234376331565005370474095216D-03 /
      DATA  BETQJ( 285) /  6.03567428429316347959959154403D-03 /
      DATA  BETQJ( 286) /  6.02878847385663148840371198738D-03 /
      DATA  BETQJ( 287) /  6.02166439622513287641506934022D-03 /
      DATA  BETQJ( 288) /  6.01432527233438180016493018451D-03 /
      DATA  BETQJ( 289) /  6.00674766629713142628330403332D-03 /
      DATA  BETQJ( 290) /  5.99895633694620903096745807849D-03 /
      DATA  BETQJ( 291) /  5.99092634082079738694329058565D-03 /
      DATA  BETQJ( 292) /  5.98268398229095953436550621224D-03 /
      DATA  BETQJ( 293) /  5.97420280233513072517297254492D-03 /
      DATA  BETQJ( 294) /  5.96551065902055052564494659613D-03 /
      DATA  BETQJ( 295) /  5.95657956924758700568167783230D-03 /
      DATA  BETQJ( 296) /  5.94743895347101737635651380543D-03 /
      DATA  BETQJ( 297) /  5.93805929545470599368436280247D-03 /
      DATA  BETQJ( 298) /  5.92847158727313154149467896103D-03 /
      DATA  BETQJ( 299) /  5.91864476994233176786813480849D-03 /
      DATA  BETQJ( 300) /  5.90861141694264810440665445148D-03 /
      DATA  BETQJ( 301) /  5.89833891636548419271295528434D-03 /
      DATA  BETQJ( 302) /  5.88786143345024501441771097868D-03 /
      DATA  BETQJ( 303) /  5.87714479260794464031356380098D-03 /
      DATA  BETQJ( 304) /  5.86622476177121917485441892510D-03 /
      DATA  BETQJ( 305) /  5.85506559032162188132820338647D-03 /
      DATA  BETQJ( 306) /  5.84370466041500761436468431693D-03 /
      DATA  BETQJ( 307) /  5.83210463444576708179247413299D-03 /
      DATA  BETQJ( 308) /  5.82030452093460504192357594932D-03 /
      DATA  BETQJ( 309) /  5.80826538270610984660325725354D-03 /
      DATA  BETQJ( 310) /  5.79602786741595214545343569400D-03 /
      DATA  BETQJ( 311) /  5.78355142509399024079408987843D-03 /
      DATA  BETQJ( 312) /  5.77087835594737204538046190928D-03 /
      DATA  BETQJ( 313) /  5.75796648332556469555896483568D-03 /
      DATA  BETQJ( 314) /  5.74485977406913535753426731964D-03 /
      DATA  BETQJ( 315) /  5.73151441028116666657567509364D-03 /
      DATA  BETQJ( 316) /  5.71797604020323735444350063429D-03 /
      DATA  BETQJ( 317) /  5.70419918942490585673820408979D-03 /
      DATA  BETQJ( 318) /  5.69023120306347374020056338150D-03 /
      DATA  BETQJ( 319) /  5.67602493420459274309795669933D-03 /
      DATA  BETQJ( 320) /  5.66162944104590457161696656306D-03 /
      DATA  BETQJ( 321) /  5.64699588743207805776059941786D-03 /
      DATA  BETQJ( 322) /  5.63217506159979886737267783839D-03 /
      DATA  BETQJ( 323) /  5.61711642064409976376520517217D-03 /
      DATA  BETQJ( 324) /  5.60187250057915544733824170716D-03 /
      DATA  BETQJ( 325) /  5.58639103344373293860667433335D-03 /
      DATA  BETQJ( 326) /  5.57072632157489853634041086043D-03 /
      DATA  BETQJ( 327) /  5.55482435282254082901025567077D-03 /
      DATA  BETQJ( 328) /  5.53874121522784965054390409817D-03 /
      DATA  BETQJ( 329) /  5.52242113246352816971713087999D-03 /
      DATA  BETQJ( 330) /  5.50592199852258026060666557601D-03 /
      DATA  BETQJ( 331) /  5.48918625202500066520109055592D-03 /
      DATA  BETQJ( 332) /  5.47227361406225269419653435781D-03 /
      DATA  BETQJ( 333) /  5.45512471640543731512591416480D-03 /
      DATA  BETQJ( 334) /  5.43780112932455970179824762323D-03 /
      DATA  BETQJ( 335) /  5.42024165498948502058513437556D-03 /
      DATA  BETQJ( 336) /  5.40250973589887606457134608469D-03 /
      DATA  BETQJ( 337) /  5.38454232087518763723626475981D-03 /
      DATA  BETQJ( 338) /  5.36640474870473857205308942903D-03 /
      DATA  BETQJ( 339) /  5.34803209008256434171135597904D-03 /
      DATA  BETQJ( 340) /  5.32949160519177364159633292887D-03 /
      DATA  BETQJ( 341) /  5.31071646074365484736195377397D-03 /
      DATA  BETQJ( 342) /  5.29177586452119479162081162279D-03 /
      DATA  BETQJ( 343) /  5.27260105227415164250996514518D-03 /
      DATA  BETQJ( 344) /  5.25326320672899511826172099324D-03 /
      DATA  BETQJ( 345) /  5.23369160452674202675547869605D-03 /
      DATA  BETQJ( 346) /  5.21395943187096286126788692592D-03 /
      DATA  BETQJ( 347) /  5.19399397692628528613543103336D-03 /
      DATA  BETQJ( 348) /  5.17387045914965108173309359416D-03 /
      DATA  BETQJ( 349) /  5.15351414758695287336414823413D-03 /
      DATA  BETQJ( 350) /  5.13300232602343541342944044013D-03 /
      DATA  BETQJ( 351) /  5.11225821241146194204285190246D-03 /
      DATA  BETQJ( 352) /  5.09136118729779679347675149150D-03 /
      DATA  BETQJ( 353) /  5.07023238417253502027175096588D-03 /
      DATA  BETQJ( 354) /  5.04895331419896902953813458505D-03 /
      DATA  BETQJ( 355) /  5.02744299157672099579930119768D-03 /
      DATA  BETQJ( 356) /  5.00578509343009402283413308522D-03 /
      DATA  BETQJ( 357) /  4.98389647831071491749128634950D-03 /
      DATA  BETQJ( 358) /  4.96186302621003044268516428491D-03 /
      DATA  BETQJ( 359) /  4.93959940207031639174441048898D-03 /
      DATA  BETQJ( 360) /  4.91719372729496464328686089652D-03 /
      DATA  BETQJ( 361) /  4.89455843357216856211867412258D-03 /
      DATA  BETQJ( 362) /  4.87178392398297563194730274741D-03 /
      DATA  BETQJ( 363) /  4.84878035554842179979749505709D-03 /
      DATA  BETQJ( 364) /  4.82564045510170894582133154114D-03 /
      DATA  BETQJ( 365) /  4.80227206172446829452486361301D-03 /
      DATA  BETQJ( 366) /  4.77877026997931737794969634818D-03 /
      DATA  BETQJ( 367) /  4.75504055577989571243552912290D-03 /
      DATA  BETQJ( 368) /  4.73118042739882962092165149570D-03 /
      DATA  BETQJ( 369) /  4.70709295029280996953941767068D-03 /
      DATA  BETQJ( 370) /  4.68287809453611107677209595620D-03 /
      DATA  BETQJ( 371) /  4.65843646566767894702860899472D-03 /
      DATA  BETQJ( 372) /  4.63387054588158432533107172163D-03 /
      DATA  BETQJ( 373) /  4.60907842904685063492137435534D-03 /
      DATA  BETQJ( 374) /  4.58416516214588006244578935964D-03 /
      DATA  BETQJ( 375) /  4.55902627320590071983093432114D-03 /
      DATA  BETQJ( 376) /  4.53376942914959272863240042801D-03 /
      DATA  BETQJ( 377) /  4.50828753543296601460794437184D-03 /
      DATA  BETQJ( 378) /  4.48269093669731856455245527690D-03 /
      DATA  BETQJ( 379) /  4.45686985639222134338597212818D-03 /
      DATA  BETQJ( 380) /  4.43093737743615747188234451414D-03 /
      DATA  BETQJ( 381) /  4.40478097897165852317443222055D-03 /
      DATA  BETQJ( 382) /  4.37851654569886384968783561016D-03 /
      DATA  BETQJ( 383) /  4.35202874711532689691284039393D-03 /
      DATA  BETQJ( 384) /  4.32543633633183554440375202308D-03 /
      DATA  BETQJ( 385) /  4.29862110464019544274457730542D-03 /
      DATA  BETQJ( 386) /  4.27170474350813422783475370720D-03 /
      DATA  BETQJ( 387) /  4.24456609403779677486165015926D-03 /
      DATA  BETQJ( 388) /  4.21732985952573493986472050144D-03 /
      DATA  BETQJ( 389) /  4.18987185526081332101339542189D-03 /
      DATA  BETQJ( 390) /  4.16231987359120724529416071039D-03 /
      DATA  BETQJ( 391) /  4.13454662449476556153614295934D-03 /
      DATA  BETQJ( 392) /  4.10668307058903551017892381108D-03 /
      DATA  BETQJ( 393) /  4.07859873291496138637332734254D-03 /
      DATA  BETQJ( 394) /  4.05042782983679126492249274297D-03 /
      DATA  BETQJ( 395) /  4.02203660542886430092954533582D-03 /
      DATA  BETQJ( 396) /  3.99356262382637656388699570722D-03 /
      DATA  BETQJ( 397) /  3.96486875940403630645125296383D-03 /
      DATA  BETQJ( 398) /  3.93609601695156376368542851963D-03 /
      DATA  BETQJ( 399) /  3.90710380338180869765013292859D-03 /
      DATA  BETQJ( 400) /  3.87803666422206433151935702113D-03 /
      DATA  BETQJ( 401) /  3.84875043577683064168980339117D-03 /
      DATA  BETQJ( 402) /  3.81939330996436728939137063975D-03 /
      DATA  BETQJ( 403) /  3.78981744356264108684800677481D-03 /
      DATA  BETQJ( 404) /  3.76017478650959685455222567394D-03 /
      DATA  BETQJ( 405) /  3.73031370094340412538729485080D-03 /
      DATA  BETQJ( 406) /  3.70039001286864893827313038633D-03 /
      DATA  BETQJ( 407) /  3.67024816801194119680284920721D-03 /
      DATA  BETQJ( 408) /  3.64004799339487764092116916059D-03 /
      DATA  BETQJ( 409) /  3.60962988939418521380336993953D-03 /
      DATA  BETQJ( 410) /  3.57915781643461600754942271600D-03 /
      DATA  BETQJ( 411) /  3.54846799288017151844804851783D-03 /
      DATA  BETQJ( 412) /  3.51772865296583042207917891569D-03 /
      DATA  BETQJ( 413) /  3.48677168804166815598306377905D-03 /
      DATA  BETQJ( 414) /  3.45576975522522553306037972296D-03 /
      DATA  BETQJ( 415) /  3.42455026483653283017516890527D-03 /
      DATA  BETQJ( 416) /  3.39329045532413702859797557422D-03 /
      DATA  BETQJ( 417) /  3.36181309219986551071988105294D-03 /
      DATA  BETQJ( 418) /  3.33030016385357354064088852568D-03 /
      DATA  BETQJ( 419) /  3.29856961662200330065165594608D-03 /
      DATA  BETQJ( 420) /  3.26680836847879723878646749459D-03 /
      DATA  BETQJ( 421) /  3.23482936071337696970039127162D-03 /
      DATA  BETQJ( 422) /  3.20282463252386624188295455688D-03 /
      DATA  BETQJ( 423) /  3.17060192175621543232540354246D-03 /
      DATA  BETQJ( 424) /  3.13835859354660204680148476865D-03 /
      DATA  BETQJ( 425) /  3.10589697024304403494839882007D-03 /
      DATA  BETQJ( 426) /  3.07341996190449327495648473866D-03 /
      DATA  BETQJ( 427) /  3.04072424840187309978717501115D-03 /
      DATA  BETQJ( 428) /  3.00801851931210509770427417756D-03 /
      DATA  BETQJ( 429) /  2.97509356870791257967936896776D-03 /
      DATA  BETQJ( 430) /  2.94216411739063417121100132412D-03 /
      DATA  BETQJ( 431) /  2.90901481238157414320406409222D-03 /
      DATA  BETQJ( 432) /  2.87586667621033491657256431814D-03 /
      DATA  BETQJ( 433) /  2.84249792787242999173052899003D-03 /
      DATA  BETQJ( 434) /  2.80913618282664853545226761692D-03 /
      DATA  BETQJ( 435) /  2.77555292932868365221763822302D-03 /
      DATA  BETQJ( 436) /  2.74198268981099643711755237185D-03 /
      DATA  BETQJ( 437) /  2.70818989505156598989941476332D-03 /
      DATA  BETQJ( 438) /  2.67441631377736150062127605463D-03 /
      DATA  BETQJ( 439) /  2.64041896593389205303142020234D-03 /
      DATA  BETQJ( 440) /  2.60644723390598260572012060636D-03 /
      DATA  BETQJ( 441) /  2.57225034388179101054669471246D-03 /
      DATA  BETQJ( 442) /  2.53808569046574171964544493300D-03 /
      DATA  BETQJ( 443) /  2.50369429021833905047042778640D-03 /
      DATA  BETQJ( 444) /  2.46934198333714387536607527607D-03 /
      DATA  BETQJ( 445) /  2.43476112406746594892417827583D-03 /
      DATA  BETQJ( 446) /  2.40022647053819912054315775020D-03 /
      DATA  BETQJ( 447) /  2.36546122071604633717066905284D-03 /
      DATA  BETQJ( 448) /  2.33074956675603954645983322894D-03 /
      DATA  BETQJ( 449) /  2.29580500995149437820059510239D-03 /
      DATA  BETQJ( 450) /  2.26092174188778126827591446107D-03 /
      DATA  BETQJ( 451) /  2.22580297437141184942774124090D-03 /
      DATA  BETQJ( 452) /  2.19075351959502198873213924547D-03 /
      DATA  BETQJ( 453) /  2.15546564766083431970044394057D-03 /
      DATA  BETQJ( 454) /  2.12025547587752038227995072416D-03 /
      DATA  BETQJ( 455) /  2.08480361283129461924092743195D-03 /
      DATA  BETQJ( 456) /  2.04943823767313285801506660404D-03 /
      DATA  BETQJ( 457) /  2.01382750041415987004685567570D-03 /
      DATA  BETQJ( 458) /  1.97831248149312574166543177124D-03 /
      DATA  BETQJ( 459) /  1.94254798659833168214618372645D-03 /
      DATA  BETQJ( 460) /  1.90688893210473543562226251916D-03 /
      DATA  BETQJ( 461) /  1.87097579129919016669498836376D-03 /
      DATA  BETQJ( 462) /  1.83517836127660272079580625493D-03 /
      DATA  BETQJ( 463) /  1.79912167614126467132591970248D-03 /
      DATA  BETQJ( 464) /  1.76319158660787970169070817043D-03 /
      DATA  BETQJ( 465) /  1.72699644233101762327148509177D-03 /
      DATA  BETQJ( 466) /  1.69093947046902093917329872949D-03 /
      DATA  BETQJ( 467) /  1.65461092838757121288839596718D-03 /
      DATA  BETQJ( 468) /  1.61843291909245962141530643224D-03 /
      DATA  BETQJ( 469) /  1.58197600768703566614624143305D-03 /
      DATA  BETQJ( 470) /  1.54568288186596503244509629882D-03 /
      DATA  BETQJ( 471) /  1.50910258575853358313894484482D-03 /
      DATA  BETQJ( 472) /  1.47270035090270235524853470173D-03 /
      DATA  BETQJ( 473) /  1.43600159724426568912198831711D-03 /
      DATA  BETQJ( 474) /  1.39949636099339228671019350218D-03 /
      DATA  BETQJ( 475) /  1.36268400239756235055077667042D-03 /
      DATA  BETQJ( 476) /  1.32608199009319141168860104925D-03 /
      DATA  BETQJ( 477) /  1.28916078293451021949576730720D-03 /
      DATA  BETQJ( 478) /  1.25246836056840185777456172285D-03 /
      DATA  BETQJ( 479) /  1.21544293696421511412253839165D-03 /
      DATA  BETQJ( 480) /  1.17866664154182817803487311823D-03 /
      DATA  BETQJ( 481) /  1.14154147257907907828468475739D-03 /
      DATA  BETQJ( 482) /  1.10468805285831536455947706100D-03 /
      DATA  BETQJ( 483) /  1.06746739945256011053424592795D-03 /
      DATA  BETQJ( 484) /  1.03054387149358109619171604922D-03 /
      DATA  BETQJ( 485) /  9.93231717400129579564378808932D-04 /
      DATA  BETQJ( 486) /  9.56245441742424763033543272989D-04 /
      DATA  BETQJ( 487) /  9.18845400181728348267996217355D-04 /
      DATA  BETQJ( 488) /  8.81804191425108046227640768662D-04 /
      DATA  BETQJ( 489) /  8.44319371609391384723334022394D-04 /
      DATA  BETQJ( 490) /  8.07231658002060400653588850445D-04 /
      DATA  BETQJ( 491) /  7.69664468753466623216743661831D-04 /
      DATA  BETQJ( 492) /  7.32539531645791989827158731916D-04 /
      DATA  BETQJ( 493) /  6.94891382588600362345280991863D-04 /
      DATA  BETQJ( 494) /  6.57739728683180794925385129672D-04 /
      DATA  BETQJ( 495) /  6.20010557183050880239058699174D-04 /
      DATA  BETQJ( 496) /  5.82844522455387643200895460808D-04 /
      DATA  BETQJ( 497) /  5.45032008039443821701947774286D-04 /
      DATA  BETQJ( 498) /  5.07866790082190195247934680745D-04 /
      DATA  BETQJ( 499) /  4.69964970872633509884207734607D-04 /
      DATA  BETQJ( 500) /  4.32820512959067500763792254954D-04 /
      DATA  BETQJ( 501) /  3.94817160828601002815028194294D-04 /
      DATA  BETQJ( 502) /  3.57721893101959330645176639449D-04 /
      DATA  BETQJ( 503) /  3.19593024660184942122151484779D-04 /
      DATA  BETQJ( 504) /  2.82592182483826071044102319589D-04 /
      DATA  BETQJ( 505) /  2.44288939510509021781348081807D-04 /
      DATA  BETQJ( 506) /  2.07466271306486322231192735046D-04 /
      DATA  BETQJ( 507) /  1.68876765097486823160729924876D-04 /
      DATA  BETQJ( 508) /  1.32427011541491924912059287646D-04 /
      DATA  BETQJ( 509) /  9.32235242601114215273332910150D-05 /
      DATA  BETQJ( 510) /  5.78244631788725686474357215168D-05 /
      DATA  BETQJ( 511) /  1.64275039639182190749970377266D-05 /
C
C     ABSCISSAE FOR MID-POINT FORMULAS OF INCREASING ORDER.
C
      DATA  KISQJ(   1) /  7.07106781186547524400844362086D-01 /
      DATA  KISQJ(   2) /  3.82683432365089771728459984008D-01 /
      DATA  KISQJ(   3) /  9.23879532511286756128183189376D-01 /
      DATA  KISQJ(   4) /  1.95090322016128267848284868470D-01 /
      DATA  KISQJ(   5) /  5.55570233019602224742830813914D-01 /
      DATA  KISQJ(   6) /  8.31469612302545237078788377607D-01 /
      DATA  KISQJ(   7) /  9.80785280403230449126182236122D-01 /
      DATA  KISQJ(   8) /  9.80171403295606019941955638834D-02 /
      DATA  KISQJ(   9) /  2.90284677254462367636192375793D-01 /
      DATA  KISQJ(  10) /  4.71396736825997648556387625885D-01 /
      DATA  KISQJ(  11) /  6.34393284163645498215171613172D-01 /
      DATA  KISQJ(  12) /  7.73010453362736960810906609739D-01 /
      DATA  KISQJ(  13) /  8.81921264348355029712756863645D-01 /
      DATA  KISQJ(  14) /  9.56940335732208864935797886967D-01 /
      DATA  KISQJ(  15) /  9.95184726672196886244836953087D-01 /
      DATA  KISQJ(  16) /  4.90676743274180142549549769402D-02 /
      DATA  KISQJ(  17) /  1.46730474455361751658850129631D-01 /
      DATA  KISQJ(  18) /  2.42980179903263889948274162066D-01 /
      DATA  KISQJ(  19) /  3.36889853392220050689253212597D-01 /
      DATA  KISQJ(  20) /  4.27555093430282094320966856838D-01 /
      DATA  KISQJ(  21) /  5.14102744193221726593693838944D-01 /
      DATA  KISQJ(  22) /  5.95699304492433343467036528809D-01 /
      DATA  KISQJ(  23) /  6.71558954847018400625376850395D-01 /
      DATA  KISQJ(  24) /  7.40951125354959091175616897478D-01 /
      DATA  KISQJ(  25) /  8.03207531480644909806676512920D-01 /
      DATA  KISQJ(  26) /  8.57728610000272069902269984268D-01 /
      DATA  KISQJ(  27) /  9.03989293123443331586200297210D-01 /
      DATA  KISQJ(  28) /  9.41544065183020778412509402582D-01 /
      DATA  KISQJ(  29) /  9.70031253194543992603984207266D-01 /
      DATA  KISQJ(  30) /  9.89176509964780973451673738002D-01 /
      DATA  KISQJ(  31) /  9.98795456205172392714771604750D-01 /
      DATA  KISQJ(  32) /  2.45412285229122880317345294569D-02 /
      DATA  KISQJ(  33) /  7.35645635996674235294656215700D-02 /
      DATA  KISQJ(  34) /  1.22410675199216198498704474141D-01 /
      DATA  KISQJ(  35) /  1.70961888760301226363642357198D-01 /
      DATA  KISQJ(  36) /  2.19101240156869797227737547479D-01 /
      DATA  KISQJ(  37) /  2.66712757474898386325286515102D-01 /
      DATA  KISQJ(  38) /  3.13681740398891476656478845977D-01 /
      DATA  KISQJ(  39) /  3.59895036534988148775104572305D-01 /
      DATA  KISQJ(  40) /  4.05241314004989870908481305482D-01 /
      DATA  KISQJ(  41) /  4.49611329654606600046294579393D-01 /
      DATA  KISQJ(  42) /  4.92898192229784036873026688727D-01 /
      DATA  KISQJ(  43) /  5.34997619887097210663076904594D-01 /
      DATA  KISQJ(  44) /  5.75808191417845300745972453789D-01 /
      DATA  KISQJ(  45) /  6.15231590580626845484913563381D-01 /
      DATA  KISQJ(  46) /  6.53172842953776764084203013586D-01 /
      DATA  KISQJ(  47) /  6.89540544737066924616730629915D-01 /
      DATA  KISQJ(  48) /  7.24247082951466920941069243301D-01 /
      DATA  KISQJ(  49) /  7.57208846506484547575464053597D-01 /
      DATA  KISQJ(  50) /  7.88346427626606262009164705349D-01 /
      DATA  KISQJ(  51) /  8.17584813151583696504920884119D-01 /
      DATA  KISQJ(  52) /  8.44853565249707073259571205087D-01 /
      DATA  KISQJ(  53) /  8.70086991108711418652292404459D-01 /
      DATA  KISQJ(  54) /  8.93224301195515320342416447476D-01 /
      DATA  KISQJ(  55) /  9.14209755703530654635014829373D-01 /
      DATA  KISQJ(  56) /  9.32992798834738887711660255522D-01 /
      DATA  KISQJ(  57) /  9.49528180593036667195936074161D-01 /
      DATA  KISQJ(  58) /  9.63776065795439866686464355485D-01 /
      DATA  KISQJ(  59) /  9.75702130038528544460395766384D-01 /
      DATA  KISQJ(  60) /  9.85277642388941244774018433156D-01 /
      DATA  KISQJ(  61) /  9.92479534598709998156767251641D-01 /
      DATA  KISQJ(  62) /  9.97290456678690216135597140171D-01 /
      DATA  KISQJ(  63) /  9.99698818696204220115765649648D-01 /
      DATA  KISQJ(  64) /  1.22715382857199260794082619499D-02 /
      DATA  KISQJ(  65) /  3.68072229413588323243326909249D-02 /
      DATA  KISQJ(  66) /  6.13207363022085777826145929125D-02 /
      DATA  KISQJ(  67) /  8.57973123444398904615563321418D-02 /
      DATA  KISQJ(  68) /  1.10222207293883058807899140209D-01 /
      DATA  KISQJ(  69) /  1.34580708507126186316358409246D-01 /
      DATA  KISQJ(  70) /  1.58858143333861441684385359645D-01 /
      DATA  KISQJ(  71) /  1.83039887955140958516532578466D-01 /
      DATA  KISQJ(  72) /  2.07111376192218549708116019770D-01 /
      DATA  KISQJ(  73) /  2.31058108280671119643236018457D-01 /
      DATA  KISQJ(  74) /  2.54865659604514571553980778808D-01 /
      DATA  KISQJ(  75) /  2.78519689385053105207848525932D-01 /
      DATA  KISQJ(  76) /  3.02005949319228067003463231707D-01 /
      DATA  KISQJ(  77) /  3.25310292162262934135954707998D-01 /
      DATA  KISQJ(  78) /  3.48418680249434568419308587682D-01 /
      DATA  KISQJ(  79) /  3.71317193951837543411934966997D-01 /
      DATA  KISQJ(  80) /  3.93992040061048108596188660875D-01 /
      DATA  KISQJ(  81) /  4.16429560097637182562598910749D-01 /
      DATA  KISQJ(  82) /  4.38616238538527637647025737510D-01 /
      DATA  KISQJ(  83) /  4.60538710958240023633181486712D-01 /
      DATA  KISQJ(  84) /  4.82183772079122748517344480771D-01 /
      DATA  KISQJ(  85) /  5.03538383725717558691867071228D-01 /
      DATA  KISQJ(  86) /  5.24589682678468906215098463898D-01 /
      DATA  KISQJ(  87) /  5.45324988422046422313987347132D-01 /
      DATA  KISQJ(  88) /  5.65731810783613197389765011331D-01 /
      DATA  KISQJ(  89) /  5.85797857456438860328080838065D-01 /
      DATA  KISQJ(  90) /  6.05511041404325513920626941292D-01 /
      DATA  KISQJ(  91) /  6.24859488142386377084072816255D-01 /
      DATA  KISQJ(  92) /  6.43831542889791465068086063145D-01 /
      DATA  KISQJ(  93) /  6.62415777590171761113069816908D-01 /
      DATA  KISQJ(  94) /  6.80600997795453050594430464426D-01 /
      DATA  KISQJ(  95) /  6.98376249408972853554813503014D-01 /
      DATA  KISQJ(  96) /  7.15730825283818654125532623434D-01 /
      DATA  KISQJ(  97) /  7.32654271672412834615546648894D-01 /
      DATA  KISQJ(  98) /  7.49136394523459325469203256756D-01 /
      DATA  KISQJ(  99) /  7.65167265622458925888815999047D-01 /
      DATA  KISQJ( 100) /  7.80737228572094478301588483774D-01 /
      DATA  KISQJ( 101) /  7.95836904608883536262791915466D-01 /
      DATA  KISQJ( 102) /  8.10457198252594791726703434240D-01 /
      DATA  KISQJ( 103) /  8.24589302785025264474803737070D-01 /
      DATA  KISQJ( 104) /  8.38224705554838043186996855800D-01 /
      DATA  KISQJ( 105) /  8.51355193105265142261290311708D-01 /
      DATA  KISQJ( 106) /  8.63972856121586737918147054340D-01 /
      DATA  KISQJ( 107) /  8.76070094195406607095844268235D-01 /
      DATA  KISQJ( 108) /  8.87639620402853947760181617196D-01 /
      DATA  KISQJ( 109) /  8.98674465693953843041976743716D-01 /
      DATA  KISQJ( 110) /  9.09167983090522376563884787686D-01 /
      DATA  KISQJ( 111) /  9.19113851690057743908477789331D-01 /
      DATA  KISQJ( 112) /  9.28506080473215565937167395694D-01 /
      DATA  KISQJ( 113) /  9.37339011912574923201899593356D-01 /
      DATA  KISQJ( 114) /  9.45607325380521325730945386510D-01 /
      DATA  KISQJ( 115) /  9.53306040354193836916740382713D-01 /
      DATA  KISQJ( 116) /  9.60430519415565811199035137641D-01 /
      DATA  KISQJ( 117) /  9.66976471044852109087220225900D-01 /
      DATA  KISQJ( 118) /  9.72939952205560145467720113873D-01 /
      DATA  KISQJ( 119) /  9.78317370719627633106240096880D-01 /
      DATA  KISQJ( 120) /  9.83105487431216327180301154647D-01 /
      DATA  KISQJ( 121) /  9.87301418157858382399815801830D-01 /
      DATA  KISQJ( 122) /  9.90902635427780025108237010518D-01 /
      DATA  KISQJ( 123) /  9.93906970002356041546922813232D-01 /
      DATA  KISQJ( 124) /  9.96312612182778012627226189641D-01 /
      DATA  KISQJ( 125) /  9.98118112900149207125155860665D-01 /
      DATA  KISQJ( 126) /  9.99322384588349500896221011129D-01 /
      DATA  KISQJ( 127) /  9.99924701839144540921646491188D-01 /
      DATA  KISQJ( 128) /  6.13588464915447535964023458999D-03 /
      DATA  KISQJ( 129) /  1.84067299058048209273663130125D-02 /
      DATA  KISQJ( 130) /  3.06748031766366259340210275626D-02 /
      DATA  KISQJ( 131) /  4.29382569349408230771245402793D-02 /
      DATA  KISQJ( 132) /  5.51952443496899398094475256932D-02 /
      DATA  KISQJ( 133) /  6.74439195636640578979724218695D-02 /
      DATA  KISQJ( 134) /  7.96824379714301211471206559920D-02 /
      DATA  KISQJ( 135) /  9.19089564971327286249909790707D-02 /
      DATA  KISQJ( 136) /  1.04121633872054579120943880056D-01 /
      DATA  KISQJ( 137) /  1.16318630911904767252544319460D-01 /
      DATA  KISQJ( 138) /  1.28498110793793172624415589162D-01 /
      DATA  KISQJ( 139) /  1.40658239332849230714788846396D-01 /
      DATA  KISQJ( 140) /  1.52797185258443427720336612528D-01 /
      DATA  KISQJ( 141) /  1.64913120489969921418189113274D-01 /
      DATA  KISQJ( 142) /  1.77004220412148756196839843918D-01 /
      DATA  KISQJ( 143) /  1.89068664149806212754997837074D-01 /
      DATA  KISQJ( 144) /  2.01104634842091911558443545873D-01 /
      DATA  KISQJ( 145) /  2.13110319916091373967757517834D-01 /
      DATA  KISQJ( 146) /  2.25083911359792835991642119848D-01 /
      DATA  KISQJ( 147) /  2.37023605994367206867735914508D-01 /
      DATA  KISQJ( 148) /  2.48927605745720168110682816257D-01 /
      DATA  KISQJ( 149) /  2.60794117915275518280186509066D-01 /
      DATA  KISQJ( 150) /  2.72621355449948984493347477264D-01 /
      DATA  KISQJ( 151) /  2.84407537211271843618310614919D-01 /
      DATA  KISQJ( 152) /  2.96150888243623824121786127753D-01 /
      DATA  KISQJ( 153) /  3.07849640041534893682063645519D-01 /
      DATA  KISQJ( 154) /  3.19502030816015677901518271526D-01 /
      DATA  KISQJ( 155) /  3.31106305759876401737190737251D-01 /
      DATA  KISQJ( 156) /  3.42660717311994397592781982541D-01 /
      DATA  KISQJ( 157) /  3.54163525420490382357395796107D-01 /
      DATA  KISQJ( 158) /  3.65612997804773870011745908586D-01 /
      DATA  KISQJ( 159) /  3.77007410216418256726567823156D-01 /
      DATA  KISQJ( 160) /  3.88345046698826291624993540646D-01 /
      DATA  KISQJ( 161) /  3.99624199845646828544117030720D-01 /
      DATA  KISQJ( 162) /  4.10843171057903942183466674906D-01 /
      DATA  KISQJ( 163) /  4.22000270799799685941287941303D-01 /
      DATA  KISQJ( 164) /  4.33093818853151968484222638448D-01 /
      DATA  KISQJ( 165) /  4.44122144570429231642069417957D-01 /
      DATA  KISQJ( 166) /  4.55083587126343823535869267878D-01 /
      DATA  KISQJ( 167) /  4.65976495767966177902756064865D-01 /
      DATA  KISQJ( 168) /  4.76799230063322133342158117393D-01 /
      DATA  KISQJ( 169) /  4.87550160148435954641485027280D-01 /
      DATA  KISQJ( 170) /  4.98227666972781852410983869328D-01 /
      DATA  KISQJ( 171) /  5.08830142543107036931749324302D-01 /
      DATA  KISQJ( 172) /  5.19355990165589587361829932035D-01 /
      DATA  KISQJ( 173) /  5.29803624686294668216054671211D-01 /
      DATA  KISQJ( 174) /  5.40171472729892881297845479710D-01 /
      DATA  KISQJ( 175) /  5.50457972936604802977289892490D-01 /
      DATA  KISQJ( 176) /  5.60661576197336023839710223091D-01 /
      DATA  KISQJ( 177) /  5.70780745886967280232652863864D-01 /
      DATA  KISQJ( 178) /  5.80813958095764545075595271643D-01 /
      DATA  KISQJ( 179) /  5.90759701858874228423887908223D-01 /
      DATA  KISQJ( 180) /  6.00616479383868926653875895506D-01 /
      DATA  KISQJ( 181) /  6.10382806276309452716352151670D-01 /
      DATA  KISQJ( 182) /  6.20057211763289178646268191276D-01 /
      DATA  KISQJ( 183) /  6.29638238914927025372981340663D-01 /
      DATA  KISQJ( 184) /  6.39124444863775743801488192727D-01 /
      DATA  KISQJ( 185) /  6.48514401022112445084560550789D-01 /
      DATA  KISQJ( 186) /  6.57806693297078656931182263719D-01 /
      DATA  KISQJ( 187) /  6.66999922303637506650154221769D-01 /
      DATA  KISQJ( 188) /  6.76092703575315960360419227639D-01 /
      DATA  KISQJ( 189) /  6.85083667772700381362052544835D-01 /
      DATA  KISQJ( 190) /  6.93971460889654009003734388959D-01 /
      DATA  KISQJ( 191) /  7.02754744457225302452914420859D-01 /
      DATA  KISQJ( 192) /  7.11432195745216441522130289774D-01 /
      DATA  KISQJ( 193) /  7.20002507961381629076682998801D-01 /
      DATA  KISQJ( 194) /  7.28464390448225196492035437495D-01 /
      DATA  KISQJ( 195) /  7.36816568877369875090132520158D-01 /
      DATA  KISQJ( 196) /  7.45057785441465962407907310253D-01 /
      DATA  KISQJ( 197) /  7.53186799043612482483430485608D-01 /
      DATA  KISQJ( 198) /  7.61202385484261814029709835526D-01 /
      DATA  KISQJ( 199) /  7.69103337645579639346626068846D-01 /
      DATA  KISQJ( 200) /  7.76888465673232450040827982993D-01 /
      DATA  KISQJ( 201) /  7.84556597155575233023892574631D-01 /
      DATA  KISQJ( 202) /  7.92106577300212351782342878604D-01 /
      DATA  KISQJ( 203) /  7.99537269107905033500246232253D-01 /
      DATA  KISQJ( 204) /  8.06847553543799272206514312516D-01 /
      DATA  KISQJ( 205) /  8.14036329705948361654516689669D-01 /
      DATA  KISQJ( 206) /  8.21102514991104679060430820303D-01 /
      DATA  KISQJ( 207) /  8.28045045257755752067527591901D-01 /
      DATA  KISQJ( 208) /  8.34862874986380056304401383012D-01 /
      DATA  KISQJ( 209) /  8.41554977436898409603499519818D-01 /
      DATA  KISQJ( 210) /  8.48120344803297251279133562939D-01 /
      DATA  KISQJ( 211) /  8.54557988365400520767862275693D-01 /
      DATA  KISQJ( 212) /  8.60866938637767279344583876764D-01 /
      DATA  KISQJ( 213) /  8.67046245515692651480195629471D-01 /
      DATA  KISQJ( 214) /  8.73094978418290098636085973083D-01 /
      DATA  KISQJ( 215) /  8.79012226428633477831323710867D-01 /
      DATA  KISQJ( 216) /  8.84797098430937780104007040552D-01 /
      DATA  KISQJ( 217) /  8.90448723244757889952150559897D-01 /
      DATA  KISQJ( 218) /  8.95966249756185155914560281940D-01 /
      DATA  KISQJ( 219) /  9.01348847046022014570746093313D-01 /
      DATA  KISQJ( 220) /  9.06595704514915365332960588402D-01 /
      DATA  KISQJ( 221) /  9.11706032005429851404397325055D-01 /
      DATA  KISQJ( 222) /  9.16679059921042663116457013390D-01 /
      DATA  KISQJ( 223) /  9.21514039342041943465396331527D-01 /
      DATA  KISQJ( 224) /  9.26210242138311341974793388408D-01 /
      DATA  KISQJ( 225) /  9.30766961078983731944872339794D-01 /
      DATA  KISQJ( 226) /  9.35183509938947577642207479732D-01 /
      DATA  KISQJ( 227) /  9.39459223602189911962669245842D-01 /
      DATA  KISQJ( 228) /  9.43593458161960361495301445371D-01 /
      DATA  KISQJ( 229) /  9.47585591017741134653387321212D-01 /
      DATA  KISQJ( 230) /  9.51435020969008369549175568940D-01 /
      DATA  KISQJ( 231) /  9.55141168305770721498157712317D-01 /
      DATA  KISQJ( 232) /  9.58703474895871555374645791752D-01 /
      DATA  KISQJ( 233) /  9.62121404269041595429604316206D-01 /
      DATA  KISQJ( 234) /  9.65394441697689374550843857504D-01 /
      DATA  KISQJ( 235) /  9.68522094274417316221088328957D-01 /
      DATA  KISQJ( 236) /  9.71503890986251775537099621818D-01 /
      DATA  KISQJ( 237) /  9.74339382785575860518721668182D-01 /
      DATA  KISQJ( 238) /  9.77028142657754351485866211067D-01 /
      DATA  KISQJ( 239) /  9.79569765685440534439326109862D-01 /
      DATA  KISQJ( 240) /  9.81963869109555264072848153807D-01 /
      DATA  KISQJ( 241) /  9.84210092386929073193874387216D-01 /
      DATA  KISQJ( 242) /  9.86308097244598647863297524314D-01 /
      DATA  KISQJ( 243) /  9.88257567730749491404792538331D-01 /
      DATA  KISQJ( 244) /  9.90058210262297105505906464450D-01 /
      DATA  KISQJ( 245) /  9.91709753669099522860049931082D-01 /
      DATA  KISQJ( 246) /  9.93211949234794533104601012074D-01 /
      DATA  KISQJ( 247) /  9.94564570734255452119106243377D-01 /
      DATA  KISQJ( 248) /  9.95767414467659793982495642497D-01 /
      DATA  KISQJ( 249) /  9.96820299291165714972629398320D-01 /
      DATA  KISQJ( 250) /  9.97723066644191609848546728409D-01 /
      DATA  KISQJ( 251) /  9.98475580573294752208559038418D-01 /
      DATA  KISQJ( 252) /  9.99077727752645382888781996856D-01 /
      DATA  KISQJ( 253) /  9.99529417501093163079703322146D-01 /
      DATA  KISQJ( 254) /  9.99830581795823422015722274892D-01 /
      DATA  KISQJ( 255) /  9.99981175282601142656990437721D-01 /
      DATA  KISQJ( 256) /  3.06795676296597627014536549079D-03 /
      DATA  KISQJ( 257) /  9.20375478205981931510237841468D-03 /
      DATA  KISQJ( 258) /  1.53392062849881010441518676013D-02 /
      DATA  KISQJ( 259) /  2.14740802754695074183748977950D-02 /
      DATA  KISQJ( 260) /  2.76081457789657416123548717418D-02 /
      DATA  KISQJ( 261) /  3.37411718513775848337161124042D-02 /
      DATA  KISQJ( 262) /  3.98729275877398111285787376780D-02 /
      DATA  KISQJ( 263) /  4.60031821309146288143017879072D-02 /
      DATA  KISQJ( 264) /  5.21317046802833212363582164206D-02 /
      DATA  KISQJ( 265) /  5.82582645004357596139797819299D-02 /
      DATA  KISQJ( 266) /  6.43826309298574608193245368214D-02 /
      DATA  KISQJ( 267) /  7.05045733896138630273514705453D-02 /
      DATA  KISQJ( 268) /  7.66238613920314922783324628178D-02 /
      DATA  KISQJ( 269) /  8.27402645493756931119870831803D-02 /
      DATA  KISQJ( 270) /  8.88535525825245965615865349980D-02 /
      DATA  KISQJ( 271) /  9.49634953296389989380343123525D-02 /
      DATA  KISQJ( 272) /  1.01069862754827824987887584545D-01 /
      DATA  KISQJ( 273) /  1.07172424956808849175529148216D-01 /
      DATA  KISQJ( 274) /  1.13270952177564349018228732900D-01 /
      DATA  KISQJ( 275) /  1.19365214810991364593637789794D-01 /
      DATA  KISQJ( 276) /  1.25454983411546238542336453258D-01 /
      DATA  KISQJ( 277) /  1.31540028702883111103387492680D-01 /
      DATA  KISQJ( 278) /  1.37620121586486044948441663422D-01 /
      DATA  KISQJ( 279) /  1.43695033150294454819773349313D-01 /
      DATA  KISQJ( 280) /  1.49764534677321517229695737330D-01 /
      DATA  KISQJ( 281) /  1.55828397654265235743101486226D-01 /
      DATA  KISQJ( 282) /  1.61886393780111837641387995320D-01 /
      DATA  KISQJ( 283) /  1.67938294974731178054745535990D-01 /
      DATA  KISQJ( 284) /  1.73983873387463827950700807455D-01 /
      DATA  KISQJ( 285) /  1.80022901405699522679906589834D-01 /
      DATA  KISQJ( 286) /  1.86055151663446648105438304154D-01 /
      DATA  KISQJ( 287) /  1.92080397049892441679288204608D-01 /
      DATA  KISQJ( 288) /  1.98098410717953586179324918141D-01 /
      DATA  KISQJ( 289) /  2.04108966092816874181696949938D-01 /
      DATA  KISQJ( 290) /  2.10111836880469621717489972069D-01 /
      DATA  KISQJ( 291) /  2.16106797076219509948385131273D-01 /
      DATA  KISQJ( 292) /  2.22093620973203534094094721299D-01 /
      DATA  KISQJ( 293) /  2.28072083170885739254457379435D-01 /
      DATA  KISQJ( 294) /  2.34041958583543423191242044903D-01 /
      DATA  KISQJ( 295) /  2.40003022448741486568922365344D-01 /
      DATA  KISQJ( 296) /  2.45955050335794611599924708527D-01 /
      DATA  KISQJ( 297) /  2.51897818154216950498106628356D-01 /
      DATA  KISQJ( 298) /  2.57831102162159005614471294743D-01 /
      DATA  KISQJ( 299) /  2.63754678974831383611349321962D-01 /
      DATA  KISQJ( 300) /  2.69668325572915106525464462401D-01 /
      DATA  KISQJ( 301) /  2.75571819310958163076425168372D-01 /
      DATA  KISQJ( 302) /  2.81464937925757984095231007325D-01 /
      DATA  KISQJ( 303) /  2.87347459544729526477331841405D-01 /
      DATA  KISQJ( 304) /  2.93219162694258650606608598941D-01 /
      DATA  KISQJ( 305) /  2.99079826308040476750336972763D-01 /
      DATA  KISQJ( 306) /  3.04929229735402406490728633409D-01 /
      DATA  KISQJ( 307) /  3.10767152749611495835997250184D-01 /
      DATA  KISQJ( 308) /  3.16593375556165867243047034657D-01 /
      DATA  KISQJ( 309) /  3.22407678801069848384807477630D-01 /
      DATA  KISQJ( 310) /  3.28209843579092526107916816603D-01 /
      DATA  KISQJ( 311) /  3.33999651442009404650865480506D-01 /
      DATA  KISQJ( 312) /  3.39776884406826857828825802789D-01 /
      DATA  KISQJ( 313) /  3.45541324963989065539191723049D-01 /
      DATA  KISQJ( 314) /  3.51292756085567125601307623029D-01 /
      DATA  KISQJ( 315) /  3.57030961233430032614954035777D-01 /
      DATA  KISQJ( 316) /  3.62755724367397216204854462101D-01 /
      DATA  KISQJ( 317) /  3.68466829953372331712746221657D-01 /
      DATA  KISQJ( 318) /  3.74164062971457997104393019516D-01 /
      DATA  KISQJ( 319) /  3.79847208924051170576281146767D-01 /
      DATA  KISQJ( 320) /  3.85516053843918864075607949316D-01 /
      DATA  KISQJ( 321) /  3.91170384302253888687512948618D-01 /
      DATA  KISQJ( 322) /  3.96809987416710328595290911328D-01 /
      DATA  KISQJ( 323) /  4.02434650859418441082533933489D-01 /
      DATA  KISQJ( 324) /  4.08044162864978680820747498903D-01 /
      DATA  KISQJ( 325) /  4.13638312238434547471944323511D-01 /
      DATA  KISQJ( 326) /  4.19216888363223956433010019919D-01 /
      DATA  KISQJ( 327) /  4.24779681209108833357226189223D-01 /
      DATA  KISQJ( 328) /  4.30326481340082633908199030557D-01 /
      DATA  KISQJ( 329) /  4.35857079922255491032544080337D-01 /
      DATA  KISQJ( 330) /  4.41371268731716692879988968221D-01 /
      DATA  KISQJ( 331) /  4.46868840162374195353044388684D-01 /
      DATA  KISQJ( 332) /  4.52349587233770874133026702910D-01 /
      DATA  KISQJ( 333) /  4.57813303598877221904961155317D-01 /
      DATA  KISQJ( 334) /  4.63259783551860197390719637078D-01 /
      DATA  KISQJ( 335) /  4.68688822035827933697617870189D-01 /
      DATA  KISQJ( 336) /  4.74100214650550014398580014631D-01 /
      DATA  KISQJ( 337) /  4.79493757660153026679839797633D-01 /
      DATA  KISQJ( 338) /  4.84869248000791101822951698636D-01 /
      DATA  KISQJ( 339) /  4.90226483288291154229598449007D-01 /
      DATA  KISQJ( 340) /  4.95565261825772531150266669506D-01 /
      DATA  KISQJ( 341) /  5.00885382611240786241285003729D-01 /
      DATA  KISQJ( 342) /  5.06186645345155291048942343572D-01 /
      DATA  KISQJ( 343) /  5.11468850437970399504391000948D-01 /
      DATA  KISQJ( 344) /  5.16731799017649881508753876009D-01 /
      DATA  KISQJ( 345) /  5.21975292937154342694258317490D-01 /
      DATA  KISQJ( 346) /  5.27199134781901348464274575453D-01 /
      DATA  KISQJ( 347) /  5.32403127877197971442805218184D-01 /
      DATA  KISQJ( 348) /  5.37587076295645482502214932310D-01 /
      DATA  KISQJ( 349) /  5.42750784864515906586768661171D-01 /
      DATA  KISQJ( 350) /  5.47894059173100165608820570587D-01 /
      DATA  KISQJ( 351) /  5.53016705580027531764226988426D-01 /
      DATA  KISQJ( 352) /  5.58118531220556115693702963791D-01 /
      DATA  KISQJ( 353) /  5.63199344013834115007363771826D-01 /
      DATA  KISQJ( 354) /  5.68258952670131549790548489116D-01 /
      DATA  KISQJ( 355) /  5.73297166698042212820171238904D-01 /
      DATA  KISQJ( 356) /  5.78313796411655563342245019258D-01 /
      DATA  KISQJ( 357) /  5.83308652937698294392830961196D-01 /
      DATA  KISQJ( 358) /  5.88281548222645304786439813207D-01 /
      DATA  KISQJ( 359) /  5.93232295039799808047809426259D-01 /
      DATA  KISQJ( 360) /  5.98160706996342311724958652118D-01 /
      DATA  KISQJ( 361) /  6.03066598540348201693430616952D-01 /
      DATA  KISQJ( 362) /  6.07949784967773667243642670989D-01 /
      DATA  KISQJ( 363) /  6.12810082429409703935211935694D-01 /
      DATA  KISQJ( 364) /  6.17647307937803932403979401674D-01 /
      DATA  KISQJ( 365) /  6.22461279374149972519166720805D-01 /
      DATA  KISQJ( 366) /  6.27251815495144113509622565119D-01 /
      DATA  KISQJ( 367) /  6.32018735939809021909403705693D-01 /
      DATA  KISQJ( 368) /  6.36761861236284230413943434850D-01 /
      DATA  KISQJ( 369) /  6.41481012808583151988739897667D-01 /
      DATA  KISQJ( 370) /  6.46176012983316364832802219513D-01 /
      DATA  KISQJ( 371) /  6.50846684996380915068975572875D-01 /
      DATA  KISQJ( 372) /  6.55492852999615385312679701200D-01 /
      DATA  KISQJ( 373) /  6.60114342067420478559490746854D-01 /
      DATA  KISQJ( 374) /  6.64710978203344868130324985251D-01 /
      DATA  KISQJ( 375) /  6.69282588346636065720696365889D-01 /
      DATA  KISQJ( 376) /  6.73829000378756060917568371746D-01 /
      DATA  KISQJ( 377) /  6.78350043129861486873655041666D-01 /
      DATA  KISQJ( 378) /  6.82845546385248068164596123030D-01 /
      DATA  KISQJ( 379) /  6.87315340891759108199186948194D-01 /
      DATA  KISQJ( 380) /  6.91759258364157774906734132053D-01 /
      DATA  KISQJ( 381) /  6.96177131491462944788582591367D-01 /
      DATA  KISQJ( 382) /  7.00568793943248366792866380211D-01 /
      DATA  KISQJ( 383) /  7.04934080375904908852523758069D-01 /
      DATA  KISQJ( 384) /  7.09272826438865651316533771592D-01 /
      DATA  KISQJ( 385) /  7.13584868780793592903125099452D-01 /
      DATA  KISQJ( 386) /  7.17870045055731736211325329334D-01 /
      DATA  KISQJ( 387) /  7.22128193929215321243607197661D-01 /
      DATA  KISQJ( 388) /  7.26359155084345976817494314532D-01 /
      DATA  KISQJ( 389) /  7.30562769227827561177758849974D-01 /
      DATA  KISQJ( 390) /  7.34738878095963464563223603807D-01 /
      DATA  KISQJ( 391) /  7.38887324460615147933116507921D-01 /
      DATA  KISQJ( 392) /  7.43007952135121693517362293305D-01 /
      DATA  KISQJ( 393) /  7.47100605980180144323078847206D-01 /
      DATA  KISQJ( 394) /  7.51165131909686411205819421773D-01 /
      DATA  KISQJ( 395) /  7.55201376896536527598710756244D-01 /
      DATA  KISQJ( 396) /  7.59209188978388033485525442686D-01 /
      DATA  KISQJ( 397) /  7.63188417263381271704838297060D-01 /
      DATA  KISQJ( 398) /  7.67138911935820381181694573246D-01 /
      DATA  KISQJ( 399) /  7.71060524261813773200605758607D-01 /
      DATA  KISQJ( 400) /  7.74953106594873878359129282458D-01 /
      DATA  KISQJ( 401) /  7.78816512381475953374724325253D-01 /
      DATA  KISQJ( 402) /  7.82650596166575738458949300573D-01 /
      DATA  KISQJ( 403) /  7.86455213599085757522319463850D-01 /
      DATA  KISQJ( 404) /  7.90230221437310055030217152301D-01 /
      DATA  KISQJ( 405) /  7.93975477554337164895083757178D-01 /
      DATA  KISQJ( 406) /  7.97690840943391108362662754966D-01 /
      DATA  KISQJ( 407) /  8.01376171723140219430247777160D-01 /
      DATA  KISQJ( 408) /  8.05031331142963597922659281889D-01 /
      DATA  KISQJ( 409) /  8.08656181588174991946968127860D-01 /
      DATA  KISQJ( 410) /  8.12250586585203913049744180752D-01 /
      DATA  KISQJ( 411) /  8.15814410806733789010772659848D-01 /
      DATA  KISQJ( 412) /  8.19347520076796960824689637221D-01 /
      DATA  KISQJ( 413) /  8.22849781375826332046780034426D-01 /
      DATA  KISQJ( 414) /  8.26321062845663480311195451756D-01 /
      DATA  KISQJ( 415) /  8.29761233794523042469023764686D-01 /
      DATA  KISQJ( 416) /  8.33170164701913186439915921546D-01 /
      DATA  KISQJ( 417) /  8.36547727223511984524285790174D-01 /
      DATA  KISQJ( 418) /  8.39893794195999504583383986534D-01 /
      DATA  KISQJ( 419) /  8.43208239641845437161743865163D-01 /
      DATA  KISQJ( 420) /  8.46490938774052078300544488117D-01 /
      DATA  KISQJ( 421) /  8.49741768000852489471268394937D-01 /
      DATA  KISQJ( 422) /  8.52960604930363657746588081732D-01 /
      DATA  KISQJ( 423) /  8.56147328375194481019630732175D-01 /
      DATA  KISQJ( 424) /  8.59301818357008404783582139215D-01 /
      DATA  KISQJ( 425) /  8.62423956111040538690933877772D-01 /
      DATA  KISQJ( 426) /  8.65513624090569082825488357583D-01 /
      DATA  KISQJ( 427) /  8.68570705971340895340449875745D-01 /
      DATA  KISQJ( 428) /  8.71595086655951034842481435162D-01 /
      DATA  KISQJ( 429) /  8.74586652278176112634431897290D-01 /
      DATA  KISQJ( 430) /  8.77545290207261291668470750274D-01 /
      DATA  KISQJ( 431) /  8.80470889052160770806542929443D-01 /
      DATA  KISQJ( 432) /  8.83363338665731594736308014685D-01 /
      DATA  KISQJ( 433) /  8.86222530148880631647990820904D-01 /
      DATA  KISQJ( 434) /  8.89048355854664562540777729324D-01 /
      DATA  KISQJ( 435) /  8.91840709392342727796478697206D-01 /
      DATA  KISQJ( 436) /  8.94599485631382678433072125618D-01 /
      DATA  KISQJ( 437) /  8.97324580705418281231391836130D-01 /
      DATA  KISQJ( 438) /  9.00015892016160228714535266562D-01 /
      DATA  KISQJ( 439) /  9.02673318237258806751502390666D-01 /
      DATA  KISQJ( 440) /  9.05296759318118774354048329122D-01 /
      DATA  KISQJ( 441) /  9.07886116487666212038681479855D-01 /
      DATA  KISQJ( 442) /  9.10441292258067196934095369262D-01 /
      DATA  KISQJ( 443) /  9.12962190428398164628018233381D-01 /
      DATA  KISQJ( 444) /  9.15448716088267819566431291934D-01 /
      DATA  KISQJ( 445) /  9.17900775621390457642276296990D-01 /
      DATA  KISQJ( 446) /  9.20318276709110566440076540986D-01 /
      DATA  KISQJ( 447) /  9.22701128333878570437264226788D-01 /
      DATA  KISQJ( 448) /  9.25049240782677590302371868590D-01 /
      DATA  KISQJ( 449) /  9.27362525650401087274536959012D-01 /
      DATA  KISQJ( 450) /  9.29640895843181265457918066455D-01 /
      DATA  KISQJ( 451) /  9.31884265581668106718557198563D-01 /
      DATA  KISQJ( 452) /  9.34092550404258914729877882510D-01 /
      DATA  KISQJ( 453) /  9.36265667170278246576310995662D-01 /
      DATA  KISQJ( 454) /  9.38403534063108112192420773588D-01 /
      DATA  KISQJ( 455) /  9.40506070593268323787291309238D-01 /
      DATA  KISQJ( 456) /  9.42573197601446879280758735003D-01 /
      DATA  KISQJ( 457) /  9.44604837261480265659265493443D-01 /
      DATA  KISQJ( 458) /  9.46600913083283570044599822951D-01 /
      DATA  KISQJ( 459) /  9.48561349915730288158494825745D-01 /
      DATA  KISQJ( 460) /  9.50486073949481721759926100598D-01 /
      DATA  KISQJ( 461) /  9.52375012719765858529893607552D-01 /
      DATA  KISQJ( 462) /  9.54228095109105629780430732160D-01 /
      DATA  KISQJ( 463) /  9.56045251349996443270479822527D-01 /
      DATA  KISQJ( 464) /  9.57826413027532890321037028776D-01 /
      DATA  KISQJ( 465) /  9.59571513081984528335528181200D-01 /
      DATA  KISQJ( 466) /  9.61280485811320641748659652503D-01 /
      DATA  KISQJ( 467) /  9.62953266873683886347921480831D-01 /
      DATA  KISQJ( 468) /  9.64589793289812723836432158606D-01 /
      DATA  KISQJ( 469) /  9.66190003445412555433832961191D-01 /
      DATA  KISQJ( 470) /  9.67753837093475465243391912229D-01 /
      DATA  KISQJ( 471) /  9.69281235356548486048290738083D-01 /
      DATA  KISQJ( 472) /  9.70772140728950302138169610669D-01 /
      DATA  KISQJ( 473) /  9.72226497078936305708321144193D-01 /
      DATA  KISQJ( 474) /  9.73644249650811925318383911503D-01 /
      DATA  KISQJ( 475) /  9.75025345066994146844913467816D-01 /
      DATA  KISQJ( 476) /  9.76369731330021149312732194451D-01 /
      DATA  KISQJ( 477) /  9.77677357824509979943404762454D-01 /
      DATA  KISQJ( 478) /  9.78948175319062194715480123643D-01 /
      DATA  KISQJ( 479) /  9.80182135968117392690210008629D-01 /
      DATA  KISQJ( 480) /  9.81379193313754574318224189860D-01 /
      DATA  KISQJ( 481) /  9.82539302287441255907040395566D-01 /
      DATA  KISQJ( 482) /  9.83662419211730274396237776118D-01 /
      DATA  KISQJ( 483) /  9.84748501801904218556553175770D-01 /
      DATA  KISQJ( 484) /  9.85797509167567424700994999589D-01 /
      DATA  KISQJ( 485) /  9.86809401814185476970235952203D-01 /
      DATA  KISQJ( 486) /  9.87784141644572154230969032360D-01 /
      DATA  KISQJ( 487) /  9.88721691960323767604516485470D-01 /
      DATA  KISQJ( 488) /  9.89622017463200834623694453770D-01 /
      DATA  KISQJ( 489) /  9.90485084256457037998682242511D-01 /
      DATA  KISQJ( 490) /  9.91310859846115418957349798653D-01 /
      DATA  KISQJ( 491) /  9.92099313142191757112085445348D-01 /
      DATA  KISQJ( 492) /  9.92850414459865090793563343958D-01 /
      DATA  KISQJ( 493) /  9.93564135520595333782021697326D-01 /
      DATA  KISQJ( 494) /  9.94240449453187946358413441893D-01 /
      DATA  KISQJ( 495) /  9.94879330794805620591166106747D-01 /
      DATA  KISQJ( 496) /  9.95480755491926941769171600327D-01 /
      DATA  KISQJ( 497) /  9.96044700901251989887944810258D-01 /
      DATA  KISQJ( 498) /  9.96571145790554847093566910310D-01 /
      DATA  KISQJ( 499) /  9.97060070339482978987989949361D-01 /
      DATA  KISQJ( 500) /  9.97511456140303459699448389777D-01 /
      DATA  KISQJ( 501) /  9.97925286198596012623025462298D-01 /
      DATA  KISQJ( 502) /  9.98301544933892840738782163012D-01 /
      DATA  KISQJ( 503) /  9.98640218180265222418199049169D-01 /
      DATA  KISQJ( 504) /  9.98941293186856850633930265717D-01 /
      DATA  KISQJ( 505) /  9.99204758618363895492950000490D-01 /
      DATA  KISQJ( 506) /  9.99430604555461772019008327257D-01 /
      DATA  KISQJ( 507) /  9.99618822495178597116830637345D-01 /
      DATA  KISQJ( 508) /  9.99769405351215321657617036317D-01 /
      DATA  KISQJ( 509) /  9.99882347454212525633049626495D-01 /
      DATA  KISQJ( 510) /  9.99957644551963866333120919506D-01 /
      DATA  KISQJ( 511) /  9.99995293809576171511580125681D-01 /
C
C     WEIGHTS FOR END-POINT FORMULAS OF INCREASING ORDER.
C
      DATA  ALFQJ(  1) /  4.00000000000000000000000000000D-01 /
      DATA  ALFQJ(  2) /  5.33333333333333333333333333333D-01 /
      DATA  ALFQJ(  3) /  6.66666666666666666666666666667D-02 /
      DATA  ALFQJ(   4) /  1.96825396825396825396825396817D-01 /
      DATA  ALFQJ(   5) /  3.61717858720489781496001680560D-01 /
      DATA  ALFQJ(   6) /  2.79365079365079365079365079362D-01 /
      DATA  ALFQJ(   7) /  1.46218649216018155011934827383D-01 /
      DATA  ALFQJ(   8) /  1.58730158730158730158730158910D-02 /
      DATA  ALFQJ(   9) /  9.82050629109452638864403570222D-02 /
      DATA  ALFQJ(  10) /  1.92513864612925646869630493245D-01 /
      DATA  ALFQJ(  11) /  1.81473784236493356996484900232D-01 /
      DATA  ALFQJ(  12) /  1.63172664281703302561919894414D-01 /
      DATA  ALFQJ(  13) /  1.38956468368233074115427056601D-01 /
      DATA  ALFQJ(  14) /  1.08905552581890930443650341868D-01 /
      DATA  ALFQJ(  15) /  7.54823315431518344134123920211D-02 /
      DATA  ALFQJ(  16) /  3.73687028372056103208777018531D-02 /
      DATA  ALFQJ(  17) /  3.92156862745098039215686276556D-03 /
      DATA  ALFQJ(  18) /  4.90892888908841483837317589249D-02 /
      DATA  ALFQJ(  19) /  9.76981882080555818199887181721D-02 /
      DATA  ALFQJ(  20) /  9.62923259454881791931222171945D-02 /
      DATA  ALFQJ(  21) /  9.39432444387687357292598119157D-02 /
      DATA  ALFQJ(  22) /  9.07061128677209987369213635670D-02 /
      DATA  ALFQJ(  23) /  8.65775384418274354386410715783D-02 /
      DATA  ALFQJ(  24) /  8.16348176549385102288108684610D-02 /
      DATA  ALFQJ(  25) /  7.58838004413884704797301542765D-02 /
      DATA  ALFQJ(  26) /  6.94275756304354508997318921625D-02 /
      DATA  ALFQJ(  27) /  6.22721095452940045529609023427D-02 /
      DATA  ALFQJ(  28) /  5.45550163039803104377448839810D-02 /
      DATA  ALFQJ(  29) /  4.62627628377517494915733878782D-02 /
      DATA  ALFQJ(  30) /  3.75943419140472060161856253328D-02 /
      DATA  ALFQJ(  31) /  2.84579166772336900936264500857D-02 /
      DATA  ALFQJ(  32) /  1.92342451326811491829302760063D-02 /
      DATA  ALFQJ(  33) /  9.39319796295501470115987522420D-03 /
      DATA  ALFQJ(  34) /  9.77517106549364613880742931933D-04 /
      DATA  ALFQJ(  35) /  2.45438117574712279238905445863D-02 /
      DATA  ALFQJ(  36) /  4.90280184310255529406044869546D-02 /
      DATA  ALFQJ(  37) /  4.88512566430660937099107851548D-02 /
      DATA  ALFQJ(  38) /  4.85558448571410527371339699338D-02 /
      DATA  ALFQJ(  39) /  4.81444325725122034100248388245D-02 /
      DATA  ALFQJ(  40) /  4.76160445852501929604020076484D-02 /
      DATA  ALFQJ(  41) /  4.69739590466141487048533746596D-02 /
      DATA  ALFQJ(  42) /  4.62176675109255768403023240524D-02 /
      DATA  ALFQJ(  43) /  4.53511095516606722103297444394D-02 /
      DATA  ALFQJ(  44) /  4.43741792392573157959860411354D-02 /
      DATA  ALFQJ(  45) /  4.32915149616908293478506982631D-02 /
      DATA  ALFQJ(  46) /  4.21033311114181020282015236939D-02 /
      DATA  ALFQJ(  47) /  4.08150134003578338355409028613D-02 /
      DATA  ALFQJ(  48) /  3.94269887129560997565087036611D-02 /
      DATA  ALFQJ(  49) /  3.79454599212848171139433315200D-02 /
      DATA  ALFQJ(  50) /  3.63709202866391830917537015223D-02 /
      DATA  ALFQJ(  51) /  3.47104981809251142704743134011D-02 /
      DATA  ALFQJ(  52) /  3.29645465699763299723064892228D-02 /
      DATA  ALFQJ(  53) /  3.11412971040676244748418795798D-02 /
      DATA  ALFQJ(  54) /  2.92406531974683376955186877006D-02 /
      DATA  ALFQJ(  55) /  2.72722571414683868638177295712D-02 /
      DATA  ALFQJ(  56) /  2.52350649817547659011368211297D-02 /
      DATA  ALFQJ(  57) /  2.31406949343581984772920808617D-02 /
      DATA  ALFQJ(  58) /  2.09862744297374337812543582559D-02 /
      DATA  ALFQJ(  59) /  1.87865297417957835416649964575D-02 /
      DATA  ALFQJ(  60) /  1.65349876572895896488648107457D-02 /
      DATA  ALFQJ(  61) /  1.42520604323519967855308389094D-02 /
      DATA  ALFQJ(  62) /  1.19233947142127716028404685798D-02 /
      DATA  ALFQJ(  63) /  9.58233879528379038701130809732D-03 /
      DATA  ALFQJ(  64) /  7.19269316173611402494145654177D-03 /
      DATA  ALFQJ(  65) /  4.83146544879091264265633245726D-03 /
      DATA  ALFQJ(  66) /  2.35149067531170332236624936762D-03 /
      DATA  ALFQJ(  67) /  2.44200244200244200244200264708D-04 /
      DATA  ALFQJ(  68) /  1.22718537527570913129538189054D-02 /
      DATA  ALFQJ(  69) /  2.45362855965149547279520737537D-02 /
      DATA  ALFQJ(  70) /  2.45141435888156829230358645493D-02 /
      DATA  ALFQJ(  71) /  2.44771754274344428396539225048D-02 /
      DATA  ALFQJ(  72) /  2.44255230615670868966806603993D-02 /
      DATA  ALFQJ(  73) /  2.43590974892764318436781843955D-02 /
      DATA  ALFQJ(  74) /  2.42780594207574592347768855464D-02 /
      DATA  ALFQJ(  75) /  2.41823362389314756676436971552D-02 /
      DATA  ALFQJ(  76) /  2.40721079232784999965897389967D-02 /
      DATA  ALFQJ(  77) /  2.39473175047690150209538888276D-02 /
      DATA  ALFQJ(  78) /  2.38081647302425897458759691724D-02 /
      DATA  ALFQJ(  79) /  2.36546074605776652264367730839D-02 /
      DATA  ALFQJ(  80) /  2.34868657119316350534971270904D-02 /
      DATA  ALFQJ(  81) /  2.33049112613114327309412378741D-02 /
      DATA  ALFQJ(  82) /  2.31089849162740716752945873491D-02 /
      DATA  ALFQJ(  83) /  2.28990713439060588211790789507D-02 /
      DATA  ALFQJ(  84) /  2.26754327045667171760111412125D-02 /
      DATA  ALFQJ(  85) /  2.24380653972263018398406215722D-02 /
      DATA  ALFQJ(  86) /  2.21872535589719508774528660849D-02 /
      DATA  ALFQJ(  87) /  2.19230040059875689202547600306D-02 /
      DATA  ALFQJ(  88) /  2.16456235671288244043093192266D-02 /
      DATA  ALFQJ(  89) /  2.13551279742597072526381730488D-02 /
      DATA  ALFQJ(  90) /  2.10518475900201113125603857018D-02 /
      DATA  ALFQJ(  91) /  2.07358053349014781567278717695D-02 /
      DATA  ALFQJ(  92) /  2.04073561200386786276601579354D-02 /
      DATA  ALFQJ(  93) /  2.00665280519835760397635707548D-02 /
      DATA  ALFQJ(  94) /  1.97137018370015572460427626662D-02 /
      DATA  ALFQJ(  95) /  1.93489084239245184413105322573D-02 /
      DATA  ALFQJ(  96) /  1.89725558706794842591168595711D-02 /
      DATA  ALFQJ(  97) /  1.85846751956690866138437810563D-02 /
      DATA  ALFQJ(  98) /  1.81857037792633948059242195271D-02 /
      DATA  ALFQJ(  99) /  1.77756693887527999747702922971D-02 /
      DATA  ALFQJ( 100) /  1.73550412541139495796798665621D-02 /
      DATA  ALFQJ( 101) /  1.69238398584649936753755450335D-02 /
      DATA  ALFQJ( 102) /  1.64825695622037790873424159209D-02 /
      DATA  ALFQJ( 103) /  1.60312385874505791578669761314D-02 /
      DATA  ALFQJ( 104) /  1.55703907389942596025456958053D-02 /
      DATA  ALFQJ( 105) /  1.51000157247926678262272643125D-02 /
      DATA  ALFQJ( 106) /  1.46207025463435020528446061842D-02 /
      DATA  ALFQJ( 107) /  1.41324143785309413340308104267D-02 /
      DATA  ALFQJ( 108) /  1.36357932129377204666109715543D-02 /
      DATA  ALFQJ( 109) /  1.31307651669397462984248954107D-02 /
      DATA  ALFQJ( 110) /  1.26180359797774327131349322249D-02 /
      DATA  ALFQJ( 111) /  1.20974805280716411270563731076D-02 /
      DATA  ALFQJ( 112) /  1.15698834829084996745597844435D-02 /
      DATA  ALFQJ( 113) /  1.10350487742725418353968914131D-02 /
      DATA  ALFQJ( 114) /  1.04938620257689212459046899782D-02 /
      DATA  ALFQJ( 115) /  9.94602784923457905407038051576D-03 /
      DATA  ALFQJ( 116) /  9.39256583934814870595392739432D-03 /
      DATA  ALFQJ( 117) /  8.83303867470133580636144150295D-03 /
      DATA  ALFQJ( 118) /  8.26865154203087108287793817451D-03 /
      DATA  ALFQJ( 119) /  7.69875778896082810694415095118D-03 /
      DATA  ALFQJ( 120) /  7.12483332325489784996115379522D-03 /
      DATA  ALFQJ( 121) /  6.54590843862298928430832774978D-03 /
      DATA  ALFQJ( 122) /  5.96388034730799521185379257526D-03 /
      DATA  ALFQJ( 123) /  5.37724746840184621439120082915D-03 /
      DATA  ALFQJ( 124) /  4.78862143341336762639286342422D-03 /
      DATA  ALFQJ( 125) /  4.19553798718534675050584434299D-03 /
      DATA  ALFQJ( 126) /  3.60197835812614147238175742601D-03 /
      DATA  ALFQJ( 127) /  3.00345869904497127939883254566D-03 /
      DATA  ALFQJ( 128) /  2.40715327877140914736457978817D-03 /
      DATA  ALFQJ( 129) /  1.80308126695362359559014504087D-03 /
      DATA  ALFQJ( 130) /  1.20930061875273990882038029438D-03 /
      DATA  ALFQJ( 131) /  5.88072153828697544458554905444D-04 /
      DATA  ALFQJ( 132) /  6.10388817676860159921870440384D-05 /
      DATA  ALFQJ( 133) /  6.13592361718964473177896006113D-03 /
      DATA  ALFQJ( 134) /  1.22709213241938073979543720158D-02 /
      DATA  ALFQJ( 135) /  1.22681511842708723864423778983D-02 /
      DATA  ALFQJ( 136) /  1.22635297783434225372679163611D-02 /
      DATA  ALFQJ( 137) /  1.22570652603110471952403084940D-02 /
      DATA  ALFQJ( 138) /  1.22487511390273881503023789349D-02 /
      DATA  ALFQJ( 139) /  1.22385961402550421427190859338D-02 /
      DATA  ALFQJ( 140) /  1.22265943083331658685049588255D-02 /
      DATA  ALFQJ( 141) /  1.22127549492255463966510678536D-02 /
      DATA  ALFQJ( 142) /  1.21970726326885400700342655700D-02 /
      DATA  ALFQJ( 143) /  1.21795572530115017550422997995D-02 /
      DATA  ALFQJ( 144) /  1.21602038948220478655306907858D-02 /
      DATA  ALFQJ( 145) /  1.21390230486920665351899917172D-02 /
      DATA  ALFQJ( 146) /  1.21160103030510821937516247550D-02 /
      DATA  ALFQJ( 147) /  1.20911767525914031530482503076D-02 /
      DATA  ALFQJ( 148) /  1.20645184779041161244726121146D-02 /
      DATA  ALFQJ( 149) /  1.20360471855715499628832919057D-02 /
      DATA  ALFQJ( 150) /  1.20057594360851009859586629143D-02 /
      DATA  ALFQJ( 151) /  1.19736675556722427453946487134D-02 /
      DATA  ALFQJ( 152) /  1.19397685717896904455053135549D-02 /
      DATA  ALFQJ( 153) /  1.19040754381081508901165198798D-02 /
      DATA  ALFQJ( 154) /  1.18665856353845361657133366787D-02 /
      DATA  ALFQJ( 155) /  1.18273127526355869001582265675D-02 /
      DATA  ALFQJ( 156) /  1.17862547094624871232439298576D-02 /
      DATA  ALFQJ( 157) /  1.17434257383023344525313040507D-02 /
      DATA  ALFQJ( 158) /  1.16988241822881030911792615533D-02 /
      DATA  ALFQJ( 159) /  1.16524649255958189902413881851D-02 /
      DATA  ALFQJ( 160) /  1.16043467186494621221227887759D-02 /
      DATA  ALFQJ( 161) /  1.15544851060064148382546873320D-02 /
      DATA  ALFQJ( 162) /  1.15028792281338010858224057648D-02 /
      DATA  ALFQJ( 163) /  1.14495452990242432850392246866D-02 /
      DATA  ALFQJ( 164) /  1.13944828308460763546902940914D-02 /
      DATA  ALFQJ( 165) /  1.13377087165893661468694086637D-02 /
      DATA  ALFQJ( 166) /  1.12792228205910675129081014208D-02 /
      DATA  ALFQJ( 167) /  1.12190427250168182651255540503D-02 /
      DATA  ALFQJ( 168) /  1.11571686255411693793727654935D-02 /
      DATA  ALFQJ( 169) /  1.10936188044194494585323981848D-02 /
      DATA  ALFQJ( 170) /  1.10283937664135255305406472382D-02 /
      DATA  ALFQJ( 171) /  1.09615125056530610062278702727D-02 /
      DATA  ALFQJ( 172) /  1.08929758121816486809825026852D-02 /
      DATA  ALFQJ( 173) /  1.08228034048098231967186206263D-02 /
      DATA  ALFQJ( 174) /  1.07509963333481484492664397210D-02 /
      DATA  ALFQJ( 175) /  1.06775750552874483669097419339D-02 /
      DATA  ALFQJ( 176) /  1.06025408528066438294821505885D-02 /
      DATA  ALFQJ( 177) /  1.05259149374630678306767431873D-02 /
      DATA  ALFQJ( 178) /  1.04476987943223745986785934531D-02 /
      DATA  ALFQJ( 179) /  1.03679144060022209852088979486D-02 /
      DATA  ALFQJ( 180) /  1.02865634286624412366025510011D-02 /
      DATA  ALFQJ( 181) /  1.02036686348348107376303771807D-02 /
      DATA  ALFQJ( 182) /  1.01192318174079947984864905108D-02 /
      DATA  ALFQJ( 183) /  1.00332765598313115637363201438D-02 /
      DATA  ALFQJ( 184) /  9.94580475448206432544928132694D-03 /
      DATA  ALFQJ( 185) /  9.85684081921393574182349342280D-03 /
      DATA  ALFQJ( 186) /  9.76638670542804712463794380772D-03 /
      DATA  ALFQJ( 187) /  9.67446769173887087921921876937D-03 /
      DATA  ALFQJ( 188) /  9.58108574447519332865952019151D-03 /
      DATA  ALFQJ( 189) /  9.48626703268709977547668138652D-03 /
      DATA  ALFQJ( 190) /  9.39001348942868645317916239211D-03 /
      DATA  ALFQJ( 191) /  9.29235220770270494825061254421D-03 /
      DATA  ALFQJ( 192) /  9.19328503442315097189013829806D-03 /
      DATA  ALFQJ( 193) /  9.09284002451894916631904314641D-03 /
      DATA  ALFQJ( 194) /  8.99101888057959938142398330879D-03 /
      DATA  ALFQJ( 195) /  8.88785066261381639127308136065D-03 /
      DATA  ALFQJ( 196) /  8.78333686460695574756796997355D-03 /
      DATA  ALFQJ( 197) /  8.67750760083810363472727229053D-03 /
      DATA  ALFQJ( 198) /  8.57036408539034802437993715757D-03 /
      DATA  ALFQJ( 199) /  8.46193754306058625432627374975D-03 /
      DATA  ALFQJ( 200) /  8.35222882860933065126889117099D-03 /
      DATA  ALFQJ( 201) /  8.24127034187625554305909245308D-03 /
      DATA  ALFQJ( 202) /  8.12906248943005855139505415508D-03 /
      DATA  ALFQJ( 203) /  8.01563892042517457137131201085D-03 /
      DATA  ALFQJ( 204) /  7.90099949331615044761003328379D-03 /
      DATA  ALFQJ( 205) /  7.78517919237115442475986783301D-03 /
      DATA  ALFQJ( 206) /  7.66817721500350575290875185838D-03 /
      DATA  ALFQJ( 207) /  7.55002998009127417719696302646D-03 /
      DATA  ALFQJ( 208) /  7.43073589568460597392484240923D-03 /
      DATA  ALFQJ( 209) /  7.31033293112933667296995296286D-03 /
      DATA  ALFQJ( 210) /  7.18881855844773660780138524279D-03 /
      DATA  ALFQJ( 211) /  7.06623243296879160913035949868D-03 /
      DATA  ALFQJ( 212) /  6.94257092201595646253529204329D-03 /
      DATA  ALFQJ( 213) /  6.81787552618365368869408834179D-03 /
      DATA  ALFQJ( 214) /  6.69214131282928683691546328128D-03 /
      DATA  ALFQJ( 215) /  6.56541181602978219565501987747D-03 /
      DATA  ALFQJ( 216) /  6.43768057551113636807835870278D-03 /
      DATA  ALFQJ( 217) /  6.30899338254401370090108651102D-03 /
      DATA  ALFQJ( 218) /  6.17934198175585931150715224064D-03 /
      DATA  ALFQJ( 219) /  6.04877468922575560917461000990D-03 /
      DATA  ALFQJ( 220) /  5.91728113766767263962628852517D-03 /
      DATA  ALFQJ( 221) /  5.78491249038589018627104260621D-03 /
      DATA  ALFQJ( 222) /  5.65165588957047700637748379070D-03 /
      DATA  ALFQJ( 223) /  5.51756573726307470480230675798D-03 /
      DATA  ALFQJ( 224) /  5.38262622829102142428119021872D-03 /
      DATA  ALFQJ( 225) /  5.24689548303089542936215866440D-03 /
      DATA  ALFQJ( 226) /  5.11035419189020942875444472285D-03 /
      DATA  ALFQJ( 227) /  4.97306478685625395256646989922D-03 /
      DATA  ALFQJ( 228) /  4.83500376677199114213311154240D-03 /
      DATA  ALFQJ( 229) /  4.69623861722940691292125260899D-03 /
      DATA  ALFQJ( 230) /  4.55674078702335155739826696987D-03 /
      DATA  ALFQJ( 231) /  4.41658375488667576981565087025D-03 /
      DATA  ALFQJ( 232) /  4.27573283170858600391165973824D-03 /
      DATA  ALFQJ( 233) /  4.13426869582077584192298953642D-03 /
      DATA  ALFQJ( 234) /  3.99214911961078728318078405510D-03 /
      DATA  ALFQJ( 235) /  3.84946355518490975879564908081D-03 /
      DATA  ALFQJ( 236) /  3.70616040049264393911083019499D-03 /
      DATA  ALFQJ( 237) /  3.56233997347505808718477724805D-03 /
      DATA  ALFQJ( 238) /  3.41793884114908965385939222216D-03 /
      DATA  ALFQJ( 239) /  3.27307102749640179785957297785D-03 /
      DATA  ALFQJ( 240) /  3.12765790293549498023677476502D-03 /
      DATA  ALFQJ( 241) /  2.98183115090367421874405783280D-03 /
      DATA  ALFQJ( 242) /  2.83549220412886478090098047493D-03 /
      DATA  ALFQJ( 243) /  2.68879607402742586450810075795D-03 /
      DATA  ALFQJ( 244) /  2.54161735307662263948435963469D-03 /
      DATA  ALFQJ( 245) /  2.39414280403931246744310752690D-03 /
      DATA  ALFQJ( 246) /  2.24620972036610004803571795298D-03 /
      DATA  ALFQJ( 247) /  2.09804969482008800046410497020D-03 /
      DATA  ALFQJ( 248) /  1.94944607190546714594236012730D-03 /
      DATA  ALFQJ( 249) /  1.80069673385486406916650585772D-03 /
      DATA  ALFQJ( 250) /  1.65150284956579013457977083575D-03 /
      DATA  ALFQJ( 251) /  1.50226641642124470238341899636D-03 /
      DATA  ALFQJ( 252) /  1.35255443179264085994664635082D-03 /
      DATA  ALFQJ( 253) /  1.20294646714375787656773147856D-03 /
      DATA  ALFQJ( 254) /  1.05276786505253903339394461320D-03 /
      DATA  ALFQJ( 255) /  9.02939741087453963180228538297D-04 /
      DATA  ALFQJ( 256) /  7.52281785192075261928655452238D-04 /
      DATA  ALFQJ( 257) /  6.02512672975876653416819120146D-04 /
      DATA  ALFQJ( 258) /  4.51077372229244745573669909813D-04 /
      DATA  ALFQJ( 259) /  3.02414838661812207289412081700D-04 /
      DATA  ALFQJ( 260) /  1.47030506832164582715135039357D-04 /
      DATA  ALFQJ( 261) /  1.52590218966964217593652459881D-05 /
      DATA  ALFQJ( 262) /  3.06796160487489088469284661263D-03 /
      DATA  ALFQJ( 263) /  6.13580758631384774307331535235D-03 /
      DATA  ALFQJ( 264) /  6.13546118603008656351109175160D-03 /
      DATA  ALFQJ( 265) /  6.13488355623432140401697485161D-03 /
      DATA  ALFQJ( 266) /  6.13407518445008555969911360861D-03 /
      DATA  ALFQJ( 267) /  6.13303563523077607662172848718D-03 /
      DATA  ALFQJ( 268) /  6.13176541373655427382748296527D-03 /
      DATA  ALFQJ( 269) /  6.13026410159327009743265081401D-03 /
      DATA  ALFQJ( 270) /  6.12853222173252572528695070922D-03 /
      DATA  ALFQJ( 271) /  6.12656937270450321474791899551D-03 /
      DATA  ALFQJ( 272) /  6.12437609534490669955764440302D-03 /
      DATA  ALFQJ( 273) /  6.12195200497696011629276095762D-03 /
      DATA  ALFQJ( 274) /  6.11929766047115156133244291922D-03 /
      DATA  ALFQJ( 275) /  6.11641269376911652384959689114D-03 /
      DATA  ALFQJ( 276) /  6.11329768190500466171465849137D-03 /
      DATA  ALFQJ( 277) /  6.10995227328072047289615812278D-03 /
      DATA  ALFQJ( 278) /  6.10637706322132553546951122697D-03 /
      DATA  ALFQJ( 279) /  6.10257171642716454624050022234D-03 /
      DATA  ALFQJ( 280) /  6.09853684664001423463082167142D-03 /
      DATA  ALFQJ( 281) /  6.09427213469296797919570018818D-03 /
      DATA  ALFQJ( 282) /  6.08977821286905729248343456083D-03 /
      DATA  ALFQJ( 283) /  6.08505477796439069953160118073D-03 /
      DATA  ALFQJ( 284) /  6.08010248092671795658601319999D-03 /
      DATA  ALFQJ( 285) /  6.07492103434120450780053329494D-03 /
      DATA  ALFQJ( 286) /  6.06951110794289747059647390314D-03 /
      DATA  ALFQJ( 287) /  6.06387242992764974218316787159D-03 /
      DATA  ALFQJ( 288) /  6.05800568893969732174259369282D-03 /
      DATA  ALFQJ( 289) /  6.05191062860260890626466031780D-03 /
      DATA  ALFQJ( 290) /  6.04558795659121550337311040450D-03 /
      DATA  ALFQJ( 291) /  6.03903743176903186765558681765D-03 /
      DATA  ALFQJ( 292) /  6.03225978096261296966068454543D-03 /
      DATA  ALFQJ( 293) /  6.02525477808265035964299385745D-03 /
      DATA  ALFQJ( 294) /  6.01802316922848958173910015914D-03 /
      DATA  ALFQJ( 295) /  6.01056474316002263662083525930D-03 /
      DATA  ALFQJ( 296) /  6.00288026537061196087579243631D-03 /
      DATA  ALFQJ( 297) /  5.99496953926595224643345734173D-03 /
      DATA  ALFQJ( 298) /  5.98683334985503877424110261084D-03 /
      DATA  ALFQJ( 299) /  5.97847151498032798849854214830D-03 /
      DATA  ALFQJ( 300) /  5.96988483928869208197273729284D-03 /
      DATA  ALFQJ( 301) /  5.96107315484443522518564223977D-03 /
      DATA  ALFQJ( 302) /  5.95203728605542647008428402683D-03 /
      DATA  ALFQJ( 303) /  5.94277707898679180494245432671D-03 /
      DATA  ALFQJ( 304) /  5.93329337793165078186833031267D-03 /
      DATA  ALFQJ( 305) /  5.92358604272856493861332634302D-03 /
      DATA  ALFQJ( 306) /  5.91365593768156034033738220476D-03 /
      DATA  ALFQJ( 307) /  5.90350293616862844481395986754D-03 /
      DATA  ALFQJ( 308) /  5.89312792263204062547075098772D-03 /
      DATA  ALFQJ( 309) /  5.88253078374832284564439549484D-03 /
      DATA  ALFQJ( 310) /  5.87171242422730643213611477464D-03 /
      DATA  ALFQJ( 311) /  5.86067274379598384997144359156D-03 /
      DATA  ALFQJ( 312) /  5.84941266756334358707582435414D-03 /
      DATA  ALFQJ( 313) /  5.83793210805130780752478106801D-03 /
      DATA  ALFQJ( 314) /  5.82623201090222334583763617012D-03 /
      DATA  ALFQJ( 315) /  5.81431230116962575266173427424D-03 /
      DATA  ALFQJ( 316) /  5.80217394516636262253717984601D-03 /
      DATA  ALFQJ( 317) /  5.78981688020616068139875812999D-03 /
      DATA  ALFQJ( 318) /  5.77724209341280622641737327378D-03 /
      DATA  ALFQJ( 319) /  5.76444953408034571871789621875D-03 /
      DATA  ALFQJ( 320) /  5.75144021028761028887315727758D-03 /
      DATA  ALFQJ( 321) /  5.73821408302028383476974140321D-03 /
      DATA  ALFQJ( 322) /  5.72477218146040906249621824371D-03 /
      DATA  ALFQJ( 323) /  5.71111447798743275794678646576D-03 /
      DATA  ALFQJ( 324) /  5.69724202303925025932482588276D-03 /
      DATA  ALFQJ( 325) /  5.68315480008160170942912912587D-03 /
      DATA  ALFQJ( 326) /  5.66885388096578706842295320504D-03 /
      DATA  ALFQJ( 327) /  5.65433925992634954724511030427D-03 /
      DATA  ALFQJ( 328) /  5.63961203039091795272855864304D-03 /
      DATA  ALFQJ( 329) /  5.62467219703487685767955892003D-03 /
      DATA  ALFQJ( 330) /  5.60952087503096827137537208516D-03 /
      DATA  ALFQJ( 331) /  5.59415807915650746753874263392D-03 /
      DATA  ALFQJ( 332) /  5.57858494650451070598214448081D-03 /
      DATA  ALFQJ( 333) /  5.56280150160385777188041138778D-03 /
      DATA  ALFQJ( 334) /  5.54680890364992438729922293993D-03 /
      DATA  ALFQJ( 335) /  5.53060718656079517787539650810D-03 /
      DATA  ALFQJ( 336) /  5.51419753182379552169078819681D-03 /
      DATA  ALFQJ( 337) /  5.49757998237128985601908279695D-03 /
      DATA  ALFQJ( 338) /  5.48075574218026520480408468845D-03 /
      DATA  ALFQJ( 339) /  5.46372486280926686449036008275D-03 /
      DATA  ALFQJ( 340) /  5.44648857093143298203265305733D-03 /
      DATA  ALFQJ( 341) /  5.42904692632956857059423358029D-03 /
      DATA  ALFQJ( 342) /  5.41140117858892757162397477260D-03 /
      DATA  ALFQJ( 343) /  5.39355139530014013445161370846D-03 /
      DATA  ALFQJ( 344) /  5.37549884918675900612569660817D-03 /
      DATA  ALFQJ( 345) /  5.35724361521555364394237551996D-03 /
      DATA  ALFQJ( 346) /  5.33878698948556927092980755218D-03 /
      DATA  ALFQJ( 347) /  5.32012905389198929588823042206D-03 /
      DATA  ALFQJ( 348) /  5.30127112815840132459130795595D-03 /
      DATA  ALFQJ( 349) /  5.28221330064379480609821750045D-03 /
      DATA  ALFQJ( 350) /  5.26295691495810917400811142515D-03 /
      DATA  ALFQJ( 351) /  5.24350206544174699970381436518D-03 /
      DATA  ALFQJ( 352) /  5.22385011986653444810508951601D-03 /
      DATA  ALFQJ( 353) /  5.20400117805314228268780650341D-03 /
      DATA  ALFQJ( 354) /  5.18395663222557766603362923399D-03 /
      DATA  ALFQJ( 355) /  5.16371658716384542515754347690D-03 /
      DATA  ALFQJ( 356) /  5.14328245985029512976030686267D-03 /
      DATA  ALFQJ( 357) /  5.12265435948242879621504468852D-03 /
      DATA  ALFQJ( 358) /  5.10183372812415508597300956158D-03 /
      DATA  ALFQJ( 359) /  5.08082067882653687870705932605D-03 /
      DATA  ALFQJ( 360) /  5.05961667907658949819845185790D-03 /
      DATA  ALFQJ( 361) /  5.03822184519161355915604838077D-03 /
      DATA  ALFQJ( 362) /  5.01663767044298044664246621556D-03 /
      DATA  ALFQJ( 363) /  4.99486427380213233321852200863D-03 /
      DATA  ALFQJ( 364) /  4.97290317470722283030053385958D-03 /
      DATA  ALFQJ( 365) /  4.95075449414547218950903400279D-03 /
      DATA  ALFQJ( 366) /  4.92841977812700768313750104372D-03 /
      DATA  ALFQJ( 367) /  4.90589914898858453395940882935D-03 /
      DATA  ALFQJ( 368) /  4.88319417974197303343365801978D-03 /
      DATA  ALFQJ( 369) /  4.86030499337759909241562895821D-03 /
      DATA  ALFQJ( 370) /  4.83723319036487183261094196748D-03 /
      DATA  ALFQJ( 371) /  4.81397889362051928023458068496D-03 /
      DATA  ALFQJ( 372) /  4.79054373155590905690648249228D-03 /
      DATA  ALFQJ( 373) /  4.76692782625316005351086638880D-03 /
      DATA  ALFQJ( 374) /  4.74313283458040264212446424960D-03 /
      DATA  ALFQJ( 375) /  4.71915887698848375646883035099D-03 /
      DATA  ALFQJ( 376) /  4.69500763934992544840921814105D-03 /
      DATA  ALFQJ( 377) /  4.67067923964949195266252667361D-03 /
      DATA  ALFQJ( 378) /  4.64617539334708796865637399450D-03 /
      DATA  ALFQJ( 379) /  4.62149621508583367302686029617D-03 /
      DATA  ALFQJ( 380) /  4.59664345053412399101833255975D-03 /
      DATA  ALFQJ( 381) /  4.57161721007429293051636827113D-03 /
      DATA  ALFQJ( 382) /  4.54641927024544390327511805340D-03 /
      DATA  ALFQJ( 383) /  4.52104973620332073794524090797D-03 /
      DATA  ALFQJ( 384) /  4.49551041606432278506821522357D-03 /
      DATA  ALFQJ( 385) /  4.46980140874177922146367248534D-03 /
      DATA  ALFQJ( 386) /  4.44392455468389287372054117008D-03 /
      DATA  ALFQJ( 387) /  4.41787994549206774547442853816D-03 /
      DATA  ALFQJ( 388) /  4.39166945475261241135812078939D-03 /
      DATA  ALFQJ( 389) /  4.36529316562780325412237494393D-03 /
      DATA  ALFQJ( 390) /  4.33875298570438528629303237280D-03 /
      DATA  ALFQJ( 391) /  4.31204898851622928796123530273D-03 /
      DATA  ALFQJ( 392) /  4.28518311657350827136864252333D-03 /
      DATA  ALFQJ( 393) /  4.25815543252553034991949366959D-03 /
      DATA  ALFQJ( 394) /  4.23096791479462503776850593905D-03 /
      DATA  ALFQJ( 395) /  4.20362061381723046981523736890D-03 /
      DATA  ALFQJ( 396) /  4.17611554498786848659355907955D-03 /
      DATA  ALFQJ( 397) /  4.14845274512385694855827943419D-03 /
      DATA  ALFQJ( 398) /  4.12063426772937529472763056134D-03 /
      DATA  ALFQJ( 399) /  4.09266013451205234847197620811D-03 /
      DATA  ALFQJ( 400) /  4.06453243830735891911578968727D-03 /
      DATA  ALFQJ( 401) /  4.03625118413131983089194896807D-03 /
      DATA  ALFQJ( 402) /  4.00781850546392964824573189079D-03 /
      DATA  ALFQJ( 403) /  3.97923438894858892161781874551D-03 /
      DATA  ALFQJ( 404) /  3.95050101012285263587535639094D-03 /
      DATA  ALFQJ( 405) /  3.92161833546879070323103024573D-03 /
      DATA  ALFQJ( 406) /  3.89258858410343720546901177087D-03 /
      DATA  ALFQJ( 407) /  3.86341170044163328390857719626D-03 /
      DATA  ALFQJ( 408) /  3.83408994882075308127264985615D-03 /
      DATA  ALFQJ( 409) /  3.80462324955477016687783449226D-03 /
      DATA  ALFQJ( 410) /  3.77501391397237159197477823373D-03 /
      DATA  ALFQJ( 411) /  3.74526183611355583299320327998D-03 /
      DATA  ALFQJ( 412) /  3.71536937621183231598381298815D-03 /
      DATA  ALFQJ( 413) /  3.68533639970758443874487819407D-03 /
      DATA  ALFQJ( 414) /  3.65516531780903810654694533535D-03 /
      DATA  ALFQJ( 415) /  3.62485596486420900818683565010D-03 /
      DATA  ALFQJ( 416) /  3.59441080529778396645871627918D-03 /
      DATA  ALFQJ( 417) /  3.56382963968923984109341443137D-03 /
      DATA  ALFQJ( 418) /  3.53311498811062785618261054808D-03 /
      DATA  ALFQJ( 419) /  3.50226661449502204792176369174D-03 /
      DATA  ALFQJ( 420) /  3.47128709720131424113678601570D-03 /
      DATA  ALFQJ( 421) /  3.44017616041609312595474062661D-03 /
      DATA  ALFQJ( 422) /  3.40893644365496404544031622939D-03 /
      DATA  ALFQJ( 423) /  3.37756762801262227411222132609D-03 /
      DATA  ALFQJ( 424) /  3.34607241728624772061195405804D-03 /
      DATA  ALFQJ( 425) /  3.31445044586183366077653388526D-03 /
      DATA  ALFQJ( 426) /  3.28270448522576140921893271000D-03 /
      DATA  ALFQJ( 427) /  3.25083411913761605194792239628D-03 /
      DATA  ALFQJ( 428) /  3.21884219049482974967433543953D-03 /
      DATA  ALFQJ( 429) /  3.18672822817852100287605305001D-03 /
      DATA  ALFQJ( 430) /  3.15449515056896281148563344049D-03 /
      DATA  ALFQJ( 431) /  3.12214242704435112141221763136D-03 /
      DATA  ALFQJ( 432) /  3.08967305593019907573678088766D-03 /
      DATA  ALFQJ( 433) /  3.05708644206153860547511812368D-03 /
      DATA  ALFQJ( 434) /  3.02438566860857141945647523119D-03 /
      DATA  ALFQJ( 435) /  2.99157007035751218494121780629D-03 /
      DATA  ALFQJ( 436) /  2.95864282071293890113133759830D-03 /
      DATA  ALFQJ( 437) /  2.92560317838424755823773793087D-03 /
      DATA  ALFQJ( 438) /  2.89245441295143400789404612574D-03 /
      DATA  ALFQJ( 439) /  2.85919570043119214231103181178D-03 /
      DATA  ALFQJ( 440) /  2.82583041314178321443027364330D-03 /
      DATA  ALFQJ( 441) /  2.79235763712774910479759411755D-03 /
      DATA  ALFQJ( 442) /  2.75878085471176861742758792117D-03 /
      DATA  ALFQJ( 443) /  2.72509905393549776029229047231D-03 /
      DATA  ALFQJ( 444) /  2.69131583519011057619472705417D-03 /
      DATA  ALFQJ( 445) /  2.65743007963031687711970877254D-03 /
      DATA  ALFQJ( 446) /  2.62344551468806641719946966901D-03 /
      DATA  ALFQJ( 447) /  2.58936090477456343629057090366D-03 /
      DATA  ALFQJ( 448) /  2.55518011437205930067068876771D-03 /
      DATA  ALFQJ( 449) /  2.52090178017944080063269295047D-03 /
      DATA  ALFQJ( 450) /  2.48652991492767559487236917513D-03 /
      DATA  ALFQJ( 451) /  2.45206301535766557699277221793D-03 /
      DATA  ALFQJ( 452) /  2.41750525501540032884454066572D-03 /
      DATA  ALFQJ( 453) /  2.38285497696650960952592593979D-03 /
      DATA  ALFQJ( 454) /  2.34811652971850094122727342093D-03 /
      DATA  ALFQJ( 455) /  2.31328808724124964627835708019D-03 /
      DATA  ALFQJ( 456) /  2.27837418898352301469347413408D-03 /
      DATA  ALFQJ( 457) /  2.24337282241899824357737872228D-03 /
      DATA  ALFQJ( 458) /  2.20828873605393276732862125433D-03 /
      DATA  ALFQJ( 459) /  2.17311971115280971829271238459D-03 /
      DATA  ALFQJ( 460) /  2.13787072589753655863693591415D-03 /
      DATA  ALFQJ( 461) /  2.10253933291584629754590016663D-03 /
      DATA  ALFQJ( 462) /  2.06713076362843731061325098537D-03 /
      DATA  ALFQJ( 463) /  2.03164231639524031649078177118D-03 /
      DATA  ALFQJ( 464) /  1.99607950292446569907198930681D-03 /
      DATA  ALFQJ( 465) /  1.96043933787508124574471403705D-03 /
      DATA  ALFQJ( 466) /  1.92472764444127103429214534777D-03 /
      DATA  ALFQJ( 467) /  1.88894111960766616178430089264D-03 /
      DATA  ALFQJ( 468) /  1.85308593422460387371656367344D-03 /
      DATA  ALFQJ( 469) /  1.81715842817174105493434553438D-03 /
      DATA  ALFQJ( 470) /  1.78116516212281629335857909628D-03 /
      DATA  ALFQJ( 471) /  1.74510207281587042034463788698D-03 /
      DATA  ALFQJ( 472) /  1.70897616020231790243602802219D-03 /
      DATA  ALFQJ( 473) /  1.67278290378421487886260034960D-03 /
      DATA  ALFQJ( 474) /  1.63652980116976738311763023406D-03 /
      DATA  ALFQJ( 475) /  1.60021181062073145704840840179D-03 /
      DATA  ALFQJ( 476) /  1.56383699680632668142199037317D-03 /
      DATA  ALFQJ( 477) /  1.52739972044591553604959740599D-03 /
      DATA  ALFQJ( 478) /  1.49090869642164192106352383243D-03 /
      DATA  ALFQJ( 479) /  1.45435759619731409715948179821D-03 /
      DATA  ALFQJ( 480) /  1.41775588533880881946593139171D-03 /
      DATA  ALFQJ( 481) /  1.38109643482055266819648168061D-03 /
      DATA  ALFQJ( 482) /  1.34438958342721647004024269786D-03 /
      DATA  ALFQJ( 483) /  1.30762726539050545764975488862D-03 /
      DATA  ALFQJ( 484) /  1.27082084370919506808529357021D-03 /
      DATA  ALFQJ( 485) /  1.23396114713070611027060496335D-03 /
      DATA  ALFQJ( 486) /  1.19706075108121382101740609626D-03 /
      DATA  ALFQJ( 487) /  1.16010916727992815727204126002D-03 /
      DATA  ALFQJ( 488) /  1.12312042121534276394022258266D-03 /
      DATA  ALFQJ( 489) /  1.08608243872210867652744207754D-03 /
      DATA  ALFQJ( 490) /  1.04901099975000236730471313273D-03 /
      DATA  ALFQJ( 491) /  1.01189209723805581828578204509D-03 /
      DATA  ALFQJ( 492) /  9.74743661956659058027496465143D-04 /
      DATA  ALFQJ( 493) /  9.37549298132018430656502046587D-04 /
      DATA  ALFQJ( 494) /  9.00329613213539530148903204709D-04 /
      DATA  ALFQJ( 495) /  8.63065211786161184992669306771D-04 /
      DATA  ALFQJ( 496) /  8.25780090897661241458056363561D-04 /
      DATA  ALFQJ( 497) /  7.88451017298644958033740128129D-04 /
      DATA  ALFQJ( 498) /  7.51106368877294215271806978495D-04 /
      DATA  ALFQJ( 499) /  7.13717892529342523724747026799D-04 /
      DATA  ALFQJ( 500) /  6.76319767017362791490652947063D-04 /
      DATA  ALFQJ( 501) /  6.38876997026417579702757877127D-04 /
      DATA  ALFQJ( 502) /  6.01431670945399971736510148555D-04 /
      DATA  ALFQJ( 503) /  5.63939439876611882322972033693D-04 /
      DATA  ALFQJ( 504) /  5.26453574403052399475469475409D-04 /
      DATA  ALFQJ( 505) /  4.88916212936631283471238716007D-04 /
      DATA  ALFQJ( 506) /  4.51397175997849943104299990850D-04 /
      DATA  ALFQJ( 507) /  4.13818036093362206792200372187D-04 /
      DATA  ALFQJ( 508) /  3.76274622903893498806221643824D-04 /
      DATA  ALFQJ( 509) /  3.38654947642520485380279353381D-04 /
      DATA  ALFQJ( 510) /  3.01099216507638394218726192286D-04 /
      DATA  ALFQJ( 511) /  2.63435012498239401965886983857D-04 /
      DATA  ALFQJ( 512) /  2.25887913001035078900872058708D-04 /
      DATA  ALFQJ( 513) /  1.88159078041982174118016937437D-04 /
      DATA  ALFQJ( 514) /  1.50673460920759583550637429215D-04 /
      DATA  ALFQJ( 515) /  1.12788538824360132673403086937D-04 /
      DATA  ALFQJ( 516) /  7.56093155848410262809258669024D-05 /
      DATA  ALFQJ( 517) /  3.67584059902680993475820744901D-05 /
      DATA  ALFQJ( 518) /  3.81471181759573972984213017682D-06 /
      DATA  ALFQJ( 519) /  1.53398078970462716386827621787D-03 /
      DATA  ALFQJ( 520) /  3.06794713372188778074021401754D-03 /
      DATA  ALFQJ( 521) /  3.06790382589973685016973309790D-03 /
      DATA  ALFQJ( 522) /  3.06783162724590296391001057372D-03 /
      DATA  ALFQJ( 523) /  3.06773056754557145480107672249D-03 /
      DATA  ALFQJ( 524) /  3.06760061864268677371810084923D-03 /
      DATA  ALFQJ( 525) /  3.06744181086983738921096489615D-03 /
      DATA  ALFQJ( 526) /  3.06725411660958236893632308177D-03 /
      DATA  ALFQJ( 527) /  3.06703756674406052106546813397D-03 /
      DATA  ALFQJ( 528) /  3.06679213419219517347375724778D-03 /
      DATA  ALFQJ( 529) /  3.06651785038780403145200808779D-03 /
      DATA  ALFQJ( 530) /  3.06621468878390171653787597742D-03 /
      DATA  ALFQJ( 531) /  3.06588268136809540712388786130D-03 /
      DATA  ALFQJ( 532) /  3.06552180212519478161465553952D-03 /
      DATA  ALFQJ( 533) /  3.06513208359868975322731935502D-03 /
      DATA  ALFQJ( 534) /  3.06471350030286488892217651321D-03 /
      DATA  ALFQJ( 535) /  3.06426608533916945424707870294D-03 /
      DATA  ALFQJ( 536) /  3.06378981374901814215413495475D-03 /
      DATA  ALFQJ( 537) /  3.06328471919388021706837921807D-03 /
      DATA  ALFQJ( 538) /  3.06275077723993047649041531446D-03 /
      DATA  ALFQJ( 539) /  3.06218802211070353621273393932D-03 /
      DATA  ALFQJ( 540) /  3.06159642989473835101121404613D-03 /
      DATA  ALFQJ( 541) /  3.06097603537966562746425505984D-03 /
      DATA  ALFQJ( 542) /  3.06032681517396593480891575116D-03 /
      DATA  ALFQJ( 543) /  3.05964880463138288225977344133D-03 /
      DATA  ALFQJ( 544) /  3.05894198087788884224777989479D-03 /
      DATA  ALFQJ( 545) /  3.05820637983534390137112638900D-03 /
      DATA  ALFQJ( 546) /  3.05744197914473447897526372233D-03 /
      DATA  ALFQJ( 547) /  3.05664881529802817256072425077D-03 /
      DATA  ALFQJ( 548) /  3.05582686644871906644025423240D-03 /
      DATA  ALFQJ( 549) /  3.05497616966086146304183467931D-03 /
      DATA  ALFQJ( 550) /  3.05409670359792141882237716501D-03 /
      DATA  ALFQJ( 551) /  3.05318850589800800372268611800D-03 /
      DATA  ALFQJ( 552) /  3.05225155573199355242266238102D-03 /
      DATA  ALFQJ( 553) /  3.05128589131399954835825788810D-03 /
      DATA  ALFQJ( 554) /  3.05029149231970821370894116847D-03 /
      DATA  ALFQJ( 555) /  3.04926839754120139687526196011D-03 /
      DATA  ALFQJ( 556) /  3.04821658715634341834920055071D-03 /
      DATA  ALFQJ( 557) /  3.04713610053711547827409996425D-03 /
      DATA  ALFQJ( 558) /  3.04602691836090409970249127884D-03 /
      DATA  ALFQJ( 559) /  3.04488908058152059464626726416D-03 /
      DATA  ALFQJ( 560) /  3.04372256837318097136964870906D-03 /
      DATA  ALFQJ( 561) /  3.04252742227344993397654315375D-03 /
      DATA  ALFQJ( 562) /  3.04130362395064671453480817831D-03 /
      DATA  ALFQJ( 563) /  3.04005121452800596552612174206D-03 /
      DATA  ALFQJ( 564) /  3.03877017616518960695324790546D-03 /
      DATA  ALFQJ( 565) /  3.03746055057301283771537134581D-03 /
      DATA  ALFQJ( 566) /  3.03612232039968471656124214174D-03 /
      DATA  ALFQJ( 567) /  3.03475552794550640454293084399D-03 /
      DATA  ALFQJ( 568) /  3.03336015634440278879912468889D-03 /
      DATA  ALFQJ( 569) /  3.03193624848806201269112927298D-03 /
      DATA  ALFQJ( 570) /  3.03048378799325696284941761623D-03 /
      DATA  ALFQJ( 571) /  3.02900281834496018757601996416D-03 /
      DATA  ALFQJ( 572) /  3.02749332363988745809744179410D-03 /
      DATA  ALFQJ( 573) /  3.02595534795819036270342291900D-03 /
      DATA  ALFQJ( 574) /  3.02438887587358437822206469625D-03 /
      DATA  ALFQJ( 575) /  3.02279395206329280279003929462D-03 /
      DATA  ALFQJ( 576) /  3.02117056157504878641892695285D-03 /
      DATA  ALFQJ( 577) /  3.01951874968503887720071041716D-03 /
      DATA  ALFQJ( 578) /  3.01783850191199221134739272591D-03 /
      DATA  ALFQJ( 579) /  3.01612986413294984633901150146D-03 /
      DATA  ALFQJ( 580) /  3.01439282233457474947536067882D-03 /
      DATA  ALFQJ( 581) /  3.01262742299665432970836826594D-03 /
      DATA  ALFQJ( 582) /  3.01083365257068193557272292270D-03 /
      DATA  ALFQJ( 583) /  3.00901155814108463043453420948D-03 /
      DATA  ALFQJ( 584) /  3.00716112662104055917443984092D-03 /
      DATA  ALFQJ( 585) /  3.00528240570151209710733898397D-03 /
      DATA  ALFQJ( 586) /  3.00337538275417361089768036464D-03 /
      DATA  ALFQJ( 587) /  3.00144010607842170985988587496D-03 /
      DATA  ALFQJ( 588) /  2.99947656350119454855403158487D-03 /
      DATA  ALFQJ( 589) /  2.99748480393222608365661094648D-03 /
      DATA  ALFQJ( 590) /  2.99546481565044107904718026944D-03 /
      DATA  ALFQJ( 591) /  2.99341664817781908780759026811D-03 /
      DATA  ALFQJ( 592) /  2.99134029024194865808848390058D-03 /
      DATA  ALFQJ( 593) /  2.98923579197896928676496745167D-03 /
      DATA  ALFQJ( 594) /  2.98710314256176391579725251613D-03 /
      DATA  ALFQJ( 595) /  2.98494239274255341328814440721D-03 /
      DATA  ALFQJ( 596) /  2.98275353213609822227912745633D-03 /
      DATA  ALFQJ( 597) /  2.98053661211263009108720701217D-03 /
      DATA  ALFQJ( 598) /  2.97829162272532161329444189530D-03 /
      DATA  ALFQJ( 599) /  2.97601861596435403006871781886D-03 /
      DATA  ALFQJ( 600) /  2.97371758231779730213865387765D-03 /
      DATA  ALFQJ( 601) /  2.97138857439773092331427387270D-03 /
      DATA  ALFQJ( 602) /  2.96903158312355700985862887579D-03 /
      DATA  ALFQJ( 603) /  2.96664666173121328091987337208D-03 /
      DATA  ALFQJ( 604) /  2.96423380156781735192148933008D-03 /
      DATA  ALFQJ( 605) /  2.96179305649513744181293481642D-03 /
      DATA  ALFQJ( 606) /  2.95932441828433752543671725056D-03 /
      DATA  ALFQJ( 607) /  2.95682794142500201064354135728D-03 /
      DATA  ALFQJ( 608) /  2.95430361810861854700696706130D-03 /
      DATA  ALFQJ( 609) /  2.95175150345458797281691653670D-03 /
      DATA  ALFQJ( 610) /  2.94917159007094429724839412161D-03 /
      DATA  ALFQJ( 611) /  2.94656393370892074669505110391D-03 /
      DATA  ALFQJ( 612) /  2.94392852738926463397700473759D-03 /
      DATA  ALFQJ( 613) /  2.94126542749707443794657014999D-03 /
      DATA  ALFQJ( 614) /  2.93857462746192084200336132239D-03 /
      DATA  ALFQJ( 615) /  2.93585618430481856696513178200D-03 /
      DATA  ALFQJ( 616) /  2.93311009186021369341370732710D-03 /
      DATA  ALFQJ( 617) /  2.93033640778710754620765979453D-03 /
      DATA  ALFQJ( 618) /  2.92753512632081439814098670336D-03 /
      DATA  ALFQJ( 619) /  2.92470630576041319022431047146D-03 /
      DATA  ALFQJ( 620) /  2.92184994073801873054409831483D-03 /
      DATA  ALFQJ( 621) /  2.91896609019490054706203542059D-03 /
      DATA  ALFQJ( 622) /  2.91605474915584462361782369759D-03 /
      DATA  ALFQJ( 623) /  2.91311597720644734562270625860D-03 /
      DATA  ALFQJ( 624) /  2.91014976975997352834897395216D-03 /
      DATA  ALFQJ( 625) /  2.90715618704850735944479153623D-03 /
      DATA  ALFQJ( 626) /  2.90413522486953584161619587492D-03 /
      DATA  ALFQJ( 627) /  2.90108694410381799325430047937D-03 /
      DATA  ALFQJ( 628) /  2.89801134092874071190133658173D-03 /
      DATA  ALFQJ( 629) /  2.89490847687595240449591134196D-03 /
      DATA  ALFQJ( 630) /  2.89177834849835053793906812911D-03 /
      DATA  ALFQJ( 631) /  2.88862101798071647790866432237D-03 /
      DATA  ALFQJ( 632) /  2.88543648224700048127839767162D-03 /
      DATA  ALFQJ( 633) /  2.88222480413739097705210045292D-03 /
      DATA  ALFQJ( 634) /  2.87898598094236331956451361466D-03 /
      DATA  ALFQJ( 635) /  2.87572007615981920251804953090D-03 /
      DATA  ALFQJ( 636) /  2.87242708744215997317192349139D-03 /
      DATA  ALFQJ( 637) /  2.86910707894734049238019336959D-03 /
      DATA  ALFQJ( 638) /  2.86576004868501604362980484709D-03 /
      DATA  ALFQJ( 639) /  2.86238606147556990623783734781D-03 /
      DATA  ALFQJ( 640) /  2.85898511568116470807769656194D-03 /
      DATA  ALFQJ( 641) /  2.85555727678702444000179582625D-03 /
      DATA  ALFQJ( 642) /  2.85210254350299631977388553710D-03 /
      DATA  ALFQJ( 643) /  2.84862098198159612434871847060D-03 /
      DATA  ALFQJ( 644) /  2.84511259127545507044987369225D-03 /
      DATA  ALFQJ( 645) /  2.84157743820687236553533840135D-03 /
      DATA  ALFQJ( 646) /  2.83801552216628307606192436929D-03 /
      DATA  ALFQJ( 647) /  2.83442691064830389301579345969D-03 /
      DATA  ALFQJ( 648) /  2.83081160337611225323466756782D-03 /
      DATA  ALFQJ( 649) /  2.82716966851922068404314343808D-03 /
      DATA  ALFQJ( 650) /  2.82350110612840435942187242559D-03 /
      DATA  ALFQJ( 651) /  2.81980598505069624116026411245D-03 /
      DATA  ALFQJ( 652) /  2.81608430565923957552555592021D-03 /
      DATA  ALFQJ( 653) /  2.81233613748126060419522921704D-03 /
      DATA  ALFQJ( 654) /  2.80856148120695401541637230919D-03 /
      DATA  ALFQJ( 655) /  2.80476040704646248407188062594D-03 /
      DATA  ALFQJ( 656) /  2.80093291600162655248550210157D-03 /
      DATA  ALFQJ( 657) /  2.79707907896828091142732204432D-03 /
      DATA  ALFQJ( 658) /  2.79319889725441535903081670482D-03 /
      DATA  ALFQJ( 659) /  2.78929244244438679869434027285D-03 /
      DATA  ALFQJ( 660) /  2.78535971614674455993771996783D-03 /
      DATA  ALFQJ( 661) /  2.78140079063725481995804901210D-03 /
      DATA  ALFQJ( 662) /  2.77741566781934140775754584775D-03 /
      DATA  ALFQJ( 663) /  2.77340442066312601853215233812D-03 /
      DATA  ALFQJ( 664) /  2.76936705136112439191350797546D-03 /
      DATA  ALFQJ( 665) /  2.76530363358082155782092822719D-03 /
      DATA  ALFQJ( 666) /  2.76121416979794270037573803733D-03 /
      DATA  ALFQJ( 667) /  2.75709873438040803663812735209D-03 /
      DATA  ALFQJ( 668) /  2.75295733008116745774270217410D-03 /
      DATA  ALFQJ( 669) /  2.74879003197171479574326007217D-03 /
      DATA  ALFQJ( 670) /  2.74459684307613516924603495071D-03 /
      DATA  ALFQJ( 671) /  2.74037783917270364792899710415D-03 /
      DATA  ALFQJ( 672) /  2.73613302355044380575936632375D-03 /
      DATA  ALFQJ( 673) /  2.73186247269769146955042953436D-03 /
      DATA  ALFQJ( 674) /  2.72756619016210197043882624349D-03 /
      DATA  ALFQJ( 675) /  2.72324425314542609692751520782D-03 /
      DATA  ALFQJ( 676) /  2.71889666544753159315338239289D-03 /
      DATA  ALFQJ( 677) /  2.71452350498701597657597542495D-03 /
      DATA  ALFQJ( 678) /  2.71012477580942460437678777991D-03 /
      DATA  ALFQJ( 679) /  2.70570055655371402372899351382D-03 /
      DATA  ALFQJ( 680) /  2.70125085150445404570947564088D-03 /
      DATA  ALFQJ( 681) /  2.69677574002455614910210125116D-03 /
      DATA  ALFQJ( 682) /  2.69227522663084007967802890958D-03 /
      DATA  ALFQJ( 683) /  2.68774939141385491932641719035D-03 /
      DATA  ALFQJ( 684) /  2.68319823911577136692166036672D-03 /
      DATA  ALFQJ( 685) /  2.67862185055854882193072055060D-03 /
      DATA  ALFQJ( 686) /  2.67402023070268228431925784140D-03 /
      DATA  ALFQJ( 687) /  2.66939346110540761119050415952D-03 /
      DATA  ALFQJ( 688) /  2.66474154693838646303676729250D-03 /
      DATA  ALFQJ( 689) /  2.66006457049809421658194970829D-03 /
      DATA  ALFQJ( 690) /  2.65536253716006713088279633251D-03 /
      DATA  ALFQJ( 691) /  2.65063552996408370098050900108D-03 /
      DATA  ALFQJ( 692) /  2.64588355448212474875011330099D-03 /
      DATA  ALFQJ( 693) /  2.64110669450143976112725758869D-03 /
      DATA  ALFQJ( 694) /  2.63630495578288243629198415133D-03 /
      DATA  ALFQJ( 695) /  2.63147842286544926825121498712D-03 /
      DATA  ALFQJ( 696) /  2.62662710169114968733482334416D-03 /
      DATA  ALFQJ( 697) /  2.62175107755511535208220238145D-03 /
      DATA  ALFQJ( 698) /  2.61685035657264488086222808636D-03 /
      DATA  ALFQJ( 699) /  2.61192502479950953681633928913D-03 /
      DATA  ALFQJ( 700) /  2.60697508851627709871991034514D-03 /
      DATA  ALFQJ( 701) /  2.60200063454398344290477120626D-03 /
      DATA  ALFQJ( 702) /  2.59700166932028776648613107676D-03 /
      DATA  ALFQJ( 703) /  2.59197828043624057382547813598D-03 /
      DATA  ALFQJ( 704) /  2.58693047447825263922776921623D-03 /
      DATA  ALFQJ( 705) /  2.58185833981226871226784766560D-03 /
      DATA  ALFQJ( 706) /  2.57676188316494465911791758452D-03 /
      DATA  ALFQJ( 707) /  2.57164119368213345540991581215D-03 /
      DATA  ALFQJ( 708) /  2.56649627822205821712668247565D-03 /
      DATA  ALFQJ( 709) /  2.56132722671563342419859544725D-03 /
      DATA  ALFQJ( 710) /  2.55613404614379535621246694862D-03 /
      DATA  ALFQJ( 711) /  2.55091682722781768675363838404D-03 /
      DATA  ALFQJ( 712) /  2.54567557706231445863623345538D-03 /
      DATA  ALFQJ( 713) /  2.54041038716436594120632731590D-03 /
      DATA  ALFQJ( 714) /  2.53512126473304196519586310320D-03 /
      DATA  ALFQJ( 715) /  2.52980830208683200845378340616D-03 /
      DATA  ALFQJ( 716) /  2.52447150651984767933155024272D-03 /
      DATA  ALFQJ( 717) /  2.51911097115775119045912173352D-03 /
      DATA  ALFQJ( 718) /  2.51372670338008421418598578639D-03 /
      DATA  ALFQJ( 719) /  2.50831879712561205485630900587D-03 /
      DATA  ALFQJ( 720) /  2.50288725984949114581468406217D-03 /
      DATA  ALFQJ( 721) /  2.49743218630969321172629670679D-03 /
      DATA  ALFQJ( 722) /  2.49195358402696444083198931027D-03 /
      DATA  ALFQJ( 723) /  2.48645154858476565349764077438D-03 /
      DATA  ALFQJ( 724) /  2.48092608755919173184685194268D-03 /
      DATA  ALFQJ( 725) /  2.47537729736566123399020065829D-03 /
      DATA  ALFQJ( 726) /  2.46980518562515401908918385838D-03 /
      DATA  ALFQJ( 727) /  2.46420984959170786766446277836D-03 /
      DATA  ALFQJ( 728) /  2.45859129692049438165227838798D-03 /
      DATA  ALFQJ( 729) /  2.45294962571103203516138494377D-03 /
      DATA  ALFQJ( 730) /  2.44728484364175428677920512461D-03 /
      DATA  ALFQJ( 731) /  2.44159704966472918621824032018D-03 /
      DATA  ALFQJ( 732) /  2.43588625147047809060105359250D-03 /
      DATA  ALFQJ( 733) /  2.43015254887090263602458571695D-03 /
      DATA  ALFQJ( 734) /  2.42439594955718632869219213675D-03 /
      DATA  ALFQJ( 735) /  2.41861655420857155603902554055D-03 /
      DATA  ALFQJ( 736) /  2.41281437050521839974211830113D-03 /
      DATA  ALFQJ( 737) /  2.40698950000144866522172874424D-03 /
      DATA  ALFQJ( 738) /  2.40114195035444525055479188082D-03 /
      DATA  ALFQJ( 739) /  2.39527182400158823254952344373D-03 /
      DATA  ALFQJ( 740) /  2.38937912856485267547434801402D-03 /
      DATA  ALFQJ( 741) /  2.38346396737290500656968768571D-03 /
      DATA  ALFQJ( 742) /  2.37752634799999584820056982176D-03 /
      DATA  ALFQJ( 743) /  2.37156637467456469261512360283D-03 /
      DATA  ALFQJ( 744) /  2.36558405491032570879824119841D-03 /
      DATA  ALFQJ( 745) /  2.35957949384424660314729791497D-03 /
      DATA  ALFQJ( 746) /  2.35355269891638783352128140009D-03 /
      DATA  ALFQJ( 747) /  2.34750377618127911151401036203D-03 /
      DATA  ALFQJ( 748) /  2.34143273299189441986516287566D-03 /
      DATA  ALFQJ( 749) /  2.33533967632964854420657318514D-03 /
      DATA  ALFQJ( 750) /  2.32922461344667002402930861493D-03 /
      DATA  ALFQJ( 751) /  2.32308765226088215147521371058D-03 /
      DATA  ALFQJ( 752) /  2.31692879990947169271472862114D-03 /
      DATA  ALFQJ( 753) /  2.31074816525680580091231766546D-03 /
      DATA  ALFQJ( 754) /  2.30454575531068413590085730172D-03 /
      DATA  ALFQJ( 755) /  2.29832167989217704334038747087D-03 /
      DATA  ALFQJ( 756) /  2.29207594586489059193916136631D-03 /
      DATA  ALFQJ( 757) /  2.28580866401719420504517739773D-03 /
      DATA  ALFQJ( 758) /  2.27951984105332004096936408756D-03 /
      DATA  ALFQJ( 759) /  2.27320958873988216507427209985D-03 /
      DATA  ALFQJ( 760) /  2.26687791360617142730683494143D-03 /
      DATA  ALFQJ( 761) /  2.26052492840835548097728915309D-03 /
      DATA  ALFQJ( 762) /  2.25415063948481555606657719782D-03 /
      DATA  ALFQJ( 763) /  2.24775516059295953099580941675D-03 /
      DATA  ALFQJ( 764) /  2.24133849786387533388005800310D-03 /
      DATA  ALFQJ( 765) /  2.23490076606829034531897849519D-03 /
      DATA  ALFQJ( 766) /  2.22844197111318502812560777051D-03 /
      DATA  ALFQJ( 767) /  2.22196222879509380360439392720D-03 /
      DATA  ALFQJ( 768) /  2.21546154477962922363100338274D-03 /
      DATA  ALFQJ( 769) /  2.20894003590204488052332062798D-03 /
      DATA  ALFQJ( 770) /  2.20239770756886216031787030958D-03 /
      DATA  ALFQJ( 771) /  2.19583467766740762562439612984D-03 /
      DATA  ALFQJ( 772) /  2.18925095132690813974141134331D-03 /
      DATA  ALFQJ( 773) /  2.18264664750057656832074275722D-03 /
      DATA  ALFQJ( 774) /  2.17602177102164369293540394661D-03 /
      DATA  ALFQJ( 775) /  2.16937644192350024329175323136D-03 /
      DATA  ALFQJ( 776) /  2.16271066472416220640110349290D-03 /
      DATA  ALFQJ( 777) /  2.15602456055198753605272956942D-03 /
      DATA  ALFQJ( 778) /  2.14931813359002170747933357744D-03 /
      DATA  ALFQJ( 779) /  2.14259150607689755288301692847D-03 /
      DATA  ALFQJ( 780) /  2.13584468184037651471731189673D-03 /
      DATA  ALFQJ( 781) /  2.12907778424521372371628423936D-03 /
      DATA  ALFQJ( 782) /  2.12229081674299346318531132132D-03 /
      DATA  ALFQJ( 783) /  2.11548390384100285098517923077D-03 /
      DATA  ALFQJ( 784) /  2.10865704859315341901273517139D-03 /
      DATA  ALFQJ( 785) /  2.10181037666625982177676275626D-03 /
      DATA  ALFQJ( 786) /  2.09494389069443880169821999082D-03 /
      DATA  ALFQJ( 787) /  2.08805771752163870499496296398D-03 /
      DATA  ALFQJ( 788) /  2.08115185933940783700357522955D-03 /
      DATA  ALFQJ( 789) /  2.07422644418707095954186347037D-03 /
      DATA  ALFQJ( 790) /  2.06728147379015626746631198943D-03 /
      DATA  ALFQJ( 791) /  2.06031707740227148382105628073D-03 /
      DATA  ALFQJ( 792) /  2.05333325625876725175976271738D-03 /
      DATA  ALFQJ( 793) /  2.04633014084713324113368267267D-03 /
      DATA  ALFQJ( 794) /  2.03930773188765018829288338200D-03 /
      DATA  ALFQJ( 795) /  2.03226616112201119978131750218D-03 /
      DATA  ALFQJ( 796) /  2.02520542872976920257326171416D-03 /
      DATA  ALFQJ( 797) /  2.01812566772789633090972258485D-03 /
      DATA  ALFQJ( 798) /  2.01102687772876204195609796505D-03 /
      DATA  ALFQJ( 799) /  2.00390919304648041132393914802D-03 /
      DATA  ALFQJ( 800) /  1.99677261269895012546840879263D-03 /
      DATA  ALFQJ( 801) /  1.98961727232011238267848631359D-03 /
      DATA  ALFQJ( 802) /  1.98244317030524050043081835001D-03 /
      DATA  ALFQJ( 803) /  1.97525044363164702259690758064D-03 /
      DATA  ALFQJ( 804) /  1.96803909004292046159838401670D-03 /
      DATA  ALFQJ( 805) /  1.96080924788418668740293802204D-03 /
      DATA  ALFQJ( 806) /  1.95356091421734559250624506025D-03 /
      DATA  ALFQJ( 807) /  1.94629422878071689025158738205D-03 /
      DATA  ALFQJ( 808) /  1.93900918792352199263470898737D-03 /
      DATA  ALFQJ( 809) /  1.93170593280363648253294937752D-03 /
      DATA  ALFQJ( 810) /  1.92438445902558345790086416186D-03 /
      DATA  ALFQJ( 811) /  1.91704490919418321048512880146D-03 /
      DATA  ALFQJ( 812) /  1.90968727813616438583901548164D-03 /
      DATA  ALFQJ( 813) /  1.90231170993175542299598019565D-03 /
      DATA  ALFQJ( 814) /  1.89491819859566918064918600848D-03 /
      DATA  ALFQJ( 815) /  1.88750688971313071059712036778D-03 /
      DATA  ALFQJ( 816) /  1.88007777645143893707052089073D-03 /
      DATA  ALFQJ( 817) /  1.87263100593158225965875922426D-03 /
      DATA  ALFQJ( 818) /  1.86516657043681618577347460834D-03 /
      DATA  ALFQJ( 819) /  1.85768461865589370978125074253D-03 /
      DATA  ALFQJ( 820) /  1.85018514195010848665984358587D-03 /
      DATA  ALFQJ( 821) /  1.84266829060927330634998820622D-03 /
      DATA  ALFQJ( 822) /  1.83513405503345166011157486064D-03 /
      DATA  ALFQJ( 823) /  1.82758258714816814417558909989D-03 /
      DATA  ALFQJ( 824) /  1.82001387635157344983623825454D-03 /
      DATA  ALFQJ( 825) /  1.81242807624097930208263174327D-03 /
      DATA  ALFQJ( 826) /  1.80482517517045841451732472902D-03 /
      DATA  ALFQJ( 827) /  1.79720532844667867223909731285D-03 /
      DATA  ALFQJ( 828) /  1.78956852333591484898916546800D-03 /
      DATA  ALFQJ( 829) /  1.78191491689332829193692345572D-03 /
      DATA  ALFQJ( 830) /  1.77424449525204453911707556963D-03 /
      DATA  ALFQJ( 831) /  1.76655741725650298944370877135D-03 /
      DATA  ALFQJ( 832) /  1.75885366785961615797088792862D-03 /
      DATA  ALFQJ( 833) /  1.75113340773761715944890462358D-03 /
      DATA  ALFQJ( 834) /  1.74339662061434311423165306356D-03 /
      DATA  ALFQJ( 835) /  1.73564346904215648752737484960D-03 /
      DATA  ALFQJ( 836) /  1.72787393546506666706391920015D-03 /
      DATA  ALFQJ( 837) /  1.72008818435781544694191698997D-03 /
      DATA  ALFQJ( 838) /  1.71228619683184512491629451310D-03 /
      DATA  ALFQJ( 839) /  1.70446813933254139500752808120D-03 /
      DATA  ALFQJ( 840) /  1.69663399158394994887714225985D-03 /
      DATA  ALFQJ( 841) /  1.68878392205248610014760934778D-03 /
      DATA  ALFQJ( 842) /  1.68091790901776958430601664896D-03 /
      DATA  ALFQJ( 843) /  1.67303612301986553469018173188D-03 /
      DATA  ALFQJ( 844) /  1.66513854083462184748002943294D-03 /
      DATA  ALFQJ( 845) /  1.65722533513072877238534139842D-03 /
      DATA  ALFQJ( 846) /  1.64929648111847569693235577591D-03 /
      DATA  ALFQJ( 847) /  1.64135215365263683357908386992D-03 /
      DATA  ALFQJ( 848) /  1.63339232631358322201146236147D-03 /
      DATA  ALFQJ( 849) /  1.62541717620225232495947258582D-03 /
      DATA  ALFQJ( 850) /  1.61742667520202268394749829084D-03 /
      DATA  ALFQJ( 851) /  1.60942100272284072480597801921D-03 /
      DATA  ALFQJ( 852) /  1.60140012888115344736884951710D-03 /
      DATA  ALFQJ( 853) /  1.59336423546168416872969744508D-03 /
      DATA  ALFQJ( 854) /  1.58531329074098364275829768951D-03 /
      DATA  ALFQJ( 855) /  1.57724747894740859500023306483D-03 /
      DATA  ALFQJ( 856) /  1.56916676644145140276452360004D-03 /
      DATA  ALFQJ( 857) /  1.56107133996722511272469503757D-03 /
      DATA  ALFQJ( 858) /  1.55296116388962051757945405311D-03 /
      DATA  ALFQJ( 859) /  1.54483642754408646038752668851D-03 /
      DATA  ALFQJ( 860) /  1.53669709321679135674217874531D-03 /
      DATA  ALFQJ( 861) /  1.52854335291375942659025350954D-03 /
      DATA  ALFQJ( 862) /  1.52037516675552790672103400763D-03 /
      DATA  ALFQJ( 863) /  1.51219272950181410926344428404D-03 /
      DATA  ALFQJ( 864) /  1.50399599901660177544001225064D-03 /
      DATA  ALFQJ( 865) /  1.49578517290053089417703897347D-03 /
      DATA  ALFQJ( 866) /  1.48756020666585401653449779784D-03 /
      DATA  ALFQJ( 867) /  1.47932130084572603827029414944D-03 /
      DATA  ALFQJ( 868) /  1.47106840850097562752218365655D-03 /
      DATA  ALFQJ( 869) /  1.46280173319349674818255412595D-03 /
      DATA  ALFQJ( 870) /  1.45452122542820757723230161026D-03 /
      DATA  ALFQJ( 871) /  1.44622709189688664941809056557D-03 /
      DATA  ALFQJ( 872) /  1.43791928043896121872054529247D-03 /
      DATA  ALFQJ( 873) /  1.42959800098247254685375904968D-03 /
      DATA  ALFQJ( 874) /  1.42126319858635994447431715036D-03 /
      DATA  ALFQJ( 875) /  1.41291508652687338283346983918D-03 /
      DATA  ALFQJ( 876) /  1.40455360696170294094394770375D-03 /
      DATA  ALFQJ( 877) /  1.39617897663318230493044030057D-03 /
      DATA  ALFQJ( 878) /  1.38779113467085189927490735781D-03 /
      DATA  ALFQJ( 879) /  1.37939030140732276164555525532D-03 /
      DATA  ALFQJ( 880) /  1.37097641281054153851110148683D-03 /
      DATA  ALFQJ( 881) /  1.36254969293432955090443068454D-03 /
      DATA  ALFQJ( 882) /  1.35411007444461479642893653000D-03 /
      DATA  ALFQJ( 883) /  1.34565778525455575328272111077D-03 /
      DATA  ALFQJ( 884) /  1.33719275458018354147476405310D-03 /
      DATA  ALFQJ( 885) /  1.32871521433980648950549669528D-03 /
      DATA  ALFQJ( 886) /  1.32022509014371565693150363075D-03 /
      DATA  ALFQJ( 887) /  1.31172261806940045002168827374D-03 /
      DATA  ALFQJ( 888) /  1.30320771995704934533665564769D-03 /
      DATA  ALFQJ( 889) /  1.29468063620616015345345708030D-03 /
      DATA  ALFQJ( 890) /  1.28614128471333549719987158820D-03 /
      DATA  ALFQJ( 891) /  1.27758991037233190058579663703D-03 /
      DATA  ALFQJ( 892) /  1.26902642695290896309034169933D-03 /
      DATA  ALFQJ( 893) /  1.26045108402543640143816313526D-03 /
      DATA  ALFQJ( 894) /  1.25186379103908956202556533093D-03 /
      DATA  ALFQJ( 895) /  1.24326480243405106501758986141D-03 /
      DATA  ALFQJ( 896) /  1.23465402313391365160859255421D-03 /
      DATA  ALFQJ( 897) /  1.22603171265352495479240759320D-03 /
      DATA  ALFQJ( 898) /  1.21739777117379707631197272663D-03 /
      DATA  ALFQJ( 899) /  1.20875246350162742798499845493D-03 /
      DATA  ALFQJ( 900) /  1.20009568484513029943450685333D-03 /
      DATA  ALFQJ( 901) /  1.19142770553413149374279413783D-03 /
      DATA  ALFQJ( 902) /  1.18274841555980651125406643911D-03 /
      DATA  ALFQJ( 903) /  1.17405809102033294444408080091D-03 /
      DATA  ALFQJ( 904) /  1.16535661643068349040030017034D-03 /
      DATA  ALFQJ( 905) /  1.15664427391850633622850330287D-03 /
      DATA  ALFQJ( 906) /  1.14792094224697997703832778335D-03 /
      DATA  ALFQJ( 907) /  1.13918690985129891978878995724D-03 /
      DATA  ALFQJ( 908) /  1.13044204944960729456601161256D-03 /
      DATA  ALFQJ( 909) /  1.12168665608106365109210309615D-03 /
      DATA  ALFQJ( 910) /  1.11292059610643693055617616468D-03 /
      DATA  ALFQJ( 911) /  1.10414417148513244470381907449D-03 /
      DATA  ALFQJ( 912) /  1.09535724188750475686687988034D-03 /
      DATA  ALFQJ( 913) /  1.08656011653103087059161881631D-03 /
      DATA  ALFQJ( 914) /  1.07775264804015253228724783674D-03 /
      DATA  ALFQJ( 915) /  1.06893515325163553969443192666D-03 /
      DATA  ALFQJ( 916) /  1.06010747736410728768167588345D-03 /
      DATA  ALFQJ( 917) /  1.05126994522027547536238603105D-03 /
      DATA  ALFQJ( 918) /  1.04242239418649914200373092725D-03 /
      DATA  ALFQJ( 919) /  1.03356515752577882848601439349D-03 /
      DATA  ALFQJ( 920) /  1.02469806433681803614348472019D-03 /
      DATA  ALFQJ( 921) /  1.01582145674746636553578916563D-03 /
      DATA  ALFQJ( 922) /  1.00693515512180979835723424141D-03 /
      DATA  ALFQJ( 923) /  9.98039510930093243030297794182D-04 /
      DATA  ALFQJ( 924) /  9.89134335300311867565037918147D-04 /
      DATA  ALFQJ( 925) /  9.80219989558740681850123219988D-04 /
      DATA  ALFQJ( 926) /  9.71296275058028896084726922132D-04 /
      DATA  ALFQJ( 927) /  9.62363563533659273652060302750D-04 /
      DATA  ALFQJ( 928) /  9.53421645982248327690190152503D-04 /
      DATA  ALFQJ( 929) /  9.44470905145065793544419609336D-04 /
      DATA  ALFQJ( 930) /  9.35511121036495895636117895374D-04 /
      DATA  ALFQJ( 931) /  9.26542688047895563288841561894D-04 /
      DATA  ALFQJ( 932) /  9.17565374535130802754692650922D-04 /
      DATA  ALFQJ( 933) /  9.08579587236512613995421176059D-04 /
      DATA  ALFQJ( 934) /  8.99585082117880124745371984480D-04 /
      DATA  ALFQJ( 935) /  8.90582279019380144589044924480D-04 /
      DATA  ALFQJ( 936) /  8.81570920724311709364929310594D-04 /
      DATA  ALFQJ( 937) /  8.72551440993694072324545174454D-04 /
      DATA  ALFQJ( 938) /  8.63523568568244517058564312777D-04 /
      DATA  ALFQJ( 939) /  8.54487752019982837050921547309D-04 /
      DATA  ALFQJ( 940) /  8.45443705112094948315211883737D-04 /
      DATA  ALFQJ( 941) /  8.36391892196677067935124741177D-04 /
      DATA  ALFQJ( 942) /  8.27332011041157211435884998614D-04 /
      DATA  ALFQJ( 943) /  8.18264542834653270572667242155D-04 /
      DATA  ALFQJ( 944) /  8.09189168237815178141825888483D-04 /
      DATA  ALFQJ( 945) /  8.00106386431756370269578733769D-04 /
      DATA  ALFQJ( 946) /  7.91015859755682423530182352934D-04 /
      DATA  ALFQJ( 947) /  7.81918106647306787846174356258D-04 /
      DATA  ALFQJ( 948) /  7.72812769793666212553283523933D-04 /
      DATA  ALFQJ( 949) /  7.63700388276598771737378135697D-04 /
      DATA  ALFQJ( 950) /  7.54580583669950027086316215304D-04 /
      DATA  ALFQJ( 951) /  7.45453917225398021991183744481D-04 /
      DATA  ALFQJ( 952) /  7.36319987795887759913963569631D-04 /
      DATA  ALFQJ( 953) /  7.27179380484448293451187119799D-04 /
      DATA  ALFQJ( 954) /  7.18031669649800848003331723713D-04 /
      DATA  ALFQJ( 955) /  7.08877466103998756515931010702D-04 /
      DATA  ALFQJ( 956) /  6.99716317750667262586281744693D-04 /
      DATA  ALFQJ( 957) /  6.90548863168366556644930308585D-04 /
      DATA  ALFQJ( 958) /  6.81374621631688265040641338340D-04 /
      DATA  ALFQJ( 959) /  6.72194261770552425107080616445D-04 /
      DATA  ALFQJ( 960) /  6.63007271813714970224638788017D-04 /
      DATA  ALFQJ( 961) /  6.53814352986931591637044758090D-04 /
      DATA  ALFQJ( 962) /  6.44614959778511755405865338169D-04 /
      DATA  ALFQJ( 963) /  6.35409828852047958178807343389D-04 /
      DATA  ALFQJ( 964) /  6.26198377941827035183229141854D-04 /
      DATA  ALFQJ( 965) /  6.16981382333546954468782679047D-04 /
      DATA  ALFQJ( 966) /  6.07758219626233371287033651098D-04 /
      DATA  ALFQJ( 967) /  5.98529707307292321869514855722D-04 /
      DATA  ALFQJ( 968) /  5.89295179033687580627476347486D-04 /
      DATA  ALFQJ( 969) /  5.80055498532725112518641569840D-04 /
      DATA  ALFQJ( 970) /  5.70809951217746437764474202988D-04 /
      DATA  ALFQJ( 971) /  5.61559451628540642752660468482D-04 /
      DATA  ALFQJ( 972) /  5.52303232055353315428718279479D-04 /
      DATA  ALFQJ( 973) /  5.43042263048782701596159142176D-04 /
      DATA  ALFQJ( 974) /  5.33775718218083636574785954478D-04 /
      DATA  ALFQJ( 975) /  5.24504630059486424879880168323D-04 /
      DATA  ALFQJ( 976) /  5.15228107142699390647172220687D-04 /
      DATA  ALFQJ( 977) /  5.05947250716045442184196720386D-04 /
      DATA  ALFQJ( 978) /  4.96661097000810912452561219409D-04 /
      DATA  ALFQJ( 979) /  4.87370823841540386593706618831D-04 /
      DATA  ALFQJ( 980) /  4.78075386667371302052398183340D-04 /
      DATA  ALFQJ( 981) /  4.68776049006352363866893684786D-04 /
      DATA  ALFQJ( 982) /  4.59471675687625790715293588306D-04 /
      DATA  ALFQJ( 983) /  4.50163626509508183153525387396D-04 /
      DATA  ALFQJ( 984) /  4.40850664241990611288487569690D-04 /
      DATA  ALFQJ( 985) /  4.31534257362381934200112162255D-04 /
      DATA  ALFQJ( 986) /  4.22213053108121256850281496397D-04 /
      DATA  ALFQJ( 987) /  4.12888643275637672338890415769D-04 /
      DATA  ALFQJ( 988) /  4.03559543619113491944722676136D-04 /
      DATA  ALFQJ( 989) /  3.94227486650684569071263603547D-04 /
      DATA  ALFQJ( 990) /  3.84890837616306345752309483253D-04 /
      DATA  ALFQJ( 991) /  3.75551490577499891072070182779D-04 /
      DATA  ALFQJ( 992) /  3.66207637394433751636696236494D-04 /
      DATA  ALFQJ( 993) /  3.56861358841573373355008390874D-04 /
      DATA  ALFQJ( 994) /  3.47510645635749483648430905919D-04 /
      DATA  ALFQJ( 995) /  3.38157795944135356031434260379D-04 /
      DATA  ALFQJ( 996) /  3.28800565327971616302696794039D-04 /
      DATA  ALFQJ( 997) /  3.19441507142088769442485709131D-04 /
      DATA  ALFQJ( 998) /  3.10078099658009541165515310262D-04 /
      DATA  ALFQJ( 999) /  3.00713198517770006574932064583D-04 /
      DATA  ALFQJ(1000) /  2.91343951868644324186116860207D-04 /
      DATA  ALFQJ(1001) /  2.81973577094905375285935352132D-04 /
      DATA  ALFQJ(1002) /  2.72598825057144167069083464283D-04 /
      DATA  ALFQJ(1003) /  2.63223351027957131781157136428D-04 /
      DATA  ALFQJ(1004) /  2.53843421880363433813802178634D-04 /
      DATA  ALFQJ(1005) /  2.44463229911461384905656663798D-04 /
      DATA  ALFQJ(1006) /  2.35078444104533086167148902985D-04 /
      DATA  ALFQJ(1007) /  2.25693925292063496496875545755D-04 /
      DATA  ALFQJ(1008) /  2.16304591887941790536508737814D-04 /
      DATA  ALFQJ(1009) /  2.06916151536012203752065929462D-04 /
      DATA  ALFQJ(1010) /  1.97522562585371454076030474173D-04 /
      DATA  ALFQJ(1011) /  1.88130627347577205342737140357D-04 /
      DATA  ALFQJ(1012) /  1.78733048655234525208012355543D-04 /
      DATA  ALFQJ(1013) /  1.69338078541451539821986648661D-04 /
      DATA  ALFQJ(1014) /  1.59936733787662266614299087517D-04 /
      DATA  ALFQJ(1015) /  1.50539243380972160577226799687D-04 /
      DATA  ALFQJ(1016) /  1.41134285264203201917671225251D-04 /
      DATA  ALFQJ(1017) /  1.31734883563328969548092321369D-04 /
      DATA  ALFQJ(1018) /  1.22326337663442579148747834118D-04 /
      DATA  ALFQJ(1019) /  1.12925808805336069599926400828D-04 /
      DATA  ALFQJ(1020) /  1.03513454574482326456960494131D-04 /
      DATA  ALFQJ(1021) /  9.41129381667466902198435049592D-05 /
      DATA  ALFQJ(1022) /  8.46960265908302758763593031107D-05 /
      DATA  ALFQJ(1023) /  7.52974768597021834664015432495D-05 /
      DATA  ALFQJ(1024) /  6.58739487635213803810533339812D-05 /
      DATA  ALFQJ(1025) /  5.64815417932571939114174550080D-05 /
      DATA  ALFQJ(1026) /  4.70453099689381721140038480342D-05 /
      DATA  ALFQJ(1027) /  3.76711963443812110423685651342D-05 /
      DATA  ALFQJ(1028) /  2.81983345165233015712726121174D-05 /
      DATA  ALFQJ(1029) /  1.89026792766573974132348561932D-05 /
      DATA  ALFQJ(1030) /  9.18965020284356169090826344936D-06 /
      DATA  ALFQJ(1031) /  9.53675225901819135493429265764D-07 /
      NUPPER=9
      IX=1
      CALL UCOPY(BETQJ,DB,1022)
      CALL UCOPY(KISQJ,DK,1022)
      CALL UCOPY(ALFQJ,DA,2062)
      RETURN
      END
