/* MprisClient.c generated by valac 0.32.1, the Vala compiler
 * generated from MprisClient.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define TYPE_MPRIS_CLIENT (mpris_client_get_type ())
#define MPRIS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS_CLIENT, MprisClient))
#define MPRIS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MPRIS_CLIENT, MprisClientClass))
#define IS_MPRIS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS_CLIENT))
#define IS_MPRIS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MPRIS_CLIENT))
#define MPRIS_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MPRIS_CLIENT, MprisClientClass))

typedef struct _MprisClient MprisClient;
typedef struct _MprisClientClass MprisClientClass;
typedef struct _MprisClientPrivate MprisClientPrivate;

#define TYPE_MPRIS_IFACE (mpris_iface_get_type ())
#define MPRIS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MPRIS_IFACE, MprisIface))
#define IS_MPRIS_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MPRIS_IFACE))
#define MPRIS_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MPRIS_IFACE, MprisIfaceIface))

typedef struct _MprisIface MprisIface;
typedef struct _MprisIfaceIface MprisIfaceIface;

#define TYPE_MPRIS_IFACE_PROXY (mpris_iface_proxy_get_type ())

#define TYPE_PLAYER_IFACE (player_iface_get_type ())
#define PLAYER_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_IFACE, PlayerIface))
#define IS_PLAYER_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_IFACE))
#define PLAYER_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_PLAYER_IFACE, PlayerIfaceIface))

typedef struct _PlayerIface PlayerIface;
typedef struct _PlayerIfaceIface PlayerIfaceIface;

#define TYPE_PLAYER_IFACE_PROXY (player_iface_proxy_get_type ())

#define TYPE_DBUS_PROP_IFACE (dbus_prop_iface_get_type ())
#define DBUS_PROP_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DBUS_PROP_IFACE, DbusPropIface))
#define IS_DBUS_PROP_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DBUS_PROP_IFACE))
#define DBUS_PROP_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_DBUS_PROP_IFACE, DbusPropIfaceIface))

typedef struct _DbusPropIface DbusPropIface;
typedef struct _DbusPropIfaceIface DbusPropIfaceIface;

#define TYPE_DBUS_PROP_IFACE_PROXY (dbus_prop_iface_proxy_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DBUS_IMPL (dbus_impl_get_type ())
#define DBUS_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DBUS_IMPL, DBusImpl))
#define IS_DBUS_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DBUS_IMPL))
#define DBUS_IMPL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_DBUS_IMPL, DBusImplIface))

typedef struct _DBusImpl DBusImpl;
typedef struct _DBusImplIface DBusImplIface;

#define TYPE_DBUS_IMPL_PROXY (dbus_impl_proxy_get_type ())
typedef GDBusProxy DBusImplProxy;
typedef GDBusProxyClass DBusImplProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef GDBusProxy DbusPropIfaceProxy;
typedef GDBusProxyClass DbusPropIfaceProxyClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef GDBusProxy MprisIfaceProxy;
typedef GDBusProxyClass MprisIfaceProxyClass;
typedef GDBusProxy PlayerIfaceProxy;
typedef GDBusProxyClass PlayerIfaceProxyClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _NewIfaceData NewIfaceData;

struct _MprisClient {
	GObject parent_instance;
	MprisClientPrivate * priv;
};

struct _MprisClientClass {
	GObjectClass parent_class;
};

struct _MprisIfaceIface {
	GTypeInterface parent_iface;
	void (*raise) (MprisIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*raise_finish) (MprisIface* self, GAsyncResult* _res_, GError** error);
	void (*quit) (MprisIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*quit_finish) (MprisIface* self, GAsyncResult* _res_, GError** error);
	gboolean (*get_can_quit) (MprisIface* self);
	void (*set_can_quit) (MprisIface* self, gboolean value);
	gboolean (*get_fullscreen) (MprisIface* self);
	gboolean (*get_can_set_fullscreen) (MprisIface* self);
	gboolean (*get_can_raise) (MprisIface* self);
	gboolean (*get_has_track_list) (MprisIface* self);
	gchar* (*get_identity) (MprisIface* self);
	gchar* (*get_desktop_entry) (MprisIface* self);
	gchar** (*get_supported_uri_schemes) (MprisIface* self, int* result_length1);
	gchar** (*get_supported_mime_types) (MprisIface* self, int* result_length1);
};

struct _PlayerIfaceIface {
	GTypeInterface parent_iface;
	void (*next) (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*next_finish) (PlayerIface* self, GAsyncResult* _res_, GError** error);
	void (*previous) (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*previous_finish) (PlayerIface* self, GAsyncResult* _res_, GError** error);
	void (*pause) (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*pause_finish) (PlayerIface* self, GAsyncResult* _res_, GError** error);
	void (*play_pause) (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*play_pause_finish) (PlayerIface* self, GAsyncResult* _res_, GError** error);
	void (*stop) (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*stop_finish) (PlayerIface* self, GAsyncResult* _res_, GError** error);
	void (*play) (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*play_finish) (PlayerIface* self, GAsyncResult* _res_, GError** error);
	void (*seek) (PlayerIface* self, gint64 offset, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*seek_finish) (PlayerIface* self, GAsyncResult* _res_, GError** error);
	void (*open_uri) (PlayerIface* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*open_uri_finish) (PlayerIface* self, GAsyncResult* _res_, GError** error);
	gchar* (*get_playback_status) (PlayerIface* self);
	gchar* (*get_loop_status) (PlayerIface* self);
	void (*set_loop_status) (PlayerIface* self, const gchar* value);
	gdouble (*get_rate) (PlayerIface* self);
	void (*set_rate) (PlayerIface* self, gdouble value);
	gboolean (*get_shuffle) (PlayerIface* self);
	void (*set_shuffle) (PlayerIface* self, gboolean value);
	GHashTable* (*get_metadata) (PlayerIface* self);
	gdouble (*get_volume) (PlayerIface* self);
	void (*set_volume) (PlayerIface* self, gdouble value);
	gint64 (*get_position) (PlayerIface* self);
	gdouble (*get_minimum_rate) (PlayerIface* self);
	gdouble (*get_maximum_rate) (PlayerIface* self);
	gboolean (*get_can_go_next) (PlayerIface* self);
	gboolean (*get_can_go_previous) (PlayerIface* self);
	gboolean (*get_can_play) (PlayerIface* self);
	gboolean (*get_can_pause) (PlayerIface* self);
	gboolean (*get_can_seek) (PlayerIface* self);
	gboolean (*get_can_control) (PlayerIface* self);
};

struct _DbusPropIfaceIface {
	GTypeInterface parent_iface;
};

struct _MprisClientPrivate {
	PlayerIface* _player;
	DbusPropIface* _prop;
};

struct _DBusImplIface {
	GTypeInterface parent_iface;
	void (*list_names) (DBusImpl* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*list_names_finish) (DBusImpl* self, GAsyncResult* _res_, int* result_length1, GError** error);
};

struct _NewIfaceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* busname;
	MprisClient* result;
	PlayerIface* play;
	MprisClient* cl;
	DbusPropIface* prop;
	PlayerIface* _tmp0_;
	const gchar* _tmp1_;
	PlayerIface* _tmp2_;
	PlayerIface* _tmp3_;
	GError* e;
	GError* _tmp4_;
	const gchar* _tmp5_;
	DbusPropIface* _tmp6_;
	const gchar* _tmp7_;
	DbusPropIface* _tmp8_;
	DbusPropIface* _tmp9_;
	GError* _vala1_e;
	GError* _tmp10_;
	const gchar* _tmp11_;
	PlayerIface* _tmp12_;
	DbusPropIface* _tmp13_;
	MprisClient* _tmp14_;
	GError * _inner_error_;
};


static gpointer mpris_client_parent_class = NULL;

GType mpris_client_get_type (void) G_GNUC_CONST;
GType mpris_iface_proxy_get_type (void) G_GNUC_CONST;
guint mpris_iface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType mpris_iface_get_type (void) G_GNUC_CONST;
GType player_iface_proxy_get_type (void) G_GNUC_CONST;
guint player_iface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType player_iface_get_type (void) G_GNUC_CONST;
GType dbus_prop_iface_get_type (void) G_GNUC_CONST;
GType dbus_prop_iface_proxy_get_type (void) G_GNUC_CONST;
guint dbus_prop_iface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
#define MPRIS_CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MPRIS_CLIENT, MprisClientPrivate))
enum  {
	MPRIS_CLIENT_DUMMY_PROPERTY,
	MPRIS_CLIENT_PLAYER,
	MPRIS_CLIENT_PROP
};
MprisClient* mpris_client_new (PlayerIface* player, DbusPropIface* prop);
MprisClient* mpris_client_construct (GType object_type, PlayerIface* player, DbusPropIface* prop);
PlayerIface* mpris_client_get_player (MprisClient* self);
void mpris_client_set_player (MprisClient* self, PlayerIface* value);
DbusPropIface* mpris_client_get_prop (MprisClient* self);
void mpris_client_set_prop (MprisClient* self, DbusPropIface* value);
static void mpris_client_finalize (GObject* obj);
static void _vala_mpris_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_mpris_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType dbus_impl_proxy_get_type (void) G_GNUC_CONST;
guint dbus_impl_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dbus_impl_get_type (void) G_GNUC_CONST;
void dbus_impl_list_names (DBusImpl* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** dbus_impl_list_names_finish (DBusImpl* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void dbus_impl_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_dbus_impl_name_owner_changed (DBusImpl* self, GVariant* parameters);
static void _dbus_handle_dbus_impl_name_acquired (DBusImpl* self, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void dbus_impl_proxy_list_names_async (DBusImpl* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar** dbus_impl_proxy_list_names_finish (DBusImpl* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void dbus_impl_proxy_dbus_impl_interface_init (DBusImplIface* iface);
static void _dbus_dbus_impl_list_names (DBusImpl* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_dbus_impl_list_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void dbus_impl_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* dbus_impl_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean dbus_impl_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_dbus_impl_name_owner_changed (GObject* _sender, const gchar* name, const gchar* old_owner, const gchar* new_owner, gpointer* _data);
static void _dbus_dbus_impl_name_acquired (GObject* _sender, const gchar* name, gpointer* _data);
static void _dbus_impl_unregister_object (gpointer user_data);
static void g_cclosure_user_marshal_VOID__STRING_BOXED_BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void dbus_prop_iface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_dbus_prop_iface_properties_changed (DbusPropIface* self, GVariant* parameters);
static void dbus_prop_iface_proxy_dbus_prop_iface_interface_init (DbusPropIfaceIface* iface);
static void dbus_prop_iface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* dbus_prop_iface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean dbus_prop_iface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_dbus_prop_iface_properties_changed (GObject* _sender, const gchar* iface, GHashTable* changed, gchar** invalid, int invalid_length1, gpointer* _data);
static void _dbus_prop_iface_unregister_object (gpointer user_data);
void mpris_iface_raise (MprisIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris_iface_raise_finish (MprisIface* self, GAsyncResult* _res_, GError** error);
void mpris_iface_quit (MprisIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void mpris_iface_quit_finish (MprisIface* self, GAsyncResult* _res_, GError** error);
gboolean mpris_iface_get_can_quit (MprisIface* self);
void mpris_iface_set_can_quit (MprisIface* self, gboolean value);
gboolean mpris_iface_get_fullscreen (MprisIface* self);
gboolean mpris_iface_get_can_set_fullscreen (MprisIface* self);
gboolean mpris_iface_get_can_raise (MprisIface* self);
gboolean mpris_iface_get_has_track_list (MprisIface* self);
gchar* mpris_iface_get_identity (MprisIface* self);
gchar* mpris_iface_get_desktop_entry (MprisIface* self);
gchar** mpris_iface_get_supported_uri_schemes (MprisIface* self, int* result_length1);
gchar** mpris_iface_get_supported_mime_types (MprisIface* self, int* result_length1);
static void mpris_iface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void mpris_iface_proxy_raise_async (MprisIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void mpris_iface_proxy_raise_finish (MprisIface* self, GAsyncResult* _res_, GError** error);
static void mpris_iface_proxy_quit_async (MprisIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void mpris_iface_proxy_quit_finish (MprisIface* self, GAsyncResult* _res_, GError** error);
static gboolean mpris_iface_dbus_proxy_get_can_quit (MprisIface* self);
static void mpris_iface_dbus_proxy_set_can_quit (MprisIface* self, gboolean value);
static gboolean mpris_iface_dbus_proxy_get_fullscreen (MprisIface* self);
static gboolean mpris_iface_dbus_proxy_get_can_set_fullscreen (MprisIface* self);
static gboolean mpris_iface_dbus_proxy_get_can_raise (MprisIface* self);
static gboolean mpris_iface_dbus_proxy_get_has_track_list (MprisIface* self);
static gchar* mpris_iface_dbus_proxy_get_identity (MprisIface* self);
static gchar* mpris_iface_dbus_proxy_get_desktop_entry (MprisIface* self);
static gchar** mpris_iface_dbus_proxy_get_supported_uri_schemes (MprisIface* self, int* result_length1);
static gchar** mpris_iface_dbus_proxy_get_supported_mime_types (MprisIface* self, int* result_length1);
static void mpris_iface_proxy_mpris_iface_interface_init (MprisIfaceIface* iface);
static void _dbus_mpris_iface_raise (MprisIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_mpris_iface_raise_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_mpris_iface_quit (MprisIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_mpris_iface_quit_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void mpris_iface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* mpris_iface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static GVariant* _dbus_mpris_iface_get_can_quit (MprisIface* self);
static GVariant* _dbus_mpris_iface_get_fullscreen (MprisIface* self);
static GVariant* _dbus_mpris_iface_get_can_set_fullscreen (MprisIface* self);
static GVariant* _dbus_mpris_iface_get_can_raise (MprisIface* self);
static GVariant* _dbus_mpris_iface_get_has_track_list (MprisIface* self);
static GVariant* _dbus_mpris_iface_get_identity (MprisIface* self);
static GVariant* _dbus_mpris_iface_get_desktop_entry (MprisIface* self);
static GVariant* _dbus_mpris_iface_get_supported_uri_schemes (MprisIface* self);
static GVariant* _dbus_mpris_iface_get_supported_mime_types (MprisIface* self);
static gboolean mpris_iface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_mpris_iface_set_can_quit (MprisIface* self, GVariant* _value);
static void _mpris_iface_unregister_object (gpointer user_data);
void player_iface_next (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void player_iface_next_finish (PlayerIface* self, GAsyncResult* _res_, GError** error);
void player_iface_previous (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void player_iface_previous_finish (PlayerIface* self, GAsyncResult* _res_, GError** error);
void player_iface_pause (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void player_iface_pause_finish (PlayerIface* self, GAsyncResult* _res_, GError** error);
void player_iface_play_pause (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void player_iface_play_pause_finish (PlayerIface* self, GAsyncResult* _res_, GError** error);
void player_iface_stop (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void player_iface_stop_finish (PlayerIface* self, GAsyncResult* _res_, GError** error);
void player_iface_play (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void player_iface_play_finish (PlayerIface* self, GAsyncResult* _res_, GError** error);
void player_iface_seek (PlayerIface* self, gint64 offset, GAsyncReadyCallback _callback_, gpointer _user_data_);
void player_iface_seek_finish (PlayerIface* self, GAsyncResult* _res_, GError** error);
void player_iface_open_uri (PlayerIface* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
void player_iface_open_uri_finish (PlayerIface* self, GAsyncResult* _res_, GError** error);
gchar* player_iface_get_playback_status (PlayerIface* self);
gchar* player_iface_get_loop_status (PlayerIface* self);
void player_iface_set_loop_status (PlayerIface* self, const gchar* value);
gdouble player_iface_get_rate (PlayerIface* self);
void player_iface_set_rate (PlayerIface* self, gdouble value);
gboolean player_iface_get_shuffle (PlayerIface* self);
void player_iface_set_shuffle (PlayerIface* self, gboolean value);
GHashTable* player_iface_get_metadata (PlayerIface* self);
gdouble player_iface_get_volume (PlayerIface* self);
void player_iface_set_volume (PlayerIface* self, gdouble value);
gint64 player_iface_get_position (PlayerIface* self);
gdouble player_iface_get_minimum_rate (PlayerIface* self);
gdouble player_iface_get_maximum_rate (PlayerIface* self);
gboolean player_iface_get_can_go_next (PlayerIface* self);
gboolean player_iface_get_can_go_previous (PlayerIface* self);
gboolean player_iface_get_can_play (PlayerIface* self);
gboolean player_iface_get_can_pause (PlayerIface* self);
gboolean player_iface_get_can_seek (PlayerIface* self);
gboolean player_iface_get_can_control (PlayerIface* self);
static void player_iface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void player_iface_proxy_raise_async (MprisIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void player_iface_proxy_raise_finish (MprisIface* self, GAsyncResult* _res_, GError** error);
static void player_iface_proxy_quit_async (MprisIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void player_iface_proxy_quit_finish (MprisIface* self, GAsyncResult* _res_, GError** error);
static gboolean player_iface_dbus_proxy_get_can_quit (MprisIface* self);
static void player_iface_dbus_proxy_set_can_quit (MprisIface* self, gboolean value);
static gboolean player_iface_dbus_proxy_get_fullscreen (MprisIface* self);
static gboolean player_iface_dbus_proxy_get_can_set_fullscreen (MprisIface* self);
static gboolean player_iface_dbus_proxy_get_can_raise (MprisIface* self);
static gboolean player_iface_dbus_proxy_get_has_track_list (MprisIface* self);
static gchar* player_iface_dbus_proxy_get_identity (MprisIface* self);
static gchar* player_iface_dbus_proxy_get_desktop_entry (MprisIface* self);
static gchar** player_iface_dbus_proxy_get_supported_uri_schemes (MprisIface* self, int* result_length1);
static gchar** player_iface_dbus_proxy_get_supported_mime_types (MprisIface* self, int* result_length1);
static void player_iface_proxy_mpris_iface_interface_init (MprisIfaceIface* iface);
static void player_iface_proxy_next_async (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void player_iface_proxy_next_finish (PlayerIface* self, GAsyncResult* _res_, GError** error);
static void player_iface_proxy_previous_async (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void player_iface_proxy_previous_finish (PlayerIface* self, GAsyncResult* _res_, GError** error);
static void player_iface_proxy_pause_async (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void player_iface_proxy_pause_finish (PlayerIface* self, GAsyncResult* _res_, GError** error);
static void player_iface_proxy_play_pause_async (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void player_iface_proxy_play_pause_finish (PlayerIface* self, GAsyncResult* _res_, GError** error);
static void player_iface_proxy_stop_async (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void player_iface_proxy_stop_finish (PlayerIface* self, GAsyncResult* _res_, GError** error);
static void player_iface_proxy_play_async (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void player_iface_proxy_play_finish (PlayerIface* self, GAsyncResult* _res_, GError** error);
static void player_iface_proxy_seek_async (PlayerIface* self, gint64 offset, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void player_iface_proxy_seek_finish (PlayerIface* self, GAsyncResult* _res_, GError** error);
static void player_iface_proxy_open_uri_async (PlayerIface* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void player_iface_proxy_open_uri_finish (PlayerIface* self, GAsyncResult* _res_, GError** error);
static gchar* player_iface_dbus_proxy_get_playback_status (PlayerIface* self);
static gchar* player_iface_dbus_proxy_get_loop_status (PlayerIface* self);
static void player_iface_dbus_proxy_set_loop_status (PlayerIface* self, const gchar* value);
static gdouble player_iface_dbus_proxy_get_rate (PlayerIface* self);
static void player_iface_dbus_proxy_set_rate (PlayerIface* self, gdouble value);
static gboolean player_iface_dbus_proxy_get_shuffle (PlayerIface* self);
static void player_iface_dbus_proxy_set_shuffle (PlayerIface* self, gboolean value);
static GHashTable* player_iface_dbus_proxy_get_metadata (PlayerIface* self);
static gdouble player_iface_dbus_proxy_get_volume (PlayerIface* self);
static void player_iface_dbus_proxy_set_volume (PlayerIface* self, gdouble value);
static gint64 player_iface_dbus_proxy_get_position (PlayerIface* self);
static gdouble player_iface_dbus_proxy_get_minimum_rate (PlayerIface* self);
static gdouble player_iface_dbus_proxy_get_maximum_rate (PlayerIface* self);
static gboolean player_iface_dbus_proxy_get_can_go_next (PlayerIface* self);
static gboolean player_iface_dbus_proxy_get_can_go_previous (PlayerIface* self);
static gboolean player_iface_dbus_proxy_get_can_play (PlayerIface* self);
static gboolean player_iface_dbus_proxy_get_can_pause (PlayerIface* self);
static gboolean player_iface_dbus_proxy_get_can_seek (PlayerIface* self);
static gboolean player_iface_dbus_proxy_get_can_control (PlayerIface* self);
static void player_iface_proxy_player_iface_interface_init (PlayerIfaceIface* iface);
static void _dbus_player_iface_next (PlayerIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_player_iface_next_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_player_iface_previous (PlayerIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_player_iface_previous_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_player_iface_pause (PlayerIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_player_iface_pause_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_player_iface_play_pause (PlayerIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_player_iface_play_pause_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_player_iface_stop (PlayerIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_player_iface_stop_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_player_iface_play (PlayerIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_player_iface_play_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_player_iface_seek (PlayerIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_player_iface_seek_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_player_iface_open_uri (PlayerIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_player_iface_open_uri_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void player_iface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* player_iface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static GVariant* _dbus_player_iface_get_playback_status (PlayerIface* self);
static GVariant* _dbus_player_iface_get_loop_status (PlayerIface* self);
static GVariant* _dbus_player_iface_get_rate (PlayerIface* self);
static GVariant* _dbus_player_iface_get_shuffle (PlayerIface* self);
static GVariant* _dbus_player_iface_get_metadata (PlayerIface* self);
static GVariant* _dbus_player_iface_get_volume (PlayerIface* self);
static GVariant* _dbus_player_iface_get_position (PlayerIface* self);
static GVariant* _dbus_player_iface_get_minimum_rate (PlayerIface* self);
static GVariant* _dbus_player_iface_get_maximum_rate (PlayerIface* self);
static GVariant* _dbus_player_iface_get_can_go_next (PlayerIface* self);
static GVariant* _dbus_player_iface_get_can_go_previous (PlayerIface* self);
static GVariant* _dbus_player_iface_get_can_play (PlayerIface* self);
static GVariant* _dbus_player_iface_get_can_pause (PlayerIface* self);
static GVariant* _dbus_player_iface_get_can_seek (PlayerIface* self);
static GVariant* _dbus_player_iface_get_can_control (PlayerIface* self);
static gboolean player_iface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_player_iface_set_loop_status (PlayerIface* self, GVariant* _value);
static void _dbus_player_iface_set_rate (PlayerIface* self, GVariant* _value);
static void _dbus_player_iface_set_shuffle (PlayerIface* self, GVariant* _value);
static void _dbus_player_iface_set_volume (PlayerIface* self, GVariant* _value);
static void _player_iface_unregister_object (gpointer user_data);
static void new_iface_data_free (gpointer _data);
void new_iface (const gchar* busname, GAsyncReadyCallback _callback_, gpointer _user_data_);
MprisClient* new_iface_finish (GAsyncResult* _res_);
static gboolean new_iface_co (NewIfaceData* _data_);
static void new_iface_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _dbus_impl_dbus_arg_info_list_names_result = {-1, "result", "as"};
static const GDBusArgInfo * const _dbus_impl_dbus_arg_info_list_names_in[] = {NULL};
static const GDBusArgInfo * const _dbus_impl_dbus_arg_info_list_names_out[] = {&_dbus_impl_dbus_arg_info_list_names_result, NULL};
static const GDBusMethodInfo _dbus_impl_dbus_method_info_list_names = {-1, "ListNames", (GDBusArgInfo **) (&_dbus_impl_dbus_arg_info_list_names_in), (GDBusArgInfo **) (&_dbus_impl_dbus_arg_info_list_names_out)};
static const GDBusMethodInfo * const _dbus_impl_dbus_method_info[] = {&_dbus_impl_dbus_method_info_list_names, NULL};
static const GDBusArgInfo _dbus_impl_dbus_arg_info_name_owner_changed_name = {-1, "name", "s"};
static const GDBusArgInfo _dbus_impl_dbus_arg_info_name_owner_changed_old_owner = {-1, "old_owner", "s"};
static const GDBusArgInfo _dbus_impl_dbus_arg_info_name_owner_changed_new_owner = {-1, "new_owner", "s"};
static const GDBusArgInfo * const _dbus_impl_dbus_arg_info_name_owner_changed[] = {&_dbus_impl_dbus_arg_info_name_owner_changed_name, &_dbus_impl_dbus_arg_info_name_owner_changed_old_owner, &_dbus_impl_dbus_arg_info_name_owner_changed_new_owner, NULL};
static const GDBusSignalInfo _dbus_impl_dbus_signal_info_name_owner_changed = {-1, "NameOwnerChanged", (GDBusArgInfo **) (&_dbus_impl_dbus_arg_info_name_owner_changed)};
static const GDBusArgInfo _dbus_impl_dbus_arg_info_name_acquired_name = {-1, "name", "s"};
static const GDBusArgInfo * const _dbus_impl_dbus_arg_info_name_acquired[] = {&_dbus_impl_dbus_arg_info_name_acquired_name, NULL};
static const GDBusSignalInfo _dbus_impl_dbus_signal_info_name_acquired = {-1, "NameAcquired", (GDBusArgInfo **) (&_dbus_impl_dbus_arg_info_name_acquired)};
static const GDBusSignalInfo * const _dbus_impl_dbus_signal_info[] = {&_dbus_impl_dbus_signal_info_name_owner_changed, &_dbus_impl_dbus_signal_info_name_acquired, NULL};
static const GDBusPropertyInfo * const _dbus_impl_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _dbus_impl_dbus_interface_info = {-1, "org.freedesktop.DBus", (GDBusMethodInfo **) (&_dbus_impl_dbus_method_info), (GDBusSignalInfo **) (&_dbus_impl_dbus_signal_info), (GDBusPropertyInfo **) (&_dbus_impl_dbus_property_info)};
static const GDBusInterfaceVTable _dbus_impl_dbus_interface_vtable = {dbus_impl_dbus_interface_method_call, dbus_impl_dbus_interface_get_property, dbus_impl_dbus_interface_set_property};
static const GDBusMethodInfo * const _dbus_prop_iface_dbus_method_info[] = {NULL};
static const GDBusArgInfo _dbus_prop_iface_dbus_arg_info_properties_changed_iface = {-1, "iface", "s"};
static const GDBusArgInfo _dbus_prop_iface_dbus_arg_info_properties_changed_changed = {-1, "changed", "a{sv}"};
static const GDBusArgInfo _dbus_prop_iface_dbus_arg_info_properties_changed_invalid = {-1, "invalid", "as"};
static const GDBusArgInfo * const _dbus_prop_iface_dbus_arg_info_properties_changed[] = {&_dbus_prop_iface_dbus_arg_info_properties_changed_iface, &_dbus_prop_iface_dbus_arg_info_properties_changed_changed, &_dbus_prop_iface_dbus_arg_info_properties_changed_invalid, NULL};
static const GDBusSignalInfo _dbus_prop_iface_dbus_signal_info_properties_changed = {-1, "PropertiesChanged", (GDBusArgInfo **) (&_dbus_prop_iface_dbus_arg_info_properties_changed)};
static const GDBusSignalInfo * const _dbus_prop_iface_dbus_signal_info[] = {&_dbus_prop_iface_dbus_signal_info_properties_changed, NULL};
static const GDBusPropertyInfo * const _dbus_prop_iface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _dbus_prop_iface_dbus_interface_info = {-1, "org.freedesktop.DBus.Properties", (GDBusMethodInfo **) (&_dbus_prop_iface_dbus_method_info), (GDBusSignalInfo **) (&_dbus_prop_iface_dbus_signal_info), (GDBusPropertyInfo **) (&_dbus_prop_iface_dbus_property_info)};
static const GDBusInterfaceVTable _dbus_prop_iface_dbus_interface_vtable = {dbus_prop_iface_dbus_interface_method_call, dbus_prop_iface_dbus_interface_get_property, dbus_prop_iface_dbus_interface_set_property};
static const GDBusArgInfo * const _mpris_iface_dbus_arg_info_raise_in[] = {NULL};
static const GDBusArgInfo * const _mpris_iface_dbus_arg_info_raise_out[] = {NULL};
static const GDBusMethodInfo _mpris_iface_dbus_method_info_raise = {-1, "Raise", (GDBusArgInfo **) (&_mpris_iface_dbus_arg_info_raise_in), (GDBusArgInfo **) (&_mpris_iface_dbus_arg_info_raise_out)};
static const GDBusArgInfo * const _mpris_iface_dbus_arg_info_quit_in[] = {NULL};
static const GDBusArgInfo * const _mpris_iface_dbus_arg_info_quit_out[] = {NULL};
static const GDBusMethodInfo _mpris_iface_dbus_method_info_quit = {-1, "Quit", (GDBusArgInfo **) (&_mpris_iface_dbus_arg_info_quit_in), (GDBusArgInfo **) (&_mpris_iface_dbus_arg_info_quit_out)};
static const GDBusMethodInfo * const _mpris_iface_dbus_method_info[] = {&_mpris_iface_dbus_method_info_raise, &_mpris_iface_dbus_method_info_quit, NULL};
static const GDBusSignalInfo * const _mpris_iface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _mpris_iface_dbus_property_info_can_quit = {-1, "CanQuit", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo _mpris_iface_dbus_property_info_fullscreen = {-1, "Fullscreen", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _mpris_iface_dbus_property_info_can_set_fullscreen = {-1, "CanSetFullscreen", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _mpris_iface_dbus_property_info_can_raise = {-1, "CanRaise", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _mpris_iface_dbus_property_info_has_track_list = {-1, "HasTrackList", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _mpris_iface_dbus_property_info_identity = {-1, "Identity", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _mpris_iface_dbus_property_info_desktop_entry = {-1, "DesktopEntry", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _mpris_iface_dbus_property_info_supported_uri_schemes = {-1, "SupportedUriSchemes", "as", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _mpris_iface_dbus_property_info_supported_mime_types = {-1, "SupportedMimeTypes", "as", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo * const _mpris_iface_dbus_property_info[] = {&_mpris_iface_dbus_property_info_can_quit, &_mpris_iface_dbus_property_info_fullscreen, &_mpris_iface_dbus_property_info_can_set_fullscreen, &_mpris_iface_dbus_property_info_can_raise, &_mpris_iface_dbus_property_info_has_track_list, &_mpris_iface_dbus_property_info_identity, &_mpris_iface_dbus_property_info_desktop_entry, &_mpris_iface_dbus_property_info_supported_uri_schemes, &_mpris_iface_dbus_property_info_supported_mime_types, NULL};
static const GDBusInterfaceInfo _mpris_iface_dbus_interface_info = {-1, "org.mpris.MediaPlayer2", (GDBusMethodInfo **) (&_mpris_iface_dbus_method_info), (GDBusSignalInfo **) (&_mpris_iface_dbus_signal_info), (GDBusPropertyInfo **) (&_mpris_iface_dbus_property_info)};
static const GDBusInterfaceVTable _mpris_iface_dbus_interface_vtable = {mpris_iface_dbus_interface_method_call, mpris_iface_dbus_interface_get_property, mpris_iface_dbus_interface_set_property};
static const GDBusArgInfo * const _player_iface_dbus_arg_info_next_in[] = {NULL};
static const GDBusArgInfo * const _player_iface_dbus_arg_info_next_out[] = {NULL};
static const GDBusMethodInfo _player_iface_dbus_method_info_next = {-1, "Next", (GDBusArgInfo **) (&_player_iface_dbus_arg_info_next_in), (GDBusArgInfo **) (&_player_iface_dbus_arg_info_next_out)};
static const GDBusArgInfo * const _player_iface_dbus_arg_info_previous_in[] = {NULL};
static const GDBusArgInfo * const _player_iface_dbus_arg_info_previous_out[] = {NULL};
static const GDBusMethodInfo _player_iface_dbus_method_info_previous = {-1, "Previous", (GDBusArgInfo **) (&_player_iface_dbus_arg_info_previous_in), (GDBusArgInfo **) (&_player_iface_dbus_arg_info_previous_out)};
static const GDBusArgInfo * const _player_iface_dbus_arg_info_pause_in[] = {NULL};
static const GDBusArgInfo * const _player_iface_dbus_arg_info_pause_out[] = {NULL};
static const GDBusMethodInfo _player_iface_dbus_method_info_pause = {-1, "Pause", (GDBusArgInfo **) (&_player_iface_dbus_arg_info_pause_in), (GDBusArgInfo **) (&_player_iface_dbus_arg_info_pause_out)};
static const GDBusArgInfo * const _player_iface_dbus_arg_info_play_pause_in[] = {NULL};
static const GDBusArgInfo * const _player_iface_dbus_arg_info_play_pause_out[] = {NULL};
static const GDBusMethodInfo _player_iface_dbus_method_info_play_pause = {-1, "PlayPause", (GDBusArgInfo **) (&_player_iface_dbus_arg_info_play_pause_in), (GDBusArgInfo **) (&_player_iface_dbus_arg_info_play_pause_out)};
static const GDBusArgInfo * const _player_iface_dbus_arg_info_stop_in[] = {NULL};
static const GDBusArgInfo * const _player_iface_dbus_arg_info_stop_out[] = {NULL};
static const GDBusMethodInfo _player_iface_dbus_method_info_stop = {-1, "Stop", (GDBusArgInfo **) (&_player_iface_dbus_arg_info_stop_in), (GDBusArgInfo **) (&_player_iface_dbus_arg_info_stop_out)};
static const GDBusArgInfo * const _player_iface_dbus_arg_info_play_in[] = {NULL};
static const GDBusArgInfo * const _player_iface_dbus_arg_info_play_out[] = {NULL};
static const GDBusMethodInfo _player_iface_dbus_method_info_play = {-1, "Play", (GDBusArgInfo **) (&_player_iface_dbus_arg_info_play_in), (GDBusArgInfo **) (&_player_iface_dbus_arg_info_play_out)};
static const GDBusArgInfo _player_iface_dbus_arg_info_seek_offset = {-1, "offset", "x"};
static const GDBusArgInfo * const _player_iface_dbus_arg_info_seek_in[] = {&_player_iface_dbus_arg_info_seek_offset, NULL};
static const GDBusArgInfo * const _player_iface_dbus_arg_info_seek_out[] = {NULL};
static const GDBusMethodInfo _player_iface_dbus_method_info_seek = {-1, "Seek", (GDBusArgInfo **) (&_player_iface_dbus_arg_info_seek_in), (GDBusArgInfo **) (&_player_iface_dbus_arg_info_seek_out)};
static const GDBusArgInfo _player_iface_dbus_arg_info_open_uri_uri = {-1, "uri", "s"};
static const GDBusArgInfo * const _player_iface_dbus_arg_info_open_uri_in[] = {&_player_iface_dbus_arg_info_open_uri_uri, NULL};
static const GDBusArgInfo * const _player_iface_dbus_arg_info_open_uri_out[] = {NULL};
static const GDBusMethodInfo _player_iface_dbus_method_info_open_uri = {-1, "OpenUri", (GDBusArgInfo **) (&_player_iface_dbus_arg_info_open_uri_in), (GDBusArgInfo **) (&_player_iface_dbus_arg_info_open_uri_out)};
static const GDBusMethodInfo * const _player_iface_dbus_method_info[] = {&_player_iface_dbus_method_info_next, &_player_iface_dbus_method_info_previous, &_player_iface_dbus_method_info_pause, &_player_iface_dbus_method_info_play_pause, &_player_iface_dbus_method_info_stop, &_player_iface_dbus_method_info_play, &_player_iface_dbus_method_info_seek, &_player_iface_dbus_method_info_open_uri, NULL};
static const GDBusSignalInfo * const _player_iface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _player_iface_dbus_property_info_playback_status = {-1, "PlaybackStatus", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _player_iface_dbus_property_info_loop_status = {-1, "LoopStatus", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo _player_iface_dbus_property_info_rate = {-1, "Rate", "d", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo _player_iface_dbus_property_info_shuffle = {-1, "Shuffle", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo _player_iface_dbus_property_info_metadata = {-1, "Metadata", "a{sv}", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _player_iface_dbus_property_info_volume = {-1, "Volume", "d", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo _player_iface_dbus_property_info_position = {-1, "Position", "x", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _player_iface_dbus_property_info_minimum_rate = {-1, "MinimumRate", "d", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _player_iface_dbus_property_info_maximum_rate = {-1, "MaximumRate", "d", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _player_iface_dbus_property_info_can_go_next = {-1, "CanGoNext", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _player_iface_dbus_property_info_can_go_previous = {-1, "CanGoPrevious", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _player_iface_dbus_property_info_can_play = {-1, "CanPlay", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _player_iface_dbus_property_info_can_pause = {-1, "CanPause", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _player_iface_dbus_property_info_can_seek = {-1, "CanSeek", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _player_iface_dbus_property_info_can_control = {-1, "CanControl", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo * const _player_iface_dbus_property_info[] = {&_player_iface_dbus_property_info_playback_status, &_player_iface_dbus_property_info_loop_status, &_player_iface_dbus_property_info_rate, &_player_iface_dbus_property_info_shuffle, &_player_iface_dbus_property_info_metadata, &_player_iface_dbus_property_info_volume, &_player_iface_dbus_property_info_position, &_player_iface_dbus_property_info_minimum_rate, &_player_iface_dbus_property_info_maximum_rate, &_player_iface_dbus_property_info_can_go_next, &_player_iface_dbus_property_info_can_go_previous, &_player_iface_dbus_property_info_can_play, &_player_iface_dbus_property_info_can_pause, &_player_iface_dbus_property_info_can_seek, &_player_iface_dbus_property_info_can_control, NULL};
static const GDBusInterfaceInfo _player_iface_dbus_interface_info = {-1, "org.mpris.MediaPlayer2.Player", (GDBusMethodInfo **) (&_player_iface_dbus_method_info), (GDBusSignalInfo **) (&_player_iface_dbus_signal_info), (GDBusPropertyInfo **) (&_player_iface_dbus_property_info)};
static const GDBusInterfaceVTable _player_iface_dbus_interface_vtable = {player_iface_dbus_interface_method_call, player_iface_dbus_interface_get_property, player_iface_dbus_interface_set_property};

MprisClient* mpris_client_construct (GType object_type, PlayerIface* player, DbusPropIface* prop) {
	MprisClient * self = NULL;
	PlayerIface* _tmp0_ = NULL;
	DbusPropIface* _tmp1_ = NULL;
	g_return_val_if_fail (player != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp0_ = player;
	_tmp1_ = prop;
	self = (MprisClient*) g_object_new (object_type, "player", _tmp0_, "prop", _tmp1_, NULL);
	return self;
}


MprisClient* mpris_client_new (PlayerIface* player, DbusPropIface* prop) {
	return mpris_client_construct (TYPE_MPRIS_CLIENT, player, prop);
}


PlayerIface* mpris_client_get_player (MprisClient* self) {
	PlayerIface* result;
	PlayerIface* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_player;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void mpris_client_set_player (MprisClient* self, PlayerIface* value) {
	PlayerIface* _tmp0_ = NULL;
	PlayerIface* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_player);
	self->priv->_player = _tmp1_;
	g_object_notify ((GObject *) self, "player");
}


DbusPropIface* mpris_client_get_prop (MprisClient* self) {
	DbusPropIface* result;
	DbusPropIface* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_prop;
	result = _tmp0_;
	return result;
}


void mpris_client_set_prop (MprisClient* self, DbusPropIface* value) {
	DbusPropIface* _tmp0_ = NULL;
	DbusPropIface* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_prop);
	self->priv->_prop = _tmp1_;
	g_object_notify ((GObject *) self, "prop");
}


static void mpris_client_class_init (MprisClientClass * klass) {
	mpris_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MprisClientPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_mpris_client_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mpris_client_set_property;
	G_OBJECT_CLASS (klass)->finalize = mpris_client_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MPRIS_CLIENT_PLAYER, g_param_spec_object ("player", "player", "player", TYPE_PLAYER_IFACE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MPRIS_CLIENT_PROP, g_param_spec_object ("prop", "prop", "prop", TYPE_DBUS_PROP_IFACE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void mpris_client_instance_init (MprisClient * self) {
	self->priv = MPRIS_CLIENT_GET_PRIVATE (self);
}


static void mpris_client_finalize (GObject* obj) {
	MprisClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MPRIS_CLIENT, MprisClient);
	_g_object_unref0 (self->priv->_player);
	_g_object_unref0 (self->priv->_prop);
	G_OBJECT_CLASS (mpris_client_parent_class)->finalize (obj);
}


/**
 * Simple wrapper to ensure vala doesn't unref our shit.
 */
GType mpris_client_get_type (void) {
	static volatile gsize mpris_client_type_id__volatile = 0;
	if (g_once_init_enter (&mpris_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MprisClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mpris_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MprisClient), 0, (GInstanceInitFunc) mpris_client_instance_init, NULL };
		GType mpris_client_type_id;
		mpris_client_type_id = g_type_register_static (G_TYPE_OBJECT, "MprisClient", &g_define_type_info, 0);
		g_once_init_leave (&mpris_client_type_id__volatile, mpris_client_type_id);
	}
	return mpris_client_type_id__volatile;
}


static void _vala_mpris_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MprisClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MPRIS_CLIENT, MprisClient);
	switch (property_id) {
		case MPRIS_CLIENT_PLAYER:
		g_value_set_object (value, mpris_client_get_player (self));
		break;
		case MPRIS_CLIENT_PROP:
		g_value_set_object (value, mpris_client_get_prop (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_mpris_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MprisClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MPRIS_CLIENT, MprisClient);
	switch (property_id) {
		case MPRIS_CLIENT_PLAYER:
		mpris_client_set_player (self, g_value_get_object (value));
		break;
		case MPRIS_CLIENT_PROP:
		mpris_client_set_prop (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void dbus_impl_list_names (DBusImpl* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBUS_IMPL_GET_INTERFACE (self)->list_names (self, _callback_, _user_data_);
}


gchar** dbus_impl_list_names_finish (DBusImpl* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	return DBUS_IMPL_GET_INTERFACE (self)->list_names_finish (self, _res_, result_length1, error);
}


static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), data2);
}


static void dbus_impl_base_init (DBusImplIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("name_owner_changed", TYPE_DBUS_IMPL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
		g_signal_new ("name_acquired", TYPE_DBUS_IMPL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	}
}


/**
 * We need to probe the dbus daemon directly, hence this interface
 */
GType dbus_impl_get_type (void) {
	static volatile gsize dbus_impl_type_id__volatile = 0;
	if (g_once_init_enter (&dbus_impl_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DBusImplIface), (GBaseInitFunc) dbus_impl_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType dbus_impl_type_id;
		dbus_impl_type_id = g_type_register_static (G_TYPE_INTERFACE, "DBusImpl", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dbus_impl_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (dbus_impl_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) dbus_impl_proxy_get_type);
		g_type_set_qdata (dbus_impl_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DBus");
		g_type_set_qdata (dbus_impl_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_dbus_impl_dbus_interface_info));
		g_type_set_qdata (dbus_impl_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) dbus_impl_register_object);
		g_once_init_leave (&dbus_impl_type_id__volatile, dbus_impl_type_id);
	}
	return dbus_impl_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (DBusImplProxy, dbus_impl_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_DBUS_IMPL, dbus_impl_proxy_dbus_impl_interface_init) )
static void dbus_impl_proxy_class_init (DBusImplProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = dbus_impl_proxy_g_signal;
}


static void _dbus_handle_dbus_impl_name_owner_changed (DBusImpl* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp21_;
	gchar* old_owner = NULL;
	GVariant* _tmp22_;
	gchar* new_owner = NULL;
	GVariant* _tmp23_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp21_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp21_, NULL);
	g_variant_unref (_tmp21_);
	_tmp22_ = g_variant_iter_next_value (&_arguments_iter);
	old_owner = g_variant_dup_string (_tmp22_, NULL);
	g_variant_unref (_tmp22_);
	_tmp23_ = g_variant_iter_next_value (&_arguments_iter);
	new_owner = g_variant_dup_string (_tmp23_, NULL);
	g_variant_unref (_tmp23_);
	g_signal_emit_by_name (self, "name-owner-changed", name, old_owner, new_owner);
	_g_free0 (name);
	_g_free0 (old_owner);
	_g_free0 (new_owner);
}


static void _dbus_handle_dbus_impl_name_acquired (DBusImpl* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* name = NULL;
	GVariant* _tmp24_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp24_ = g_variant_iter_next_value (&_arguments_iter);
	name = g_variant_dup_string (_tmp24_, NULL);
	g_variant_unref (_tmp24_);
	g_signal_emit_by_name (self, "name-acquired", name);
	_g_free0 (name);
}


static void dbus_impl_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "NameOwnerChanged") == 0) {
		_dbus_handle_dbus_impl_name_owner_changed ((DBusImpl*) proxy, parameters);
	} else if (strcmp (signal_name, "NameAcquired") == 0) {
		_dbus_handle_dbus_impl_name_acquired ((DBusImpl*) proxy, parameters);
	}
}


static void dbus_impl_proxy_init (DBusImplProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void dbus_impl_proxy_list_names_async (DBusImpl* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.DBus", "ListNames");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static gchar** dbus_impl_proxy_list_names_finish (DBusImpl* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result;
	int _result_length1;
	GVariant* _tmp25_;
	gchar** _tmp26_;
	int _tmp26__length;
	int _tmp26__size;
	int _tmp26__length1;
	GVariantIter _tmp27_;
	GVariant* _tmp28_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp25_ = g_variant_iter_next_value (&_reply_iter);
	_tmp26_ = g_new (gchar*, 5);
	_tmp26__length = 0;
	_tmp26__size = 4;
	_tmp26__length1 = 0;
	g_variant_iter_init (&_tmp27_, _tmp25_);
	for (; (_tmp28_ = g_variant_iter_next_value (&_tmp27_)) != NULL; _tmp26__length1++) {
		if (_tmp26__size == _tmp26__length) {
			_tmp26__size = 2 * _tmp26__size;
			_tmp26_ = g_renew (gchar*, _tmp26_, _tmp26__size + 1);
		}
		_tmp26_[_tmp26__length++] = g_variant_dup_string (_tmp28_, NULL);
		g_variant_unref (_tmp28_);
	}
	_result_length1 = _tmp26__length1;
	_tmp26_[_tmp26__length] = NULL;
	_result = _tmp26_;
	g_variant_unref (_tmp25_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}


static void dbus_impl_proxy_dbus_impl_interface_init (DBusImplIface* iface) {
	iface->list_names = dbus_impl_proxy_list_names_async;
	iface->list_names_finish = dbus_impl_proxy_list_names_finish;
}


static void _dbus_dbus_impl_list_names (DBusImpl* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	dbus_impl_list_names (self, (GAsyncReadyCallback) _dbus_dbus_impl_list_names_ready, invocation);
}


static void _dbus_dbus_impl_list_names_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	int result_length1 = 0;
	gchar** _tmp29_;
	GVariantBuilder _tmp30_;
	int _tmp31_;
	invocation = _user_data_;
	result = dbus_impl_list_names_finish ((DBusImpl*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp29_ = result;
	g_variant_builder_init (&_tmp30_, G_VARIANT_TYPE ("as"));
	for (_tmp31_ = 0; _tmp31_ < result_length1; _tmp31_++) {
		g_variant_builder_add_value (&_tmp30_, g_variant_new_string (*_tmp29_));
		_tmp29_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp30_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void dbus_impl_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ListNames") == 0) {
		_dbus_dbus_impl_list_names (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* dbus_impl_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean dbus_impl_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_dbus_impl_name_owner_changed (GObject* _sender, const gchar* name, const gchar* old_owner, const gchar* new_owner, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (old_owner));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (new_owner));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.DBus", "NameOwnerChanged", _arguments, NULL);
}


static void _dbus_dbus_impl_name_acquired (GObject* _sender, const gchar* name, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (name));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.DBus", "NameAcquired", _arguments, NULL);
}


guint dbus_impl_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_dbus_impl_dbus_interface_info), &_dbus_impl_dbus_interface_vtable, data, _dbus_impl_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "name-owner-changed", (GCallback) _dbus_dbus_impl_name_owner_changed, data);
	g_signal_connect (object, "name-acquired", (GCallback) _dbus_dbus_impl_name_acquired, data);
	return result;
}


static void _dbus_impl_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_dbus_impl_name_owner_changed, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_dbus_impl_name_acquired, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void g_cclosure_user_marshal_VOID__STRING_BOXED_BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_BOXED_BOXED_INT) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOXED_BOXED_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOXED_BOXED_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boxed (param_values + 2), g_value_get_boxed (param_values + 3), g_value_get_int (param_values + 4), data2);
}


static void dbus_prop_iface_base_init (DbusPropIfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("properties_changed", TYPE_DBUS_PROP_IFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED_BOXED_INT, G_TYPE_NONE, 4, G_TYPE_STRING, G_TYPE_HASH_TABLE, G_TYPE_STRV, G_TYPE_INT);
	}
}


/**
 * Vala dbus property notifications are not working. Manually probe property changes.
 */
GType dbus_prop_iface_get_type (void) {
	static volatile gsize dbus_prop_iface_type_id__volatile = 0;
	if (g_once_init_enter (&dbus_prop_iface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DbusPropIfaceIface), (GBaseInitFunc) dbus_prop_iface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType dbus_prop_iface_type_id;
		dbus_prop_iface_type_id = g_type_register_static (G_TYPE_INTERFACE, "DbusPropIface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dbus_prop_iface_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (dbus_prop_iface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) dbus_prop_iface_proxy_get_type);
		g_type_set_qdata (dbus_prop_iface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.DBus.Properties");
		g_type_set_qdata (dbus_prop_iface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_dbus_prop_iface_dbus_interface_info));
		g_type_set_qdata (dbus_prop_iface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) dbus_prop_iface_register_object);
		g_once_init_leave (&dbus_prop_iface_type_id__volatile, dbus_prop_iface_type_id);
	}
	return dbus_prop_iface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (DbusPropIfaceProxy, dbus_prop_iface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_DBUS_PROP_IFACE, dbus_prop_iface_proxy_dbus_prop_iface_interface_init) )
static void dbus_prop_iface_proxy_class_init (DbusPropIfaceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = dbus_prop_iface_proxy_g_signal;
}


static void _dbus_handle_dbus_prop_iface_properties_changed (DbusPropIface* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* iface = NULL;
	GVariant* _tmp32_;
	GHashTable* changed = NULL;
	GVariant* _tmp33_;
	GHashTable* _tmp34_;
	GVariantIter _tmp35_;
	GVariant* _tmp36_;
	GVariant* _tmp37_;
	gchar** invalid = NULL;
	int invalid_length1;
	GVariant* _tmp38_;
	gchar** _tmp39_;
	int _tmp39__length;
	int _tmp39__size;
	int _tmp39__length1;
	GVariantIter _tmp40_;
	GVariant* _tmp41_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp32_ = g_variant_iter_next_value (&_arguments_iter);
	iface = g_variant_dup_string (_tmp32_, NULL);
	g_variant_unref (_tmp32_);
	_tmp33_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp34_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp35_, _tmp33_);
	while (g_variant_iter_loop (&_tmp35_, "{?*}", &_tmp36_, &_tmp37_)) {
		g_hash_table_insert (_tmp34_, g_variant_dup_string (_tmp36_, NULL), g_variant_get_variant (_tmp37_));
	}
	changed = _tmp34_;
	g_variant_unref (_tmp33_);
	invalid_length1 = 0;
	_tmp38_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp39_ = g_new (gchar*, 5);
	_tmp39__length = 0;
	_tmp39__size = 4;
	_tmp39__length1 = 0;
	g_variant_iter_init (&_tmp40_, _tmp38_);
	for (; (_tmp41_ = g_variant_iter_next_value (&_tmp40_)) != NULL; _tmp39__length1++) {
		if (_tmp39__size == _tmp39__length) {
			_tmp39__size = 2 * _tmp39__size;
			_tmp39_ = g_renew (gchar*, _tmp39_, _tmp39__size + 1);
		}
		_tmp39_[_tmp39__length++] = g_variant_dup_string (_tmp41_, NULL);
		g_variant_unref (_tmp41_);
	}
	invalid_length1 = _tmp39__length1;
	_tmp39_[_tmp39__length] = NULL;
	invalid = _tmp39_;
	g_variant_unref (_tmp38_);
	g_signal_emit_by_name (self, "properties-changed", iface, changed, invalid, invalid_length1);
	_g_free0 (iface);
	_g_hash_table_unref0 (changed);
	invalid = (_vala_array_free (invalid, invalid_length1, (GDestroyNotify) g_free), NULL);
}


static void dbus_prop_iface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "PropertiesChanged") == 0) {
		_dbus_handle_dbus_prop_iface_properties_changed ((DbusPropIface*) proxy, parameters);
	}
}


static void dbus_prop_iface_proxy_init (DbusPropIfaceProxy* self) {
}


static void dbus_prop_iface_proxy_dbus_prop_iface_interface_init (DbusPropIfaceIface* iface) {
}


static void dbus_prop_iface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}


static GVariant* dbus_prop_iface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean dbus_prop_iface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_dbus_prop_iface_properties_changed (GObject* _sender, const gchar* iface, GHashTable* changed, gchar** invalid, int invalid_length1, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp42_;
	GHashTableIter _tmp43_;
	gpointer _tmp44_;
	gpointer _tmp45_;
	gchar** _tmp46_;
	GVariantBuilder _tmp47_;
	int _tmp48_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (iface));
	g_hash_table_iter_init (&_tmp43_, changed);
	g_variant_builder_init (&_tmp42_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp43_, &_tmp44_, &_tmp45_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp44_;
		_value = (GVariant*) _tmp45_;
		g_variant_builder_add (&_tmp42_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp42_));
	_tmp46_ = invalid;
	g_variant_builder_init (&_tmp47_, G_VARIANT_TYPE ("as"));
	for (_tmp48_ = 0; _tmp48_ < invalid_length1; _tmp48_++) {
		g_variant_builder_add_value (&_tmp47_, g_variant_new_string (*_tmp46_));
		_tmp46_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp47_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.DBus.Properties", "PropertiesChanged", _arguments, NULL);
}


guint dbus_prop_iface_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_dbus_prop_iface_dbus_interface_info), &_dbus_prop_iface_dbus_interface_vtable, data, _dbus_prop_iface_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "properties-changed", (GCallback) _dbus_dbus_prop_iface_properties_changed, data);
	return result;
}


static void _dbus_prop_iface_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_dbus_prop_iface_properties_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


void mpris_iface_raise (MprisIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MPRIS_IFACE_GET_INTERFACE (self)->raise (self, _callback_, _user_data_);
}


void mpris_iface_raise_finish (MprisIface* self, GAsyncResult* _res_, GError** error) {
	MPRIS_IFACE_GET_INTERFACE (self)->raise_finish (self, _res_, error);
}


void mpris_iface_quit (MprisIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	MPRIS_IFACE_GET_INTERFACE (self)->quit (self, _callback_, _user_data_);
}


void mpris_iface_quit_finish (MprisIface* self, GAsyncResult* _res_, GError** error) {
	MPRIS_IFACE_GET_INTERFACE (self)->quit_finish (self, _res_, error);
}


gboolean mpris_iface_get_can_quit (MprisIface* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return MPRIS_IFACE_GET_INTERFACE (self)->get_can_quit (self);
}


void mpris_iface_set_can_quit (MprisIface* self, gboolean value) {
	g_return_if_fail (self != NULL);
	MPRIS_IFACE_GET_INTERFACE (self)->set_can_quit (self, value);
}


gboolean mpris_iface_get_fullscreen (MprisIface* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return MPRIS_IFACE_GET_INTERFACE (self)->get_fullscreen (self);
}


gboolean mpris_iface_get_can_set_fullscreen (MprisIface* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return MPRIS_IFACE_GET_INTERFACE (self)->get_can_set_fullscreen (self);
}


gboolean mpris_iface_get_can_raise (MprisIface* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return MPRIS_IFACE_GET_INTERFACE (self)->get_can_raise (self);
}


gboolean mpris_iface_get_has_track_list (MprisIface* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return MPRIS_IFACE_GET_INTERFACE (self)->get_has_track_list (self);
}


gchar* mpris_iface_get_identity (MprisIface* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return MPRIS_IFACE_GET_INTERFACE (self)->get_identity (self);
}


gchar* mpris_iface_get_desktop_entry (MprisIface* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return MPRIS_IFACE_GET_INTERFACE (self)->get_desktop_entry (self);
}


gchar** mpris_iface_get_supported_uri_schemes (MprisIface* self, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return MPRIS_IFACE_GET_INTERFACE (self)->get_supported_uri_schemes (self, result_length1);
}


gchar** mpris_iface_get_supported_mime_types (MprisIface* self, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return MPRIS_IFACE_GET_INTERFACE (self)->get_supported_mime_types (self, result_length1);
}


static void mpris_iface_base_init (MprisIfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


/**
 * Represents the base org.mpris.MediaPlayer2 spec
 */
GType mpris_iface_get_type (void) {
	static volatile gsize mpris_iface_type_id__volatile = 0;
	if (g_once_init_enter (&mpris_iface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MprisIfaceIface), (GBaseInitFunc) mpris_iface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType mpris_iface_type_id;
		mpris_iface_type_id = g_type_register_static (G_TYPE_INTERFACE, "MprisIface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (mpris_iface_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (mpris_iface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) mpris_iface_proxy_get_type);
		g_type_set_qdata (mpris_iface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.mpris.MediaPlayer2");
		g_type_set_qdata (mpris_iface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_mpris_iface_dbus_interface_info));
		g_type_set_qdata (mpris_iface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) mpris_iface_register_object);
		g_once_init_leave (&mpris_iface_type_id__volatile, mpris_iface_type_id);
	}
	return mpris_iface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (MprisIfaceProxy, mpris_iface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_MPRIS_IFACE, mpris_iface_proxy_mpris_iface_interface_init) )
static void mpris_iface_proxy_class_init (MprisIfaceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = mpris_iface_proxy_g_signal;
}


static void mpris_iface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void mpris_iface_proxy_init (MprisIfaceProxy* self) {
}


static void mpris_iface_proxy_raise_async (MprisIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.mpris.MediaPlayer2", "Raise");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void mpris_iface_proxy_raise_finish (MprisIface* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void mpris_iface_proxy_quit_async (MprisIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.mpris.MediaPlayer2", "Quit");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void mpris_iface_proxy_quit_finish (MprisIface* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static gboolean mpris_iface_dbus_proxy_get_can_quit (MprisIface* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "CanQuit");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("CanQuit"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return FALSE;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static void mpris_iface_dbus_proxy_set_can_quit (MprisIface* self, gboolean value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("CanQuit"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static gboolean mpris_iface_dbus_proxy_get_fullscreen (MprisIface* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Fullscreen");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Fullscreen"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return FALSE;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static gboolean mpris_iface_dbus_proxy_get_can_set_fullscreen (MprisIface* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "CanSetFullscreen");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("CanSetFullscreen"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return FALSE;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static gboolean mpris_iface_dbus_proxy_get_can_raise (MprisIface* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "CanRaise");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("CanRaise"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return FALSE;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static gboolean mpris_iface_dbus_proxy_get_has_track_list (MprisIface* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "HasTrackList");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("HasTrackList"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return FALSE;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static gchar* mpris_iface_dbus_proxy_get_identity (MprisIface* self) {
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Identity");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Identity"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}


static gchar* mpris_iface_dbus_proxy_get_desktop_entry (MprisIface* self) {
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "DesktopEntry");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("DesktopEntry"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}


static gchar** mpris_iface_dbus_proxy_get_supported_uri_schemes (MprisIface* self, int* result_length1) {
	GVariant *_inner_reply;
	gchar** _result;
	int _result_length1;
	gchar** _tmp49_;
	int _tmp49__length;
	int _tmp49__size;
	int _tmp49__length1;
	GVariantIter _tmp50_;
	GVariant* _tmp51_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "SupportedUriSchemes");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("SupportedUriSchemes"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result_length1 = 0;
	_tmp49_ = g_new (gchar*, 5);
	_tmp49__length = 0;
	_tmp49__size = 4;
	_tmp49__length1 = 0;
	g_variant_iter_init (&_tmp50_, _inner_reply);
	for (; (_tmp51_ = g_variant_iter_next_value (&_tmp50_)) != NULL; _tmp49__length1++) {
		if (_tmp49__size == _tmp49__length) {
			_tmp49__size = 2 * _tmp49__size;
			_tmp49_ = g_renew (gchar*, _tmp49_, _tmp49__size + 1);
		}
		_tmp49_[_tmp49__length++] = g_variant_dup_string (_tmp51_, NULL);
		g_variant_unref (_tmp51_);
	}
	_result_length1 = _tmp49__length1;
	_tmp49_[_tmp49__length] = NULL;
	_result = _tmp49_;
	*result_length1 = _result_length1;
	g_variant_unref (_inner_reply);
	return _result;
}


static gchar** mpris_iface_dbus_proxy_get_supported_mime_types (MprisIface* self, int* result_length1) {
	GVariant *_inner_reply;
	gchar** _result;
	int _result_length1;
	gchar** _tmp52_;
	int _tmp52__length;
	int _tmp52__size;
	int _tmp52__length1;
	GVariantIter _tmp53_;
	GVariant* _tmp54_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "SupportedMimeTypes");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("SupportedMimeTypes"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result_length1 = 0;
	_tmp52_ = g_new (gchar*, 5);
	_tmp52__length = 0;
	_tmp52__size = 4;
	_tmp52__length1 = 0;
	g_variant_iter_init (&_tmp53_, _inner_reply);
	for (; (_tmp54_ = g_variant_iter_next_value (&_tmp53_)) != NULL; _tmp52__length1++) {
		if (_tmp52__size == _tmp52__length) {
			_tmp52__size = 2 * _tmp52__size;
			_tmp52_ = g_renew (gchar*, _tmp52_, _tmp52__size + 1);
		}
		_tmp52_[_tmp52__length++] = g_variant_dup_string (_tmp54_, NULL);
		g_variant_unref (_tmp54_);
	}
	_result_length1 = _tmp52__length1;
	_tmp52_[_tmp52__length] = NULL;
	_result = _tmp52_;
	*result_length1 = _result_length1;
	g_variant_unref (_inner_reply);
	return _result;
}


static void mpris_iface_proxy_mpris_iface_interface_init (MprisIfaceIface* iface) {
	iface->raise = mpris_iface_proxy_raise_async;
	iface->raise_finish = mpris_iface_proxy_raise_finish;
	iface->quit = mpris_iface_proxy_quit_async;
	iface->quit_finish = mpris_iface_proxy_quit_finish;
	iface->get_can_quit = mpris_iface_dbus_proxy_get_can_quit;
	iface->set_can_quit = mpris_iface_dbus_proxy_set_can_quit;
	iface->get_fullscreen = mpris_iface_dbus_proxy_get_fullscreen;
	iface->get_can_set_fullscreen = mpris_iface_dbus_proxy_get_can_set_fullscreen;
	iface->get_can_raise = mpris_iface_dbus_proxy_get_can_raise;
	iface->get_has_track_list = mpris_iface_dbus_proxy_get_has_track_list;
	iface->get_identity = mpris_iface_dbus_proxy_get_identity;
	iface->get_desktop_entry = mpris_iface_dbus_proxy_get_desktop_entry;
	iface->get_supported_uri_schemes = mpris_iface_dbus_proxy_get_supported_uri_schemes;
	iface->get_supported_mime_types = mpris_iface_dbus_proxy_get_supported_mime_types;
}


static void _dbus_mpris_iface_raise (MprisIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	mpris_iface_raise (self, (GAsyncReadyCallback) _dbus_mpris_iface_raise_ready, invocation);
}


static void _dbus_mpris_iface_raise_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	mpris_iface_raise_finish ((MprisIface*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_mpris_iface_quit (MprisIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	mpris_iface_quit (self, (GAsyncReadyCallback) _dbus_mpris_iface_quit_ready, invocation);
}


static void _dbus_mpris_iface_quit_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	mpris_iface_quit_finish ((MprisIface*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void mpris_iface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Raise") == 0) {
		_dbus_mpris_iface_raise (object, parameters, invocation);
	} else if (strcmp (method_name, "Quit") == 0) {
		_dbus_mpris_iface_quit (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* _dbus_mpris_iface_get_can_quit (MprisIface* self) {
	gboolean result;
	GVariant* _reply;
	result = mpris_iface_get_can_quit (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_mpris_iface_get_fullscreen (MprisIface* self) {
	gboolean result;
	GVariant* _reply;
	result = mpris_iface_get_fullscreen (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_mpris_iface_get_can_set_fullscreen (MprisIface* self) {
	gboolean result;
	GVariant* _reply;
	result = mpris_iface_get_can_set_fullscreen (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_mpris_iface_get_can_raise (MprisIface* self) {
	gboolean result;
	GVariant* _reply;
	result = mpris_iface_get_can_raise (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_mpris_iface_get_has_track_list (MprisIface* self) {
	gboolean result;
	GVariant* _reply;
	result = mpris_iface_get_has_track_list (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_mpris_iface_get_identity (MprisIface* self) {
	gchar* result;
	GVariant* _reply;
	result = mpris_iface_get_identity (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}


static GVariant* _dbus_mpris_iface_get_desktop_entry (MprisIface* self) {
	gchar* result;
	GVariant* _reply;
	result = mpris_iface_get_desktop_entry (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}


static GVariant* _dbus_mpris_iface_get_supported_uri_schemes (MprisIface* self) {
	gchar** result;
	int result_length1 = 0;
	gchar** _tmp55_;
	GVariantBuilder _tmp56_;
	int _tmp57_;
	GVariant* _reply;
	result = mpris_iface_get_supported_uri_schemes (self, &result_length1);
	_tmp55_ = result;
	g_variant_builder_init (&_tmp56_, G_VARIANT_TYPE ("as"));
	for (_tmp57_ = 0; _tmp57_ < result_length1; _tmp57_++) {
		g_variant_builder_add_value (&_tmp56_, g_variant_new_string (*_tmp55_));
		_tmp55_++;
	}
	_reply = g_variant_builder_end (&_tmp56_);
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	return _reply;
}


static GVariant* _dbus_mpris_iface_get_supported_mime_types (MprisIface* self) {
	gchar** result;
	int result_length1 = 0;
	gchar** _tmp58_;
	GVariantBuilder _tmp59_;
	int _tmp60_;
	GVariant* _reply;
	result = mpris_iface_get_supported_mime_types (self, &result_length1);
	_tmp58_ = result;
	g_variant_builder_init (&_tmp59_, G_VARIANT_TYPE ("as"));
	for (_tmp60_ = 0; _tmp60_ < result_length1; _tmp60_++) {
		g_variant_builder_add_value (&_tmp59_, g_variant_new_string (*_tmp58_));
		_tmp58_++;
	}
	_reply = g_variant_builder_end (&_tmp59_);
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	return _reply;
}


static GVariant* mpris_iface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "CanQuit") == 0) {
		return _dbus_mpris_iface_get_can_quit (object);
	} else if (strcmp (property_name, "Fullscreen") == 0) {
		return _dbus_mpris_iface_get_fullscreen (object);
	} else if (strcmp (property_name, "CanSetFullscreen") == 0) {
		return _dbus_mpris_iface_get_can_set_fullscreen (object);
	} else if (strcmp (property_name, "CanRaise") == 0) {
		return _dbus_mpris_iface_get_can_raise (object);
	} else if (strcmp (property_name, "HasTrackList") == 0) {
		return _dbus_mpris_iface_get_has_track_list (object);
	} else if (strcmp (property_name, "Identity") == 0) {
		return _dbus_mpris_iface_get_identity (object);
	} else if (strcmp (property_name, "DesktopEntry") == 0) {
		return _dbus_mpris_iface_get_desktop_entry (object);
	} else if (strcmp (property_name, "SupportedUriSchemes") == 0) {
		return _dbus_mpris_iface_get_supported_uri_schemes (object);
	} else if (strcmp (property_name, "SupportedMimeTypes") == 0) {
		return _dbus_mpris_iface_get_supported_mime_types (object);
	}
	return NULL;
}


static void _dbus_mpris_iface_set_can_quit (MprisIface* self, GVariant* _value) {
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	mpris_iface_set_can_quit (self, value);
}


static gboolean mpris_iface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "CanQuit") == 0) {
		_dbus_mpris_iface_set_can_quit (object, value);
		return TRUE;
	}
	return FALSE;
}


guint mpris_iface_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_mpris_iface_dbus_interface_info), &_mpris_iface_dbus_interface_vtable, data, _mpris_iface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _mpris_iface_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


void player_iface_next (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	PLAYER_IFACE_GET_INTERFACE (self)->next (self, _callback_, _user_data_);
}


void player_iface_next_finish (PlayerIface* self, GAsyncResult* _res_, GError** error) {
	PLAYER_IFACE_GET_INTERFACE (self)->next_finish (self, _res_, error);
}


void player_iface_previous (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	PLAYER_IFACE_GET_INTERFACE (self)->previous (self, _callback_, _user_data_);
}


void player_iface_previous_finish (PlayerIface* self, GAsyncResult* _res_, GError** error) {
	PLAYER_IFACE_GET_INTERFACE (self)->previous_finish (self, _res_, error);
}


void player_iface_pause (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	PLAYER_IFACE_GET_INTERFACE (self)->pause (self, _callback_, _user_data_);
}


void player_iface_pause_finish (PlayerIface* self, GAsyncResult* _res_, GError** error) {
	PLAYER_IFACE_GET_INTERFACE (self)->pause_finish (self, _res_, error);
}


void player_iface_play_pause (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	PLAYER_IFACE_GET_INTERFACE (self)->play_pause (self, _callback_, _user_data_);
}


void player_iface_play_pause_finish (PlayerIface* self, GAsyncResult* _res_, GError** error) {
	PLAYER_IFACE_GET_INTERFACE (self)->play_pause_finish (self, _res_, error);
}


void player_iface_stop (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	PLAYER_IFACE_GET_INTERFACE (self)->stop (self, _callback_, _user_data_);
}


void player_iface_stop_finish (PlayerIface* self, GAsyncResult* _res_, GError** error) {
	PLAYER_IFACE_GET_INTERFACE (self)->stop_finish (self, _res_, error);
}


void player_iface_play (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	PLAYER_IFACE_GET_INTERFACE (self)->play (self, _callback_, _user_data_);
}


void player_iface_play_finish (PlayerIface* self, GAsyncResult* _res_, GError** error) {
	PLAYER_IFACE_GET_INTERFACE (self)->play_finish (self, _res_, error);
}


void player_iface_seek (PlayerIface* self, gint64 offset, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	PLAYER_IFACE_GET_INTERFACE (self)->seek (self, offset, _callback_, _user_data_);
}


void player_iface_seek_finish (PlayerIface* self, GAsyncResult* _res_, GError** error) {
	PLAYER_IFACE_GET_INTERFACE (self)->seek_finish (self, _res_, error);
}


void player_iface_open_uri (PlayerIface* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	PLAYER_IFACE_GET_INTERFACE (self)->open_uri (self, uri, _callback_, _user_data_);
}


void player_iface_open_uri_finish (PlayerIface* self, GAsyncResult* _res_, GError** error) {
	PLAYER_IFACE_GET_INTERFACE (self)->open_uri_finish (self, _res_, error);
}


gchar* player_iface_get_playback_status (PlayerIface* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return PLAYER_IFACE_GET_INTERFACE (self)->get_playback_status (self);
}


gchar* player_iface_get_loop_status (PlayerIface* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return PLAYER_IFACE_GET_INTERFACE (self)->get_loop_status (self);
}


void player_iface_set_loop_status (PlayerIface* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	PLAYER_IFACE_GET_INTERFACE (self)->set_loop_status (self, value);
}


gdouble player_iface_get_rate (PlayerIface* self) {
	g_return_val_if_fail (self != NULL, 0.0);
	return PLAYER_IFACE_GET_INTERFACE (self)->get_rate (self);
}


void player_iface_set_rate (PlayerIface* self, gdouble value) {
	g_return_if_fail (self != NULL);
	PLAYER_IFACE_GET_INTERFACE (self)->set_rate (self, value);
}


gboolean player_iface_get_shuffle (PlayerIface* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return PLAYER_IFACE_GET_INTERFACE (self)->get_shuffle (self);
}


void player_iface_set_shuffle (PlayerIface* self, gboolean value) {
	g_return_if_fail (self != NULL);
	PLAYER_IFACE_GET_INTERFACE (self)->set_shuffle (self, value);
}


GHashTable* player_iface_get_metadata (PlayerIface* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return PLAYER_IFACE_GET_INTERFACE (self)->get_metadata (self);
}


gdouble player_iface_get_volume (PlayerIface* self) {
	g_return_val_if_fail (self != NULL, 0.0);
	return PLAYER_IFACE_GET_INTERFACE (self)->get_volume (self);
}


void player_iface_set_volume (PlayerIface* self, gdouble value) {
	g_return_if_fail (self != NULL);
	PLAYER_IFACE_GET_INTERFACE (self)->set_volume (self, value);
}


gint64 player_iface_get_position (PlayerIface* self) {
	g_return_val_if_fail (self != NULL, 0LL);
	return PLAYER_IFACE_GET_INTERFACE (self)->get_position (self);
}


gdouble player_iface_get_minimum_rate (PlayerIface* self) {
	g_return_val_if_fail (self != NULL, 0.0);
	return PLAYER_IFACE_GET_INTERFACE (self)->get_minimum_rate (self);
}


gdouble player_iface_get_maximum_rate (PlayerIface* self) {
	g_return_val_if_fail (self != NULL, 0.0);
	return PLAYER_IFACE_GET_INTERFACE (self)->get_maximum_rate (self);
}


gboolean player_iface_get_can_go_next (PlayerIface* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return PLAYER_IFACE_GET_INTERFACE (self)->get_can_go_next (self);
}


gboolean player_iface_get_can_go_previous (PlayerIface* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return PLAYER_IFACE_GET_INTERFACE (self)->get_can_go_previous (self);
}


gboolean player_iface_get_can_play (PlayerIface* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return PLAYER_IFACE_GET_INTERFACE (self)->get_can_play (self);
}


gboolean player_iface_get_can_pause (PlayerIface* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return PLAYER_IFACE_GET_INTERFACE (self)->get_can_pause (self);
}


gboolean player_iface_get_can_seek (PlayerIface* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return PLAYER_IFACE_GET_INTERFACE (self)->get_can_seek (self);
}


gboolean player_iface_get_can_control (PlayerIface* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return PLAYER_IFACE_GET_INTERFACE (self)->get_can_control (self);
}


static void player_iface_base_init (PlayerIfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


/**
 * Interface for the org.mpris.MediaPlayer2.Player spec
 * This is the one that actually does cool stuff!
 *
 * @note We cheat and inherit from MprisIface to save faffing around with two
 * iface initialisations over one
 */
GType player_iface_get_type (void) {
	static volatile gsize player_iface_type_id__volatile = 0;
	if (g_once_init_enter (&player_iface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PlayerIfaceIface), (GBaseInitFunc) player_iface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType player_iface_type_id;
		player_iface_type_id = g_type_register_static (G_TYPE_INTERFACE, "PlayerIface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (player_iface_type_id, TYPE_MPRIS_IFACE);
		g_type_set_qdata (player_iface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) player_iface_proxy_get_type);
		g_type_set_qdata (player_iface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.mpris.MediaPlayer2.Player");
		g_type_set_qdata (player_iface_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_player_iface_dbus_interface_info));
		g_type_set_qdata (player_iface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) player_iface_register_object);
		g_once_init_leave (&player_iface_type_id__volatile, player_iface_type_id);
	}
	return player_iface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (PlayerIfaceProxy, player_iface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_MPRIS_IFACE, player_iface_proxy_mpris_iface_interface_init) G_IMPLEMENT_INTERFACE (TYPE_PLAYER_IFACE, player_iface_proxy_player_iface_interface_init) )
static void player_iface_proxy_class_init (PlayerIfaceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = player_iface_proxy_g_signal;
}


static void player_iface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void player_iface_proxy_init (PlayerIfaceProxy* self) {
}


static void player_iface_proxy_raise_async (MprisIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.mpris.MediaPlayer2", "Raise");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void player_iface_proxy_raise_finish (MprisIface* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void player_iface_proxy_quit_async (MprisIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.mpris.MediaPlayer2", "Quit");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void player_iface_proxy_quit_finish (MprisIface* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static gboolean player_iface_dbus_proxy_get_can_quit (MprisIface* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "CanQuit");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("CanQuit"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return FALSE;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static void player_iface_dbus_proxy_set_can_quit (MprisIface* self, gboolean value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("CanQuit"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static gboolean player_iface_dbus_proxy_get_fullscreen (MprisIface* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Fullscreen");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Fullscreen"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return FALSE;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static gboolean player_iface_dbus_proxy_get_can_set_fullscreen (MprisIface* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "CanSetFullscreen");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("CanSetFullscreen"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return FALSE;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static gboolean player_iface_dbus_proxy_get_can_raise (MprisIface* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "CanRaise");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("CanRaise"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return FALSE;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static gboolean player_iface_dbus_proxy_get_has_track_list (MprisIface* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "HasTrackList");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("HasTrackList"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return FALSE;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static gchar* player_iface_dbus_proxy_get_identity (MprisIface* self) {
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Identity");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Identity"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}


static gchar* player_iface_dbus_proxy_get_desktop_entry (MprisIface* self) {
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "DesktopEntry");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("DesktopEntry"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}


static gchar** player_iface_dbus_proxy_get_supported_uri_schemes (MprisIface* self, int* result_length1) {
	GVariant *_inner_reply;
	gchar** _result;
	int _result_length1;
	gchar** _tmp61_;
	int _tmp61__length;
	int _tmp61__size;
	int _tmp61__length1;
	GVariantIter _tmp62_;
	GVariant* _tmp63_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "SupportedUriSchemes");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("SupportedUriSchemes"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result_length1 = 0;
	_tmp61_ = g_new (gchar*, 5);
	_tmp61__length = 0;
	_tmp61__size = 4;
	_tmp61__length1 = 0;
	g_variant_iter_init (&_tmp62_, _inner_reply);
	for (; (_tmp63_ = g_variant_iter_next_value (&_tmp62_)) != NULL; _tmp61__length1++) {
		if (_tmp61__size == _tmp61__length) {
			_tmp61__size = 2 * _tmp61__size;
			_tmp61_ = g_renew (gchar*, _tmp61_, _tmp61__size + 1);
		}
		_tmp61_[_tmp61__length++] = g_variant_dup_string (_tmp63_, NULL);
		g_variant_unref (_tmp63_);
	}
	_result_length1 = _tmp61__length1;
	_tmp61_[_tmp61__length] = NULL;
	_result = _tmp61_;
	*result_length1 = _result_length1;
	g_variant_unref (_inner_reply);
	return _result;
}


static gchar** player_iface_dbus_proxy_get_supported_mime_types (MprisIface* self, int* result_length1) {
	GVariant *_inner_reply;
	gchar** _result;
	int _result_length1;
	gchar** _tmp64_;
	int _tmp64__length;
	int _tmp64__size;
	int _tmp64__length1;
	GVariantIter _tmp65_;
	GVariant* _tmp66_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "SupportedMimeTypes");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("SupportedMimeTypes"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result_length1 = 0;
	_tmp64_ = g_new (gchar*, 5);
	_tmp64__length = 0;
	_tmp64__size = 4;
	_tmp64__length1 = 0;
	g_variant_iter_init (&_tmp65_, _inner_reply);
	for (; (_tmp66_ = g_variant_iter_next_value (&_tmp65_)) != NULL; _tmp64__length1++) {
		if (_tmp64__size == _tmp64__length) {
			_tmp64__size = 2 * _tmp64__size;
			_tmp64_ = g_renew (gchar*, _tmp64_, _tmp64__size + 1);
		}
		_tmp64_[_tmp64__length++] = g_variant_dup_string (_tmp66_, NULL);
		g_variant_unref (_tmp66_);
	}
	_result_length1 = _tmp64__length1;
	_tmp64_[_tmp64__length] = NULL;
	_result = _tmp64_;
	*result_length1 = _result_length1;
	g_variant_unref (_inner_reply);
	return _result;
}


static void player_iface_proxy_mpris_iface_interface_init (MprisIfaceIface* iface) {
	iface->raise = player_iface_proxy_raise_async;
	iface->raise_finish = player_iface_proxy_raise_finish;
	iface->quit = player_iface_proxy_quit_async;
	iface->quit_finish = player_iface_proxy_quit_finish;
	iface->get_can_quit = player_iface_dbus_proxy_get_can_quit;
	iface->set_can_quit = player_iface_dbus_proxy_set_can_quit;
	iface->get_fullscreen = player_iface_dbus_proxy_get_fullscreen;
	iface->get_can_set_fullscreen = player_iface_dbus_proxy_get_can_set_fullscreen;
	iface->get_can_raise = player_iface_dbus_proxy_get_can_raise;
	iface->get_has_track_list = player_iface_dbus_proxy_get_has_track_list;
	iface->get_identity = player_iface_dbus_proxy_get_identity;
	iface->get_desktop_entry = player_iface_dbus_proxy_get_desktop_entry;
	iface->get_supported_uri_schemes = player_iface_dbus_proxy_get_supported_uri_schemes;
	iface->get_supported_mime_types = player_iface_dbus_proxy_get_supported_mime_types;
}


static void player_iface_proxy_next_async (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.mpris.MediaPlayer2.Player", "Next");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void player_iface_proxy_next_finish (PlayerIface* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void player_iface_proxy_previous_async (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.mpris.MediaPlayer2.Player", "Previous");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void player_iface_proxy_previous_finish (PlayerIface* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void player_iface_proxy_pause_async (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.mpris.MediaPlayer2.Player", "Pause");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void player_iface_proxy_pause_finish (PlayerIface* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void player_iface_proxy_play_pause_async (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.mpris.MediaPlayer2.Player", "PlayPause");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void player_iface_proxy_play_pause_finish (PlayerIface* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void player_iface_proxy_stop_async (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.mpris.MediaPlayer2.Player", "Stop");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void player_iface_proxy_stop_finish (PlayerIface* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void player_iface_proxy_play_async (PlayerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.mpris.MediaPlayer2.Player", "Play");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void player_iface_proxy_play_finish (PlayerIface* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void player_iface_proxy_seek_async (PlayerIface* self, gint64 offset, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.mpris.MediaPlayer2.Player", "Seek");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int64 (offset));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void player_iface_proxy_seek_finish (PlayerIface* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void player_iface_proxy_open_uri_async (PlayerIface* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.mpris.MediaPlayer2.Player", "OpenUri");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (uri));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void player_iface_proxy_open_uri_finish (PlayerIface* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static gchar* player_iface_dbus_proxy_get_playback_status (PlayerIface* self) {
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "PlaybackStatus");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PlaybackStatus"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}


static gchar* player_iface_dbus_proxy_get_loop_status (PlayerIface* self) {
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "LoopStatus");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("LoopStatus"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}


static void player_iface_dbus_proxy_set_loop_status (PlayerIface* self, const gchar* value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("LoopStatus"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static gdouble player_iface_dbus_proxy_get_rate (PlayerIface* self) {
	GVariant *_inner_reply;
	gdouble _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Rate");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Rate"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return 0.0;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_double (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static void player_iface_dbus_proxy_set_rate (PlayerIface* self, gdouble value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Rate"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_double (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static gboolean player_iface_dbus_proxy_get_shuffle (PlayerIface* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Shuffle");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Shuffle"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return FALSE;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static void player_iface_dbus_proxy_set_shuffle (PlayerIface* self, gboolean value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Shuffle"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static GHashTable* player_iface_dbus_proxy_get_metadata (PlayerIface* self) {
	GVariant *_inner_reply;
	GHashTable* _result;
	GHashTable* _tmp67_;
	GVariantIter _tmp68_;
	GVariant* _tmp69_;
	GVariant* _tmp70_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Metadata");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Metadata"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_tmp67_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp68_, _inner_reply);
	while (g_variant_iter_loop (&_tmp68_, "{?*}", &_tmp69_, &_tmp70_)) {
		g_hash_table_insert (_tmp67_, g_variant_dup_string (_tmp69_, NULL), g_variant_get_variant (_tmp70_));
	}
	_result = _tmp67_;
	g_variant_unref (_inner_reply);
	return _result;
}


static gdouble player_iface_dbus_proxy_get_volume (PlayerIface* self) {
	GVariant *_inner_reply;
	gdouble _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Volume");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Volume"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return 0.0;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_double (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static void player_iface_dbus_proxy_set_volume (PlayerIface* self, gdouble value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Volume"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_double (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static gint64 player_iface_dbus_proxy_get_position (PlayerIface* self) {
	GVariant *_inner_reply;
	gint64 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Position");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Position"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return 0LL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_int64 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static gdouble player_iface_dbus_proxy_get_minimum_rate (PlayerIface* self) {
	GVariant *_inner_reply;
	gdouble _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "MinimumRate");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("MinimumRate"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return 0.0;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_double (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static gdouble player_iface_dbus_proxy_get_maximum_rate (PlayerIface* self) {
	GVariant *_inner_reply;
	gdouble _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "MaximumRate");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("MaximumRate"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return 0.0;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_double (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static gboolean player_iface_dbus_proxy_get_can_go_next (PlayerIface* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "CanGoNext");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("CanGoNext"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return FALSE;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static gboolean player_iface_dbus_proxy_get_can_go_previous (PlayerIface* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "CanGoPrevious");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("CanGoPrevious"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return FALSE;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static gboolean player_iface_dbus_proxy_get_can_play (PlayerIface* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "CanPlay");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("CanPlay"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return FALSE;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static gboolean player_iface_dbus_proxy_get_can_pause (PlayerIface* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "CanPause");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("CanPause"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return FALSE;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static gboolean player_iface_dbus_proxy_get_can_seek (PlayerIface* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "CanSeek");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("CanSeek"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return FALSE;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static gboolean player_iface_dbus_proxy_get_can_control (PlayerIface* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "CanControl");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.mpris.MediaPlayer2.Player"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("CanControl"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return FALSE;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static void player_iface_proxy_player_iface_interface_init (PlayerIfaceIface* iface) {
	iface->next = player_iface_proxy_next_async;
	iface->next_finish = player_iface_proxy_next_finish;
	iface->previous = player_iface_proxy_previous_async;
	iface->previous_finish = player_iface_proxy_previous_finish;
	iface->pause = player_iface_proxy_pause_async;
	iface->pause_finish = player_iface_proxy_pause_finish;
	iface->play_pause = player_iface_proxy_play_pause_async;
	iface->play_pause_finish = player_iface_proxy_play_pause_finish;
	iface->stop = player_iface_proxy_stop_async;
	iface->stop_finish = player_iface_proxy_stop_finish;
	iface->play = player_iface_proxy_play_async;
	iface->play_finish = player_iface_proxy_play_finish;
	iface->seek = player_iface_proxy_seek_async;
	iface->seek_finish = player_iface_proxy_seek_finish;
	iface->open_uri = player_iface_proxy_open_uri_async;
	iface->open_uri_finish = player_iface_proxy_open_uri_finish;
	iface->get_playback_status = player_iface_dbus_proxy_get_playback_status;
	iface->get_loop_status = player_iface_dbus_proxy_get_loop_status;
	iface->set_loop_status = player_iface_dbus_proxy_set_loop_status;
	iface->get_rate = player_iface_dbus_proxy_get_rate;
	iface->set_rate = player_iface_dbus_proxy_set_rate;
	iface->get_shuffle = player_iface_dbus_proxy_get_shuffle;
	iface->set_shuffle = player_iface_dbus_proxy_set_shuffle;
	iface->get_metadata = player_iface_dbus_proxy_get_metadata;
	iface->get_volume = player_iface_dbus_proxy_get_volume;
	iface->set_volume = player_iface_dbus_proxy_set_volume;
	iface->get_position = player_iface_dbus_proxy_get_position;
	iface->get_minimum_rate = player_iface_dbus_proxy_get_minimum_rate;
	iface->get_maximum_rate = player_iface_dbus_proxy_get_maximum_rate;
	iface->get_can_go_next = player_iface_dbus_proxy_get_can_go_next;
	iface->get_can_go_previous = player_iface_dbus_proxy_get_can_go_previous;
	iface->get_can_play = player_iface_dbus_proxy_get_can_play;
	iface->get_can_pause = player_iface_dbus_proxy_get_can_pause;
	iface->get_can_seek = player_iface_dbus_proxy_get_can_seek;
	iface->get_can_control = player_iface_dbus_proxy_get_can_control;
}


static void _dbus_player_iface_next (PlayerIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	player_iface_next (self, (GAsyncReadyCallback) _dbus_player_iface_next_ready, invocation);
}


static void _dbus_player_iface_next_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	player_iface_next_finish ((PlayerIface*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_player_iface_previous (PlayerIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	player_iface_previous (self, (GAsyncReadyCallback) _dbus_player_iface_previous_ready, invocation);
}


static void _dbus_player_iface_previous_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	player_iface_previous_finish ((PlayerIface*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_player_iface_pause (PlayerIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	player_iface_pause (self, (GAsyncReadyCallback) _dbus_player_iface_pause_ready, invocation);
}


static void _dbus_player_iface_pause_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	player_iface_pause_finish ((PlayerIface*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_player_iface_play_pause (PlayerIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	player_iface_play_pause (self, (GAsyncReadyCallback) _dbus_player_iface_play_pause_ready, invocation);
}


static void _dbus_player_iface_play_pause_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	player_iface_play_pause_finish ((PlayerIface*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_player_iface_stop (PlayerIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	player_iface_stop (self, (GAsyncReadyCallback) _dbus_player_iface_stop_ready, invocation);
}


static void _dbus_player_iface_stop_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	player_iface_stop_finish ((PlayerIface*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_player_iface_play (PlayerIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	player_iface_play (self, (GAsyncReadyCallback) _dbus_player_iface_play_ready, invocation);
}


static void _dbus_player_iface_play_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	player_iface_play_finish ((PlayerIface*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_player_iface_seek (PlayerIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gint64 offset = 0LL;
	GVariant* _tmp71_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp71_ = g_variant_iter_next_value (&_arguments_iter);
	offset = g_variant_get_int64 (_tmp71_);
	g_variant_unref (_tmp71_);
	player_iface_seek (self, offset, (GAsyncReadyCallback) _dbus_player_iface_seek_ready, invocation);
}


static void _dbus_player_iface_seek_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	player_iface_seek_finish ((PlayerIface*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_player_iface_open_uri (PlayerIface* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* uri = NULL;
	GVariant* _tmp72_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp72_ = g_variant_iter_next_value (&_arguments_iter);
	uri = g_variant_dup_string (_tmp72_, NULL);
	g_variant_unref (_tmp72_);
	player_iface_open_uri (self, uri, (GAsyncReadyCallback) _dbus_player_iface_open_uri_ready, invocation);
	_g_free0 (uri);
}


static void _dbus_player_iface_open_uri_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	player_iface_open_uri_finish ((PlayerIface*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void player_iface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Next") == 0) {
		_dbus_player_iface_next (object, parameters, invocation);
	} else if (strcmp (method_name, "Previous") == 0) {
		_dbus_player_iface_previous (object, parameters, invocation);
	} else if (strcmp (method_name, "Pause") == 0) {
		_dbus_player_iface_pause (object, parameters, invocation);
	} else if (strcmp (method_name, "PlayPause") == 0) {
		_dbus_player_iface_play_pause (object, parameters, invocation);
	} else if (strcmp (method_name, "Stop") == 0) {
		_dbus_player_iface_stop (object, parameters, invocation);
	} else if (strcmp (method_name, "Play") == 0) {
		_dbus_player_iface_play (object, parameters, invocation);
	} else if (strcmp (method_name, "Seek") == 0) {
		_dbus_player_iface_seek (object, parameters, invocation);
	} else if (strcmp (method_name, "OpenUri") == 0) {
		_dbus_player_iface_open_uri (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* _dbus_player_iface_get_playback_status (PlayerIface* self) {
	gchar* result;
	GVariant* _reply;
	result = player_iface_get_playback_status (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}


static GVariant* _dbus_player_iface_get_loop_status (PlayerIface* self) {
	gchar* result;
	GVariant* _reply;
	result = player_iface_get_loop_status (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}


static GVariant* _dbus_player_iface_get_rate (PlayerIface* self) {
	gdouble result;
	GVariant* _reply;
	result = player_iface_get_rate (self);
	_reply = g_variant_new_double (result);
	return _reply;
}


static GVariant* _dbus_player_iface_get_shuffle (PlayerIface* self) {
	gboolean result;
	GVariant* _reply;
	result = player_iface_get_shuffle (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_player_iface_get_metadata (PlayerIface* self) {
	GHashTable* result;
	GVariantBuilder _tmp73_;
	GHashTableIter _tmp74_;
	gpointer _tmp75_;
	gpointer _tmp76_;
	GVariant* _reply;
	result = player_iface_get_metadata (self);
	g_hash_table_iter_init (&_tmp74_, result);
	g_variant_builder_init (&_tmp73_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp74_, &_tmp75_, &_tmp76_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp75_;
		_value = (GVariant*) _tmp76_;
		g_variant_builder_add (&_tmp73_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	_reply = g_variant_builder_end (&_tmp73_);
	_g_hash_table_unref0 (result);
	return _reply;
}


static GVariant* _dbus_player_iface_get_volume (PlayerIface* self) {
	gdouble result;
	GVariant* _reply;
	result = player_iface_get_volume (self);
	_reply = g_variant_new_double (result);
	return _reply;
}


static GVariant* _dbus_player_iface_get_position (PlayerIface* self) {
	gint64 result;
	GVariant* _reply;
	result = player_iface_get_position (self);
	_reply = g_variant_new_int64 (result);
	return _reply;
}


static GVariant* _dbus_player_iface_get_minimum_rate (PlayerIface* self) {
	gdouble result;
	GVariant* _reply;
	result = player_iface_get_minimum_rate (self);
	_reply = g_variant_new_double (result);
	return _reply;
}


static GVariant* _dbus_player_iface_get_maximum_rate (PlayerIface* self) {
	gdouble result;
	GVariant* _reply;
	result = player_iface_get_maximum_rate (self);
	_reply = g_variant_new_double (result);
	return _reply;
}


static GVariant* _dbus_player_iface_get_can_go_next (PlayerIface* self) {
	gboolean result;
	GVariant* _reply;
	result = player_iface_get_can_go_next (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_player_iface_get_can_go_previous (PlayerIface* self) {
	gboolean result;
	GVariant* _reply;
	result = player_iface_get_can_go_previous (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_player_iface_get_can_play (PlayerIface* self) {
	gboolean result;
	GVariant* _reply;
	result = player_iface_get_can_play (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_player_iface_get_can_pause (PlayerIface* self) {
	gboolean result;
	GVariant* _reply;
	result = player_iface_get_can_pause (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_player_iface_get_can_seek (PlayerIface* self) {
	gboolean result;
	GVariant* _reply;
	result = player_iface_get_can_seek (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_player_iface_get_can_control (PlayerIface* self) {
	gboolean result;
	GVariant* _reply;
	result = player_iface_get_can_control (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* player_iface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "PlaybackStatus") == 0) {
		return _dbus_player_iface_get_playback_status (object);
	} else if (strcmp (property_name, "LoopStatus") == 0) {
		return _dbus_player_iface_get_loop_status (object);
	} else if (strcmp (property_name, "Rate") == 0) {
		return _dbus_player_iface_get_rate (object);
	} else if (strcmp (property_name, "Shuffle") == 0) {
		return _dbus_player_iface_get_shuffle (object);
	} else if (strcmp (property_name, "Metadata") == 0) {
		return _dbus_player_iface_get_metadata (object);
	} else if (strcmp (property_name, "Volume") == 0) {
		return _dbus_player_iface_get_volume (object);
	} else if (strcmp (property_name, "Position") == 0) {
		return _dbus_player_iface_get_position (object);
	} else if (strcmp (property_name, "MinimumRate") == 0) {
		return _dbus_player_iface_get_minimum_rate (object);
	} else if (strcmp (property_name, "MaximumRate") == 0) {
		return _dbus_player_iface_get_maximum_rate (object);
	} else if (strcmp (property_name, "CanGoNext") == 0) {
		return _dbus_player_iface_get_can_go_next (object);
	} else if (strcmp (property_name, "CanGoPrevious") == 0) {
		return _dbus_player_iface_get_can_go_previous (object);
	} else if (strcmp (property_name, "CanPlay") == 0) {
		return _dbus_player_iface_get_can_play (object);
	} else if (strcmp (property_name, "CanPause") == 0) {
		return _dbus_player_iface_get_can_pause (object);
	} else if (strcmp (property_name, "CanSeek") == 0) {
		return _dbus_player_iface_get_can_seek (object);
	} else if (strcmp (property_name, "CanControl") == 0) {
		return _dbus_player_iface_get_can_control (object);
	}
	return NULL;
}


static void _dbus_player_iface_set_loop_status (PlayerIface* self, GVariant* _value) {
	gchar* value = NULL;
	value = g_variant_dup_string (_value, NULL);
	player_iface_set_loop_status (self, value);
	_g_free0 (value);
}


static void _dbus_player_iface_set_rate (PlayerIface* self, GVariant* _value) {
	gdouble value = 0.0;
	value = g_variant_get_double (_value);
	player_iface_set_rate (self, value);
}


static void _dbus_player_iface_set_shuffle (PlayerIface* self, GVariant* _value) {
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	player_iface_set_shuffle (self, value);
}


static void _dbus_player_iface_set_volume (PlayerIface* self, GVariant* _value) {
	gdouble value = 0.0;
	value = g_variant_get_double (_value);
	player_iface_set_volume (self, value);
}


static gboolean player_iface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "LoopStatus") == 0) {
		_dbus_player_iface_set_loop_status (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Rate") == 0) {
		_dbus_player_iface_set_rate (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Shuffle") == 0) {
		_dbus_player_iface_set_shuffle (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Volume") == 0) {
		_dbus_player_iface_set_volume (object, value);
		return TRUE;
	}
	return FALSE;
}


guint player_iface_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_player_iface_dbus_interface_info), &_player_iface_dbus_interface_vtable, data, _player_iface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _player_iface_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void new_iface_data_free (gpointer _data) {
	NewIfaceData* _data_;
	_data_ = _data;
	_g_free0 (_data_->busname);
	_g_object_unref0 (_data_->result);
	g_slice_free (NewIfaceData, _data_);
}


void new_iface (const gchar* busname, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	NewIfaceData* _data_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	_data_ = g_slice_new0 (NewIfaceData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, new_iface);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, new_iface_data_free);
	_tmp0_ = busname;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data_->busname);
	_data_->busname = _tmp1_;
	new_iface_co (_data_);
}


MprisClient* new_iface_finish (GAsyncResult* _res_) {
	MprisClient* result;
	NewIfaceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
 * Utility function, return a new iface instance, i.e. deal
 * with all the dbus cruft
 *
 * @param busname The busname to instaniate ifaces from
 * @return a new MprisClient, or null if errors occurred.
 */
static void new_iface_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	NewIfaceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	new_iface_co (_data_);
}


static gboolean new_iface_co (NewIfaceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->play = NULL;
	_data_->cl = NULL;
	_data_->prop = NULL;
	{
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->busname;
		_data_->_state_ = 1;
		g_async_initable_new_async (TYPE_PLAYER_IFACE_PROXY, 0, NULL, new_iface_ready, _data_, "g-flags", 0, "g-name", _data_->_tmp1_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/mpris/MediaPlayer2", "g-interface-name", "org.mpris.MediaPlayer2.Player", "g-interface-info", g_type_get_qdata (TYPE_PLAYER_IFACE, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp0_ = (PlayerIface*) _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch14_g_error;
		}
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->play);
		_data_->play = _data_->_tmp3_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally14;
	__catch14_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->e;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		g_message ("MprisClient.vala:122: %s", _data_->_tmp5_);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->prop);
		_g_object_unref0 (_data_->cl);
		_g_object_unref0 (_data_->play);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally14:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->prop);
		_g_object_unref0 (_data_->cl);
		_g_object_unref0 (_data_->play);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	{
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->busname;
		_data_->_state_ = 2;
		g_async_initable_new_async (TYPE_DBUS_PROP_IFACE_PROXY, 0, NULL, new_iface_ready, _data_, "g-flags", 0, "g-name", _data_->_tmp7_, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/mpris/MediaPlayer2", "g-interface-name", "org.freedesktop.DBus.Properties", "g-interface-info", g_type_get_qdata (TYPE_DBUS_PROP_IFACE, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		return FALSE;
		_state_2:
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp6_ = (DbusPropIface*) _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch15_g_error;
		}
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->_tmp6_;
		_data_->_tmp6_ = NULL;
		_g_object_unref0 (_data_->prop);
		_data_->prop = _data_->_tmp9_;
		_g_object_unref0 (_data_->_tmp6_);
	}
	goto __finally15;
	__catch15_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->_vala1_e;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->_tmp10_->message;
		g_message ("MprisClient.vala:128: %s", _data_->_tmp11_);
		_data_->result = NULL;
		_g_error_free0 (_data_->_vala1_e);
		_g_object_unref0 (_data_->prop);
		_g_object_unref0 (_data_->cl);
		_g_object_unref0 (_data_->play);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally15:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->prop);
		_g_object_unref0 (_data_->cl);
		_g_object_unref0 (_data_->play);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->play;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->prop;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14_ = mpris_client_new (_data_->_tmp12_, _data_->_tmp13_);
	_g_object_unref0 (_data_->cl);
	_data_->cl = _data_->_tmp14_;
	_data_->result = _data_->cl;
	_g_object_unref0 (_data_->prop);
	_g_object_unref0 (_data_->play);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->prop);
	_g_object_unref0 (_data_->cl);
	_g_object_unref0 (_data_->play);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



