/* VolumeItem.c generated by valac 0.32.1, the Vala compiler
 * generated from VolumeItem.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright (C) 2015-2016 Solus Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define TYPE_LIST_ITEM (list_item_get_type ())
#define LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_ITEM, ListItem))
#define LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_ITEM, ListItemClass))
#define IS_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_ITEM))
#define IS_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_ITEM))
#define LIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_ITEM, ListItemClass))

typedef struct _ListItem ListItem;
typedef struct _ListItemClass ListItemClass;
typedef struct _ListItemPrivate ListItemPrivate;

#define TYPE_VOLUME_ITEM (volume_item_get_type ())
#define VOLUME_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VOLUME_ITEM, VolumeItem))
#define VOLUME_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VOLUME_ITEM, VolumeItemClass))
#define IS_VOLUME_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VOLUME_ITEM))
#define IS_VOLUME_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VOLUME_ITEM))
#define VOLUME_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VOLUME_ITEM, VolumeItemClass))

typedef struct _VolumeItem VolumeItem;
typedef struct _VolumeItemClass VolumeItemClass;
typedef struct _VolumeItemPrivate VolumeItemPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ListItem {
	GtkBox parent_instance;
	ListItemPrivate * priv;
	gchar* item_class;
	gchar* category_name;
	GtkToolButton* name_button;
	GtkOverlay* overlay;
	GtkSpinner* spin;
};

struct _ListItemClass {
	GtkBoxClass parent_class;
};

struct _VolumeItem {
	ListItem parent_instance;
	VolumeItemPrivate * priv;
};

struct _VolumeItemClass {
	ListItemClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	VolumeItem* self;
	GMountOperation* operation;
	GVolume* volume;
};


static gpointer volume_item_parent_class = NULL;
static GType volume_item_type_id = 0;

GType list_item_get_type (void) G_GNUC_CONST;
GType list_item_register_type (GTypeModule * module);
GType volume_item_get_type (void) G_GNUC_CONST;
GType volume_item_register_type (GTypeModule * module);
enum  {
	VOLUME_ITEM_DUMMY_PROPERTY
};
VolumeItem* volume_item_new (GVolume* volume);
VolumeItem* volume_item_construct (GType object_type, GVolume* volume);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
ListItem* list_item_construct (GType object_type);
void list_item_set_button (ListItem* self, const gchar* label, GtkImage* image, gboolean spinner);
GtkImage* list_item_get_icon (ListItem* self, GIcon* icon);
static void ___lambda8_ (Block2Data* _data2_);
static void __lambda9_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res);
static void ___lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ____lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda10_ (Block2Data* _data2_);
static void __lambda11_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res);
void list_item_open_directory (ListItem* self, const gchar* location);
static void ___lambda11__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda10__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void g_cclosure_user_marshal_VOID__STRING_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		VolumeItem* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->operation);
		_g_object_unref0 (_data2_->volume);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void __lambda9_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res) {
	VolumeItem* self;
	GError * _inner_error_ = NULL;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	{
		GVolume* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		gchar* safe_remove = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* device_name = NULL;
		GVolume* _tmp4_ = NULL;
		GDrive* _tmp5_ = NULL;
		GDrive* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		_tmp0_ = _data2_->volume;
		_tmp1_ = res;
		g_volume_eject_with_operation_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_tmp2_ = _ ("You can now safely remove");
		_tmp3_ = g_strdup (_tmp2_);
		safe_remove = _tmp3_;
		_tmp4_ = _data2_->volume;
		_tmp5_ = g_volume_get_drive (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_drive_get_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		device_name = _tmp8_;
		_tmp9_ = safe_remove;
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = device_name;
		_tmp12_ = string_to_string (_tmp11_);
		_tmp13_ = g_strconcat (_tmp10_, " \"", _tmp12_, "\"", NULL);
		_tmp14_ = _tmp13_;
		g_signal_emit_by_name (self, "send-message", _tmp14_, GTK_MESSAGE_INFO);
		_g_free0 (_tmp14_);
		_g_free0 (device_name);
		_g_free0 (safe_remove);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		g_signal_emit_by_name (self, "send-message", _tmp16_, GTK_MESSAGE_ERROR);
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_warning ("VolumeItem.vala:61: %s", _tmp18_);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda9_ (self, source_object, res);
	block2_data_unref (self);
}


static void ___lambda8_ (Block2Data* _data2_) {
	VolumeItem* self;
	GVolume* _tmp0_ = NULL;
	GMountOperation* _tmp1_ = NULL;
	self = _data2_->self;
	_tmp0_ = _data2_->volume;
	_tmp1_ = _data2_->operation;
	g_volume_eject_with_operation (_tmp0_, G_MOUNT_UNMOUNT_NONE, _tmp1_, NULL, ___lambda9__gasync_ready_callback, block2_data_ref (_data2_));
}


static void ____lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	___lambda8_ (self);
}


static void __lambda11_ (Block2Data* _data2_, GObject* obj, GAsyncResult* res) {
	VolumeItem* self;
	GtkSpinner* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	self = _data2_->self;
	g_return_if_fail (res != NULL);
	{
		GVolume* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		GVolume* _tmp2_ = NULL;
		GMount* _tmp3_ = NULL;
		GMount* _tmp4_ = NULL;
		GFile* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp0_ = _data2_->volume;
		_tmp1_ = res;
		g_volume_mount_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		_tmp2_ = _data2_->volume;
		_tmp3_ = g_volume_get_mount (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_mount_get_root (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_file_get_uri (_tmp6_);
		_tmp8_ = _tmp7_;
		list_item_open_directory ((ListItem*) self, _tmp8_);
		_g_free0 (_tmp8_);
		_g_object_unref0 (_tmp6_);
		_g_object_unref0 (_tmp4_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_signal_emit_by_name (self, "send-message", _tmp10_, GTK_MESSAGE_ERROR);
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("VolumeItem.vala:76: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = ((ListItem*) self)->spin;
	gtk_spinner_stop (_tmp13_);
}


static void ___lambda11__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda11_ (self, source_object, res);
	block2_data_unref (self);
}


static void __lambda10_ (Block2Data* _data2_) {
	VolumeItem* self;
	GtkSpinner* _tmp0_ = NULL;
	GVolume* _tmp1_ = NULL;
	GMountOperation* _tmp2_ = NULL;
	self = _data2_->self;
	_tmp0_ = ((ListItem*) self)->spin;
	gtk_spinner_start (_tmp0_);
	_tmp1_ = _data2_->volume;
	_tmp2_ = _data2_->operation;
	g_volume_mount (_tmp1_, G_MOUNT_MOUNT_NONE, _tmp2_, NULL, ___lambda11__gasync_ready_callback, block2_data_ref (_data2_));
}


static void ___lambda10__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda10_ (self);
}


VolumeItem* volume_item_construct (GType object_type, GVolume* volume) {
	VolumeItem * self = NULL;
	Block2Data* _data2_;
	GVolume* _tmp0_ = NULL;
	GVolume* _tmp1_ = NULL;
	GVolume* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GQuark _tmp7_ = 0U;
	static GQuark _tmp6_label0 = 0;
	static GQuark _tmp6_label1 = 0;
	static GQuark _tmp6_label2 = 0;
	GVolume* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	GVolume* _tmp21_ = NULL;
	GIcon* _tmp22_ = NULL;
	GIcon* _tmp23_ = NULL;
	GtkImage* _tmp24_ = NULL;
	GtkImage* _tmp25_ = NULL;
	GMountOperation* _tmp26_ = NULL;
	GMountOperation* _tmp27_ = NULL;
	GVolume* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	GtkToolButton* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	GVolume* _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	gchar* _tmp47_ = NULL;
	GtkToolButton* _tmp48_ = NULL;
	g_return_val_if_fail (volume != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = volume;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data2_->volume);
	_data2_->volume = _tmp1_;
	self = (VolumeItem*) list_item_construct (object_type);
	_data2_->self = g_object_ref (self);
	_tmp2_ = _data2_->volume;
	_tmp3_ = g_volume_get_identifier (_tmp2_, "class");
	_g_free0 (((ListItem*) self)->item_class);
	((ListItem*) self)->item_class = _tmp3_;
	_tmp4_ = ((ListItem*) self)->item_class;
	_tmp5_ = _tmp4_;
	_tmp7_ = (NULL == _tmp5_) ? 0 : g_quark_from_string (_tmp5_);
	if (_tmp7_ == ((0 != _tmp6_label0) ? _tmp6_label0 : (_tmp6_label0 = g_quark_from_static_string ("device")))) {
		switch (0) {
			default:
			{
				GVolume* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
				_tmp8_ = _data2_->volume;
				_tmp9_ = g_volume_can_eject (_tmp8_);
				if (_tmp9_) {
					const gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					_tmp10_ = _ ("Removable devices");
					_tmp11_ = g_strdup (_tmp10_);
					_g_free0 (((ListItem*) self)->category_name);
					((ListItem*) self)->category_name = _tmp11_;
				} else {
					const gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
					_tmp12_ = _ ("Local volumes");
					_tmp13_ = g_strdup (_tmp12_);
					_g_free0 (((ListItem*) self)->category_name);
					((ListItem*) self)->category_name = _tmp13_;
				}
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label1) ? _tmp6_label1 : (_tmp6_label1 = g_quark_from_static_string ("network")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				_tmp14_ = _ ("Network folders");
				_tmp15_ = g_strdup (_tmp14_);
				_g_free0 (((ListItem*) self)->category_name);
				((ListItem*) self)->category_name = _tmp15_;
				break;
			}
		}
	} else if (_tmp7_ == ((0 != _tmp6_label2) ? _tmp6_label2 : (_tmp6_label2 = g_quark_from_static_string (NULL)))) {
		switch (0) {
			default:
			{
				const gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				_tmp16_ = _ ("Other");
				_tmp17_ = g_strdup (_tmp16_);
				_g_free0 (((ListItem*) self)->category_name);
				((ListItem*) self)->category_name = _tmp17_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	_tmp18_ = _data2_->volume;
	_tmp19_ = g_volume_get_name (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = _data2_->volume;
	_tmp22_ = g_volume_get_symbolic_icon (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = list_item_get_icon ((ListItem*) self, _tmp23_);
	_tmp25_ = _tmp24_;
	list_item_set_button ((ListItem*) self, _tmp20_, _tmp25_, TRUE);
	_g_object_unref0 (_tmp25_);
	_g_object_unref0 (_tmp23_);
	_g_free0 (_tmp20_);
	_tmp26_ = g_mount_operation_new ();
	_data2_->operation = _tmp26_;
	_tmp27_ = _data2_->operation;
	g_mount_operation_set_password_save (_tmp27_, G_PASSWORD_SAVE_FOR_SESSION);
	_tmp28_ = _data2_->volume;
	_tmp29_ = g_volume_can_eject (_tmp28_);
	if (_tmp29_) {
		GtkButton* eject_button = NULL;
		GtkButton* _tmp30_ = NULL;
		GtkButton* _tmp31_ = NULL;
		GtkStyleContext* _tmp32_ = NULL;
		GtkButton* _tmp33_ = NULL;
		GtkButton* _tmp34_ = NULL;
		GtkButton* _tmp35_ = NULL;
		GtkButton* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		GtkOverlay* _tmp38_ = NULL;
		GtkButton* _tmp39_ = NULL;
		GtkButton* _tmp40_ = NULL;
		_tmp30_ = (GtkButton*) gtk_button_new_from_icon_name ("media-eject-symbolic", GTK_ICON_SIZE_MENU);
		g_object_ref_sink (_tmp30_);
		eject_button = _tmp30_;
		_tmp31_ = eject_button;
		_tmp32_ = gtk_widget_get_style_context ((GtkWidget*) _tmp31_);
		gtk_style_context_add_class (_tmp32_, "unmount-button");
		_tmp33_ = eject_button;
		gtk_button_set_relief (_tmp33_, GTK_RELIEF_NONE);
		_tmp34_ = eject_button;
		gtk_widget_set_can_focus ((GtkWidget*) _tmp34_, FALSE);
		_tmp35_ = eject_button;
		gtk_widget_set_halign ((GtkWidget*) _tmp35_, GTK_ALIGN_END);
		_tmp36_ = eject_button;
		_tmp37_ = _ ("Eject");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp36_, _tmp37_);
		_tmp38_ = ((ListItem*) self)->overlay;
		_tmp39_ = eject_button;
		gtk_overlay_add_overlay (_tmp38_, (GtkWidget*) _tmp39_);
		_tmp40_ = eject_button;
		g_signal_connect_data (_tmp40_, "clicked", (GCallback) ____lambda8__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
		_g_object_unref0 (eject_button);
	}
	_tmp41_ = ((ListItem*) self)->name_button;
	_tmp42_ = _ ("Mount and open \"%s\"");
	_tmp43_ = _data2_->volume;
	_tmp44_ = g_volume_get_name (_tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = g_strdup_printf (_tmp42_, _tmp45_);
	_tmp47_ = _tmp46_;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp41_, _tmp47_);
	_g_free0 (_tmp47_);
	_g_free0 (_tmp45_);
	_tmp48_ = ((ListItem*) self)->name_button;
	g_signal_connect_data (_tmp48_, "clicked", (GCallback) ___lambda10__gtk_tool_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return self;
}


VolumeItem* volume_item_new (GVolume* volume) {
	return volume_item_construct (TYPE_VOLUME_ITEM, volume);
}


static void g_cclosure_user_marshal_VOID__STRING_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_ENUM) (gpointer data1, const char* arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_enum (param_values + 2), data2);
}


static void volume_item_class_init (VolumeItemClass * klass) {
	volume_item_parent_class = g_type_class_peek_parent (klass);
	g_signal_new ("send_message", TYPE_VOLUME_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_ENUM, G_TYPE_NONE, 2, G_TYPE_STRING, GTK_TYPE_MESSAGE_TYPE);
}


static void volume_item_instance_init (VolumeItem * self) {
}


GType volume_item_get_type (void) {
	return volume_item_type_id;
}


GType volume_item_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (VolumeItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) volume_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VolumeItem), 0, (GInstanceInitFunc) volume_item_instance_init, NULL };
	volume_item_type_id = g_type_module_register_type (module, TYPE_LIST_ITEM, "VolumeItem", &g_define_type_info, 0);
	return volume_item_type_id;
}



