#!/usr/bin/perl

use strict;
use warnings;

use Benchmark qw(:all);

my $hexdigest = 'a' x 64;
my $file = 'test';
my %data;
my %hash_length = (32 => 'md5',
		   40 => 'sha1',
		   64 => 'sha256');

cmpthese(-1, {
	      'Switch' =>
	      sub {
		  for (my $len = length($hexdigest)) { # Select algorithm based on hex length
		      $len == 32 # md5sum:
			&& do { $data{$file}{md5}=$hexdigest; last; };
		      $len == 40 # sha1
			&& do { $data{$file}{sha1}=$hexdigest; last; };
		      $len == 64 # sha256:
			&& do { $data{$file}{sha256}=$hexdigest; last; };
		  }
	      },
	      'Hash' =>
	      sub {
		  my $len = length($hexdigest);
		  if (exists $hash_length{$len}) {
		      $data{$file}{$len} = $hexdigest;
		  }
	      }
	     });
