# J.4 What trends in society aid anarchist activity?

In this section we will examine some modern trends which we regard as being
potential openings for anarchists to organise and which point in an anarchist
direction. These trends are of a general nature, partly as a product of social
struggle, partly as a response to economic and social crisis, partly involving
people's attitudes to big government and big business, partly in relation to
the communications revolution we are currently living through, and so on.

Of course, looking at modern society we see multiple influences, changes which
have certain positive aspects in some directions but negative ones in others.
For example, the business-inspired attempts to decentralise or reduce
(certain) functions of governments should in the abstract be welcomed by
anarchists for they lead to the reduction of government. In practice such a
conclusion is deeply suspect simply because these developments are being
pursued to increase the power and influence of capital as well as to increase
wage-labour to, and exploitation by, the economic master class and to
undermine working class power and autonomy. As such, they are as anti-
libertarian as the status quo (as Proudhon stressed, anarchism is _"the denial
of Government and of Property."_ [**Property is Theft!**, p. 559]). Similarly,
increases in self-employment can be seen, in the abstract, as reducing wage
slavery. However, if, in practice, this increase is due to corporations
encouraging "independent" contractors in order to cut wages and worsen working
conditions, increase job insecurity and undermine paying for health and other
employee packages then it is hardly a positive sign. Obviously increases in
self-employment would be different if it were the result of an increase in the
number of co-operatives, for example.

Thus few anarchists celebrate many apparently "libertarian" developments as
they are not the product of social movements and activism, but are the product
of elite lobbying for private profit and power. Decreasing the power of the
state in (certain) areas while leaving (or increasing) the power of capital is
a retrograde step in most, if not all, ways. Needless to say, this "rolling
back" of the state does not bring into question its role as defender of
property and the interests of the capitalist class -- nor could it, as it is
the ruling class who introduces and supports these developments.

In this section, we aim to discuss tendencies from **below**, not above --
tendencies which can truly "roll back" the state rather than reduce its
functions purely to that of the armed thug of property. The tendencies we
discuss here are not the be all nor end all of anarchist activism or
tendencies. We discuss many of the more traditionally anarchist "openings" in
[section J.5](secJ5.html) (such as industrial and community unionism, mutual
credit, co-operatives, modern schools and so on) and so will not do so here.
However, it is important to stress here that such "traditional" openings are
not being downplayed -- indeed, much of what we discuss here can only become
fully libertarian in combination with these more "traditional" forms of
**_"anarchy in action."_**

For a lengthy discussion of anarchistic trends in society, we recommend Colin
Ward's classic book **Anarchy in Action**. Ward covers many areas in which
anarchistic tendencies have been expressed, far more than we can cover here.
The libertarian tendencies in society are many. No single work could hope to
do them justice.

## J.4.1 Why is social struggle a good sign?

Simply because it shows that people are unhappy with the existing society and,
more importantly, are trying to change at least some part of it. It suggests
that certain parts of the population have reflected on their situation and,
potentially at least, seen that **by their own actions** they can influence
and change it for the better.

Given that the ruling minority draws its strength by the acceptance and
acquiescence of the majority, the fact that a part of that majority no longer
accepts and acquiesces is a positive sign. After all, if the majority did not
accept the status quo and acted to change it, the class and state system could
not survive. Any hierarchical society survives because those at the bottom
follow the orders of those above it. Social struggle suggests that some people
are considering their own interests, thinking for themselves and saying "no"
and this, by its very nature, is an important, indeed, the most important,
tendency towards anarchism. It suggests that people are rejecting the old
ideas which hold the system up, acting upon this rejection and creating new
ways of doing things.

_"Our social institutions,"_ argued Alexander Berkman, _"are founded on
certain ideas; as long as the latter are generally believed, the institutions
built upon them are safe. Government remains strong because people think
political authority and legal compulsion necessary. Capitalism will continue
as long as such an economic system is considered adequate and just. The
weakening of the ideas which support the evil and oppressive present-day
conditions means the ultimate breakdown of government and capitalism."_
[**What is Anarchism?**, p. xii]

Social struggle is the most obvious sign of this change of perspective, this
change in ideas, this progress towards freedom.

Social struggle is expressed by direct action. We have discussed both social
struggle ([section J.1](secJ1.html)) and direct action ([section
J.2](secJ2.html)) before and some readers may wonder why we are covering this
again here. We do so as we are discussing what trends in society help
anarchist activity, it would be wrong **not** to highlight social struggle and
direct action here. This is because these factors are key tendencies towards
anarchism as social struggle is the means by which people create the new world
in the shell of the old, transforming themselves and society.

So social struggle is a good sign as it suggests that people are thinking for
themselves, considering their own interests and working together collectively
to change things for the better. As the French syndicalist Emile Pouget
argued:

> _"Direct action . . . means that the working class, forever bridling at the
existing state of affairs, expects nothing from outside people, powers or
forces, but rather creates its own conditions of struggle and looks to itself
for its methodology . . . Direct Action thus implies that the working class
subscribes to notions of freedom and autonomy instead of genuflecting before
the principle of authority. Now, it is thanks to this authority principle, the
pivot of the modern world -- democracy being its latest incarnation -- that
the human being, tied down by a thousand ropes, moral as well as material, is
bereft of any opportunity to display will and initiative."_ [**Direct
Action**, p. 1]

Social struggle means that people come into opposition with the boss and other
authorities such as the state and the dominant morality. This challenge to
existing authorities generates two related processes: the tendency of those
involved to begin taking over the direction of their own activities and the
development of solidarity with each other. Firstly, in the course of a
struggle, such as a strike, occupation, boycott, and so on, the ordinary life
of people, in which they act under the constant direction of the bosses or
state, ceases, and they have to think, act and co-ordinate their actions for
themselves. This reinforces the expression towards autonomy that the initial
refusal that led to the struggle indicates. Secondly, in the process of
struggle those involved learn the importance of solidarity, of working with
others in a similar situation, in order to win. This means the building of
links of support, of common interests, of organisation. The practical need for
solidarity to help win the struggle is the basis for the solidarity required
for a free society to be viable.

Therefore the real issue in social struggle is that it is an attempt by people
to wrestle at least part of the power over their own lives away from the
managers, state officials and so on who currently have it and exercise it
themselves. This is, by its very nature, anarchistic and libertarian. Thus we
find politicians, managers and property owners denouncing strikes and other
forms of direct action. This is logical. As direct action challenges the real
power-holders in society and because, if carried to its logical conclusion, it
would remove them, social struggle and direct action can be considered in
essence a revolutionary process.

Moreover, the very act of using direct action suggests a transformation within
the people using it. _"Direct action's very powers to fertilise,"_ argued
Pouget, _"reside in such exercises in imbuing the individual with a sense of
his own worth and in extolling such worth. It marshals human resourcefulness,
tempers characters and focuses energies. It teaches self-confidence! And self-
reliance! And self-mastery! And shifting for oneself!"_ Moreover, _"direct
action has an unmatched educational value: It teaches people to reflect, to
make decisions and to act. It is characterised by a culture of autonomy, an
exaltation of individuality and is a fillip to initiative, to which it is the
leaven. And this superabundance of vitality and burgeoning of 'self' in no way
conflicts with the economic fellowship that binds the workers one with another
and far from being at odds with their common interests, it reconciles and
bolsters these: the individual's independence and activity can only erupt into
splendour and intensity by sending its roots deep into the fertile soil of
common agreement."_ [**Op. Cit.**, p. 2 and p. 5]

Social struggle is the beginning of a transformation of the people involved
and their relationships to each other. While its external expression lies in
contesting the power of existing authorities, its inner expression is the
transformation of people from passive and isolated competitors into empowered,
self-directing, self-governing co-operators. Moreover, this process widens
considerably what people think is "possible." Through struggle, by collective
action, the fact people **can** change things is driven home, that **they**
have the power to govern themselves and the society they live in. Thus
struggle can change people's conception of "what is possible" and encourage
them to try and create a better world. As Kropotkin argued:

> _"since the times of the [first] International Working Men's Association,
the anarchists have always advised taking an active part in those workers'
organisations which carry on the **direct** struggle of labour against capital
and its protector -- the State._

> _"Such a struggle . . . permits the worker to obtain some temporary
improvements . . ., while it opens his [or her] eyes to the evil that is done
by capitalism and the State . . . , and wakes up his [or her] thoughts
concerning the possibility of organising consumption, production, and exchange
without the intervention of the capitalist and the State."_ [**Anarchism**, p.
171]

In other words, social struggle has a **radicalising** and **politicising**
effect, an effect which brings into a new light existing society and the
possibilities of a better world (direct action, in Pouget's words, _"develops
the feeling for human personality as well as the spirit of initiative . . . it
shakes people out of their torpor and steers them to consciousness."_ [**Op.
Cit.**, p. 5]). The practical need to unite and resist the boss also helps
break down divisions within the working class. Those in struggle start to
realise that they need each other to give them the power necessary to get
improvements, to change things. Thus solidarity spreads and overcomes
divisions between black and white, male and female, heterosexual and
homosexual, trades, industries, nationalities and so on. The real need for
solidarity to win the fight helps to undermine artificial divisions and show
that there are only two groups in society, the oppressed and the oppressors.
Moreover, struggle as well as transforming those involved is also the basis
for transforming society as a whole simply because, as well as producing
transformed individuals, it also produces new forms of organisation,
organisations created to co-ordinate their struggle and which can, potentially
at least, become the framework of a libertarian socialist society (see
[section I.2.3](secI2.html#seci23)).

Thus anarchists argue that social struggle opens the eyes of those involved to
self-esteem and a sense of their own strength, and the groupings it forms at
its prompting are living, vibrant associations where libertarian principles
usually come to the fore. We find almost all struggles developing new forms of
organisation, forms which are often based on direct democracy, federalism and
decentralisation. If we look at every major revolution, we find people
creating mass organisations such as workers' councils, factory committees,
neighbourhood assemblies and so on as a means of taking back the power to
govern their own lives, communities and workplaces. In this way social
struggle and direct action lay the foundations for the future. By actively
taking part in social life, people are drawn into creating new forms of
organisation, new ways of doing things. In this way they educate themselves in
participation, in self-government, in initiative and in asserting themselves.
They begin to realise that the only alternative to management by others is
self-management and organise to achieve it.

Given that remaking society has to begin at the bottom, this finds its
expression in direct action, individuals taking the initiative and using the
power they have just generated by collective action and organisation to change
things by their own efforts. Social struggle is therefore a two way
transformation -- the external transformation of society by the creation of
new organisations and the changing of the power relations within it and the
internal transformation of those who take part in the struggle. This is key:

> _"Whatever may be the practical results of the struggle for immediate gains,
the greatest value lies in the struggle itself. For thereby workers learn that
the bosses interests are opposed to theirs and that they cannot improve their
conditions, and much less emancipate themselves, except by uniting and
becoming stronger than the bosses. If they succeed in getting what they
demand, they will be better off . . . and immediately make greater demands and
have greater needs. If they do not succeed they will be led to study the
causes of their failure and recognise the need for closer unity and greater
activism and they will in the end understand that to make their victory secure
and definitive, it is necessary to destroy capitalism. The revolutionary
cause, the cause of the moral elevation and emancipation of the workers must
benefit by the fact that workers unite and struggle for their interests."_
[Malatesta, **Errico Malatesta: His Life and Ideas**, p. 191]

Hence Nestor Makhno's comment that _"[i]n fact, it is only through that
struggle for freedom, equality and solidarity that you reach an understanding
of anarchism."_ [**The Struggle Against the State and other Essays**, p. 71]
The creation of an anarchist society is a **process** and social struggle is
the key anarchistic tendency within society which anarchists look for,
encourage and support. Its radicalising and transforming nature is the key to
the growth of anarchist ideas, the creation of libertarian structures and
alternatives within capitalism (structures which may, one day, replace it) and
the creation of anarchists and those sympathetic to anarchist ideas. Its
importance cannot be underestimated!

## J.4.2 Won't social struggle do more harm than good?

It is often argued that social struggle, resisting the powerful and the
wealthy, will just do more harm than good. Employers often use this approach
in anti-union propaganda, for example, arguing that creating a union will
force the company to close and move to less "militant" areas.

There is some truth in this. Yes, social struggle can lead to bosses moving to
more compliant workforces -- but this also happens in periods lacking social
struggle too! If we look at the down-sizing mania that gripped the U.S. in the
1980s and 1990s, we see companies firing tens of thousands of people during a
period when unions were weak, workers scared about losing their jobs and class
struggle basically becoming mostly informal, atomised and "underground."
Moreover, this argument actually indicates the need for anarchism. It is a
damning indictment of any social system that it requires people to kow-tow to
their masters otherwise they will suffer economic hardship. It boils down to
the argument _"do what you are told, otherwise you will regret it."_ Any
system based on that maxim is an affront to human dignity!

It would, in a similar fashion, be easy to "prove" that slave rebellions are
against the long term interests of the slaves. After all, by rebelling the
slaves will face the anger of their masters. Only by submitting without
question can they avoid this fate and, perhaps, be rewarded by better
conditions. Of course, the evil of slavery would continue but by submitting to
it they can ensure their life can become better. Needless to say, any thinking
and feeling person would quickly dismiss this reasoning as missing the point
and being little more than apologetics for an evil social system that treated
human beings as things. The same can be said for the argument that social
struggles within capitalism do more harm than good. It betrays a slave
mentality unfitting for human beings (although fitting for those who desire to
live off the backs of workers or desire to serve those who do).

Moreover, this kind of argument ignores a few key points.

Firstly, by resistance the conditions of the oppressed can be maintained or
even improved. If the boss knows that their decisions will be resisted they
may be less inclined to impose speed-ups, longer hours and so on. If, on the
other hand, they know that their employees will agree to anything then there
is every reason to expect them to impose all kinds of oppressions, just as a
state will impose draconian laws if it knows that it can get away with it.
History is full of examples of non-resistance producing greater evils in the
long term and of resistance producing numerous important reforms and
improvements (such as higher wages, shorter hours, the right to vote for
working class people and women, freedom of speech, the end of slavery, trade
union rights and so on).

So social struggle has been proven time and time again to gain successful
reforms. For example, before the 8 hour day movement of 1886 in America most
companies argued they could not introduce that reform without going bust.
However, after displaying a militant mood and conducting an extensive strike
campaign, hundreds of thousands of workers discovered that their bosses had
been lying and they got shorter hours. Indeed, the history of the labour
movement shows what bosses say they can afford and the reforms workers can get
via struggle are somewhat at odds. Given the asymmetry of information between
workers and bosses, this is unsurprising as workers can only guess at what is
available and bosses like to keep their actual finances hidden. Even the
threat of labour struggle can be enough to gain improvements. For example,
Henry Ford's $5 day is often used as an example of capitalism rewarding good
workers. However, this substantial pay increase was largely motivated by the
unionisation drive by the **Industrial Workers of the World** among Ford
workers in the summer of 1913. [Harry Braverman, **Labour and Monopoly
Capitalism**, p. 144] More recently, it was the mass non-payment campaign
against the poll-tax in Britain during the late 1980s and early 1990s which
helped ensure its defeat. In the 1990s, France also saw the usefulness of
direct action. Two successive prime ministers (Edouard Balladur and Alain
Juppe) tried to impose large scale neo-liberal "reform" programmes that
swiftly provoked mass demonstrations and general strikes amongst students,
workers, farmers and others. Confronted by crippling disruptions, both
governments gave in.

Secondly, and in some ways more importantly, the radicalising effect of social
struggle can open new doors for those involved, liberate their minds, empower
them and create the potential for deep social change. Without resistance to
existing forms of authority a free society cannot be created as people adjust
themselves to authoritarian structures and accept "what is" as the only
possibility. By resisting, people transform and empower themselves as well as
transforming society. New possibilities can be seen (possibilities before
dismissed as "utopian") and, via the organisation and action required to win
reforms, the framework for these possibilities (i.e. of a new, libertarian,
society) created. The transforming and empowering effect of social struggle is
expressed well by the Nick DiGaetano, a one-time Wobbly who had joined during
the 1912 Lawrence strike and then became a UAW-CIO shop floor militant:

> _"the workers of my generation from the early days up to now [1958] had what
you might call a labour insurrection in changing from a plain, humble,
submissive creature into a man. The union made a man out of him . . . I am not
talking about the benefits . . . I am talking about the working conditions and
how they affected the men in the plant . . . Before they were submissive.
Today they are men."_ [quoted by David Brody, _"Workplace Contractualism in
comparative perspective"_, pp. 176-205, Helson Lichtenstein and Howell John
Harris (eds.), **Industrial Democracy in America**, p. 204]

Other labour historians note the same radicalising process elsewhere (modern
day activists could give more examples!):

> _"The contest [over wages and conditions] so pervaded social life that the
ideology of acquisitive individualism, which explained and justified a society
regulated by market mechanisms and propelled by the accumulation of capital,
was challenged by an ideology of mutualism, rooted in working-class bondings
and struggles . . . Contests over pennies on or off existing piece rates had
ignited controversies over the nature and purpose of the American republic
itself."_ [David Montgomery, **The Fall of the House of Labour**, p. 171]

This radicalising effect is far more dangerous to authoritarian structures
than better pay, more liberal laws and so on as they need submissiveness to
work. Little wonder that direct action is usually denounced as pointless or
harmful by those in power or their spokespersons for direct action will, taken
to its logical conclusion, put them out of a job! Struggle, therefore, holds
the possibility of a free society as well as of improvements in the here and
now. It also changes the perspectives of those involved, creating new ideas
and values to replace the ones of capitalism.

Thirdly, it ignores the fact that such arguments do not imply the end of
social struggle and working class resistance and organisation, but rather its
**extension.** If, for example, your boss argues that they will move to Mexico
if you do not "shut up and put up" then the obvious solution is to make sure
the workers in Mexico are also organised! Bakunin argued this basic point over
one hundred years ago, and it is still true: _"in the long run the relatively
tolerable position of workers in one country can be maintained only on
condition that it be more or less the same in other countries."_ The
_"conditions of labour cannot get worse or better in any particular industry
without immediately affecting the workers in other industries, and that
workers of all trades are inter-linked with real and indissoluble ties of
solidarity."_ Ultimately, _"in those countries the workers work longer hours
for less pay; and the employers there can sell their products cheaper,
successfully competing against conditions where workers working less earn
more, and thus force the employers in the latter countries to cut wages and
increase the hours of their workers."_ [**The Political Philosophy of
Bakunin**, pp. 306-7] Bakunin's solution was to organise internationally, to
stop this undercutting of conditions by solidarity between workers. As history
shows, his argument was correct. Thus it is **not** social struggle or
militancy which perhaps could have negative results, just **isolated**
militancy, struggle which ignores the ties of solidarity required to win,
extend and keep reforms and improvements. In other words, our resistance must
be as transnational as capitalism is.

The idea that social struggle and working class organisation are harmful was
expressed constantly in the 1970s and 80s. With the post-war Keynesian
consensus crumbling, the "New Right" argued that trade unions (and strikes)
hampered growth and that wealth redistribution (i.e. welfare schemes which
returned some of the surplus value workers produced back into our own hands)
hindered "wealth creation" (i.e. economic growth). Do not struggle over
income, they argued, let the market decide and everyone will be better off.

This argument was dressed up in populist clothes. Thus we find the right-wing
guru F.A. von Hayek arguing that, in the case of Britain, the _"legalised
powers of the unions have become the biggest obstacle to raising the standards
of the working class as a whole. They are the chief cause of the unnecessarily
big differences between the best- and worse-paid workers."_ He maintained that
_"the elite of the British working class . . . derive their relative
advantages by keeping workers who are **worse off** from improving their
position."_ Moreover, he _"predict[ed] that the average worker's income would
rise fastest in a country where relative wages are flexible, and where the
exploitation of workers by monopolistic trade union organisations of
specialised workers are effectively outlawed."_ [**1980s Unemployment and the
Unions**, p. 107, p. 108 and p. 110]

Now, if von Hayek's claims were true we could expect that in the aftermath of
Thatcher government's trade union reforms we would have seen: a rise in
economic growth (usually considered as **the** means to improve living
standards for workers by the right); that this growth would be more equally
distributed; a decrease in the differences between high and low paid workers;
a reduction in the percentage of low paid workers as they improved their
positions when freed from union _"exploitation"_; and that wages rise fastest
in countries with the highest wage flexibility. Unfortunately for von Hayek,
the actual trajectory of the British economy exposed his claims as nonsense.

Looking at each of his claims in turn we discover that rather than "exploit"
other workers, trade unions are an essential means to shift income from
capital to labour (which is why capital fights labour organisers tooth and
nail). And, equally important, labour militancy aids **all** workers by
providing a floor under which wages cannot drop (non-unionised firms have to
offer similar programs to prevent unionisation and be able to hire workers)
and by maintaining aggregate demand. This positive role of unions in aiding
**all** workers can be seen by comparing Britain before and after Thatcher's
von Hayek inspired trade union and labour market reforms.

There has been a steady fall in growth in the UK since the trade union
"reforms". In the "bad old days" of the 1970s, with its strikes and "militant
unions" growth was 2.4% in Britain. It fell to 2% in the 1980s and fell again
to 1.2% in the 1990s. A similar pattern of slowing growth as wage flexibility
and market reform has increased can be seen in the US economy (it was 4.4% in
the 1960s, 3.2% in the 1970s, 2.8% in the 1980s and 1.9% in the first half of
the 1990s). [Larry Elliot and Dan Atkinson, **The Age of Insecurity**, p. 236]
Given that the free-market right proclaims higher economic growth is the only
way to make workers better off, growth rates have steadily fallen
internationally since the domination of their ideology. Thus growth of output
per head in the USA, Europe, Japan and the OECD countries between 1979 to 1990
was lower than in 1973-9, and 1990-2004 lower still. The deregulation,
privatisation, anti-union laws and other neo-liberal policies have _"failed to
bring an increase in the growth rate."_ [Andrew Glyn, **Capitalism
Unleashed**, p. 131] What growth spurts there have been were associated with
speculative bubbles (in the American economy, dot.com stocks in the late 1990s
and housing in the 2000s) which burst with disastrous consequences.

So the rate of "wealth creation" (economic growth) has steadily fallen as
unions were "reformed" in line with von Hayek's ideology (and lower growth
means that the living standards of the working class as a whole do not rise as
fast as they did under the "exploitation" of the "monopolistic" trade unions).

If we look at the differences between the highest and lowest paid workers, we
find that rather than decrease, they have in fact shown _"a dramatic widening
out of the distribution with the best-workers doing much better"_ since
Thatcher was elected in 1979 [Andrew Glyn and David Miliband (eds.), **Paying
for Inequality**, p. 100] This is important, as average figures can hide how
badly those in the bottom (80%!) are doing. In an unequal society, the gains
of growth are monopolised by the few and we would expect rising inequality
over time alongside average growth. In America inequality has dramatically
increased since the 1970s, with income and wealth growth in the 1980s going
predominately to the top 20% (and, in fact, mostly to the top 1% of the
population). The bottom 80% of the population saw their wealth grow by 1.2%
and their income by 23.7% in the 1980s, while for the top 20% the respective
figures were 98.2% and 66.3% (the figures for the top 1% were 61.6% and 38.9%,
respectively). [Edward N. Wolff, _"How the Pie is Sliced"_, **The American
Prospect**, no. 22, Summer 1995] There has been a _"fanning out of the pay
distribution"_ with the gap between the top 10% of wage-earners increasing
compared to those in the middle and bottom 10%. Significantly, in the neo-
liberal countries the rise in inequality is _"considerably higher"_ than in
European ones. In America, for example, _"real wages at the top grew by 27.2%
between 1979 and 2003 as compared to 10.2% in the middle"_ while real wages
for the bottom 10% _"did not grow at all between 1979 and 2003."_ In fact,
most of the gains in the top 10% _"occurred amongst the top 5%, and two-thirds
of it within the top 1%."_ Unsurprising, the neo-liberal countries of the UK,
USA and New Zealand saw the largest increases in inequality. [Glyn, **Op.
Cit.**, pp. 116-8 and p. 168]

Given that inequality has increased, the condition of the average worker must
have suffered. For example, Ian Gilmore states that _"[i]n the 1980s, for the
first time for fifty years . . . the poorer half of the population saw its
share of total national income shirk."_ [**Dancing with Dogma**, p. 113]
According to Noam Chomsky, _"[d]uring the Thatcher decade, the income share of
the bottom half of the population fell from one-third to one-fourth"_ and the
between 1979 and 1992, the share of total income of the top 20% grew from 35%
to 40% while that of the bottom 20% fell from 10% to 5%. In addition, the
number of UK employees with weekly pay below the Council of Europe's _"decency
threshold"_ increased from 28.3% in 1979 to 37% in 1994. [**World Orders, Old
and New**, p. 144 and p. 145] Moreover, _"[b]ack in the early 1960s, the
heaviest concentration of incomes fell at 80-90 per cent of the mean . . . But
by the early 1990s there had been a dramatic change, with the peak of the
distribution falling at just 40-50 per cent of the mean. One-quarter of the
population had incomes below half the average by the early 1990s as against 7
per cent in 1977 and 11 per cent in 1961."_ [Elliot and Atkinson, **Op.
Cit.**, p. 235] _"Overall,"_ notes Takis Fotopoulos, _"average incomes
increased by 36 per cent during this period [1979-1991/2], but 70 per cent of
the population had a below average increase in their income."_ [**Towards an
Inclusive Democracy**, p. 113]

The reason for this rising inequality is not difficult to determine. When
workers organise and strike, they can keep more of what they produce in their
own hands. The benefits of productivity growth, therefore, can be spread. With
unions weakened, such gains will accumulate in fewer hands and flood upwards.
This is precisely what happened. Before (approximately) 1980 and the neo-
liberal assault on unions, productivity and wages rose hand-in-hand in
America, afterward productivity continued to rise while wages flattened. In
fact, the value of the output of an average worker _"has risen almost 50
percent since 1973. Yet the growing concentration of income in the hands of a
small minority had proceeded so rapidly that we're not sure whether the
typical American has gained **anything** from rising productivity."_ Rather
than "trickle down" _"the lion's share of economic growth in America over the
past thirty years has gone to a small, wealthy minority."_ In short: _"The big
winners . . . have been members of a very narrow elite: the top 1 percent or
less of the population."_ [Paul Krugman, **The Conscience of a Liberal**, p.
124, p. 244 and p. 8]

Looking at America, after the Second World War the real income of the typical
family ("exploited" by "monopolistic" trade unions) grew by 2.7% per year,
with _"incomes all through the income distribution grew at about the same
rate."_ Since 1980 (i.e., after working people were freed from the tyranny of
unions), _"medium family income has risen only about 0.7 percent a year"_
Median household income _"grew modestly"_ from 1973 to 2005, the total gain
was about 16%. Yet this _"modest gain"_ may _"overstate"_ how well American
families were doing, as it _was achieved in part through longer working
hours._ For example, _"a gain in family income that occurs because a spouse
goes to work isn't the same thing as a wage increase. In particular it may
carry hidden costs that offset some of the gains in money."_ This stagnation
is, of course, being denied by the right. Yet, as Krugman memorably puts it:
_"Modern economists debate whether American median income has risen or fallen
since the early 1970s. What's really telling is the fact that we're even
having this debate."_ So while the average values may have gone up, because of
_"rising inequality, good performance in overall numbers like GDP hasn't
translated into gains for ordinary workers."_ [**Op. Cit.**, p. 55, pp. 126-7,
p. 124 and p. 201]

Luckily for American capitalism a poll in 2000 found that 39% of Americans
believe they are either in the wealthiest 1% or will be there _"soon"_! [Glyn,
**Op. Cit.**, p. 179] In fact, as we discussed in [section
B.7.2](secB7.html#sec72), social mobility has **fallen** under neo-liberalism
-- perhaps unsurprisingly as it is easier to climb a hill than a mountain.
This is just as important as the explosion in inequality as the “free-market”
right argue that dynamic social mobility makes up for wealth and income
inequality. As Krugman notes, Americans _"may believe that anyone can succeed
through hard work and determination, but the facts say otherwise."_ In
reality, mobility is _"highest in the Scandinavian countries, and most results
suggest that mobility is lower in the United States than it is in France,
Canada, and maybe even in Britain. Not only don't Americans have equal
opportunity, opportunity is less equal here than elsewhere in the West."_
Without the blinkers of free market capitalist ideology this should be
unsurprising: _"A society with highly unequal results is, more or less
inevitably, a society with highly unequal opportunity, too."_ [**Op. Cit.**,
p. 247 and p. 249]

Looking at the claim that trade union members gained their _"relative
advantage by keeping workers who are **worse off** from improving their
position"_ it would be fair to ask whether the percentage of workers in low-
paid jobs decreased in Britain after the trade union reforms. In fact, the
percentage of workers below the Low Pay Unit's definition of low pay (namely
two-thirds of men's median earnings) **increased** \-- from 16.8% in 1984 to
26.2% in 1991 for men, 44.8% to 44.9% for women. For manual workers it rose by
15% to 38.4%, and for women by 7.7% to 80.7% (for non-manual workers the
figures were 5.4% rise to 13.7% for men and a 0.5% rise to 36.6%). [Andrew
Glyn and David Miliband (eds.), **Op. Cit.**, p.102] If unions **were**
gaining at the expense of the worse off, you would expect a **decrease** in
the number in low pay, **not** an increase. An OECD study concluded that
_"[t]ypically, countries with high rates of collective bargaining and trade
unionisation tend to have low incidence of low paid employment."_ [**OECD
Employment Outlook**, 1996, p. 94] Within America, we also discover that
higher union density is associated with fewer workers earning around the
minimum wage and that "right-to-work" states (i.e., those that pass anti-union
laws) _"tend to have lower wages, lower standard of living, and more workers
earning around the minimum wage."_ It is hard not to conclude that states
_"passed laws aimed at making unionisation more difficult would imply that
they sought to maintain the monopoly power of employers at the expense of
workers."_ [Oren M. Levin-Waldman, _"The Minimum Wage and Regional Wage
Structure: Implications for Income Distribution"_, pp. 635-57, **Journal of
Economic Issues**, Vol. XXXVI, No. 3, p. 639 and p. 655]

As far as von Hayek's prediction on wage flexibility leading to the _"average
worker's income"_ rising fastest in a country where relative wages are
flexible, it has been proved totally wrong. Between 1967 and 1971, real wages
grew (on average) by 2.95% per year in the UK (nominal wages grew by 8.94%)
[P. Armstrong, A. Glyn and J. Harrison, **Capitalism Since World War II**, p.
272]. In comparison, real household disposable income grew by just 0.5 percent
between June 2006 and 2007. Average weekly earnings rose 2.9% between April
2006 and 2007 while inflation rose by 3.6% (Retail Prices Index) and 2.8%
(Consumer Prices Index). [Elliot and Atkinson, **The Gods That Failed**, p.
163] This is part of a general pattern, with UK Real Wages per employee being
an average 3.17% per year between 1960 and 1974, falling to 1.8% between 1980
and 1999. In America, the equivalent figures are 2.37% and 1.02%. [Eckhard
Hein and Thorsten Schulten, **Unemployment, Wages and Collective Bargaining in
the European Union**, p. 9] Looking at the wider picture, during the early
1970s when strikes and union membership increased, _"real wage increases rose
steadily to reach over 4% per year"_ in the West. However, after von Hayek's
anti-union views were imposed, _"real wages have grown very slowly."_ In anti-
union America, the median wage was $13.62 in 2003 compared to $12.36 in 1979
(reckoned in 2003 prices). In Europe and Japan _"average wages have done only
a little better, having grown around 1% per year."_ [Glyn, **Op. Cit.**, p. 5
and p. 116] It gets worse as these are average figures. Given that inequality
soared during this period the limited gains of the neo-liberal era were not
distributed as evenly as before (in the UK, for example, wage growth was
concentrated at the top end of society. [Elliot and Atkinson, **Fantasy
Island**, p. 99]).

Nor can it be said that breaking the unions and lower real wages translated
into lower unemployment in the UK as the average unemployment rate between
1996 and 1997 was 7.1% compared to 4.5% between 1975 and 1979 (the year
Thatcher took power). The average between 1960 and 1974 was 1.87% compared to
8.7% over the whole Thatcherite period of 1980 to 1999. Perhaps this is not
too surprising, given that (capitalist economic theology aside) unemployment
_"systematically weakens the bargaining power of trade unions."_ In short:
_"Neither on the theoretical nor empirical level can a strictly inverse
relation between the real wage rate and the level of unemployment be
derived."_ [Hein and Schulten, **Op. Cit.**, p. 9, p. 3 and p. 2] As we
discussed in [section C.1.5](secC1.html#secc15) this should come as no
surprise to anyone with awareness of the real nature of unemployment and the
labour market. So unemployment did not fall after the trade union reforms,
quite the reverse: _"By the time Blair came to power [in 1997], unemployment
in Britain was falling, although it still remained higher than it had been
when the [last Labour Government of] Callaghan left office in May 1979."_
[Elliot and Atkinson, **Age of Insecurity**, p. 258] To be fair, von Hayek did
argue that falls in unemployment would be _"a slow process"_ but nearly 20
years of far higher unemployment is moving backwards!

So we have a stark contrast between the assertions of the right and the
reality their ideology helped create. The reason for this difference is not
hard to discover. As economist Paul Krugman correctly argues unions _"raise
average wages for their membership; they also, indirectly and to a lesser
extent, raise wages for similar workers . . . as nonunionised employers try to
diminish the appeal of union drives to their workers . . . unions tend to
narrow income gaps among blue-collar workers, by negotiating bigger wage
increases for their worse-paid members . . . And nonunion employers, seeking
to forestall union organisers, tend to echo this effect."_ He argues that _"if
there's a single reason blue-collar workers did so much better in the fifties
than they had in the twenties, it was the rise of unions"_ and that unions
_"were once an important factor limiting income inequality, both because of
their direct effect in raising their members’ wages and because the union
pattern of wage settlements . . . was . . . reflected in the labour market as
a whole."_ With the smashing of the unions came rising inequality, with the
_"sharpest increases in wage inequality in the Western world have taken place
in the United States and in Britain, both of which experience sharp declines
in union membership."_ Unions restrict inequality because _"they act as a
countervailing force to management."_ [**Op. Cit.**, p. 51, p. 49, p. 149 and
p. 263]

So under the neo-liberal regime instigated by Thatcher and Reagan the power,
influence and size of the unions were reduced considerably and real wage
growth fell considerably -- which is the **exact** opposite of von Hayek's
predictions. Flexible wages and weaker unions have harmed the position of
**all** workers (Proudhon: _"Contrary to all expectation! It takes an
economist not to expect these things"_ [**System of Economical
Contradictions**, p. 203]). So comparing the claims of von Hayek to what
actually happened after trade union "reform" and the reduction of class
struggle suggests that claims that social struggle is self-defeating are false
(and self-serving, considering it is usually bosses, employer supported
parties and economists who make these claims). A **lack** of social struggle
has been correlated with low economic growth and often stagnant (even
declining) wages. So while social struggle **may** make capital flee and other
problems, lack of it is no guarantee of prosperity (quite the reverse, if the
last quarter of the 20th century is anything to go by). Indeed, a lack of
social struggle will make bosses be more likely to cut wages, worsen working
conditions and so on -- after all, they feel they can get away with it! Which
brings home the fact that to make reforms last it is necessary to destroy
capitalism.

Of course, no one can **know** that struggle will make things better. It is a
guess; no one can predict the future. Not all struggles are successful and
many can be very difficult. If the _"military is a role model for the business
world"_ (in the words of an ex-CEO of Hill &amp; Knowlton Public Relations),
and it is, then **any** struggle against it and other concentrations of power
may, and often is, difficult and dangerous at times. [quoted by John Stauber
and Sheldon Rampton in **Toxic Sludge Is Good For You!**, p. 47] But, as
Zapata once said, _"better to die on your feet than live on your knees!"_ All
we can say is that social struggle can and does improve things and, in terms
of its successes and transforming effect on those involved, well worth the
potential difficulties it can create. Moreover, without struggle there is
little chance of creating a free society, dependent as it is on individuals
who refuse to bow to authority and have the ability and desire to govern
themselves. In addition, social struggle is always essential, not only to
**win** improvements, but to **keep** them as well. In order to fully secure
improvements you have to abolish capitalism and the state. Not to do so means
that any reforms can and will be taken away (and if social struggle does not
exist, they will be taken away sooner rather than later). Ultimately, most
anarchists would argue that social struggle is not an option -- we either do
it or we put up with the all the petty (and not so petty) impositions of
authority. If we do not say "no" then the powers that be will walk all over
us.

As the history of neo-liberalism shows, a lack of social struggle is fully
compatible with worsening conditions. Ultimately, if you want to be treated as
a human being you have to stand up for your dignity -- and that means thinking
and rebelling. As Bakunin argued in **God and the State**, human freedom and
development is based on these. Without rebellion, without social struggle,
humanity would stagnate beneath authority forever and never be in a position
to be free. So anarchists agree wholeheartedly with the Abolitionist Frederick
Douglass:

> _"If there is no struggle, there is no progress. Those who profess to favour
freedom, and yet depreciate agitation, are men who want crops without
ploughing up the ground. They want rain without thunder and lightning. They
want the ocean without the awful roar of its many waters._

> _"This struggle may be a moral one; or it may be a physical one; or it may
be both moral and physical; but it must be a struggle. Power concedes nothing
without a demand. It never did and it never will. Find out just what a people
will submit to, and you have found out the exact amount of injustice and wrong
which will be imposed upon them; and these will continue till they are
resisted with either words or blows, or with both. The limits of tyrants are
prescribed by the endurance of those whom they oppress."_ [**The Life and
Writings of Frederick Douglass**, vol. 2, p. 437]

Of course, being utterly wrong has not dented von Hayek's reputation with the
right nor stopped him being quoted in arguments in favour of flexibility and
free market reforms (what can we expect? The right still quote Milton Friedman
whose track-record was equally impressive). Still, why let the actual
development of the economies influenced by von Hayek's ideology get in the
way? Perhaps it is fortunate that he once argued that economic theories can
_"never be verified or falsified by reference to facts. All that we can and
must verify is the presence of our assumptions in the particular case."_
[**Individualism and Economic Order**, p. 73] With such a position all is
saved -- the obvious problem is that capitalism is still not pure enough and
the "reforms" must not only continue but be made deeper... As Kropotkin
stressed, _"economists who continue to consider economic forces alone . . .
without taking into account **the ideology of the State**, or the forces that
each State necessarily places at the service of the rich . . . remain
completely outside the realities of the economic and social world."_ [quoted
by Ruth Kinna, _"Fields of Vision: Kropotkin and Revolutionary Change"_, pp.
67-86, **SubStance**, Vol. 36, No. 2, pp. 72-3]

And, needless to say, while three decades of successful capitalist class war
goes without mention in polite circles, documenting its results gets you
denounced as advocating "class war"! It is more than pass the time when
working class people _should_ wage a class war -- particularly given the
results of not doing so.

## J.4.3 Are the new social movements a positive development for anarchists?

When assessing the revolutionary potential of our own era, we must note again
that modern civilisation is under constant pressure from the potential
catastrophes of social breakdown, ecological destruction, and proliferating
weapons of mass destruction. These crises have drawn attention as never before
to the inherently counter-evolutionary nature of the authoritarian paradigm,
making more and more people aware that the human race is headed for extinction
if it persists in outmoded forms of thought and behaviour. This awareness
produces a favourable climate for the reception of new ideas, and thus an
opening for radical educational efforts aimed at creating the mass
transformation of consciousness which must take place alongside the creation
of new liberatory institutions.

This receptiveness to new ideas has led to a number of new social movements in
recent years. From the point of view of anarchism, the four most important of
these are perhaps the feminist, ecology, peace, and social justice movements.
Each of these movements contain a great deal of anarchist content,
particularly insofar as they imply the need for decentralisation and direct
democracy. Since we have already commented on the anarchist aspects of the
ecology and feminist movements, here we will limit our remarks to the peace
and social justice movements.

It is clear to many members of the peace movement that international
disarmament, like the liberation of women, saving the planet's ecosystem, and
preventing social breakdown, can never be attained without a shift of mass
consciousness involving widespread rejection of hierarchy, which is based on
the authoritarian principles of domination and exploitation. As C. George
Bennello argued: _"Since peace involves the positive process of replacing
violence by other means of settling conflict . . . it can be argued that some
sort of institutional change is necessary. For if insurgency is satisfied with
specific reform goals, and does not seek to transform the institutional
structure of society by getting at its centralised make-up, the war system
will probably not go away. This is really what we should mean by
decentralising: making institutions serve human ends again by getting humans
to be responsible at every level within them."_ [**From the Ground Up**, p.
31]

When pursued along gender, class, racial, ethnic, or national lines,
domination and exploitation are the primary causes of resentment, hatred,
anger, and hostility, which often explode into individual or organised
violence. Given this, both domestic and international peace depend on
decentralisation, i.e. dismantling hierarchies, thus replacing domination and
exploitation by the anarchist principles of co-operation and mutual aid.

Direct democracy is the other side of decentralisation. In order for an
organisation to spread power horizontally rather than concentrating it at the
apex of a hierarchy, all of its members have to have an equal voice in making
the decisions that affect them. Hence decentralisation implies self-
management. So, anarchists argue, the peace movement implies anarchism because
world peace is impossible without both decentralisation and direct democracy
(_"a federated people would be a people organised for peace; what would they
do with armies?"_ [Proudhon, **Property is Theft!**, p. 719]). As Benello
correctly argued, the _"anarchist perspective has an unparalleled relevance
today because prevailing nuclear policies can be considered as an ultimate
stage in the divergence between the interests of governments and their peoples
. . . the implications when revealed serve to raise fundamental questions
regarding the advisability of entrusting governments with questions of life
and death . . . There is thus a pressing impetus to re-think the role, scale,
and structure of national governments."_ Moreover, _"[s]o long as profits are
tied to defence production, speaking truth to the elites involved is not
likely to get very far"_ as _"it is only within the boundaries of the profit
system that the corporate elites would have any space to move."_ [**Op.
Cit.**, p. 138 and p. 34] Thus the peace movement implicitly contains a
libertarian critique of both forms of the power system -- the political and
economical.

In addition, certain of the practical aspects of the peace movement also
suggest anarchistic elements. The use of non-violent direct action to protest
against the war machine can only be viewed as a positive development by
anarchists. Not only does it use effective, anarchistic methods of struggle it
also radicalises those involved, making them more receptive to anarchist ideas
and analysis.

If we look at the implications of _"nuclear free zones"_ we can detect
anarchistic tendencies within them. A nuclear free zone involves a town or
region declaring an end of its association with the nuclear military
industrial complex. They prohibit the research, production, transportation and
deployment of nuclear weapons as well as renouncing the right to be defended
by nuclear power. This movement was popular in the 1980s, with many areas in
Europe and the Pacific Basin declaring that they were nuclear free zones. As
Benello pointed out, _"[t]he development of campaigns for nuclear free zones
suggests a strategy which can educate and radicalise local communities.
Indeed, by extending the logic of the nuclear free zone idea, we can begin to
flesh out a libertarian municipalist perspective which can help move our
communities several steps towards autonomy from both the central government
and the existing corporate system."_ While the later development of these
initiatives did not have the radicalising effects that Benello hoped for, they
did _"represent a local initiative that does not depend on the federal
government for action. Thus it is a step toward local empowerment . . . Steps
that increase local autonomy change the power relations between the centre and
its colonies . . . The nuclear free zone movement has a thrust which is
clearly congruent with anarchist ideas . . . The same motives which go into
the declaration of a nuclear free zone would dictate that in other areas where
the state and the corporate systems services are dysfunctional and involve
excessive costs, they should be dispensed with."_ [**Op. Cit.**, p. 137 and
pp. 140-1]

The social justice movement is composed of people seeking fair and
compassionate solutions to problems such as poverty, unemployment, economic
exploitation, discrimination, poor housing, lack of health insurance, wealth
and income inequalities, and the like. In the aftermath of decades of
especially single-minded pursuit of enriching the few by impoverishing the
many by neo-liberal administrations, the United States, for example, is
reaping the grim harvest: wages stagnate, personal debt soars, homelessness
stalks the streets; social welfare budgets are slashed to the bone while
poverty, unemployment, and underemployment grow; sweatshops mushrooming in the
large cities; millions of Americans without any health insurance while others
face rocketing costs; obscene wealth inequalities and falling social mobility;
and so on. Britain under the neo-liberal policies of Thatcher, Major and Blair
experienced a social deterioration similar to that in the US.

It is not difficult to show that the major problems concerning the social
justice movement can all be traced back to hierarchy and domination. For,
given the purpose of hierarchy, the highest priority of the elites who control
the state is necessarily to maintain their own power and privileges,
regardless of the suffering involved for subordinate classes.

In short, social injustice is inherent in the exploitative functions of the
state, which are made possible by the authoritarian form of state
institutions. Similarly, the authoritarian structure of capitalist companies
gives rise to social injustice due to exploitation producing massive income
differentials and wealth disparity between owners/management and labour. Hence
the success of the social justice movement, like that of the feminist,
ecology, and peace movements, depends on dismantling hierarchies. This means
not only that these movements all imply anarchism but that they are related in
such a way that it is impossible to conceive one of them achieving its goals
in isolation from any of the others. To take just one example, let us consider
the relationship between social justice and peace, which can be seen by
examining a specific social justice issue: labour rights.

The production of advanced weapons systems is highly profitable for
capitalists, which is why more technologically complex and precise weapons
keep getting built with government help (with the public paying the tab by way
of taxes). Now, we may reasonably argue that it is a fundamental human right
to be able to choose freely whether or not one will personally contribute to
the production of technologies that could lead to the extinction of the human
race. Yet because of the authoritarian form of the capitalist corporation,
rank-and-file workers have virtually no say in whether the companies for which
they work will produce such technologies. (To the objection that workers can
always quit if they don't like company policy, the reply is that they may not
be able to find other work and therefore that the choice is not genuinely
free). Hence the only way that ordinary workers can obtain the right to be
consulted on life-or-death company policies is to control the production
process themselves, through self-management as production for need and use
will never come from the employer. The owners of production in a capitalist
society will never begin to take social priorities into account in the
production process. The pursuit of ever greater profits is not compatible with
social justice and responsibility.

For these reasons, the peace and social justice movements are fundamentally
linked through their shared need for a worker-controlled economy. Moreover,
extreme poverty makes military service one of the few legal options open for
many individuals to improve their social situation. These considerations
illustrate further links between the peace and social justice movements -- and
between those movements and anarchism, which is the conceptual "glue" that can
potentially unite all the new social movements in a single anti-authoritarian
coalition.

## J.4.4 What is the _"economic structural crisis"_?

There is an ongoing structural crisis in the global capitalist economy.
Compared to the post-war "Golden Age" of 1950 to 1973, the period from 1974
has seen a continual worsening in economic performance in the West and for
Japan. For example, growth is lower, unemployment is far higher, labour
productivity lower as is investment. Average rates of unemployment in the
major industrialised countries have risen sharply since 1973, especially after
1979. Unemployment _"in the advanced capitalist countries . . . increased by
56 per cent between 1973 and 1980 (from an average 3.4 per cent to 5.3 per
cent of the labour force) and by another 50 per cent since then (from 5.3 per
cent of the labour force in 1980 to 8.0 per cent in 1994)."_ Job insecurity
has increased with, for example, the USA, having the worse job insecurity
since the depression of the 1930s. [Takis Fotopoulos, **Towards an Inclusive
Democracy**, p. 35 and p. 141] In addition, the world economy has become far
less stable with regular financial crises sweeping the world of de-regulated
capitalism every few years or so.

This crisis is not confined to the economy. It extends into the ecological and
the social, with the quality of life and well-being decreasing as GDP grows
(as we noted in [section C.10](secC10.html), economic factors cannot, and do
not, indicate human happiness). However, here we discuss economic factors.
This does not imply that the social and ecological crises are unimportant or
are reducible to the economy. Far from it. We concentrate on the economic
factor simply because this is the factor usually stressed by the establishment
and it is useful to indicate the divergence of reality and hype we are
currently being subjected to.

Ironically enough, as Marxist Robert Brenner points out, _"as the neo-
classical medicine has been administered in even stronger doses, the economy
has performed steadily less well. The 1970s were worse than the 1960s, the
1980s worse than the 1970s, and the 1990s have been worse than the 1980s."_
[_"The Economics of Global Turbulence"_, **New Left Review**, no. 229, p. 236]
This is ironic because during the crisis of Keynesianism in the 1970s the
right argued that too much equality and democracy harmed the economy, and so
made us all worse-off in the long run (due to lower growth, sluggish
investment and so on). However, after decades of pro-capitalist governments,
rising inequality, increased freedom for capital and its owners and managers,
the weakening of trade unions and so on, economic growth has become worse!

If we look at the USA in the 1990s (usually presented as an economy that "got
it right") we find that the _"cyclical upturn of the 1990s has, in terms of
the main macro-economic indicators of growth -- output, investment,
productivity, and real compensation -- has been even less dynamic than its
relatively weak predecessors of the 1980s and the 1970s (not to mention those
of the 1950s and 1960s)."_ [Brenner, **Op. Cit.**, p. 5] Of course, the
economy is presented as a success -- inequality is growing, the rich are
getting richer and wealth is concentrating into fewer and fewer hands and so
for the rich and finance capital, it can be considered a "Golden Age" and so
is presented as such by the media. As economist Paul Krugman summarises, in
America while the bulk of the population are working longer and harder to make
ends meet _"the really big gains went to the really, really rich."_ In fact,
_“only the top 1 percent has done better since the 1970s than it did in the
generation after World War II. Once you get way up the scale, however, the
gains have been spectacular -- the top tenth of a percent saw its income rise
fivefold, and the top .01 percent of American is seven times richer than they
were in 1973."_ Significantly, _the top 0.1% of Americans, a class with a
minimum income of about $1.3 million and an average of about $3.5 million,
receives more than 7 percent of all income -- up from just 2.2 percent in
1979."_ [**The Conscience of a Liberal**, p. 129 and p. 259]

So it is for this reason that it may be wrong to term this slow rot a "crisis"
as it is hardly one for the ruling elite as their share in social wealth,
power and income has steadily increased over this period. However, for the
majority it is undoubtedly a crisis (the term _"silent depression"_ has been
accurately used to describe this). Unsurprisingly, when the chickens came home
to roost under the Bush Junta and the elite faced economic collapse, the state
bailed them out.

The only countries which saw substantial and dynamic growth after 1973 where
those which used state intervention to violate the eternal "laws" of neo-
classical economics, namely the South East Asian countries (in this they
followed the example of Japan which had used state intervention to grow at
massive rates after the war). Of course, before the economic crisis of 1997,
capitalist ideologues argued that these countries were classic examples of
"free market" economies. Right-wing icon F.A von Hayek asserted that _"South
Korea and other newcomers"_ had _"discovered the benefits of free markets."_
[**1980s Unemployment and the Unions**, p. 113] In 1995, the **Heritage
Foundation** (a right-wing think-tank) released its index of economic freedom.
Four of the top seven countries were Asian, including Japan and Taiwan. All
the Asian countries struggling just a few years later qualified as "free."
Yet, as mentioned in [section C.10.1](secC10.html#secc101), such claims were
manifestly false: _"it was not **laissez-faire** policies that induced their
spectacular growth. As a number of studies have shown, the expansion of the
Asian Tigers was based on massive state intervention that boosted their export
sectors, by public policies involving not only heavy protectionism but even
deliberate distortion of market prices to stimulate investment and trade."_
[Fotopoulos, **Op. Cit.**, p. 115] Moreover, for a long period these countries
also banned unions and protest, but then for the right "free markets" always
seem compatible with lack of freedom for workers to organise.

Needless to say, **after** the crisis of the late 1990s, the free-marketeers
discovered the statism that had always been there and danced happily on the
grave of what used to be called _"the Asian miracle"_. It was perverse to see
the supporters of "free-market" capitalism concluding that history was
rendering its verdict on the Asian model of capitalism while placing into the
Memory Hole the awkward fact that until the crisis they themselves had taken
great pains to deny that such a model existed! Such hypocrisy is not only
truly sickening, it also undermines their own case for the wonders of "the
market." For until the crisis appeared, the world's investors -- which is to
say "the market" -- saw nothing but golden opportunities ahead for these
"free" economies. They showed their faith by shoving billions into Asian
equity markets, while foreign banks contentedly handed out billions in loans.
If Asia's problems were systemic and the result of these countries' statist
policies, then investors' failure to recognise this earlier is a blow against
the market, not for it.

So, as can be seen, the global economy has been marked by an increasing
stagnation, the slowing down of growth, weak (and jobless) recoveries,
speculative bubbles driving what growth there is and increasing financial
instability producing regular and deepening crisis. This is despite (or, more
likely, **because of**) the free market reforms imposed and the deregulation
of finance capital (we say "because of" simply because neo-classical economics
argue that pro-market reforms would increase growth and improve the economy,
but as we noted in [section C.1](secC1.html) such economics has little basis
in reality and so their recommendations are hardly going to produce positive
results). Of course as the ruling class have been doing well this underlying
slowdown has been ignored and obviously claims of crisis are only raised when
economic distress reach the elite.

Crisis (particularly financial crisis) has become increasingly visible,
reflecting the underlying weakness of the global economy (rising inequality,
lack of investment in producing real goods in favour of speculation in
finance, etc.). This underlying weakness has been hidden by large rises in the
world's stock markets, which, ironically enough, has helped create that
weakness to begin with! As one expert on Wall Street argues, _"Bond markets .
. . hate economic strength . . . Stocks generally behave badly just as the
real economy is at its strongest . . . Stocks thrive on a cool economy, and
wither in a hot one."_ In other words, real economic weakness is reflected in
financial strength. Unsurprisingly, then, _"[w]hat might be called the rentier
share of the corporate surplus -- dividends plus interest as a percentage of
pre-tax profits and interest -- has risen sharply, from 20-30% in the 1950s to
60% in the 1990s."_ [Doug Henwood, **Wall Street**, p. 124 and p. 73]

This helps explain the stagnation which has afflicted the economies of the
west. The rich have been placing more of their ever-expanding wealth in
stocks, allowing this market to rise in the face of general economic torpor.
Rather than being used for investment, surplus is being funnelled into the
finance market (retained earnings in the US have decreased as interest and
dividend payments have increased [Brenner, **Op. Cit.**, p. 210]). However,
such markets do concentrate wealth very successfully even if _"the US
financial system performs dismally at its advertised task, that of efficiently
directing society's savings towards their optimal investment pursuits. The
system is stupefyingly expensive, gives terrible signals for the allocation of
capital, and has surprisingly little to do with real investment."_ [Henwood,
**Op. Cit.**, p. 3] As most investment comes from internal funds, the rise in
the rentiers share of the surplus has meant less investment and so the
stagnation of the economy. The weakening economy has increased financial
strength, which in turn leads to a weakening in the real economy. A vicious
circle, and one reflected in the slowing of economic growth over the last 30
years.

The increasing dominance of finance capital has, in effect, created a market
for government policies. As finance capital has become increasingly global in
nature governments must secure, protect and expand the field of profit-making
for financial capital and transnational corporations, otherwise they will be
punished by dis-investment by global markets (i.e. finance capital). These
policies have been at the expense of the underlying economy in general, and of
the working class in particular:

> _"Rentier power was directed at labour, both organised and unorganised ranks
of wage earners, because it regarded rising wages as a principal threat to the
stable order. For obvious reasons, this goal was never stated very clearly,
but financial markets understood the centrality of the struggle: protecting
the value of their capital required the suppression of labour incomes."_
[William Greider, **One World, Ready or Not**, p. 302]

For example, _"the practical effect of finance capital's hegemony was to lock
the advanced economies and their governments in a malignant spiral,
restricting them to bad choices. Like bondholders in general, the new
governing consensus explicitly assumed that faster economic growth was
dangerous -- threatening to the stable financial order -- so nations were
effectively blocked from measures that might reduce permanent unemployment or
ameliorate the decline in wages . . . The reality of slow growth, in turn,
drove the governments into their deepening indebtedness, since the
disappointing growth inevitably undermined tax revenues while it expanded the
public welfare costs. The rentier regime repeatedly instructed governments to
reform their spending priorities -- that is, withdraw benefits from dependent
citizens."_ [Greider, **Op. Cit.**, pp. 297-8]

Of course, industrial capital **also** hates labour, so there is a basis of an
alliance between the two sides of capital, even if they do disagree over the
specifics of the economic policies implemented. Given that a key aspect of the
neo-liberal reforms was the transformation of the labour market from a post-
war sellers' market to a nineteenth century buyers' market with its related
effects on workplace discipline, wage claims and proneness to strike,
industrial capital could not but be happy even if its members quibbled over
details. Doug Henwood correctly argues that _"Liberals and populists often
search for potential allies among industrialists, reasoning that even if
financial interests suffer in a boom, firms that trade in real, rather than
fictitious, products would thrive when growth is strong. In general,
industrialists are less sympathetic to these arguments. Employers in any
industry like slack in the labour market; it makes for a pliant workforce, one
unlikely to make demands or resist speedups."_ In addition, _"many non-
financial corporations have heavy financial interests."_ [**Op. Cit.**, p. 123
and p. 135]

Thus the general stagnation afflicting much of the world, a stagnation which
regularly develop into open crisis as the needs of finance undermine the real
economy which, ultimately, it is dependent upon. The contradiction between
short term profits and long term survival inherent in capitalism strikes
again.

Crisis, as we have noted above, has appeared in areas previously considered as
strong economies and it has been spreading. An important aspect of this crisis
is the tendency for productive capacity to outstrip effective demand, which
arises in large part from the imbalance between capitalists' need for a high
rate of profit and their simultaneous need to ensure that workers have enough
wealth and income so that they can keep buying the products on which those
profits depend. Inequality has been increasing particularly in neo-liberal
countries like the UK and USA, which means that the economy faces as
realisation crisis (see [section C.7](secC7.html)), a crisis which was avoided
in the short-term by deepening debt for working people (debt levels more than
doubled between the 1950s to the 1990s, from 25% to over 60%). In 2007, the
chickens came hole to roost with a global credit crunch much worse than the
previous finance crises of the neo-liberal era.

Over-investment has been magnified due to the East-Asian Tigers and China
which, thanks to their intervention in the market (and repressive regimes
against labour), ensured they were a more profitable place to invest than
elsewhere. Capital flooded into the area, ensuring a relative over-investment
was inevitable. As we argued in [section C.7.2](secC7.html#secc72), crisis is
possible simply due to the lack of information provided by the price mechanism
-- economic agents can react in such a way that the collective result of
individually rational decisions is irrational. Thus the desire to reap profits
in the Tiger economies resulted in a squeeze in profits as the aggregate
investment decisions resulted in over-investment, and so over-production and
falling profits.

In effect, the South East Asian economies suffered from the "fallacy of
composition." When you are the first Asian export-driven economy, you are
competing with high-cost Western producers and so your cheap workers, low
taxes and lax environmental laws allow you to under-cut your competitors and
make profits. However, as more tigers joined into the market, they end up
competing against **each other** and so their profit margins would decrease
towards their actual cost price rather than that of Western firms. With the
decrease in profits, the capital that flowed into the region flowed back out,
thus creating a crisis (and proving, incidentally, that free markets are
destabilising and do not secure the best of all possible outcomes). Thus, the
rentier regime, after weakening the Western economies, helped destabilise the
Eastern ones too.

So, in the short-run, many large corporations and financial companies solved
their profit problems by expanding production into "underdeveloped" countries
so as to take advantage of the cheap labour there (and the state repression
which ensured that cheapness) along with weaker environmental laws and lower
taxes. Yet gradually they are running out of third-world populations to
exploit. For the very process of "development" stimulated by the presence of
Transnational Corporations in third-world nations increases competition and
so, potentially, over-investment and, even more importantly, produces
resistance in the form of unions, rebellions and so on, which tend to exert a
downward pressure on the level of exploitation and profits.

This process reflects, in many ways, the rise of finance capital in the 1970s.
In the 1950s and 1960s, existing industrialised nations experienced increased
competition from Japan and Germany. As these nations re-industrialised, they
placed increased pressure on the USA and other nations, reducing the global
"degree of monopoly" and forcing them to compete with lower cost producers. In
addition, full employment produced increasing resistance on the shop floor and
in society as a whole (see [section C.7.1](secC7.html#secc71)), squeezing
profits even more. Thus a combination of class struggle and global over-
capacity resulted in the 1970s crisis. With the inability of the real economy,
especially the manufacturing sector, to provide an adequate return, capital
shifted into finance. In effect, it ran away from the success of working
people asserting their rights at the point of production and elsewhere. This,
combined with increased international competition, ensured the rise of finance
capital which in return ensured the current stagnationist tendencies in the
economy (tendencies made worse by the rise of the Asian Tiger economies in the
1980s).

From the contradictions between finance capital and the real economy, between
capitalists' need for profit and human needs, between over-capacity and
demand, and others, there has emerged what appears to be a long-term trend
toward **permanent** stagnation of the capitalist economy with what growth
spurts which do exist being fuelled by speculative bubbles as well as its
benefits being monopolised by the few (so refuting the notion of "trickle
down" economics). This trend has been apparent for several decades, as
evidenced by the continuous upward adjustment of the rate of unemployment
officially considered to be "normal" or "acceptable" during those decades, and
by other symptoms as well such as falling growth, lower rates of profit and so
on.

This stagnation has became even more obvious by the development of deep crisis
in many countries at the end of the 2000s. This caused central banks to
intervene in order to try and revive the real economies that have suffered
under their rentier inspired policies since the 1970s. Such action may just
ensure continued stagnation and reflated bubbles rather than a real up-turn.
One thing is true, however, and that is the working class will pay the price
of any "solution" -- unless they organise and get rid of capitalism and the
state. Ultimately, capitalism need profits to survive and such profits came
from the fact that workers do not have economic liberty. Thus any "solution"
within a capitalist framework means the increased oppression and exploitation
of working class people.

## J.4.5 Why is this _"economic structural crisis"_ important to social
struggle?

The **_"economic structural crisis"_** we out-lined in the [last
section](secJ4.html#secj44) has certain implications for anarchists and social
struggle. Essentially, as C. George Benello argued, _"[i]f economic conditions
worsen . . . then we are likely to find an openness to alternatives which have
not been thought of since the depression of the 1930s . . . It is important to
plan for a possible economic crisis, since it is not only practical, but also
can serve as a method of mobilising a community in creative ways."_ [**From
the Ground Up**, p. 149]

In the face of economic stagnation and depression, attempts to generate more
profits (i.e., increase exploitation) by increasing the authority of the boss
grow. In addition, more people find it harder to make ends meet, run up debts
to survive, face homelessness if they are made unemployed, and so on. This
makes exploitation ever more visible and tends to push oppressed strata
together in movements that seek to mitigate, and even remove, their
oppression. As the capitalist era has worn on, these strata have become
increasingly able to rebel and gain substantial political and economic
improvements, which have, in addition, lead to an increasing willingness to do
so because of rising expectations (about what is possible) and frustration
(about what actually is). It is true that libertarians, the left and labour
have suffered setbacks since the 1970s, but with increasing misery of the
working class due to neo-liberal policies (and the _"economic structural
crisis"_ they create), it is only a matter of time before there is a
resurgence of radicalism.

Anarchists will be in the forefront of this resurgence. For, with the
discrediting and eventual fall of authoritarian state capitalism ("Communism")
in Eastern Europe, the anti-authoritarian faction of the left will
increasingly be seen as its only credible one. Thus the ongoing structural
crisis of the global capitalist economy, combined with the other developments
springing from what Takis Fotopoulos calls (in his book **Towards an Inclusive
Democracy**) a _"multidimensional crisis"_ (which includes economic,
political, social, ecological and ideological aspects), could (potentially)
lead to a new **international** anti-authoritarian alliance linking together
the new (and not so new) social movements in the West (feminism, the Green
movement, rank-and-file labour militancy, etc.) with non-authoritarian
liberation movements in the Third World and new movements in formerly
Stalinist countries. However, this is only likely to happen if anarchists take
the lead in promoting alternatives and working with the mass of the
population. Ways in which anarchists can do this are discussed in some detail
in [section J.5](secJ5.html).

Thus the _"economic structural crisis"_ can aid social struggle by placing the
contrast of _"what is"_ with what _"could be"_ in a clear light. Any crisis
brings forth the contradictions in capitalism, between the production of use
values (things people need) and of exchange value (capitalist profits),
between capitalism's claims of being based on liberty and the authoritarianism
associated with wage labour (_"The general evidence of repression poses an
ancient contradiction for capitalism: while it claims to promote human
freedom, it profits concretely from the denial of freedom, most especially
freedom for the workers employed by capitalist enterprise."_ [William Greider,
**One World, Ready or Not**, p. 388]) and so on. It shakes to the bone popular
faith in capitalism's ability to "deliver the goods" and gets more and more
people thinking about alternatives to a system that places profit above and
before people and planet. The crisis also, by its very nature, encourages
workers and other oppressed sections of the population to resist and fight
back, which in turn generates collective organisation (such as unions or
workplace-based assemblies and councils), solidarity and direct action -- in
other words, collective self-help and the awareness that the problems of
working class people can only be solved by ourselves, by our own actions and
organisations. The 1930s in the USA is a classic example of this process, with
very militant struggles taking place in very difficult situations (see Howard
Zinn's **A People's History of the United States** or Jeremy Brecher's
**Strike!** for details).

In other words, the "economic structural crisis" gives radicals a lot
potential to get their message across, even if the overall environment may
make success seem difficult at times!

As well as encouraging workplace organisation due to the intensification of
exploitation and authority provoked by the economic stagnation/depression, the
"economic structural crisis" can encourage other forms of libertarian
alternatives. For example, the _"economic structural crisis"_ has resulted in
the erosion of the welfare state (at least for the working class, for the
elite state aid is never far away). This development has potential libertarian
possibilities. _"The decline of the state,"_ argues L. Gambone, _"makes
necessary a revitalisation of the notions of direct action and mutual aid.
Without Mama State to do it for us, we must create our own social services
through mutual aid societies."_ [**Syndicalism in Myth and Reality**, p. 12]
As we argue in more depth in [section J.5.16](secJ5.html#secj516), such a
movement of mutual aid has a long history in the working class and, as it is
under our control, it cannot be withdrawn from us to enrich and empower the
ruling class as state run systems have been. Thus the decline of state run
social services could, potentially, see the rise of a network of self-managed,
working class alternatives (equally, of course, it could see the end of all
services to the weakest sections of our society -- which possibility comes
about depends on what we do in the here and now. See [section
J.5.15](secJ5.html#secj515) for an anarchist analysis of the welfare state).

**Food Not Bombs!** (FNB) is an excellent example of practical libertarian alternatives being generated by the economic crisis we are facing. FNB is a community-based group which helps the homeless through the direct action of its members. It also involves the homeless in helping themselves. It serves free food in public places to expose the plight of the homeless, the callousness of the system and our capacity to solve social problems through our own actions without government or capitalism. The constant harassment of FNB by the police, middle classes and the government illustrates their callousness to the plight of the poor and the failure of their institutions to build a society which cares for people more than money and property (and the police and prisons to protect them). The fact is that in the US many working and unemployed people have no **feeling** that they are entitled to basic human needs such as medicine, clothes, shelter, and food. FNB encourages poor people to make these demands, provides a space in which these demands can be voiced, and helps to breakdown the wall between hungry and not-hungry. The repression directed towards FNB by local police forces and governments also demonstrates the effectiveness of their activity and the possibility that it may radicalise those who get involved with the organisation. Charity is obviously one thing, mutual aid is something else. FNB is a politicised movement from below, based on solidarity, **not** charity as, in Kropotkin's words, charity _"bears a character of inspiration from above, and, accordingly, implies a certain superiority of the giver upon the receiver."_ [**Mutual Aid**, p. 222]

The last example of how economic stagnation can generate libertarian
tendencies can be seen from the fact that, _"[h]istorically, at times of
severe inflation or capital shortages, communities have been forced to rely on
their own resources. During the Great Depression, many cities printed their
own currency; this works to the extent that a community is able to maintain a
viable internal economy which provides the necessities of life, independent of
transactions with the outside."_ [Benello, **Op. Cit.**, p. 150]

These local currencies could be the basis of a mutual bank (see [section
J.5.5](secJ5.html#secj55)), providing interest-free loans to workers to form
co-operatives and so build libertarian alternatives to capitalist firms, so
eliminating the profits of capitalists by allowing workers to exchange the
product of their labour with other workers. Moreover, _"local exchange systems
strength local communities by increasing their self-reliance, empowering
community members, and helping to protect them from the excesses of the global
market."_ [Frank Lindenfield, _"Economics for Anarchists,"_ **Social
Anarchism**, no. 23, p. 24] In this way self-managing communes could be
created, communes that replace hierarchical, top-down, government with
collective decision making of community affairs based on directly democratic
community assemblies. These self-governing communities and economies could
federate together to co-operate on a wider scale and so create a counter-power
to that of state and capitalism.

This confederal system of self-managing communities could also protect jobs as
the _"globalisation of capital threatens local industries. A way has to be
found to keep capital at home and so preserve the jobs and the communities
that depend upon them. Protectionism is both undesirable and unworkable. But
worker-ownership or workers' co-operatives are alternatives."_ [Gambone, **Op.
Cit.**, pp. 12-13] Local communities could provide the necessary support
structures which could protect co-operatives from the corrupting effects of
working in the capitalist market (see [section J.5.11](secJ5.html#secj511)).
They could also demand that rather than nationalise or bailout failing
companies (or, for that matter, privatise state services or public works),
they should be turned over (as Proudhon constantly argued) to workers co-
operatives by aiding _"the **Labour Unions** to enter into a temporary
possession of the industrial concerns"_, anarchists would provide _"an
effective means to check the State Nationalisation"_ in the period before a
social revolution when _"State phases which we are traversing now seems to be
unavoidable."_ [quoted by Ruth Kinna, _"Fields of Vision: Kropotkin and
Revolutionary Change"_, pp. 67-86, **SubStance**, Vol. 36, No. 2, p. 77] In
this way, economic liberty (self-management) could replace capitalism (wage
slavery) and show that anarchism is a practical alternative to the chaos and
authoritarianism of capitalism, even if these examples are initially
fragmentally and limited in nature.

However, these developments should **not** be taken in isolation of collective
struggle in the workplace or community. It is in the class struggle that the
real potential for anarchy is created. The work of such organisations as
**Food Not Bombs!** and the creation of local currencies and co-operatives are
supplementary to the important task of creating workplace and community
organisations that can create effective resistance to both state and
capitalists, resistance that can overthrow both (see sections
[J.5.2](secJ5.html#secj52) and [J.5.1](secJ5.html#secj51) respectively).
_"Volunteer and service credit systems and alternative currencies by
themselves may not be enough to replace the corporate capitalist system.
Nevertheless, they can help build the economic strength of local currencies,
empower local residents, and mitigate some of the consequences of poverty and
unemployment . . . By the time a majority [of a community are involved it]
will be well on its way to becoming a living embodiment of many anarchist
ideals."_ [Lindenfield, **Op. Cit.**, p. 28] And such a community would be a
great aid in any strike or other social struggle which is going on!

The general economic crisis which we are facing has implications for social
struggle and anarchist activism. It could be the basis of libertarian
alternatives in our workplaces and communities, alternatives based on direct
action, solidarity and self-management. These alternatives could include
workplace and community unionism, co-operatives, mutual banks and other forms
of anarchistic resistance to capitalism and the state.

Finally, we must stress that we are **not** arguing that working class people
need an economic crisis to force them into struggle. Such "objectivism" (i.e.
the placing of tendencies towards socialism in the development of capitalism,
of objective factors, rather than in the class struggle, i.e. subjective
factors) is best left to orthodox Marxists and Leninists as it has
authoritarian implications. Rather we are aware that the class struggle, the
subjective pressure on capitalism, is not independent of the conditions within
which it takes place (and helps to create, we must add). Subjective revolt is
always present under capitalism and, in the case of the 1970s, played a role
in creating crisis. Faced with an economic crisis we are indicating what we
can do in response to it and how it could, potentially, generate libertarian
tendencies within society. Economic crisis could, in other words, provoke
social struggle, collective action and generate anarchic tendencies in
society. Equally, it could cause apathy, rejection of collective struggle and,
perhaps, the embracing of **false** "solutions" such as right-wing populism,
Leninism, or Fascism. We cannot predict how the future will develop, but it is
true that if we do nothing then, obviously, libertarian tendencies will not
grow and develop.

## J.4.6 What are implications of anti-government and anti-big business
feelings?

Public opinion polls show increasing feelings of disappointment and lack of
confidence in governments and big business.

Some of the feelings of disappointment with government can be blamed on the
anti-big-government rhetoric of conservatives and right-wing populists. Of
course the Right would never dream of **really** dismantling the state, as is
evident from the fact that government was as bureaucratic and expensive under
"conservative" administrations. So this "decentralist" element of right-wing
rhetoric is a con (and quickly jettisoned as required by the capitalist
class). The "anti-Government" rhetoric is combined with the pro-business, pro-
private tyranny, racist, anti-feminist, and homophobic hogwash disseminated by
right-wing radio and TV propagandists and the business-backed media which
shows that capitalism is not **genuinely** anti-authoritarian (nor could it
ever be), as a social system based on liberty must entail.

When a right-wing politician, economist or business "leader" argues that the
government is too big, they are rarely thinking of the same government
functions you are. You may be thinking of subsidies for tobacco farmers or
defence firms; they are thinking about pollution controls. You may be thinking
of reforming welfare for the better; their idea is to dismantle the welfare
state (for working class people). Moreover, with their support for "family
values", "wholesome" television, bans on abortion and so on, their victory
would see an increased level of government intrusion in many personal spheres
as well as increased state support for the power of the boss over the worker
and the landlord over the tenant.

If you look at what the Right has done and is doing, rather than what it is
saying, you quickly see the ridiculousness of claims of right-wing
"libertarianism" (as well as who is really in charge). Obstructing pollution
and health regulations; defunding product safety laws; opening national parks
to logging and mining, or closing them entirely; reducing taxes for the rich;
eliminating the capital gains tax; allowing companies to fire striking
workers; making it easier for big telecommunications companies to dominate the
media; limiting companies' liability for unsafe products -- the objective here
is obviously to help big business and the wealthy do what they want without
government interference, helping the rich get richer and increasing "freedom"
for private power combined with a state whose sole role is to protect that
"liberty."

Such right-wing tendencies do not have anarchistic elements. The "anti-
government" propaganda of big business is hardly anarchistic. What anarchists
try to do is point out the hypocritical and contradictory nature of such
rhetoric. The arguments against big government are equally applicable to
business. **If** people are capable of making their own decisions, then why
should this capability be denied in the workplace? As Noam Chomsky points out,
while there is a _"leave it alone"_ and _"do your own thing"_ current within
society, it in fact _"tells you that the propaganda system is working full-
time, because there is no such ideology in the US. Business, for example,
doesn't believe it. It has always insisted upon a powerful interventionist
state to support its interests -- still does and always has -- back to the
origins of American society. There's nothing individualistic about
corporations. Those are big conglomerate institutions, essentially
totalitarian in character, but hardly individualistic. Within them you're a
cog in a big machine. There are few institutions in human society that have
such strict hierarchy and top-down control as a business organisation. Nothing
there about 'Don't tread on me.' You're being tread on all the time. The point
of the ideology is to try to get other people, outside of the sectors of co-
ordinated power, to fail to associate and enter into decision-making in the
political arena themselves. The point is to atomise everyone else while
leaving powerful sectors integrated and highly organised and of course
dominating resources."_ He goes on to note that there is _"a streak of
independence and individuality in American culture which I think is a very
good thing. This 'Don't tread on me' feeling is in many respects a healthy
one. It's healthy up to the point where it atomises and keeps you from working
together with other people. So it's got its healthy side and its negative
side. It's the negative side that's emphasised naturally in the propaganda and
indoctrination."_ [**Keeping the Rabble in Line**, pp. 279-80]

As opinion polls show, most people direct their dislike and distrust of
institutions equally to Big Business, which shows that people are not stupid.
Unfortunately, as Goebbels was well aware, tell a lie often enough and people
start to believe it. Given the funds available to big business, its influence
in the media, its backing of "think-tanks," the use of Public Relations
companies, the support of economic "science," its extensive advertising and so
on, it says a lot for the common sense of people that so many see big business
for what it is. You simply cannot fool all the people all of the time!

However, these feelings can easily be turned into cynicism as well as a
hopelessness that things can change for the better and that you cannot help
change society. Or, even worse, they can be twisted into support for right,
authoritarian, populism. The job for anarchists is to combat this and help
point the healthy distrust people have for government and business towards a
real solution to society's problems, namely a decentralised, self-managed
anarchist society.

## J.4.7 What about the communications revolution?

Another important factor working in favour of anarchists is the existence of a
sophisticated global communications network and a high degree of education and
literacy among the populations of the core industrialised nations. Together
these two developments make possible nearly instantaneous sharing and public
dissemination of information by members of various progressive and radical
movements all over the globe -- a phenomenon that tends to reduce the
effectiveness of repression by central authorities. The electronic-media and
personal-computer revolutions also make it more difficult for elitist groups
to maintain their previous monopolies of knowledge. Copy-left software and
text, user-generated and shared content, file-sharing, all show that
information, and its users, reaches its full potential when it is free. In
short, the advent of the Information Age is potentially extremely subversive.

The very existence of the Internet provides anarchists with a powerful
argument that decentralised structures can function effectively in a highly
complex world. For the net has no centralised headquarters and is not subject
to regulation by any centralised regulatory agency, yet it still manages to
function effectively. Moreover, the net is also an effective way for
anarchists and other radicals to communicate their ideas to others, share
knowledge, work on common projects and co-ordinate activities and social
struggle. By using the Internet, radicals can make their ideas accessible to
people who otherwise would not come across anarchist ideas. In addition, and
far more important than anarchists putting their ideas across, the fact is
that the net allows everyone with access to express themselves freely, to
communicate with others and get access (by visiting webpages and joining
mailing lists and newsgroups) and give access (by creating webpages and
joining in with on-line arguments) to new ideas and viewpoints. This is very
anarchistic as it allows people to express themselves and start to consider
new ideas, ideas which may change how they think and act.

Obviously we are aware that the vast majority of people in the world do not
have access to telephones, never mind computers, but computer access is
increasing in many countries, making it available, via work, libraries,
schools, universities, and so on to more and more working class people.

Of course there is no denying that the implications of improved communications
and information technology are ambiguous, implying Big Brother as well the
ability of progressive and radical movements to organise. However, the point
is only that the information revolution in combination with the other social
developments **could** (but will not **necessarily**) contribute to a social
paradigm shift. Obviously such a shift will not happen automatically. Indeed,
it will not happen at all unless there is strong resistance to governmental
and corporate attempts to limit public access to information, technology (e.g.
encryption programs), censor peoples' communications and use of electronic
media and track them on-line.

This use of the Internet and computers to spread the anarchist message is
ironic. The rapid improvement in price-performance ratios of computers,
software, and other technology today is often used to validate the faith in
free market capitalism but that requires a monumental failure of historical
memory as not just the Internet but also the computer represents a spectacular
success of public investment. As late as the 1970s and early 1980s, according
to Kenneth Flamm's **Creating the Computer**, the federal government was
paying for 40 percent of all computer-related research and 60 to 75 percent of
basic research. Even such modern-seeming gadgets as video terminals, the light
pen, the drawing tablet, and the mouse evolved from Pentagon-sponsored
research in the 1950s, 1960s and 1970s. Even software was not without state
influence, with databases having their root in US Air Force and Atomic Energy
Commission projects, artificial intelligence in military contracts back in the
1950s and airline reservation systems in 1950s air-defence systems. More than
half of IBM's Research and Development budget came from government contracts
in the 1950s and 1960s.

The motivation was national security, but the result has been the creation of
comparative advantage in information technology for the United States that
private firms have happily exploited and extended. When the returns were
uncertain and difficult to capture, private firms were unwilling to invest,
and government played the decisive role. And not for want of trying, for key
players in the military first tried to convince businesses and investment
bankers that a new and potentially profitable business opportunity was
presenting itself, but they did not succeed and it was only when the market
expanded and the returns were more definite that the government receded. While
the risks and development costs were socialised, the gains were privatised.
All of which make claims that the market would have done it anyway highly
unlikely.

Looking beyond state aid to the computer industry we discover a _"do-it-
yourself"_ (and so self-managed) culture which was essential to its
development. The first personal computer, for example, was invented by
amateurs who wanted their own cheap machines. The existence of a "gift"
economy among these amateurs and hobbyists was a necessary precondition for
the development of PCs. Without this free sharing of information and
knowledge, the development of computers would have been hindered and so
socialistic relations between developers and within the working environment
created the necessary conditions for the computer revolution. If this
community had been marked by commercial relations, the chances are the
necessary breakthroughs and knowledge would have remained monopolised by a few
companies or individuals, so hindering the industry as a whole.

Encouragingly, this socialistic "gift economy" is still at the heart of
computer/software development and the Internet. For example, the **Free
Software Foundation** has developed the **General Public Licence** (GPL). GPL,
also known as **_"copyleft"_**, uses copyright to ensure that software remains
free. Copyleft ensures that a piece of software is made available to everyone
to use and modify as they desire. The only restriction is that any used or
modified copyleft material must remain under copyleft, ensuring that others
have the same rights as you did when you used the original code. It creates a
commons which anyone may add to, but no one may subtract from. Placing
software under GPL means that every contributor is assured that she, and all
other users, will be able to run, modify and redistribute the code
indefinitely. Unlike commercial software, copyleft code ensures an increasing
knowledge base from which individuals can draw from and, equally as important,
contribute to. In this way everyone benefits as code can be improved by
everyone, unlike commercial code.

Many will think that this essentially anarchistic system would be a failure.
In fact, code developed in this way is far more reliable and sturdy than
commercial software. Linux, for example, is a far superior operating system
than DOS precisely **because** it draws on the collective experience, skill
and knowledge of thousands of developers. Apache, the most popular web-server,
is another freeware product and is acknowledged as the best available. The
same can be said of other key web-technologies (most obviously PHP) and
projects (Wikipedia springs to mind, although that project while based on co-
operative and free activity is owned by a few people who have ultimate
control). While non-anarchists may be surprised, anarchists are not. Mutual
aid and co-operation are beneficial in the evolution of life, why not in the
evolution of software? For anarchists, this "gift economy" at the heart of the
communications revolution is an important development. It shows both the
superiority of common development as well as the walls built against
innovation and decent products by property systems. We hope that such an
economy will spread increasingly into the "real" world.

Another example of co-operation being aided by new technologies is Netwar.
This refers to the use of the Internet by autonomous groups and social
movements to co-ordinate action to influence and change society and fight
government or business policy. This use of the Internet has steadily grown
over the years, with a Rand corporation researcher, David Ronfeldt, arguing
that this has become an important and powerful force (Rand is, and has been
since its creation in 1948, a private appendage of the military industrial
complex). In other words, activism and activists' power and influence has been
fuelled by the advent of the information revolution. Through computer and
communication networks, especially via the Internet, grassroots campaigns have
flourished, and most importantly, government elites have taken notice.

Ronfeldt specialises in issues of national security, especially in the areas
of Latin American and the impact of new informational technologies. Ronfeldt
and another colleague coined the term **_"netwar"_** in a Rand document
entitled _"Cyberwar is Coming!"_. Ronfeldt's work became a source of
discussion on the Internet in mid-March 1995 when Pacific News Service
correspondent Joel Simon wrote an article about Ronfeldt's opinions on the
influence of netwars on the political situation in Mexico after the Zapatista
uprising. According to Simon, Ronfeldt holds that the work of social activists
on the Internet has had a large influence -- helping to co-ordinate the large
demonstrations in Mexico City in support of the Zapatistas and the
proliferation of EZLN communiqués across the world via computer networks.
These actions, Ronfeldt argues, have allowed a network of groups that oppose
the Mexican Government to muster an international response, often within hours
of actions by it. In effect, this has forced the Mexican government to
maintain the facade of negotiations with the EZLN and has on many occasions,
actually stopped the army from just going in to Chiapas and brutally
massacring the Zapatistas.

Given that Ronfeldt was an employee of the Rand Corporation his comments
indicate that the U.S. government and its military and intelligence wings are
very interested in what the Left is doing on the Internet. Given that they
would not be interested in this if it were not effective, we can say that this
use of the "Information Super-Highway" is a positive example of the use of
technology in ways un-planned of by those who initially developed it (let us
not forget that the Internet was originally funded by the U.S. government and
military). While the internet is being hyped as the next big marketplace, it
is being subverted by activists -- an example of anarchistic trends within
society worrying the powers that be.

A good example of this powerful tool is the incredible speed and range at
which information travels the Internet about events concerning Mexico and the
Zapatistas. When Alexander Cockburn wrote an article exposing a Chase
Manhattan Bank memo about Chiapas and the Zapatistas in **Counterpunch**, only
a small number of people read it because it is only a newsletter with a
limited readership. The memo, written by Riordan Roett, argued that _"the
[Mexican] government will need to eliminate the Zapatistas to demonstrate
their effective control of the national territory and of security policy"_. In
other words, if the Mexican government wants investment from Chase, it would
have to crush the Zapatistas. This information was relatively ineffective when
just confined to print but when it was uploaded to the Internet, it suddenly
reached a very large number of people. These people in turn co-ordinated
protests against the U.S and Mexican governments and especially Chase
Manhattan. Chase was eventually forced to attempt to distance itself from the
Roett memo that it commissioned. Since then net-activism has grown.

Ronfeldt's research and opinion should be flattering for the Left. He is
basically arguing that the efforts of activists on computers not only has been
very effective (or at least has that potential), but more importantly, argues
that the only way to counter this work is to follow the lead of social
activists. Activists should understand the important implications of
Ronfeldt's work: government elites are not only watching these actions (big
surprise) but are also attempting to work against them. Thus Netwars and
copyleft are good examples of anarchistic trends within society, using
communications technology as a means of co-ordinating activity across the
world in a libertarian fashion for libertarian goals.

[‹ J.3 What kinds of organisation do anarchists build?](/afaq/secJ3.html "Go
to previous page" ) [up](/afaq/secJcon.html "Go to parent page" ) [J.5 What
alternative social organisations do anarchists create? ›](/afaq/secJ5.html "Go
to next page" )

