# J.3 What kinds of organisation do anarchists build?

Anarchists are well aware of the importance of building organisations.
Organisations allow those within them to multiply their strength and activity,
becoming the means by which an individual can see their ideas, hopes and
dreams realised. This is as true for getting the anarchist message across as
for building a home, running a hospital or creating some useful product.
Anarchists support two types of organisation -- organisations of anarchists
and popular organisations which are not made up exclusively of anarchists such
as industrial unions, co-operatives and community assemblies.

Here we will discuss the kinds, nature and role of the first type of
organisation, namely explicitly anarchist organisations. In addition, we
discuss anarcho-syndicalism, a revolutionary unionism which aims to create an
anarchist society by anarchist tactics, as well as why many anarchists are not
anarcho-syndicalists. The second type of organisations, popular ones, are
discussed in [section J.5](secJ5.html). Both forms of organisation, however,
share the anarchist commitment to confederalism, decentralisation, self-
management and decision making from the bottom up. In such organisations the
membership plays the decisive role in running them and ensuring that power
remains in their hands. They express the anarchist vision of the power and
creative efficacy people have when they are self-reliant, when they act for
themselves and manage their own lives directly. Only by organising in this way
can we create a new world, a world worthy of human beings and unique
individuals.

Anarchist organisation in all its forms reflects our desire to _"build the new
world in the shell of the old"_ and to empower the individual. We reject the
notion that it does not really matter how we organise to change society.
Indeed, nothing could be further from the truth. We are all the products of
the influences and social relationships in our lives, this is a basic idea of
(philosophical) materialism. Thus the way our organisations are structured has
an impact on us. If the organisation is centralised and hierarchical (no
matter how "democratically" controlled officials or leaders are) then those
subject to it will, as in any hierarchical organisation, see their abilities
to manage their own lives, their creative thought and imagination eroded under
the constant stream of orders from above. This in turn justifies the
pretensions to power of those at the top, as the capacity of self-management
of the rank and file is weakened by authoritarian social relationships. This
means anarchist organisations are structured so that they allow everyone the
maximum potential to participate. Such participation is the key for a free
organisation. As Malatesta argued:

> _"The real being is man, the individual. Society or the collectivity . . .
if it is not a hollow abstraction, must be made up of individuals. And it is
in the organism of every individual that all thoughts and human actions
inevitably have their origin, and from being individual they become collective
thoughts and acts when they are or become accepted by many individuals. Social
action, therefore, is neither the negation nor the complement of individual
initiative, but is the resultant of initiatives, thoughts and actions of all
individuals who make up society."_ [**Anarchy**, p. 36]

Anarchist organisations exist to allow this development and expression of
individual initiatives. This empowering of the individual is an important
aspect of creating viable solidarity for sheep cannot express solidarity, they
only follow the shepherd. Therefore, _"to achieve their ends, anarchist
organisations must, in their constitution and operation, remain in harmony
with the principles of anarchism; that is, they must know how to blend the
free action of individuals with the necessity and the joy of co-operation
which serve to develop the awareness and initiative of their members and a
means of education for the environment in which they operate and of a moral
and material preparation for the future we desire."_ [Malatesta, **The
Anarchist Revolution**, p. 95]

As such, anarchist organisations reflect the sort of society anarchists
desire. We reject as ridiculous the claim of Leninists that the form of
organisation we build is irrelevant and therefore we must create highly
centralised parties which aim to become the leadership of the working class.
No matter how "democratic" such organisations are, they just reflect the
capitalist division of labour between brain and manual work and the Liberal
ideology of surrendering our ability to govern ourselves to an elected elite.
In other words, they just mirror the very society we are opposed to and so
will soon produce the very problems **within** so-called anti-capitalist
organisations which originally motivated us to oppose capitalism in the first
place (see [section H.5](secH5.html)). Given this, anarchists regard _"the
Marxist party as another statist form that, if it succeeded in 'seizing
power,' would preserve the power of one human being over another, the
authority of the leader over the led. The Marxist party . . . was a mirror
image of the very society it professed to oppose, an invasion of the camp of
revolutionaries by bourgeois values, methods, and structures."_ [**The Spanish
Anarchists**, pp. 179-80] As can be seen from the history of the Russian
Revolution, this was the case with the Bolsheviks soon taking the lead in
undermining workers' self-management, soviet democracy and, finally, democracy
within the ruling party itself (see [section H.6](secH6.html)).

From an anarchist (i.e. materialist) point of view, this was highly
predictable -- after all, _"facts are before ideas; yes, the ideal, as
Proudhon said, is but a flower whose root lies in the material conditions of
existence."_ [Bakunin, **God and the State**, p. 9] So it is unsurprising that
hierarchical parties helped to maintain a hierarchical society. In the words
of the famous Sonvillier Circular: _"How could one want an egalitarian and
free society to issue from an authoritarian organisation? It is impossible."_
[quoted in **Bakunin on Anarchism**, p. 45]

We must stress here that anarchists are **not** opposed to organisation and
are **not** opposed to organisations of anarchists (i.e. **political**
organisations, although anarchists generally reject the term "party" due to
its statist and hierarchical associations). Murray Bookchin made it clear when
he wrote that the _"real question at issue here is not organisation versus
non-organisation, but rather what **kind** of organisation"_ Anarchist
organisations are _"organic developments from below . . . They are social
movements, combing a creative revolutionary lifestyle with a creative
revolutionary theory . . . As much as is humanly possibly, they try to reflect
the liberated society they seek to achieve"_ and _"co-ordination between
groups . . . discipline, planning, and unity in action . . . achieved
**voluntarily**, by means of a self-discipline nourished by conviction and
understanding."_ [**Post-Scarcity Anarchism**, pp. 138-9]

Ultimately, centralised organisations are undemocratic and, equally as
important, **ineffective.** Hierarchical organisations kill people's
enthusiasm and creativity, where plans and ideas are not adopted because they
are the best but simply because they are what a handful of leaders **think**
are best for everyone else. Really effective organisations are those which
make decisions based frank and open co-operation and debate, where dissent is
**not** stifled and ideas are adopted because of their merit and not imposed
from the top-down by a few party leaders. This is why anarchists stress
federalist organisation. It ensures that co-ordination flows from below and
there is no institutionalised leadership. By organising in a way that reflects
the kind of society we want, we train ourselves in the skills and decision
making processes required to make a free and classless society work. Means and
ends are united and this ensures that the means used will result in the
desired ends. Simply put, libertarian means must be used if you want
libertarian ends (see [section H.1.6](secH1.html#sech16) for further
discussion).

In the sections that follow, we discuss the nature and role of anarchist
organisation. Anarchists would agree with Situationist Guy Debord that a
_"revolutionary organisation must always remember that its objective is not
getting people to listen to speeches by expert leaders, but getting them to
speak for themselves."_ We organise our groups accordingly. In [section
J.3.1](secJ3.html#secj31) we discuss the basic building block of specifically
anarchist organisations, the **_"affinity group."_** Sections
[J.3.2](secJ3.html#secj32), [J.3.3](secJ3.html#secj33),
[J.3.4](secJ3.html#secj34) and [J.3.5](secJ3.html#secj35), we discuss the main
types of federations of **_affinity groups_** anarchists create to help spread
our message and influence. Then [section J.3.6](secJ3.html#secj36) highlights
the role these organisations play in our struggles to create an anarchist
society. In [section J.3.7](secJ3.html#secj37), we analyse Bakunin's
unfortunate expression _"Invisible Dictatorship"_ in order to show how many
Marxists distort Bakunin's ideas on this matter. Finally, in sections
[J.3.8](secJ3.html#secj38) and [J.3.9](secJ3.html#secj39) we discuss anarcho-
syndicalism and other anarchists attitudes to it.

Anarchist organisations, therefore, aim to enrich social struggle by their
ideas and suggestions but also, far more importantly, enrich the libertarian
idea by practical experience and activity. In other words, a two way process
by which life informs theory and theory aids life. The means by which this
social dynamic is created and developed is the underlying aim of anarchist
organisation and is reflected in its theoretical role. The power of ideas
cannot be under estimated, for _"if you have an idea you can communicate it to
a million people and lose nothing in the process, and the more the idea is
propagated the more it acquires in power and effectiveness."_ [Malatesta,
**Op. Cit.**, p. 46] The right idea at the right time, one that reflects the
needs of individuals and of required social change, can have a transforming
effect on society. That is why organisations that anarchists create to spread
their message are so important and why we devote a whole section to them.

## J.3.1 What are affinity groups?

Affinity groups are the basic organisation which anarchists create to spread
the anarchist idea. The term _"affinity group"_ comes from the Spanish F.A.I.
(**Iberian Anarchist Federation**) and refers to the organisational form
devised in their struggles for freedom (from _"grupo de afinidad"_). At its
most basic, it is a (usually small) group of anarchists who work together to
spread their ideas to the wider public, using propaganda, initiating or
working with campaigns and spreading their ideas **within** popular
organisations (such as unions) and communities. It aims not to be a
"leadership" but to give a lead, to act as a catalyst within popular
movements. Unsurprisingly it reflects basic anarchist ideas:

> _"Autonomous, communal and directly democratic, the group combines
revolutionary theory with revolutionary lifestyle in its everyday behaviour.
It creates a free space in which revolutionaries can remake themselves
individually, and also as social beings."_ [Murray Bookchin, **Post-Scarcity
Anarchism**, p. 144]

The reason for this is simple, for a _"movement that sought to promote a
liberatory revolution had to develop liberatory and revolutionary forms. This
meant . . . that it had to mirror the free society it was trying to achieve,
not the repressive one it was trying to overthrow. If a movement sought to
achieve a world united by solidarity and mutual aid, it had to be guided by
these precepts; if it sought to achieve a decentralised, stateless, non-
authoritarian society, it had to be structured in accordance with these
goals."_ [Bookchin, **The Spanish Anarchists**, p. 180]

The aim of an anarchist organisation is to promote a sense of community, of
confidence in ones own abilities, to enable all to be involved in the
identification, initiation and management of group needs, decisions and
activities. They must ensure that individuals are in a position (both
physically, as part of a group, and mentally, as an individual) to manage
their own lives and take direct action in the pursuit of individual and
communal needs and desires. Anarchist organisation is about empowering all, to
develop "integral" or whole individuals and a community that encourages
individuality (not abstract "individualism") and solidarity. It is about
collective decision making from the bottom up, that empowers those at the
"base" of the structure and only delegates the work of co-ordinating and
implementing the members decisions (and not the power of making decisions for
people). In this way the initiative and power of the few (government) is
replaced by the initiative and empowerment of all (anarchy). Affinity groups
exist to achieve these aims and are structured to encourage them.

The local affinity group is the means by which anarchists co-ordinate their
activities in a community, workplace, social movement and so on. Within these
groups, anarchists discuss their ideas, politics and hopes, what they plan to
do, organise propaganda work, discuss how they are going to work within wider
organisations like unions, how their strategies fit into their long term plans
and goals and so on. It is the basic way that anarchists work out their ideas,
pull their resources and get their message across to others. There can be
affinity groups for different interests and activities (for example a
workplace affinity group, a community affinity group, an anarcha-feminist
affinity group, etc., could all exist within the same area, with overlapping
members). Moreover, as well as these more "political" activities, the
"affinity group" also stresses the _"importance of education and the need to
live by Anarchist precepts -- the need . . . to create a counter-society that
could provide the space for people to begin to remake themselves."_ [Bookchin,
**Op. Cit.**, p. 180] In other words, "affinity groups" aim to be the _"living
germs"_ of the new society in **all** aspects, not purely in a structurally
way.

So affinity groups are self-managed, autonomous groupings of anarchists who
unite and work on specific activities and interests. This means that _"[i]n an
anarchist organisation the individual members can express any opinion and use
any tactic which is not in contradiction with accepted principles and which
does not harm the activities of others."_ [Errico Malatesta, **The Anarchist
Revolution**, p. 102] Such groups are a key way for anarchists to co-ordinate
their activity and spread their message of individual freedom and voluntary
co-operation. However, the description of what an "affinity group" is does not
explain **why** anarchists organise in that way. Essentially, these affinity
groups are the means by which anarchists actually intervene in social
movements and struggles in order to win people to the anarchist idea and so
help transform them from struggles **against** injustice into struggles
**for** a free society. We will discuss the role these groups play in
anarchist theory in [section J.3.6](secJ3.html#secj36).

These basic affinity groups are not seen as being enough in themselves. Most
anarchists see the need for local groups to work together with others in a
confederation. Such co-operation aims to pull resources and expand the options
for the individuals and groups who are part of the federation. As with the
basic affinity group, the anarchist federation is a self-managed organisation:

> _"Full autonomy, full independence and therefore full responsibility of
individuals and groups; free accord between those who believe it is useful to
unite in co-operating for a common aim; moral duty to see through commitments
undertaken and to do nothing that would contradict the accepted programme. It
is on these bases that the practical structures, and the right tools to give
life to the organisation should be built and designed. Then the groups, the
federations of groups, the federations of federations, the meetings, the
congresses, the correspondence committees and so forth. But all this must be
done freely, in such a way that the thought and initiative of individuals is
not obstructed, and with the sole view of giving greater effect to efforts
which, in isolation, would be either impossible or ineffective."_ [Malatesta,
**Op. Cit.**, p. 101]

To aid in this process of propaganda, agitation, political discussion and
development, anarchists organise federations of affinity groups. These take
three main forms, **_"synthesis"_** federations (see [section
J.3.2](secJ3.html#secj32)), **_"Platformist"_** federations (see [section
J.3.3](secJ3.html#secj33) while [section J.3.4](secJ3.html#secj34) has
criticism of this tendency) and **_"class struggle"_** groups (see [section
J.3.5](secJ3.html#secj35)). All the various types of federation are based on
groups of anarchists organising themselves in a libertarian fashion. This is
because anarchists try to live by the values of the future to the extent that
this is possible under capitalism and try to develop organisations based upon
mutual aid, in which control would be exercised from below upward, not
downward from above. We must also note here that these types of federation are
not mutually exclusive. Synthesis type federations often have "class struggle"
and "Platformist" groups within them (although, as will become clear,
Platformist federations do not have synthesis groups within them) and most
countries have different federations representing the different perspectives
within the movement. Moreover, it should also be noted that no federation will
be a totally "pure" expression of each tendency. "Synthesis" groups merge into
"class struggle" ones, Platformist groups do not subscribe totally to the
Platform and so on. We isolate each tendency to show its essential features.
In real life few, if any, federations will exactly fit the types we highlight.
It would be more precise to speak of organisations which are descended from a
given tendency, for example the French **Anarchist Federation** is mostly
influenced by the synthesis tradition but it is not, strictly speaking, 100%
synthesis. Lastly, we must also note that the term "class struggle" anarchist
group in no way implies that "synthesis" and "Platformist" groups do not
support the class struggle or take part in it, they most definitely do -- it
is simply a technical term to differentiate between types of organisation!

It must be stressed anarchists do not reduce the complex issue of political
organisation and ideas into **one** organisation but instead recognise that
different threads within anarchism will express themselves in different
political organisations (and even within the same organisation). A diversity
of anarchist groups and federations is a good sign and expresses the diversity
of political and individual thought to be expected in a movement aiming for a
society based upon freedom. All we aim to do is to paint a broad picture of
the similarities and differences between the various perspectives on
organising in the movement and indicate the role these federations play in
libertarian theory, namely of an aid in the struggle, not a new leadership
seeking power.

## J.3.2 What are "synthesis" federations?

The "synthesis" federation acquired its name from the work of Voline (a
Russian exile) and leading French anarchist Sebastien Faure in the 1920s.
Voline published in 1924 a paper calling for _"the anarchist synthesis"_ and
was also the author of the article in Faure's **Encyclopedie Anarchiste** on
the very same topic. Its roots lie in the Russian revolution and the **Nabat**
federation created in the Ukraine during 1918 whose aim was _"organising all
of the life forces of anarchism; bringing together through a common endeavour
all anarchists seriously desiring of playing an active part in the social
revolution which is defined as a process (of greater or lesser duration)
giving rise to a new form of social existence for the organised masses."_
[**No Gods, No Masters**, vol. 2, p. 117]

The "synthesis" organisation is based on uniting all kinds of anarchists in
one federation as there is, to use the words of the **Nabat**, _"validity in
all anarchist schools of thought. We must consider all diverse tendencies and
accept them."_ The synthesis organisation attempts to get different kinds of
anarchists _"joined together on a number of basic positions and with the
awareness of the need for planned, organised collective effort on the basis of
federation."_ [quoted in _"The Reply by Several Russian Anarchists"_, pp.
32-6, **Constructive Anarchism**, G. P. Maximoff (ed.), p. 32] These basic
positions would be based on a synthesis of the viewpoints of the members of
the organisation, but each tendency would be free to agree their own ideas due
to the federal nature of the organisation.

An example of this synthesis approach is provided by the differing assertions
that anarchism is a theory of classes (as stated by the Platform, among
others), that anarchism is a humanitarian ideal for all people and that
anarchism is purely about individuals (and so essentially individualist and
having nothing to do with humanity or with a class). The synthesis of these
positions would be to _"state that anarchism contains class elements as well
as humanism and individualist principles . . . Its class element is above all
its means of fighting for liberation; its humanitarian character is its
ethical aspect, the foundation of society; its individualism is the goal of
humanity."_ [**Op. Cit.**, p. 32]

So, as can be seen, the "synthesis" tendency aims to unite all anarchists (be
they individualist, mutualist, syndicalist or communist) into one common
federation. Thus the "synthesis" viewpoint is "inclusive" and obviously has
affinities with the _"anarchism without adjectives"_ approach favoured by many
anarchists (see [section A.3.8](secA3.html#seca38)). However, in practice many
"synthesis" organisations are more restrictive (for example, they could aim to
unite all **social** anarchists) and so there can be a difference between the
general idea of the synthesis and how it is concretely applied.

The basic idea behind the synthesis is that the anarchist movement (in most
countries, at most times, including France in the 1920s and Russia during the
revolution and at this time) is divided into three main tendencies: communist
anarchism, anarcho-syndicalism, and individualist anarchism. This division can
cause severe damage to the movement simply because of the many (and often
redundant) arguments and diatribes on why "my anarchism is best" can get in
the way of working in common in order to fight our common enemies (state,
capitalism and authority). The "synthesis" federations are defined by agreeing
what is the common denominator of the various tendencies within anarchism and
agreeing a minimum programme based on this for the federation. This would
allow a _"certain ideological and tactical unity among organisations"_ within
the "synthesis" federation. [**Op. Cit.**, p. 35] Moreover, as well as saving
time and energy for more important tasks, there are technical and efficiency
reasons for unifying into one organisation, namely allowing the movement to
have access to more resources and being able to co-ordinate them so as to
maximise their use and impact.

The "synthesis" federation, like all anarchist groups, aims to spread
anarchist ideas within society as a whole. They believe that their role is to
_"assist the masses only when they need such assistance . . . the anarchists
are part of the membership in the economic and social mass organisations [such
as trade unions]. They act and build as part of the whole. An immense field of
action is opened to them for ideological, social and creative activity without
assuming a position of superiority over the masses. Above all they must fulfil
their ideological and ethical influence in a free and natural manner . . .
[they] offer ideological assistance, but not in the role of leaders."_ [**Op.
Cit.**, p. 33] This, as we shall see in [section J.3.6](secJ3.html#secj36), is
the common anarchist position as regards the role of an anarchist group.

The great strength of "synthesis" federations, obviously, is that they allow a
wide and diverse range of viewpoints to be expressed within the organisation
which can allow the development of political ideas and theories by constant
discussion and debate. They allow the maximum amount of resources to be made
available to individuals and groups within the organisation by increasing the
number of members. This is why we find the original promoters of the
"synthesis" arguing that _"that first step toward achieving unity in the
anarchist movement which can lead to serious organisation is collective
ideological work on a series of important problems that seek the clearest
possible collective solution,"_ discussing _"concrete questions"_ rather than
_"philosophical problems and abstract dissertations"_ and _"suggest that there
be a publication for discussion in every country where the problems in our
ideology and tactics can be fully discussed, regardless of how 'acute' or even
'taboo' it may be. The need for such a printed organ, as well as oral
discussion, seems to us to be a 'must' because it is the practical way to try
to achieve 'ideological unity', 'tactical unity', and possibly organisation .
. . A full and tolerant discussion of our problems . . . will create a basis
for understanding, not only among anarchists, but among different conceptions
of anarchism."_ [**Op. Cit.**, p. 35]

The "synthesis" idea for anarchist organisation was taken up by those who
opposed the Platform (see [next section](secJ3.html#secj33)). For both Faure
and Voline, the basic idea was the same, namely that the various tendencies in
anarchism must co-operate and work in the same organisation. However, there
are differences between Voline's and Faure's points of view. The latter saw
these various tendencies as a wealth in themselves and advocated that each
tendency would gain from working together in a common organisation. From
Voline's point of view, the emergence of these various tendencies was
historically needed to discover the in-depth implications of anarchism in
various settings (such as the economical, the social and individual life).
However, it was the time to go back to anarchism as a whole, an anarchism
considerably empowered by what each tendency could give it, and in which
tendencies as such should dissolve. Moreover, these tendencies co-existed in
every anarchist at various levels, so all anarchists should aggregate in an
organisation where these tendencies would disappear (both individually and
organisationally, i.e. there would not be an "anarcho-syndicalist" specific
tendency inside the organisation, and so forth).

The "synthesis" federation would be based on complete autonomy (within the
basic principles of the Federation and Congress decisions, of course) for
groups and individuals, so allowing all the different trends to work together
and express their differences in a common front. The various groups would be
organised in a federal structure, combining to share resources in the struggle
against state, capitalism and other forms of oppression. This federal
structure is organised at the local level through a "local union" (i.e. the
groups in a town or city), at the regional level (i.e. all groups in, say,
Strathclyde are members of the same regional union) up to the "national" level
(i.e. all groups in Scotland, say) and beyond.

As every group in the federation is autonomous, it can discuss, plan and
initiate an action (such as campaign for a reform, against a social evil, and
so on) without having to wait for others in the federation (or have to wait
for instructions). This means that the local groups can respond quickly to
issues and developments. This does not mean that each group works in
isolation. These initiatives may gain federal support if local groups see the
need. The federation can adopt an issue if it is raised at a federal
conference and other groups agree to co-operate on that issue. Moreover, each
group has the freedom **not** to participate on a specific issue while leaving
others to do so. Thus groups can concentrate on what they are interested in
most.

The programme and policies of the federation would be agreed at regular
delegate meetings and congresses. The "synthesis" federation is managed at the
federal level by "relations committees" made up of people elected and mandated
at the federation congresses. These committees would have a purely
administrative role, spreading information, suggestions and proposals coming
from groups and individuals within the organisation, looking after the
finances of the federation and so on. They do not have any more rights than
any other member of the federation (i.e. they could not make a proposal as a
committee, just as members of their local group or as individuals). These
administrative committees are accountable to the federation and subject to
both mandates and recall.

Most national sections of the **International of Anarchist Federations** (IFA)
are good examples of successful federations which are heavily influenced by
"synthesis" ideas (such as the French and Italian federations). Obviously,
though, how effective a "synthesis" federation is depends upon how tolerant
members are of each other and how seriously they take their responsibilities
towards their federations and the agreements they make.

Of course, there are problems with most forms of organisation, and the
"synthesis" federation is no exception. While diversity can strengthen an
organisation by provoking debate, a too diverse grouping can often make it
difficult to get things done. Platformist and other critics of the "synthesis"
federation argue that it can be turned into a talking shop and any common
programme difficult to agree, never mind apply. For example, how can
mutualists and communists agree on the ends, never mind the means, their
organisation supports? One believes in co-operation within a (modified) market
system and reforming capitalism away, while the other believes in the
abolition of commodity production and money, seeing revolution as the means of
so doing. Ultimately, all they could do would be to agree to disagree and thus
any joint programmes and activity would be somewhat limited. It could, indeed,
be argued that both Voline and Faure forgot essential points, namely what is
this common denominator between the different kinds of anarchism, how do we
achieve it and what is in it? For without this agreed common position, many
synthesist organisations do end up becoming little more than talking shops,
escaping from any social or organisational perspective. This seems to have
been the fate of many groups in Britain and America during the 1960s and
1970s, for example.

It is this (potential) disunity that lead the authors of the Platform to argue
that _"[s]uch an organisation having incorporated heterogeneous theoretical
and practical elements, would only be a mechanical assembly of individuals
each having a different conception of all the questions of the anarchist
movement, an assembly which would inevitably disintegrate on encountering
reality."_ [**The Organisational Platform of the Libertarian Communists**, p.
12] The Platform suggested _"Theoretical and Tactical Unity"_ as a means of
overcoming this problem, but that term provoked massive disagreement in
anarchist circles (see [section J.3.4](secJ3.html#secj34)). In reply to the
Platform, supporters of the "synthesis" counter by pointing to the fact that
"Platformist" groups are usually very small, far smaller that "synthesis"
federations (for example, compare the size of the **French Anarchist
Federation** with, say, the Irish **Workers Solidarity Movement** or the
French-language **Alternative Libertaire**). This means, they argue, that the
Platform does not, in fact, lead to a more effective organisation, regardless
of the claims of its supporters. Moreover, they argue that the requirements
for _"Theoretical and Tactical Unity"_ help ensure a small organisation as
differences would express themselves in splits rather than constructive
activity. Needless to say, the discussion continues within the movement on
this issue!

What can be said is that this potential problem within "synthesisism" has been
the cause of some organisations failing or becoming little more than talking
shops, with each group doing its own thing and so making co-ordination
pointless as any agreements made would be ignored. Most supporters of the
synthesis would argue that this is not what the theory aims for and that the
problem lies in misunderstanding it rather than in the theory itself (as can
be seen from mainland Europe, "synthesis" inspired federations can be **very**
successful). Non-supporters are more critical, with some supporting the
"Platform" as a more effective means of organising to spread anarchist ideas
and influence (see the [next section](secJ3.html#secj33)). Other social
anarchists create the "class struggle" type of federation (this is a common
organisational form in Britain, for example) as discussed in [section
J.3.5](secJ3.html#secj35).

## J.3.3 What is the "Platform"?

The Platform is a current within anarcho-communism which has specific
suggestions on the nature and form which an anarchist federation should take.
Its roots lie in the Russian anarchist movement, a section of which, in 1926,
published **_"The Organisational Platform of the Libertarian Communists"_**
when in exile from the Bolshevik dictatorship. The authors of the work
included Nestor Makhno, Peter Arshinov and Ida Mett. At the time it provoked
intense debate (and still does in many anarchist circles) between supporters
of the Platform (usually called "Platformists") and those who oppose it (which
includes other communist-anarchists, anarcho-syndicalists and supporters of
the "synthesis"). We will discuss why many anarchists oppose the Platform in
the [next section](secJ3.html#secj34). Here we discuss what the Platform
argued for.

Like the "synthesis" federation (see [last section](secJ3.html#secj32)), the
Platform was created in response to the experiences of the Russian Revolution.
The authors of the Platform (like Voline and other supporters of the
"synthesis") had participated in that Revolution and saw all their work, hopes
and dreams fail as the Bolshevik state triumphed and destroyed any chances of
socialism by undermining soviet democracy, workers' self-management of
production, trade union democracy as well as fundamental individual freedoms
and rights (see the [section H.6](secH6.html) for details). Moreover, the
authors of the Platform had been leading activists in the Makhnovist movement
in the Ukraine which had successfully resisted both White and Red armies in
the name of working class self-determination and anarchism. Facing the same
problems as the Bolshevik government, the Makhnovists had actively encouraged
popular self-management and organisation, freedom of speech and of
association, and so on, whereas the Bolsheviks had not. Thus they were aware
that anarchist ideas not only worked in practice, but that the claims of
Leninists who maintained that Bolshevism (and the policies it introduced at
the time) was the only "practical" response to the problems facing a
revolution were false.

They wrote the pamphlet in order to examine why the anarchist movement had
failed to build on its successes in gaining influence within the working
class. As can be seen from libertarian participation in the factory committee
movement, where workers organised self-management in their workplaces and
anarchist ideas had proven to be both popular and practical. While repression
by the Bolsheviks did play a part in this failure, it did not explain
everything. Also important, in the eyes of the Platform authors, was the lack
of anarchist organisation **before** the revolution:

> _"It is very significant that, in spite of the strength and incontestably
positive character of libertarian ideas, and in spite of the facing up to the
social revolution, and finally the heroism and innumerable sacrifices borne by
the anarchists in the struggle for anarchist communism, the anarchist movement
remains weak despite everything, and has appeared, very often, in the history
of working class struggles as a small event, an episode, and not an important
factor."_ [**Organisational Platform of the Libertarian Communists**, p. 11]

This weakness in the movement derived, they argued, from a number of causes,
the main one being _"the absence of organisational principles and practices"_
within the anarchist movement. This resulted in an anarchist movement
_"represented by several local organisations advocating contradictory theories
and practices, having no perspectives for the future, nor of a continuity in
militant work, and habitually disappearing, hardly leaving the slightest trace
behind them."_ This explained the _"contradiction between the positive and
incontestable substance of libertarian ideas, and the miserable state in which
the anarchist movement vegetates."_ [**Op. Cit.**, p. 11] For anyone familiar
with the anarchist movement in many countries, these words will still strike
home. Thus the Platform still appears to many anarchists a relevant and
important document, even if they are not Platformists.

The author's of the Platform proposed a solution to this problem, namely the
creation of a new type of anarchist organisation. This organisation would be
based upon communist-anarchist ideas exclusively, while recognising
syndicalism as a principal method of struggle. Like most anarchists, the
Platform placed class and class struggle at the centre of their analysis,
recognising that the _"social and political regime of all states is above all
the product of class struggle . . . The slightest change in the course of the
battle of classes, in the relative locations of the forces of the class
struggle, produces continuous modifications in the fabric and structure of
society."_ Again, like most anarchists, the Platform aimed to _"transform the
present bourgeois capitalist society into a society which assures the workers
the products of the labours, their liberty, independence, and social and
political equality"_, one based on a _"workers organisations of production and
consumption, united federatively and self-administering."_ The _"birth, the
blossoming, and the realisation of anarchist ideas have their roots in the
life and the struggle of the working masses and are inseparable bound to their
fate."_ [**Op. Cit.**, p. 14, p. 15, p. 19 and p. 15] Again, most anarchists
(particularly social anarchists) would agree -- anarchist ideas will wither
when isolated from working class life since only working class people, the
vast majority, can create a free society and anarchist ideas are expressions
of working class experience (remove the experience and the ideas do not
develop as they should).

In order to create such a free society it is necessary, argue the
Platformists, _"to work in two directions: on the one hand towards the
selection and grouping of revolutionary worker and peasant forces on a
libertarian communist theoretical basis (a specifically libertarian communist
organisation); on the other hand, towards regrouping revolutionary workers and
peasants on an economic base of production and consumption (revolutionary
workers and peasants organised around production [i.e. syndicalism]; workers
and free peasants co-operatives)."_ Again, most anarchists would agree with
this along with the argument that _"anarchism should become the leading
concept of revolution . . . The leading position of anarchist ideas in the
revolution suggests an orientation of events after anarchist theory. However,
this theoretical driving force should not be confused with the political
leadership of the statist parties which leads finally to State Power."_ [**Op.
Cit.**, p. 20 and p. 21]

This _"leadership of ideas"_ (as it has come to be known) would aim at
developing and co-ordinating libertarian feelings already existing within
social struggle. _"Although the masses,"_ explained the Platform, _"express
themselves profoundly in social movements in terms of anarchist tendencies and
tenets, these . . . do however remain dispersed, being uncoordinated, and
consequently do not lead to the . . . preserving [of] the anarchist
orientation of the social revolution."_ [**Op. Cit.**, p. 21] The Platform
argued that a specific anarchist organisation was required to ensure that the
libertarian tendencies initially expressed in any social revolution or
movement (for example, free federation, self-management in mass assemblies,
mandating of delegates, decentralisation, etc.) do not get undermined by
statists and authoritarians who have their own agendas. This would be done by
actively working in mass organisation and winning people to libertarian ideas
and practices by argument (see [section J.3.6](secJ3.html#secj36)).

However, these principles do not, in themselves, determine a Platformist
organisation. After all, most anarcho-syndicalists and non-Platformist
communist-anarchists would agree with these positions. The main point which
distinguishes the Platform is its position on how an anarchist organisation
should be structured and work. This is sketched in the _"Organisational
Section,"_ the shortest and most contentious part of the whole work. They
called this the **General Union of Anarchists** and where they introduced the
concepts of **_"Theoretical and Tactical Unity"_** and **_"Collective
Responsibility,"_** concepts which are unique to the Platform. Even today
within the anarchist movement these are contentious ideas so it is worth
exploring them in a little more detail.

By _"Theoretical Unity"_ the Platform meant any anarchist organisation must
come to an agreement on the theory upon which it is based. In other words,
that members of the organisation must agree on a certain number of basic
points, such as class struggle, social revolution and libertarian communism,
and so on. An organisation in which half the members thought that union
struggles were important and the other half that they were a waste of time
would not be effective as the membership would spend all their time arguing
with themselves. While most Platformists admit that everyone will not agree on
everything, they think it is important to reach as much agreement as possible,
and to translate this into action. Once a theoretical position is reached, the
members have to argue it in public (even if they initially opposed it within
the organisation but they do have the right to get the decision of the
organisation changed by internal discussion). Which brings us to _"Tactical
Unity"_ by which the Platform meant that the members of an organisation should
struggle together **as an organised force** rather than as individuals. Once a
strategy has been agreed by the Union, all members would work towards ensuring
its success (even if they initially opposed it). In this way resources and
time are concentrated in a common direction, towards an agreed objective.

Thus _"Theoretical and Tactical Unity"_ means an anarchist organisation that
agrees specific ideas and the means of applying them. The Platform's basic
assumption is that there is a link between coherency and efficiency. By
increasing the coherency of the organisation by making collective decisions
and applying them, the Platform argues that this will increase the influence
of anarchist ideas. Without this, they argue, more organised groups (such as
Leninist ones) would be in a better position to have their arguments heard and
listened to than anarchists would. Anarchists cannot be complacent, and rely
on the hope that the obvious strength and rightness of our ideas will shine
through and win the day. As history shows, this rarely happens and when it
does, the authoritarians are usually in positions of power to crush the
emerging anarchist influence (this was the case in Russia, for example).
Platformists argue that the world we live in is the product of struggles
between competing ideas of how society should be organised and if the
anarchist voice is weak, quiet and disorganised it will not be heard and other
arguments, other perspectives, will win the day.

Which brings us to _"Collective Responsibility,"_ which the Platform defines
as _"the entire Union will be responsible for the political and revolutionary
activity of each member; in the same way, each member will be responsible for
the political and revolutionary activity of the Union."_ In short, that each
member should support the decisions made by the organisation and that each
member should take part in the process of collective decision making process.
Without this, argue Platformists, any decisions made will be paper ones as
individuals and groups would ignore the agreements made by the federation (the
Platform calls this _"the tactic of irresponsible individualism"_). [**Op.
Cit.**, p. 32] With _"Collective Responsibility,"_ the strength of all the
individuals that make up the group is magnified and collectively applied.

The last principle in the _"Organisational Section"_ of the Platform is
_"Federalism,"_ which it defined as _"the free agreement of individuals and
organisations to work collectively towards a common objective"_ and which
_"reconciles the independence and initiative of individuals and the
organisation with service to the common cause."_ However, the Platform argued
that this principle has been _"deformed"_ within the movement to mean the
_"right"_ to _"manifest one's 'ego,' without obligation to account for duties
as regards the organisation"_ one is a member of. In order to overcome this
problem, they stress that _"the federalist type of anarchist organisation,
while recognising each member's rights to independence, free opinion,
individual liberty and initiative, requires each member to undertake fixed
organisation duties, and demands execution of communal decisions."_ [**Op.
Cit.**, p. 33 and pp. 33-4]

As part of their solution to the problem of anarchist organisation, the
Platform suggested that each group would have _"its secretariat, executing and
guiding theoretically the political and technical work of the organisation."_
Moreover, the Platform urged the creation of an _"**executive committee of the
Union**"_ which would _"be in charge"_ of _"the execution of decisions taken
by the Union with which it is entrusted; the theoretical and organisational
orientation of the activity of isolated organisations consistent with the
theoretical positions and the general tactical lines of the Union; the
monitoring of the general state of the movement; the maintenance of working
and organisational links between all the organisations in the Union; and with
other organisation."_ The rights, responsibilities and practical tasks of the
executive committee are fixed by the congress of the Union. [**Op. Cit.**, p.
34]

This suggestion, unsurprisingly, meet with strong disapproval by most
anarchists, as we will see in the [next section](secJ3.html#secj34), who
argued that this would turn the anarchist movement into a centralised,
hierarchical party similar to the Bolsheviks. Needless to say, supporters of
the Platform reject this argument and point out that the Platform itself is
not written in stone and needs to be discussed fully and modified as required.
In fact, few, if any, Platformist groups, do have this _"secretariat"_
structure (it could, in fact, be argued that there are no actual "Platformist"
groups, rather groups influenced by the Platform, namely on the issues of
_"Theoretical and Tactical Unity"_ and _"Collective Responsibility"_).

Similarly, most modern day Platformists reject the idea of gathering all
anarchists into one organisation. The original Platform seemed to imply that
the **General Union** would be an umbrella organisation, made up of different
groups and individuals. Most Platformists would argue that not only will there
never be one organisation which encompasses everyone, they do not think it
necessary. Instead they envisage the existence of a number of organisations,
each internally unified, each co-operating with each other where possible, a
much more amorphous and fluid entity than a **General Union of Anarchists**.

As well as the original Platform, most Platformists place the **Manifesto of
Libertarian Communism** by Georges Fontenis and **Towards a Fresh Revolution**
by the _"Friends of Durruti"_ as landmark texts in the Platformist tradition.
A few anarcho-syndicalists question this last claim, arguing that the
_"Friends of Durruti"_ manifesto has strong similarities with the CNT's
pre-1936 position on revolution and thus is an anarcho-syndicalist document,
going back to the position the CNT ignored after July 19th, 1936. Alexandre
Skirda's book **Facing the Enemy** contains the key documents on the original
Platformists (including the original draft Platform, supplementary documents
clarifying issues and polemics against critiques). There are numerous
Platformist and Platformist influenced organisations in the world today, such
as the Irish **Workers Solidarity Movement** and Italian **Federation of
Anarchist Communists**.

In the [next section](secJ3.html#secj34) we discuss the objections that most
anarchists have towards the Platform.

## J.3.4 Why do many anarchists oppose the "Platform"?

When the "Platform" was published it provoked a massive amount of debate and
comment, the majority of it critical. Most famous anarchists rejected the
Platform. Indeed, only Nestor Makhno (who co-authored the work) supported its
proposals, with (among others) Alexander Berkman, Emma Goldman, Voline, G.P.
Maximoff, Luigi Fabbri, Camilo Berneri and Errico Malatesta rejecting its
suggestions on how anarchists should organise. Some argued that the Platform
was trying to _"Bolshevise"_ anarchism (_""They are only one step away from
bolshevism."_ [_"The Reply by Several Russian Anarchists"_, pp. 32-6,
**Constructive Anarchism**, G.P. Maximoff (ed.), pp. 36]). Others, such as
Malatesta, suggested that the authors were too impressed by the apparent
"success" of the Bolsheviks in Russia. Since then, it has continued to provoke
a lot of debate in anarchist circles. So why do so many anarchists oppose the
Platform?

While many of the anti-Platformists made points about most parts of the
Platform (both Maximoff and Voline pointed out that while the Platform denied
the need of a _"Transitional Period"_ in theory, it accepted it in practice,
for example) the main bone of contention was found in the _"Organisational
Section"_ with its call for _"Tactical and Theoretical Unity,"_ _"Collective
Responsibility"_ and group and executive _"secretariats"_ guiding the
organisation. Here most anarchists found ideas they considered incompatible
with libertarian ideas. We will concentrate on this issue as it is usually
considered as the most important.

Today, in some quarters of the libertarian movement, the Platformists are
often dismissed as "would-be leaders." Yet this was not where Malatesta and
other critics of the Platform took issue. Malatesta and Maximoff both argued
that, to use Maximoff's words, anarchists should _"go into the masses. . . ,
work[ing] with them, struggle for their soul, and attempt to win it
**ideologically** and give it guidance."_ So the question was _"not the
rejection of **leadership,** but making certain it is **free** and
**natural.**"_ [**Constructive Anarchism**, p. 19] Moreover, as Maximoff
noted, the "synthesis" anarchists came to the same conclusion. Thus all sides
of the debate accepted that anarchists should take the lead. The question, as
Malatesta and the others saw it, was not whether to lead, but rather **how**
you should lead - a fairly important distinction.

Malatesta posed two alternatives, either you _"provide leadership by advice
and example leaving people themselves to . . . adopt our methods and solutions
if these are, or seem to be, better than those suggested and carried out by
others"_ or you can _"direct by taking over command, that is by becoming a
government."_ He asked the Platformists: _"In which manner do you wish to
direct?"_ While he thought, from his knowledge of Makhno and his work, that
the answer would be the first option, he was _"assailed by doubt that [Makhno]
would also like to see, within the general movement, a central body that
would, in an authoritarian manner, dictate the theoretical and practical
programme for the revolution."_ This was because of the _"Executive
Committee"_ in the Platform which would _"give ideological and organisational
direction to the association."_ [**The Anarchist Revolution**, p. 108 and p.
110]

Maximoff made the same point, arguing that the Platform implied that
anarchists in the unions are responsible to the anarchist federation, **not**
to the union assemblies that elected them. As he put it, according to the
Platform anarchists _"are to join the Trades Unions with ready-made recipes
and are to carry out their plans, if necessary, against the will of the Unions
themselves."_ This was just one example of a general problem, namely that the
Platform _"places its Party on the same height as the Bolsheviks do, i.e., it
places the interests of the Party above the interests of the masses since the
Party has the monopoly of understanding these interests."_ [**Constructive
Anarchism**, p. 19 and p. 18] This flowed from the Platform arguing that
anarchists must _"enter into revolutionary trade unions as an organised force,
responsible to accomplish work in the union before the general anarchist
organisation and orientated by the latter."_ However, Maximoff's argument may
be considered harsh as the Platform also argued that anarchism _"aspires
neither to political power nor dictatorship"_ and so they would hardly be
urging the opposite principles within the trade union movement. [**The
Organisational Platform of the Libertarian Communists**, p. 25 and p. 21] If
we take the Platform's comments within a context informed by the _"leadership
of ideas"_ concept (see [section J.3.6](secJ3.html#secj36)) then what they
meant was simply that the anarchist group would convince the union members of
the validity of their ideas by argument which was something Maximoff did not
disagree with. In short, the disagreement becomes one of unclear (or bad) use
of language by the Platform's authors.

Despite many efforts and many letters on the subject (in particular between
Malatesta and Makhno) the question of "leadership" could not be clarified to
either side's satisfaction, in part because there was an additional issue in
dispute. This was the related issue of organisational principles (which in
themselves make up the defining part of the original Platform). Malatesta
argued that this did not conform with anarchist methods and principles, and so
could not _"help bring about the triumph of anarchism."_ [**The Anarchist
Revolution**, p. 97] This was because of two main reasons, the first being the
issue of the Platform's "secretariats" and "executive committee" and the issue
of "Collective Responsibility." We will take each in turn.

With a structure based round "secretariats" and "executive committees" the
_"will of the [General] Union [of Anarchists] can only mean the will of the
majority, expressed through congresses which nominate and control the
**Executive Committee** and decide on all important issues. Naturally, the
congresses would consist of representatives elected by the majority of member
groups . . . So, in the best of cases, the decisions would be taken by a
majority of a majority, and this could easily, especially when the opposing
opinions are more than two, represent only a minority."_ This, Malatesta
argued, _"comes down to a pure majority system, to pure parliamentarianism"_
and so non-anarchist in nature. [**Op. Cit.**, p. 100]

As long as a Platformist federation is based on _"secretariats"_ and
_"executive committees"_ directing the activity and development of the
organisation, this critique is valid. In such a system, as these bodies
control the organisation and members are expected to follow their decisions
(due to _"theoretical and tactical unity"_ and _"collective responsibility"_)
they are, in effect, the government of the association. While this government
may be elected and accountable, it is still a government simply because these
bodies have executive power. As Maximoff argued, individual initiative in the
Platform _"has a special character . . . Each organisation (i.e. association
of members with the right to individual initiative) has its secretariat which
. . . **directs** the ideological, political and technical activities of the
organisation . . . In what, then, consists the self-reliant activities of the
rank-and-file members? Apparently in one thing: initiative to obey the
secretariat and carry out its directives."_ [**Op. Cit.**, p. 18] This seems
to be the logical conclusion of the structure suggested by the Platform. _"The
spirit,"_ argued Malatesta, _"the tendency remains authoritarian and the
educational effect would remain anti-anarchist."_ [**Op. Cit.**, p. 98]

Malatesta, in contrast, argued that an anarchist organisation must be based on
the _"[f]ull autonomy, full independence and therefore the full responsibility
of individuals and groups"_ with all organisational work done _"freely, in
such a way that the thought and initiative of individuals is not obstructed."_
The individual members of such an organisation _"express any opinion and use
any tactic which is not in contradiction with accepted principles and which
does not harm the activities of others."_ Moreover, the administrative bodies
such organisations nominate would _"have no executive powers, have no
directive powers"_ leaving it up to the groups and their federal meetings to
decide their own fates. The congresses of such organisations would be _"free
from any kind of authoritarianism, because they do not lay down the law; they
do not impose their own resolutions on others . . . and do not become binding
and enforceable except on those who accept them."_ [**Op. Cit.**, p. 101, p.
102 and p. 101] Such an organisation does not exclude collective decisions and
self-assumed obligations, rather it is based upon them.

Most groups inspired by the Platform, however, seem to reject this aspect of
its organisational suggestions. Instead of "secretariats" and "executive
committees" they have regular conferences and meetings to reach collective
decisions on issues and practice unity that way. Thus the **really** important
issue is of _"theoretical and tactical unity"_ and _"collective
responsibility,"_ rather than the structure suggested by the Platform. Indeed,
this issue was the main topic in Makhno's letter to Malatesta, for example,
and so we would be justified in saying that this is the key issue dividing
"Platformists" from other anarchists.

So in what way did Malatesta disagree with this concept? As we mentioned in
the [last section](secJ3.html#secj33), the Platform defined the idea of
"Collective Responsibility" as _"the entire Union will be responsible for the
political and revolutionary activity of each member; in the same way, each
member will be responsible for the political and revolutionary activity of the
Union."_ To which Malatesta replied:

> _"But if the Union is responsible for what each member does, how can it
leave to its members and to the various groups the freedom to apply the common
programme in the way they think best? How can one be responsible for an action
if it does not have the means to prevent it? Therefore, the Union and in its
name the Executive Committee, would need to monitor the action of the
individual member and order them what to do and what not to do; and since
disapproval after the event cannot put right a previously accepted
responsibility, no-one would be able to do anything at all before having
obtained the go-ahead, the permission of the committee. And, on the other
hand, can an individual accept responsibility for the actions of a
collectivity before knowing what it will do and if he cannot prevent it doing
what he disapproves of?"_ [**Op. Cit.**, p. 99]

In other words, the term _"collective responsibility"_ (if taken literally)
implies a highly inefficient and somewhat authoritarian mode of organisation.
Before any action could be undertaken, the organisation would have to be
consulted and this would crush individual, group and local initiative. The
organisation would respond slowly to developing situations, if at all, and
this response would not be informed by first hand knowledge and experience.
Moreover, this form of organisation implies a surrendering of individual
judgement, as members would have to _"submit to the decisions of the majority
before they have even heard what those might be."_ [Malatesta, **Op. Cit.**,
101] In the end, all a member could do would be to leave the organisation if
they disagree with a tactic or position and could not bring themselves to
further it by their actions.

This structure also suggests that the Platform's commitment to federalism is
in words only. As most anarchists critical of the Platform argued, while its
authors affirm federalist principles they, in fact, _"outline a perfectly
centralised organisation with an Executive Committee that has responsibility
to give ideological and organisational direction to the different anarchist
organisations, which in turn will direct the professional organisations of the
workers."_ [_"The Reply by Several Russian Anarchists"_, **Op. Cit.**, pp.
35-6]

Thus it is likely that "Collective Responsibility" taken to its logical
conclusion would actually **hinder** anarchist work by being too bureaucratic
and slow. However, let us assume that by applying collective responsibility as
well as tactical and theoretical unity, anarchist resources and time will be
more efficiently utilised. What is the point of being "efficient" if the
collective decision reached is wrong or is inapplicable to many areas? Rather
than local groups applying their knowledge of local conditions and developing
theories and policies that reflect these conditions (and co-operating from the
bottom up), they may be forced to apply inappropriate policies due to the
"Unity" of the Platformist organisation. It is true that Makhno argued that
the _"activities of local organisations can be adapted, as far as possible, to
suit local conditions"_ but only if they are _"consonant with the pattern of
the overall organisational practice of the Union of anarchists covering the
whole country."_ [**The Struggle Against the State and Other Essays**, p. 62]
Which still begs the question on the nature of the Platform's unity (however,
it does suggest that the Platform's position may be less extreme than might be
implied by the text, as we will discuss). That is why anarchists have
traditionally supported federalism and free agreement within their
organisations, to take into account the real needs of localities.

If we do not take the Platform's definition of "Collective Responsibility"
literally or to its logical extreme (as Makhno's comments suggest) then the
differences between Platformists and non-Platformists may not be that far. As
Malatesta pointed out in his reply to Makhno's letter:

> _"I accept and support the view that anyone who associates and co-operates
with others for a common purpose must feel the need to co-ordinate his [or
her] actions with those of his [or her] fellow members and do nothing that
harms the work of others . . . and respect the agreements that have been made
. . . [Moreover] I maintain that those who do not feel and do not practice
that duty should be thrown out of the association. _

> _"Perhaps, speaking of collective responsibility, you mean precisely that
accord and solidarity that must exist among members of an association. And if
that is so, your expression amounts . . . to an incorrect use of language, but
basically it would only be an unimportant question of wording and agreement
would soon be reached."_ [**Op. Cit.**, pp. 107-8]

This, indeed, seems to be the way that most Platformist organisations do
operate. They have agreed broad theoretical and tactical positions on various
subjects (such as, for example, the nature of trade unions and how anarchists
relate to them) while leaving it to local groups to act within these
guidelines. Moreover, the local groups do not have to report to the
organisation before embarking on an activity. In other words, most Platformist
groups do not take the Platform literally and so many differences are, to a
large degree, a question of wording. As two supporters of the Platform note:

> _"The Platform doesn't go into detail about how collective responsibility
works in practice. There are issues it leaves untouched such as the question
of people who oppose the majority view. We would argue that obviously people
who oppose the view of the majority have a right to express their own views,
however in doing so they must make clear that they don't represent the view of
the organisation. If a group of people within the organisation oppose the
majority decision they have the right to organise and distribute information
so that their arguments can be heard within the organisation as a whole. Part
of our anarchism is the belief that debate and disagreement, freedom and
openness strengthens both the individual and the group to which she or he
belongs."_ [Aileen O'Carroll and Alan MacSimoin, _"The Platform"_, pp. 29-31,
**Red and Black Revolution**, no. 4, p. 30]

While many anarchists are critical of Platformist groups for being too
centralised for their liking, it is the case that the Platform has influenced
many anarchist organisations, even non-Platformist ones (this can be seen in
the "class struggle" groups discussed in the [next
section](secJ3.html#secj35)). This influence has been both ways, with the
criticism the original Platform was subjected to having had an effect on how
Platformist groups have developed. This, of course, does not imply that there
is little or no difference between Platformists and other anarchists.
Platformist groups tend to stress "collective responsibility" and "theoretical
and tactical unity" more than others, which has caused problems when
Platformists have worked within "synthesis" organisations (as was the case in
France, for example, which resulted in much bad-feeling between Platformists
and others).

**Constructive Anarchism** by the leading Russian anarcho-syndicalist G.P. Maximoff gathers all the relevant documents in one place. As well as Maximoff's critique of the Platform, it includes the "synthesis" reply, Malatesta's review and subsequent exchange of letters between him and Makhno. **The Anarchist Revolution** also contains Malatesta's article and the exchange of letters between him and Makhno.

## J.3.5 Are there other kinds of anarchist federation?

Yes. Another type of anarchist federation is what we term the **_"class
struggle"_** group. Many local anarchist groups in Britain, for example,
organise in this fashion. They use the term "class struggle" to indicate that
their anarchism is based on collective working class resistance as opposed to
reforming capitalism via lifestyle changes and the support of, say, co-
operatives (many "class struggle" anarchists do these things, of course, but
they are aware that they cannot create an anarchist society by so doing). We
follow this use of the term here. And just to stress the point again, our use
of "class struggle" to describe this type of anarchist group does not imply
that "synthesis" or "Platformist" do not support the class struggle. They do!

This kind of group is half-way between the "synthesis" and the "Platform." The
"class struggle" group agrees with the "synthesis" in so far as it is
important to have a diverse viewpoints within a federation and that it would
be a mistake to try to impose a common-line on different groups in different
circumstances as the Platform does. However, like the "Platform," the class
struggle group recognises that there is little point in creating a forced
union between totally different strands of anarchism. Thus the "class
struggle" group rejects the idea that individualist or mutualist anarchists
should be part of the same organisation as anarchist communists or
syndicalists or that anarcho-pacifists should join forces with non-pacifists.
Thus the "class struggle" group acknowledges that an organisation which
contains viewpoints which are dramatically opposed can lead to pointless
debates and paralysis of action due to the impossibilities of overcoming those
differences.

Instead, the "class struggle" group agrees a common set of **_"aims and
principles"_** which are the basic terms of agreement within the federation.
If an individual or group does not agree with this statement then they cannot
join. If they are members and try to change this statement and cannot get the
others to agree its modification, then they are morally bound to leave the
organisation. In other words, there is a framework within which individuals
and groups apply their own ideas and their interpretation of agreed policies.
It means that individuals in a group and the groups within a federation have
something to base their local activity on, something which has been agreed
collectively. There would be a common thread to activities and a guide to
action (particularly in situations were a group or federation meeting cannot
be called). In this way individual initiative and co-operation can be
reconciled, without hindering either. In addition, the **_"aims and
principles"_** shows potential members where the anarchist group was coming
from.

In this way the "class struggle" group solves one of the key problems with the
"synthesis" grouping, namely that any such basic statement of political ideas
would be hard to agree and be so watered down as to be almost useless (for
example, a federation combining individualist and communist anarchists would
find it impossible to agree on such things as the necessity for revolution,
communal ownership, and so on). By clearly stating its ideas, the "class
struggle" group ensures a common basis for activity and discussion.

Such a federation, like all anarchist groups, would be based upon regular
assemblies locally and in frequent regional, national, etc., conferences to
continually re-evaluate policies, tactics, strategies and goals. In addition,
such meetings prevent power from collecting in the higher administration
committees created to co-ordinate activity. The regular conferences aim to
create federation policies on specific topics and agree common strategies.
Such policies, once agreed, are morally binding on the membership, who can
review and revise them as required at a later stage but cannot take action
which would hinder their application (they do not have to apply them, if they
consider them as a big mistake).

For example, minorities in such a federation can pursue their own policies as
long as they clearly state that theirs is a minority position and does not
contradict the federation's aims and principles. In this way the anarchist
federation combines united action and dissent, for no general policy will be
applicable in all circumstances and it is better for minorities to ignore
policies which they know will make even greater problems in their area. As
long as their actions and policies do not contradict the federation's basic
political ideas, then diversity is an essential means for ensuring that the
best tactic and ideas are be identified.

## J.3.6 What role do these groups play in anarchist theory?

The aim of anarchist groups and federations is to spread libertarian ideas
within society and within social movements. They aim to convince people of the
validity of anarchist ideas and analysis, of the need for a libertarian
transformation of society and of themselves by working with others as equals.
Such groups are convinced that (to use Murray Bookchin's words) _"anarcho-
communism cannot remain a mere mood or tendency, wafting in the air like a
cultural ambience. It must be organised -- indeed **well-organised** \-- if it
is effectively to articulate and spread this new sensibility; it must have a
coherent theory and extensive literature; it must be capable of duelling with
the authoritarian movements that try to denature the intuitive libertarian
impulses of our time and channel social unrest into hierarchical forms of
organisation."_ [_"Looking Back at Spain,"_ pp. 53-96, Dimitrios I.
Roussopoulos (ed.), **The Radical Papers**, p. 90]

These groups and federations play a key role in anarchist theory. This is
because anarchists are well aware that there are different levels of knowledge
and consciousness in society. While people learn through struggle and their
own experiences, different people develop at different speeds, that each
individual is unique and is subject to different influences. As one pamphlet
by the British **Anarchist Federation** puts it, the _"experiences of working
class life constantly lead to the development of ideas and actions which
question the established order . . . At the same time, different sections of
the working class reach different degrees of consciousness."_ [**The Role of
the Revolutionary Organisation**, p. 13] This can easily be seen from any
group of individuals of the same class or even community. Some are anarchists,
others Marxists, some social democrats/labourites, others conservatives,
others liberals, most "apolitical," some support trade unions, others are
against and so on.

Because we are aware that we are one tendency among many, anarchists organise
as anarchists to influence social struggle. Only when anarchists ideas are
accepted by the vast majority will an anarchist society be possible. We wish,
in other words, to win the most widespread understanding and influence for
anarchist ideas and methods in the working class and in society, primarily
because we believe that these alone will ensure a successful revolutionary
transformation of society. Hence Malatesta:

> _"anarchists, convinced of the validity of our programme, must strive to
acquire overwhelming influence in order to draw the movement towards the
realisation of our ideals. But such influence must be won by doing more and
better than others, and will be useful if won in that way . . . we must
deepen, develop and propagate our ideas and co-ordinate our forces in a common
action. We must act within the labour movement to prevent it being limited to
and corrupted by the exclusive pursuit of small improvements compatible with
the capitalist system . . . We must work with . . . [all the] masses to awaken
the spirit of revolt and the desire for a free and happy life. We must
initiate and support all movements that tend to weaken the forces of the State
and of capitalism and to raise the mental level and material conditions of the
workers."_ [**The Anarchist Revolution**, p. 109]

Anarchist organisation exists to help the process by which people come to
anarchist conclusions. It aims to make explicit the feelings and thoughts that
people have (such as, wage slavery is hell, that the state exists to oppress
people and so on) by exposing as wrong common justifications for existing
society and social relationships by a process of debate and providing a vision
of something better. In other words, anarchist organisations seek to explain
and clarify what is happening in society and show why anarchism is the only
real solution to social problems. As part of this, we also have to combat
wrong ideas such as Liberalism, Social Democracy, Leninism, right-wing
populism and so on, indicating why these proposed solutions are false. In
addition, an anarchist organisation must also be a 'collective memory' for the
oppressed, keeping alive and developing the traditions of the labour and
radical movements as well as anarchism so that new generations of libertarians
have a body of experience to build upon and use in their struggles.

Anarchist organisations see themselves in the role of aiders, **not** leaders.
As Voline argued, the minority which is politically aware _"should intervene.
But, in every place and under all circumstances, . . . [they] should freely
participate in the common work, **as true collaborators, not as dictators.**
It is necessary that they especially create an example, and employ themselves
. . . without dominating, subjugating, or oppressing anyone . . . Accordingly
to the libertarian thesis, it is the labouring masses themselves, who, by
means of the various class organisations, factory committees, industrial and
agricultural unions, co-operatives, et cetera, federated . . . should apply
themselves everywhere, to solving the problems of waging the Revolution . . .
As for the 'elite' [i.e. the politically aware], their role, according to the
libertarians, is to **help** the masses, enlighten them, teach them, give them
necessary advice, impel them to take initiative, provide them with an example,
and support them in their action -- **but not to direct them
governmentally.**"_ [**The Unknown Revolution**, pp. 177-8]

This role is usually called providing a **_"leadership of ideas"_**.
Anarchists stress the difference of this concept with authoritarian notions of
"leadership" such as Leninist ones. While both anarchist and Leninist
organisations exist to overcome the problem of "uneven development" within the
working class, the aims, role and structure of these groups could not be more
different (as discussed in [section H.5](secH5.html), anarchists reject the
assumptions and practice of vanguardism as incompatible with genuine
socialism).

Anarchist groups are needed for, no matter how much people change through
struggle, it is not enough in itself (if it were, we would be living in an
anarchist society now!). So anarchists stress, as well as self-organisation,
self-liberation and self-education through struggle developing libertarian
socialist thought, the need for anarchist groups to work within popular
organisations and in the mass of the population in general. These groups would
play an important role in helping to clarify the ideas of those in struggle
and undermining the internal and external barriers against these ideas.

The first of these are what Emma Goldman termed the _"internal tyrants,"_ the
_"ethical and social conventions"_ of existing, hierarchical society which
accustom people to authoritarian social relationships, injustice, lack of
freedom and so on. [**Red Emma Speaks**, pp. 164-5] External barriers are what
Chomsky terms _"the Manufacture of Consent,"_ the process by which the
population at large are influenced to accept the status quo and the dominant
elites viewpoint via the education system and media. It is this "manufacture
of consent" which helps explain why, relatively speaking, there are so few
anarchists even though we argue that anarchism is the natural product of
working class life. While, objectively, the experiences of life drives working
class people to resist domination and oppression, they enter that struggle
with a history behind them, a history of education in capitalist schools, of
consuming capitalist media, and so on.

This means that while social struggle is radicalising, it also has to combat
years of pro-state and pro-capitalist influences. So even if an anarchist
consciousness springs from the real conditions of working class life, because
we live in a class society there are numerous counter-tendencies that
**inhibit** the development of that consciousness (such as religion, current
morality, the media, pro-business and pro-state propaganda, state and business
repression and so on). This explains the differences in political opinion
within the working class, as people develop at different speeds and are
subject to different influences and experiences. However, the numerous
internal and external barriers to the development of anarchist opinions
created by our _"internal tyrants"_ and by the process of _"manufacturing
consent"_ can be, and are, weakened by rational discussion as well as social
struggle and self-activity. Indeed, until such time as we have _"learned to
defy them all [the internal tyrants], to stand firmly on [our] own ground and
to insist upon [our] own unrestricted freedom"_ we can never be free or
successfully combat the "manufacture of consent." [Goldman, **Op. Cit.**, p.
140] And this is where the anarchist group can play a part, for there is an
important role to be played by those who have been through this process
already, namely to aid those going through it.

Of course the activity of an anarchist group does not occur in a vacuum. In
periods of low class struggle, where there is little collective action,
anarchist ideas will seem utopian and so dismissed by most. In these
situations, only a few will become anarchists simply because the experiences
of working people do not bred confidence that an alternative to the current
system is possible. In addition, if anarchist groups are small, many who are
looking for an alternative may join other groups which are more visible and
express a libertarian sounding rhetoric (such as Leninist groups, who often
talk about workers' control, workers' councils and so on while meaning
something distinctly different from what anarchists mean by these terms).
However, as the class struggle increases and people become more inclined to
take collective action, they can become empowered and radicalised by their own
activity and be more open to anarchist ideas and the possibility of changing
society. In these situations, anarchist groups grow and the influence in
anarchist ideas increases. This explains why anarchist ideas are not as
widespread as they could be. It also indicates another important role for the
anarchist group, namely to provide an environment and space where those drawn
to anarchist ideas can meet and share experiences and ideas during periods of
reaction.

The role of the anarchist group, therefore, is **not** to import a foreign
ideology into the working class, but rather to help develop and clarify the
ideas of those working class people who are moving towards anarchism and so
aid those undergoing that development. They would aid this development by
providing propaganda which exposes the current social system (and the
rationales for it) as bankrupt as well as encouraging resistance to oppression
and exploitation. The former, for Bakunin, allowed the _"bringing [of] a more
just general expression, a new and more congenial form to the existent
instincts of the proletariat . . . [which] can sometimes facilitate and
precipitate development . . . [and] give them an awareness of what they have,
of what they feel, of what they already instinctively desire, but never can it
give to them what they don't have."_ The latter _"is the most popular, the
most potent, and the most irresistible form of propaganda"_ and _"awake[s] in
the masses all the social-revolutionary instincts which reside deeply in the
heart of every worker"_ so allowing instinct to become transformed into
_"reflected socialist thought."_ [quoted by Richard B. Saltman, **The Social
and Political Thought of Michael Bakunin**, p. 107, p. 108 and p. 141]

To quote the UK **Anarchist Federation**, again _"the [libertarian]
organisation is not just a propaganda group: above all it must actively work
in all the grassroots organisations of the working class such as rank and file
[trade union] groups, tenants associations, squatters and unemployed groups as
well as women's, black and gay groups."_ It _"respects the independence of
working class movements and (unlike] others) does not try to subordinate them
to the revolutionary organisation. This does not mean that it does not seek to
spread its ideas in these movements."_ [**Op. Cit.**, p. 15 and p. 16] Such an
organisation is not vanguardist in the Leninist sense as it recognises that
socialist politics derive from working class experience, rather than bourgeois
intellectuals (as Lenin and Karl Kautsky argued), and that it does not aim to
dominate popular movements but rather work within them as equals.

So while we recognise that "advanced" sections do exist within the working
class and that anarchists are one such section, we also recognise that
**central** characteristic of anarchism is that its politics are derived from
the concrete experience of fighting capitalism and statism directly -- that
is, from the realities of working class life. This means that anarchists must
also learn from working class people in struggle. If we recognise that
anarchist ideas are the product of working class experience and self-activity
and that these constantly change and develop in light of new experiences and
struggles then anarchist theory **must be open to change by learning from non-
anarchists.** Not to recognise this fact is to open the door to vanguardism
and dogma. Because of this fact, anarchists argue that the relationship
between anarchists and non-anarchists must be an egalitarian one, based on
mutual interaction and the recognition that no one is infallible or has all
the answers -- including anarchists! With this in mind, while we recognise the
presence of "advanced" groups within the working class (which obviously
reflects the uneven development within it), anarchists aim to minimise such
unevenness by the way anarchist organisations intervene in social struggle,
intervention based on involving **all** in the decision making process (as we
discuss below).

Thus the general aim of anarchist groups is to spread ideas -- such as general
anarchist analysis of society and current events, libertarian forms of
organisation, direct action and solidarity and so forth -- and win people over
to anarchism (i.e. to "make" anarchists). This involves both propaganda and
participating as equals in social struggle and popular organisation.
Anarchists do not think that changing leaders is a solution to the problem of
(bad) leadership. Rather, it is a question of making leaders redundant by
empowering all. As Malatesta argued, we _"do not want to **emancipate** the
people; we want the people to **emancipate themselves.**"_ Thus anarchists
_"advocate and practise direct action, decentralisation, autonomy and
individual initiative; they should make special efforts to help members [of
popular organisations] learn to participate directly in the life of the
organisation and to dispense with leaders and full-time functionaries."_
[**Errico Malatesta: His Life and Ideas**, p. 90 and p. 125]

This means that anarchists reject the idea that anarchist groups and
federations must become the "leaders" of organisations. Rather, we desire
anarchist ideas to be commonplace in society and in popular organisations, so
that leadership by people from positions of power is replaced by the _"natural
influence"_ (to use Bakunin's term) of activists within the rank and file on
the decisions made **by** the rank and file. While we will discuss Bakunin's
ideas in more detail in [section J.3.7](secJ3.html#secj37), the concept of
_"natural influence"_ can be gathered from this comment of Francisco Ascaso
(friend of Durruti and an influential anarchist militant in the CNT and FAI in
his own right):

> _"There is not a single militant who as a 'FAIista' intervenes in union
meetings. I work, therefore I am an exploited person. I pay my dues to the
workers' union and when I intervene at union meetings I do it as someone who
is exploited, and with the right which is granted me by the card in my
possession, as do the other militants, whether they belong to the FAI or
not."_ [quoted by Abel Paz, **Durruti: The People Armed**, p. 137]

This shows the nature of the "leadership of ideas." Rather than be elected to
a position of power or responsibility, the anarchist presents their ideas at
mass meetings and argues his or her case. This obviously implies a two-way
learning process, as the anarchist learns from the experiences of others and
the others come in contact with anarchist ideas. Moreover, it is an
egalitarian relationship, based upon discussion between equals rather than
urging people to place someone into power above them. It ensures that everyone
in the organisation participates in making, understands and agrees with the
decisions reached. This obviously helps the political development of all
involved (including, we must stress, the anarchists). As Durruti argued: _"the
man [or woman] who alienates his will, can never be free to express himself
and follow his own ideas at a union meeting if he feel dominated by the
feeblest orator . . . As long as a man doesn't think for himself and doesn't
assume his own responsibilities, there will be no complete liberation of human
beings."_ [quoted by Paz, **Op. Cit.**, p. 184]

Because of our support for the "leadership of ideas", anarchists think that
all popular organisations must be open, fully self-managed and free from
authoritarianism. Only in this way can ideas and discussion play an important
role in the life of the organisation. Since anarchists _"do not believe in the
good that comes from above and imposed by force"_ and _"want the new way of
life to emerge from the body of the people and advance as they advance. It
matters to us therefore that all interests and opinions find their expression
in a conscious organisation and should influence communal life in proportion
to their importance."_ [Malatesta, **Op. Cit.**, p. 90] Bakunin's words with
regards the first International Workers Association indicate this clearly:

> _"It must be a people's movement, organised from the bottom up by the free,
spontaneous action of the masses. There must be no secret governmentalism, the
masses must be informed of everything . . . All the affairs of the
International must be thoroughly and openly discussed without evasions and
circumlocutions."_ [**Bakunin on Anarchism**, p. 408]

Given this, anarchists reject the idea of turning the organs created in the
class struggle and revolutionary process into hierarchical structures. By
turning them from organs of self-management into organs for nominating
"leaders," the constructive tasks and political development of the revolution
will be aborted before they really begin. The active participation of all will
become reduced to the picking of new masters and the revolution will falter.
For this reason, anarchists _"differ from the Bolshevik type of party in their
belief that genuine revolutionaries must function **within the framework of
the forms created by the revolution,** not within forms created by the
party."_ This means that _"an organisation is needed to propagate ideas
systematically -- and not ideas alone, but **ideas which promote the concept
of self-management.**"_ In other words, there _"is a need for a revolutionary
organisation -- but its function must always be kept clearly in mind. Its
first task is propaganda . . . In a revolutionary situation, the revolutionary
organisation presents the most advanced demands: it is prepared at every turn
of events to formulate -- in the most concrete fashion -- the immediate task
that should be performed to advance the revolutionary process. It provides the
boldest elements in action and in the decision-making organs of the
revolution."_ [Murray Bookchin, **Post-Scarcity Anarchism**, p. 140] What it
does **not** do is to supplant those organs or decision-making process by
creating institutionalised, hierarchical leadership structures.

Equally as important as **how** anarchists intervene in social struggles and
popular organisations and the organisation of those struggles and
organisations, there is the question of the nature of that intervention. We
would like to quote the following by the British libertarian socialist group
**Solidarity** as it sums up the underlying nature of anarchist action and the
importance of a libertarian perspective on social struggle and change and how
politically aware minorities work within them:

> _"**Meaningful action,** for revolutionaries, is whatever increases the
confidence, the autonomy, the initiative, the participation, the solidarity,
the egalitarian tendencies and the self-activity of the masses and whatever
assists in their demystification. **Sterile and harmful action** is whatever
reinforces the passivity of the masses, their apathy, their cynicism, their
differentiation through hierarchy, their alienation, their reliance on others
to do things for them and the degree to which they can therefore be
manipulated by others -- even by those allegedly acting on their behalf."_
[Maurice Brinton, **For Workers' Power**, p. 154]

Part of this "meaningful action" involves encouraging people to **_"act for
yourselves"_** (to use Kropotkin's words). As we noted in [section
A.2.7](secA2.html#seca27), anarchism is based on **self**-liberation and self-
activity is key aspect of this. Hence Malatesta's argument:

> _"Our task is that of 'pushing' the people to demand and to seize all the
freedom they can and to make themselves responsible for providing their own
needs without waiting for orders from any kind of authority. Our task is that
of demonstrating the uselessness and harmfulness of government, provoking and
encouraging by propaganda and action, all kinds of individual and collective
activities._

> _"It is in fact a question of education for freedom, of making people who
are accustomed to obedience and passivity consciously aware of their real
power and capabilities. One must encourage people to do things for
themselves."_ [**Op. Cit.**, pp. 178-9]

This "pushing" people to "do it themselves" is another key role for any
anarchist organisation. The encouragement of direct action is just as
important as anarchist propaganda and popular participation within social
struggle and popular organisations.

As such social struggle develops, the possibility of revolution becomes closer
and closer. While we discuss anarchists ideas on social revolution in [section
J.7](secJ7.html), we must note here that the role of the anarchist
organisation does not change. As Bookchin argued, anarchists _"seek to
persuade the factory committees, assemblies"_ and other organisations created
by people in struggle _"to make themselves into **genuine organs of popular
self-management**, not to dominate them, manipulate them, or hitch them to an
all-knowing political party."_ [**Op. Cit.**, p. 140] In this way, by
encouraging self-management in struggle, anarchists lay the foundations of a
self-managed society.

## J.3.7 Doesn't Bakunin's _"Invisible Dictatorship"_ prove that anarchists
are secret authoritarians?

No. While Bakunin did use the term _"invisible dictatorship"_, it does not
prove that Bakunin or anarchists are secret authoritarians. The claim
otherwise, often made by Leninists and other Marxists, expresses a distinct,
even wilful, misunderstanding of Bakunin's ideas on the role revolutionaries
should play in popular movements.

Marxists quote Bakunin's terms _"invisible dictatorship"_ and _"collective
dictatorship"_ out of context, using it to "prove" that anarchists are secret
authoritarians, seeking dictatorship over the masses. More widely, the
question of Bakunin and his "invisible dictatorship" finds its way into
sympathetic accounts of anarchist ideas. For example, Peter Marshall writes
that it is _"not difficult to conclude that Bakunin's invisible dictatorship
would be even more tyrannical than a . . . Marxist one"_ and that it expressed
a _"profound authoritarian and dissimulating streak in his life and work."_
[**Demanding the Impossible**, p. 287] So, the question of setting the record
straight about this aspect of Bakunin's theory is of more importance than just
correcting a few Leninists. In addition, to do so will help clarify the
concept of _"leadership of ideas"_ we discussed in the [last
section](secJ3.html#secj36). For both these reasons, this section, while
initially appearing somewhat redundant and of interest only to academics, is
of a far wider interest.

Anarchists have two responses to claims that Bakunin (and, by implication, all
anarchists) seek an _"invisible"_ dictatorship and so are not true
libertarians. Firstly, and this is the point we will concentrate upon in this
section, Bakunin's expression is taken out of context and when placed within
context it takes on a radically different meaning than that implied by critics
of anarchism. Secondly, even **if** the expression means what the critics
claim it does, it does not refute anarchism as a political theory. This is
because anarchists are **not** Bakuninists (or Proudhonists or Kropotkinites
or any other person-ist). We recognise other anarchists for what they are,
human beings who said lots of important and useful things but, like any other
human being, made mistakes and often do not live up to all of their ideas. For
anarchists, it is a question of extracting the useful parts from their works
and rejecting the useless (as well as the downright nonsense!). Just because
Bakunin said something, it does not make it right! This common-sense approach
to politics seems to be lost on Marxists. Indeed, if we take the logic of
these Marxists to its conclusion, we must reject everything Rousseau wrote (he
was sexist), Marx and Engels (their comments against Slavs spring to mind,
along with numerous other racist comments) and so on. But, of course, this
never happens to non-anarchist thinkers when Marxists write their articles and
books.

However, to return to our main argument, that of the importance of context.
Significantly, whenever Bakunin uses the term "invisible" or "collective"
dictatorship he also explicitly states his opposition to government power and
**in particular** the idea that anarchists should seize it. For example, a
Leninist quotes the following passage from _"a Bakuninist document"_ to show
_"the dictatorial ambitions of Bakunin"_ and that the _"principle of anti-
democracy was to leave Bakunin unchallenged at the apex of power"_: _"It is
necessary that in the midst of popular anarchy, which will constitute the very
life and energy of the revolution, unity of thought and revolutionary action
should find an organ. This organ must be the secret and world-wide association
of the international brethren."_ [Derek Howl, _"The legacy of Hal Draper"_,
pp. 137-49, **International Socialist**, no. 52, p. 147]

However, in the sentence **immediately before** those quoted, Bakunin stated
that _"[t]his organisation rules out any idea of dictatorship and custodial
control."_ Strange that this part of the document was not quoted! Nor is
Bakunin quoted when he wrote, in the same document, that _"[w]e are the
natural enemies of those revolutionaries -- future dictators, regimentors and
custodians of revolution -- who . . . [want] to create new revolutionary
States just as centralist and despotic as those we already know."_ Not
mentioned either is Bakunin's opinion that the _"revolution everywhere must be
created by the people, and supreme control must always belong to the people
organised into a free federation of agricultural and industrial associations .
. . organised from the bottom upwards by means of revolutionary delegations .
. . [who] will set out to administer public services, not to rule over
peoples."_ [**Michael Bakunin: Selected Writings**, p. 172, p. 169 and p. 172]
Selective quoting is only convincing to those ignorant of the subject.

Similarly, when we look at the situations where Bakunin uses the terms
_"invisible"_ or _"collective"_ dictatorship (usually in letters to comrades)
we find the same thing -- the explicit denial **in these same letters** that
Bakunin thought the revolutionary association should take governmental power.
For example, in a letter to Albert Richard (a fellow member of the _"Alliance
of Social Democracy"_) Bakunin stated that _"[t]here is only one power and one
dictatorship whose organisation is salutary and feasible: it is that
collective, invisible dictatorship of those who are allied in the name of our
principle."_ He then immediately adds that _"this dictatorship will be all the
more salutary and effective for not being dressed up in any official power or
extrinsic character."_ Earlier in the letter he argued that anarchists must be
_"like invisible pilots in the thick of the popular tempest. . . steer[ing] it
[the revolution] not by any open power but by the collective dictatorship of
all the allies -- a dictatorship without insignia, titles or official rights,
and all the stronger for having none of the paraphernalia of power."_
Explicitly opposing _"Committees of Public Safety and official, overt
dictatorship"_ he explains his idea of a revolution based on _"workers
hav[ing] joined into associations . . . armed and organised by streets and
**quartiers**, the federative commune."_ [**Op. Cit.**, p. 181, p. 180 and p.
179] Hardly what would be expected from a would-be dictator. As Sam Dolgoff
suggested:

> _"an organisation exercising no overt authority, without a state, without
official status, without the machinery of institutionalised power to enforce
its policies, cannot be defined as a dictatorship . . . Moreover, if it is
borne in mind that this passage is part of a letter repudiating in the
strongest terms the State and the authoritarian statism of the 'Robespierres,
the Dantons, and the Saint-Justs of the revolution,' it is reasonable to
conclude that Bakunin used the word 'dictatorship' to denote preponderant
influence or guidance exercised largely by example . . . In line with this
conclusion, Bakunin used the words 'invisible' and 'collective' to denote the
underground movement exerting this influence in an organised manner."_
[**Bakunin on Anarchism**, p. 182]

This analysis is confirmed by other passages from Bakunin's letters. In a
letter to the Nihilist Sergi Nechaev (within which Bakunin indicates exactly
how far apart politically they were -- which is important as, from Marx
onwards, many of Bakunin's opponents quote Nechaev's pamphlets as if they were
"Bakuninist," when in fact they were not) we find him arguing that:

> _"These [revolutionary] groups would not seek anything for themselves,
neither privilege nor honour nor power . . . [but] would be in a position to
direct popular movements . . . and lead the people towards the most complete
realisation of the social-economic ideal and the organisation of the fullest
popular freedom. This is what I call **the collective dictatorship** of a
secret organisation._

> _"The dictatorship . . . does not reward any of the members that comprise
the groups, or the groups themselves, with any profit or honour or official
power. It does not threaten the freedom of the people, because, lacking any
official character, it does not take the place of State control over the
people, and because its whole aim . . . consists of the fullest realisation of
the liberty of the people._

> _"This sort of dictatorship is not in the least contrary to the free
development and the self-development of the people, nor its organisation from
the bottom upward . . . for it influences the people exclusively through the
natural, personal influence of its members, who have not the slightest power,
. . . and . . . try . . . to direct the spontaneous revolutionary movement of
the people towards . . . the organisation of popular liberty . . . This secret
dictatorship would in the first place, and at the present time, carry out a
broadly based popular propaganda . . . and by the power of this propaganda and
also by **organisation among the people themselves** join together separate
popular forces into a mighty strength capable of demolishing the State."_
[**Michael Bakunin: Selected Writings**, pp. 193-4]

The key aspect of this is the notion of _"natural"_ influence. In a letter to
a Spanish member of the Alliance we find Bakunin arguing that it _"will
promote the Revolution only through the **natural but never official
influence** of all members of the Alliance."_ [**Bakunin on Anarchism**, p.
387] This term was also used in his public writings, with Bakunin arguing that
the _"very freedom of every individual results from th[e] great number of
material, intellectual, and moral influences which every individual around him
and which society . . . continually exercise on him"_ and that _"everything
alive . . . intervene[s] . . . in the life of others . . . [so] we hardly wish
to abolish the effect of any individual's or any group of individuals' natural
influence upon the masses."_ [**The Basic Bakunin**, p. 140 and p. 141]

Thus _"natural influence"_ simply means the effect of communicating which
others, discussing your ideas with them and winning them over to your
position, nothing more. This is hardly authoritarian, and so Bakunin contrasts
this _"natural"_ influence with _"official"_ influence, which replaced the
process of mutual interaction between equals with a fixed hierarchy of command
and thereby induced the _"transformation of natural influence, and, as such,
the perfectly legitimate influence over man, into a right."_ [quoted by
Richard B. Saltman, **The Social and Political Thought of Michael Bakunin**,
p. 46]

As an example of this difference, consider the case of a union militant (as
will become clear, this is the sort of example Bakunin had in mind). As long
as they are part of the rank-and-file, arguing their case at union meetings or
being delegated to carry out the decisions of these assemblies then their
influence is _"natural."_ However, if this militant is elected into a position
with executive power in the union (i.e. becomes a full-time union official,
for example, rather than a shop-steward) then their influence becomes
_"official"_ and so, potentially, corrupting for both the militant and the
rank-and-file who are subject to the rule of the official.

Indeed, this notion of _"natural"_ influence was also termed _"invisible"_ by
Bakunin: _"It is only necessary that one worker in ten join the [International
Working-Men's] Association **earnestly** and **with full understanding of the
cause** for the nine-tenths remaining outside its organisation nevertheless to
be influenced invisibly by it."_ [**The Basic Bakunin**, p. 139] So, as can be
seen, the terms _"invisible"_ and _"collective"_ dictatorship used by Bakunin
in his letters is strongly related to the term _"natural influence"_ used in
his public works and seems to be used simply to indicate the effects of an
organised political group on the masses. To see this, it is worthwhile to
quote Bakunin at length about the nature of this _"invisible"_ influence:

> _"It may be objected that this . . . influence on the popular masses
suggests the establishment of a system of authority and a new government . . .
Such a belief would be a serious blunder. The organised effect of the
International on the masses . . . is nothing but the entirely natural
organisation -- neither official nor clothed in any authority or political
force whatsoever -- of the effect of a rather numerous group of individuals
who are inspired by the same thought and headed toward the same goal, first of
all on the opinion of the masses and only then, by the intermediary of this
opinion (restated by the International's propaganda), on their will and their
deeds. But the governments . . . impose themselves violently on the masses,
who are forced to obey them and to execute their decrees . . . The
International's influence will never be anything but one of opinion and the
International will never be anything but the organisation of the natural
effect of individuals on the masses."_ [**Op. Cit.**, pp. 139-40]

Therefore, from both the fuller context provided by the works and letters
selectively quoted by Marxists **and** his other writings, we find that rather
than being a secret authoritarian, Bakunin was, in fact, trying to express how
anarchists could _"naturally influence"_ the masses and their revolution:

> _"We are the most pronounced enemies of every sort of **official power** . .
. We are the enemies of any sort of publicly declared dictatorship, we are
social revolutionary anarchists . . . if we are anarchists, by what right do
we want to influence the people, and what methods will we use? Denouncing all
power, with what sort of power, or rather by what sort of force, shall we
direct a people's revolution? **By a force that is invisible . . . that is not
imposed on anyone . . . [and] deprived of all official rights and
significance.**"_ [**Michael Bakunin: Selected Writings**, pp. 191-2]

Continually opposing _"official"_ power, authority and influence, Bakunin used
the term _"invisible, collective dictatorship"_ to describe the _"natural
influence"_ of organised anarchists on mass movements. Rather than express a
desire to become a dictator, it in fact expresses the awareness that there is
an "uneven" political development within the working class, an unevenness that
can only be undermined by discussion within the mass assemblies of popular
organisations. Any attempt to by-pass this "unevenness" by seizing or being
elected to positions of power (i.e. by _"official influence"_) would be doomed
to failure and result in dictatorship by a party -- _"triumph of the Jacobins
or the Blanquists [or the Bolsheviks, we must add] would be the death of the
Revolution."_ [**Op. Cit.**, p. 169]

So rather than seek power, the anarchists would seek **influence** based on
the soundness of their ideas, what anarchists today term the _"leadership of
ideas"_ in other words. Thus the anarchist federation _"unleashes their [the
peoples] will and gives wider opportunity for their self-determination and
their social-economic organisation, which should be created by them alone from
the bottom upwards . . . The [revolutionary] organisation . . . [must] not in
any circumstances . . . ever be their master . . . What is to be the chief aim
and pursue of this organisation? **To help the people towards self-
determination on the lines of the most complete equality and fullest human
freedom in every direction, without the least interference from any sort of
domination . . . that is without any sort of government control.**"_ [**Op.
Cit.**, p. 191]

This analysis can be seen from Bakunin's discussion on union bureaucracy and
how anarchists should combat it. Taking the Geneva section of the IWMA,
Bakunin notes that the construction workers' section _"simply left all
decision-making to their committees . . . In this manner power gravitated to
the committees, and by a species of fiction characteristic of all governments
the committees substituted their own will and their own ideas for that of the
membership."_ To combat this bureaucracy, the union _"sections could only
defend their rights and their autonomy in only one way: the workers called
general membership meetings. Nothing arouses the antipathy of the committees
more than these popular assemblies . . . In these great meetings of the
sections, the items on the agenda was amply discussed and the most progressive
opinion prevailed."_ Given that Bakunin considered _"the federative Alliance
of all the workers' associations"_ would _"constitute the Commune"_ by means
of delegates with _"always responsible, and revocable mandates"_, we can
easily see that the role of the anarchist federation would be to intervene in
general assemblies of these associations and ensure, through debate, that the
most progressive opinion prevailed. [**Bakunin on Anarchism**, p. 246, p. 247
and p. 153]

Having shown that the role of Bakunin's revolutionary organisations is
drastically different than that suggested by the selective quotations of
Marxists, we need to address two more issues. One, the so-called hierarchical
nature of Bakunin's organisations and, two, their secret nature. Taking the
issue of hierarchy first, we can do no better than quote Richard B. Saltman's
summary of the internal organisation of these groups:

> _"The association's 'single will,' Bakunin wrote, would be determined by
'laws' that every member 'helped to create,' or at a minimum 'equally
approved' by 'mutual agreement.' This 'definite set of rules' was to be
'frequently renewed' in plenary sessions wherein each member had the 'duty to
try and make his view prevail,' but then he must accept fully the decision of
the majority. Thus the revolutionary association's 'rigorously conceived and
prescribed plan,' implemented under the 'strictest discipline,' was in reality
to be 'nothing more or less than the expression and direct outcome of the
reciprocal commitment contracted by each of the members towards the others.'"_
[**Op. Cit.**, p. 115]

While many anarchists would not totally agree with this set-up (although we
think that most supporters of the "Platform" would) all would agree that it is
**not** hierarchical. If anything, it appears quite democratic in nature.
Moreover, comments in Bakunin's letters to other Alliance members support the
argument that his revolutionary associations were more democratic in nature
than Marxists suggest. In a letter to a Spanish comrade we find him suggesting
that _"all [Alliance] groups. . . should. . . from now on accept new members
not by majority vote, but unanimously."_ [**Op. Cit.**, p. 386] In a letter to
Italian members of the IWMA he argued that in Geneva the Alliance did not
resort to _"secret plots and intrigues."_ Rather:

> _"Everything was done in broad daylight, openly, for everyone to see . . .
The Alliance had regular weekly open meetings and everyone was urged to
participate in the discussions . . . The old procedure where members sat and
passively listened to speakers talking down to them from their pedestal was
discarded._

> _"It was established that all meetings be conducted by informal round-table
conversational discussions in which everybody felt free to participate: not to
be talked **at**, but to exchange views."_ [**Op. Cit.**, pp. 405-6]

Moreover, we find Bakunin being out-voted within the Alliance, hardly what we
would expect if they **were** top-down dictatorships run by him as Marxists
claim. The historian T.R. Ravindranathan indicates that after the Alliance was
founded _"Bakunin wanted the Alliance to become a branch of the International
[Worker's Association] and at the same time preserve it as a secret society.
The Italian and some French members wanted the Alliance to be totally
independent of the IWA and objected to Bakunin's secrecy. Bakunin's view
prevailed on the first question as he succeeded in convincing the majority of
the harmful effects of a rivalry between the Alliance and the International.
On the question of secrecy, he gave way to his opponents."_ [**Bakunin and the
Italians**, p. 83]

Moreover, if Bakunin **did** seek to create a centralised, hierarchical
organisation, as Marxists claim, he did not do a good job. We find him
complaining that the Madrid Alliance was breaking up (_"The news of the
dissolution of the Alliance in Spain saddened Bakunin. he intensified his
letter-writing to Alliance members whom he trusted . . . He tried to get the
Spaniards to reverse their decision"_ [Juan Gomez Casa, **Anarchist
Organisation**, pp. 37-8]). While the "Bakuninist" Spanish and Swiss sections
of the IWMA sent delegates to its infamous Hague congress, the "Bakuninist"
Italian section did not. Of course, Marxists could argue that these facts show
Bakunin's cunning nature, but the more obvious explanation is that Bakunin did
not create a hierarchical organisation with himself at the top.

The evidence suggests that the Alliance _"was not a compulsory or
authoritarian body."_ In Spain, it _"acted independently and was prompted by
purely local situations. The copious correspondence between Bakunin and his
friends . . . was at all times motivated by the idea of offering advice,
persuading, and clarifying. It was never written in a spirit of command,
because that was not his style, nor would it have been accepted as such by his
associates."_ Moreover, there _"is no trace or shadow or hierarchical
organisation in a letter from Bakunin to Mora . . . On the contrary, Bakunin
advises 'direct' relations between Spanish and Italian Comrades."_ The Spanish
comrades also wrote a pamphlet which _"ridiculed the fable of orders from
abroad."_ [Casa, **Op. Cit.**, p. 25 and p. 40] This is confirmed by George R.
Esenwein who argues that _"[w]hile it is true that Bakunin's direct
intervention during the early days of the International's development in Spain
had assured the pre-dominance of his influence in the various federations and
sections"_ of the organisation, _"it cannot be said that he manipulated it or
otherwise used the Spanish Alliance as a tool for his own subversive
designs."_ Thus, _"though the Alliance did exist in Spain, the society did not
bear any resemblance to the nefarious organisation that the Marxists
depicted."_ [**Anarchist Ideology and the Working Class Movement in Spain**,
p. 42] Indeed, as Max Nettlau points out, those Spaniards who did break with
the Alliance were persuaded of its _"hierarchical organisation . . . not by
their own direct observation, but by what they had been told about the conduct
of the organisation"_ in other countries. [quoted by Casa, **Op. Cit.**, pp.
39-40]. In addition, if Bakunin **did** run the Alliance under his own
personal dictatorship we would expect it to change or dissolve upon his death.
However, _"the Spanish Alliance survived Bakunin, who died in 1876, yet with
few exceptions it continued to function in much the same way it had during
Bakunin's lifetime."_ [Esenwein, **Op. Cit.**, p. 43]

Moving on to the second issue, the question of why Bakunin favoured secret
organisation. At the time many states were despotic monarchies, with little or
no civil rights. As he argued, _"nothing but a secret society would want to
take this [arousing a revolution] on, for the interests of the government and
of the government classes would be bitterly opposed to it."_ [**Michael
Bakunin: Selected Writings**, p. 188] For survival, Bakunin considered secrecy
an essential. As Juan Gomez Casas noted: _"In view of the difficulties of that
period, Bakunin believed that secret groups of convinced and absolutely
trustworthy men were safer and more effective. They would be able to place
themselves at the head of developments at critical moments, but only to
inspire and to clarify the issues."_ [**Op. Cit.**, p. 22] Even Marxists,
faced with dictatorial states, have organised in secret and as George R.
Esenwein points out, the _"claim that Bakunin's organisation scheme was not
the product of a 'hard-headed realism' cannot be supported in the light of the
experiences of the Spanish Alliancists. It is beyond doubt that their
adherence to Bakunin's program greatly contributed to the FRE's [Spanish
section of the First International] ability to flourish during the early part
of the 1870s and to survive the harsh circumstances of repression in the
period 1874-1881."_ [**Op. Cit.**, p. 224f] So Bakunin's personal experiences
in Tsarist Russia and other illiberal states shaped his ideas on how
revolutionaries should organise (and let us not forget that he had been
imprisoned in the Peter and Paul prison for his activities).

This is not to suggest that all of Bakunin's ideas on the role and nature of
anarchist groups are accepted by anarchists today. Most anarchists would
reject Bakunin's arguments for secrecy, for example (particularly as secrecy
cannot help but generate an atmosphere of deceit and, potentially,
manipulation). Anarchists remember that anarchism did not spring fully formed
and complete from Bakunin's (or any other individual's) head. Rather it was
developed over time and by many individuals, inspired by many different
experiences and movements. As such, anarchists recognise that Bakunin was
inconsistent in some ways, as would be expected from a theorist breaking new
ground, and this applies to his ideas on how anarchist groups should work
within and the role they should play in popular movements. Most of his ideas
are valid, once we place them into context, some are not. Anarchists embrace
the valid ones and voice their opposition to the others.

In summary, any apparent contradiction between the "public" and "private"
Bakunin disappears once we place his comments into context within both the
letters he wrote and his overall political theory. As Brian Morris argues,
those who argue that Bakunin was in favour of despotism only come to _"these
conclusions by an incredible distortion of the substance of what Bakunin was
trying to convey in his letters to Richard and Nechaev"_ and _"[o]nly the most
jaundiced scholar, or one blinded by extreme antipathy towards Bakunin or
anarchism, could interpret these words as indicating that Bakunin conception
of a secret society implied a revolutionary dictatorship in the Jacobin sense,
still less a 'despotism'"_ [**Bakunin: The Philosophy of Freedom**, p. 144 and
p. 149]

## J.3.8 What is anarcho-syndicalism?

Anarcho-syndicalism (as mentioned in [section A.3.2](secA3.html#seca32)) is a
form of anarchism which applies itself (primarily) to creating industrial
unions organised in an anarchist manner, using anarchist tactics (such as
direct action) to create a free society. To quote _"The Principles of
Revolutionary Syndicalism"_ of the **International Workers Association**:

> _"Revolutionary Syndicalism is that movement of the working classes founded
on the basis of class war, which strives for the union of manual and
intellectual workers in economic fighting organisations, in order to prepare
for and realise in practice their liberation from the yoke of wage-slavery and
state oppression. Its goal is the reorganisation of social life on the basis
of free communism through the collective revolutionary action of the working
classes themselves. It takes the view that only the economic organisations of
the proletariat are appropriate for the realisation of this task and turns
therefore to the workers in their capacity as producers and generators of
social value, in opposition to the modern political labour parties, which for
constructive economic purpose do not come into consideration."_ [quoted by
Wayne Thorpe, **"The Workers Themselves"**, p. 322]

The word _"syndicalism"_ is an English rendering of the French for
_"revolutionary trade unionism"_ (_"syndicalisme revolutionarie"_). In the
1890s many anarchists in France started to work within the trade union
movement, radicalising it from within. As the ideas of autonomy, direct
action, the general strike and political independence of unions which where
associated with the French **Confederation Generale du Travail** (CGT, or
General Confederation of Labour) spread across the world (partly through
anarchist contacts, partly through word of mouth by non-anarchists who were
impressed by the militancy of the CGT), the word "syndicalism" was used to
describe movements inspired by the example of the CGT. Thus "syndicalism,"
"revolutionary syndicalism" and "anarcho-syndicalism" all basically mean
"revolutionary unionism" (the term "industrial unionism" used by the IWW
essentially means the same thing).

The main difference is between revolutionary syndicalism and anarcho-
syndicalism, with anarcho-syndicalism arguing that revolutionary syndicalism
concentrates too much on the workplace and, obviously, stressing the anarchist
roots and nature of syndicalism more than the former. In addition, anarcho-
syndicalism is often considered compatible with supporting a specific
anarchist organisation to complement the work of the revolutionary unions.
Revolutionary syndicalism, in contrast, argues that the syndicalist unions are
sufficient in themselves to create libertarian socialism and rejects anarchist
groups along with political parties. However, the dividing line can be unclear
and, just to complicate things even more, **some** syndicalists support
political parties and are not anarchists (there have been a few Marxist
syndicalists, for example) but we will ignore these in our discussion. We will
use the term syndicalism to describe what each branch has in common.

The syndicalist union is a self-managed industrial union (see [section
J.5.2](secJ5.html#secj52)) which is committed to **direct action** and refuses
links with political parties, even labour or "socialist" ones. A key idea of
syndicalism is that of union autonomy -- the idea that the workers'
organisation is capable of changing society by its own efforts, that it must
control its own fate and not be controlled by any party or other outside group
(including anarchist federations). This is sometimes termed **_"workerism"_**
(from the French **_"ouverierisme"_**), i.e. workers' control of the class
struggle and their own organisations. Rather than being a cross-class
organisation like the political party, the union is a **class** organisation
and is so uniquely capable of representing working class aspirations,
interests and hopes. _"The **syndicat**,"_ Emile Pouget wrote, _"groups
together those who work against those who live by human exploitation: it
brings together interests and not opinions."_ [quoted by Jeremy Jennings,
**Syndicalism in France**, pp. 30-1] There is, then, _"no place in it for
anybody who was not a worker. Professional middle class intellectuals who
provided both the leadership and the ideas of the socialist political
movement, were therefore at a discount. As a consequence the syndicalist
movement was, and saw itself as, a purely working class form of socialism."_
Syndicalism _"appears as the great heroic movement of the proletariat, the
first movement which took seriously"_ the argument _"that the emancipation of
the working class must be the task of labour unaided by middle class
intellectuals or by politicians and aimed to establish a genuinely working
class socialism and culture, free of all bourgeois taints. For the
syndicalists, the workers were to be everything, the rest, nothing."_
[Geoffrey Ostergaard, **The Tradition of Workers' Control**, p. 38]

Therefore syndicalism is _"consciously anti-parliamentary and anti-political.
It focuses not only on the realities of power but also on the key problem of
achieving its disintegration. Real power in syndicalist doctrine is economic
power. The way to dissolve economic power is to make every worker powerful,
thereby eliminating power as a social privilege. Syndicalism thus ruptures all
the ties between the workers and the state. It opposes political action,
political parties, and any participant in political elections. Indeed it
refuses to operate in the framework of the established order and the state._
It _"turns to direct action -- strikes, sabotage, obstruction, and above all,
the revolutionary general strike. Direct action not only perpetuates the
militancy of the workers and keeps alive the spirit of revolt, but awakens in
them a greater sense of individual initiative. By continual pressure, direct
action tests the strength of the capitalist system at all times and presumably
in its most important arena -- the factory, where ruled and ruler seem to
confront each other most directly."_ [Murray Bookchin, **The Spanish
Anarchists**, p. 121]

This does not mean that syndicalism is "apolitical" in the sense of ignoring
totally all political issues. This is a Marxist myth. Syndicalists follow
other anarchists by being opposed to all forms of authoritarian/capitalist
politics but do take a keen interest in "political" questions as they relate
to the interests of working people. Thus they do not "ignore" the state, or
the role of the state. Indeed, syndicalists (like all libertarians) are well
aware that the state exists to protect capitalist property and power and that
we need to combat it as well as fight for economic improvements. In short,
syndicalism is deeply political in the widest sense of the word, aiming for a
radical change in political, economic and social conditions and institutions.
Moreover, it is political in the narrower sense of being aware of political
issues and aiming for political reforms along with economic ones. It is only
"apolitical" when it comes to supporting political parties and using bourgeois
political institutions, a position which is "political" in the wider sense of
course! This is obviously identical to the usual anarchist position (see
[section J.2.10](secJ2.html#secj210)).

Which indicates an importance difference between syndicalism and trade
unionism. Syndicalism aims at changing society rather than just working within
it. Thus syndicalism is revolutionary while trade unionism is reformist. For
syndicalists the union _"has a double aim: with tireless persistence, it must
pursue betterment of the working class's current conditions. But, without
letting themselves become obsessed with this passing concern, the workers
should take care to make possible and imminent the essential act of
comprehensive emancipation: the expropriation of capital."_ Thus syndicalism
aims to win reforms by direct action and by this struggle bring the
possibilities of a revolution, via the general strike, closer. Indeed any
_"desired improvement is to be wrested directly from the capitalist"_ and
_"must always represent a reduction in capitalist privileges and be a partial
expropriation."_ [Emile Pouget, **No Gods, No Masters**, vol. 2, p. 71 and p.
73] Thus Emma Goldman:

> _"Of course Syndicalism, like the old trade unions, fights for immediate
gains, but it is not stupid enough to pretend that labour can expect humane
conditions from inhumane economic arrangements in society. Thus it merely
wrests from the enemy what it can force him to yield; on the whole, however,
Syndicalism aims at, and concentrates its energies upon, the complete
overthrow of the wage system._

> _"Syndicalism goes further: it aims to liberate labour from every
institution that has not for its object the free development of production for
the benefit of all humanity. In short, the ultimate purpose of Syndicalism is
to reconstruct society from its present centralised, authoritative and brutal
state to one based upon the free, federated grouping of the workers along
lines of economic and social liberty._

> _"With this object in view, Syndicalism works in two directions: first, by
undermining the existing institutions; secondly, by developing and educating
the workers and cultivating their spirit of solidarity, to prepare them for a
full, free life, when capitalism shall have been abolished._

> _"Syndicalism is, in essence, the economic expression of Anarchism."_ [**Red
Emma Speaks**, p. 91]

Which, in turn, explains why syndicalist unions are structured in such an
obviously libertarian way. It reflects the importance of empowering every
worker by creating a union which is decentralised and self-managed, a union
which every member plays a key role in determining its policy and activities.
Participation ensures that the union becomes a _"school for the will"_ (to use
Pouget's expression) and allows working people to learn how to govern
themselves and so do without the state. After the revolution, the union can
easily be transformed into the body by which production is organised. The aim
of the union is workers' self-management of production and distribution after
the revolution, a self-management which the union is based upon in the here
and now. The syndicalist union is seen as _"the germ of the Socialist economy
of the future, the elementary school of Socialism in general"_ and we need to
_"plant these germs while there is yet time and bring them to the strongest
possible development, so as to make the task of the coming social revolution
easier and to insure its permanence."_ [Rocker, **Op. Cit.**, p. 59]

Thus, as can be seen, syndicalism differs from trade unionism in its
structure, its methods and its aims. Its structure, method and aims are
distinctly anarchist. Little wonder leading syndicalist theorist Fernand
Pelloutier argued that the trade union, _"governing itself along anarchic
lines,"_ must become _"a practical schooling in anarchism."_ [**No Gods, No
Masters**, vol. 2, p. 55 and p. 57] In addition, most anarcho-syndicalists
support community organisations and struggle alongside the more traditional
industry based approach usually associated within syndicalism. While we have
concentrated on the industrial side here (simply because this is a key aspect
of syndicalism) we must stress that syndicalism can and does lend itself to
community struggles. It is a myth that anarcho-syndicalism ignores community
struggles and organisation, as can be seen from the history of the Spanish CNT
for example (see [section J.5.1](secJ5.html#secj51)).

It must be stressed that a syndicalist union is open to all workers regardless
of their political opinions (or lack of them). The union exists to defend
workers' interests as workers and is organised in an anarchist manner to
ensure that their interests are fully expressed. This means that a syndicalist
organisation is different from an organisation of syndicalists. What makes the
union syndicalist is its structure, aims and methods. Obviously things can
change (that is true of any organisation which has a democratic structure) but
that is a test revolutionary and anarcho-syndicalists welcome and do not shirk
from. As the union is self-managed from below up, its militancy and political
content is determined by its membership. As Pouget put it, the union _"offers
employers a degree of resistance in geometric proportion with the resistance
put up by its members."_ [**Op. Cit.**, p. 71] That is why syndicalists ensure
that power rests in the members of the union.

Syndicalists have two main approaches to building revolutionary unions --
**_"dual unionism"_** and **_"boring from within."_** The former approach
involves creating new, syndicalist, unions, in opposition to the existing
trade unions. This approach was historically and is currently the favoured way
of building syndicalist unions (American, Italian, Spanish, Swedish and
numerous other syndicalists built their own union federations in the heyday of
syndicalism between 1900 and 1920). "Boring from within" simply means working
within the existing trade unions in order to reform them and make them
syndicalist. This approach was favoured by French and British syndicalists,
plus a few American ones. However, these two approaches are not totally in
opposition. Many of the dual unions were created by syndicalists who had first
worked within the existing trade unions. Once they got sick of the
bureaucratic union machinery and of trying to reform it, they split from the
reformist unions and formed new, revolutionary, ones. Similarly, dual
unionists will happily support trade unionists in struggle and often be "two
carders" (i.e. members of both the trade union and the syndicalist one). See
[section J.5.3](secJ5.html#secj53) for more on anarchist perspectives on
existing trades unions.

Syndicalists no matter what tactics they prefer, favour autonomous workplace
organisations, controlled from below. Both tend to favour syndicalists forming
networks of militants to spread anarchist/syndicalist ideas within the
workplace. Indeed, such a network (usually called _"Industrial Networks"_ \--
see [section J.5.4](secJ5.html#secj54) for more details) would be an initial
stage and essential means for creating syndicalist unions. These groups would
encourage syndicalist tactics and rank and file organisation during struggles
and so create the potential for building syndicalist unions as libertarian
ideas spread and are seen to work.

Syndicalists think that such an organisation is essential for the successful
creation of an anarchist society as it builds the new world in the shell of
the old, making a sizeable majority of the population aware of anarchism and
the benefits of anarchist forms of organisation and struggle. Moreover, they
argue that those who reject syndicalism _"because it believes in a permanent
organisation of workers"_ and urge _"workers to organise 'spontaneously' at
the very moment of revolution"_ promote a _"con-trick, designed to leave 'the
revolutionary movement,' so called, in the hands of an educated class . . .
[or] so-called 'revolutionary party' . . . [which] means that the workers are
only expected to come in the fray when there's any fighting to be done, and in
normal times leave theorising to the specialists or students."_ [Albert
Meltzer, **Anarchism: Arguments for and Against**, pp. 82-3] A self-managed
society can only be created by self-managed means, and as only the practice of
self-management can ensure its success, the need for libertarian popular
organisations is essential. Syndicalism is seen as the key way working people
can prepare themselves for revolution and learn to direct their own lives. In
this way syndicalism creates a true politics of the people, one that does not
create a parasitic class of politicians and bureaucrats (_"We wish to
emancipate ourselves, to free ourselves"_, Pelloutier wrote, _"but we do not
wish to carry out a revolution, to risk our skin, to put Pierre the socialist
in the place of Paul the radical"_ [quoted by Jeremy Jennings, **Syndicalism
in France**, p. 17]).

This does not mean that syndicalists do not support organisations
spontaneously created by workers' in struggle (such as workers' councils,
factory committees and so on). Far from it. Syndicalists have played important
roles in these kinds of organisation (as can be seen from the Russian
Revolution, the factory occupations in Italy in 1920, the British Shop Steward
movement and so on). This is because syndicalism acts as a catalyst to
militant labour struggles and serves to counteract class-collaborationist
tendencies by union bureaucrats and "socialist" politicians. Part of this
activity must involve encouraging self-managed organisations where none exist
and so syndicalists support and encourage all such spontaneous movements,
hoping that they turn into the basis of a syndicalist union movement or a
successful revolution. Moreover, most anarcho-syndicalists recognise that it
is unlikely that every worker, nor even the majority, will be in syndicalist
unions before a revolutionary period starts. This means **new** organisations,
created spontaneously by workers in struggle, would have to be the framework
of social struggle and the post-capitalist society rather than the syndicalist
union as such. All the syndicalist union can do is provide a practical example
of how to organise in a libertarian way within capitalism and statism and
support spontaneously created organisations.

It should be noted that while the term "syndicalism" dates from the 1890s in
France, the ideas associated with these names have a longer history. Anarcho-
syndicalist ideas have developed independently in many different countries and
times. Indeed, anyone familiar with Bakunin's work will quickly see that much
of his ideas prefigure what was latter to become known by these terms.
Similarly, we find that the American **International Working People's
Association** organised by anarchists in the 1880s _"anticipated by some
twenty years the doctrine of anarcho-syndicalism"_ and _"[m]ore than merely
resembling the 'Chicago Idea' [of the **IWPA**], the IWW's principles of
industrial unionism resulted from the conscious efforts of anarchists . . .
who continued to affirm . . . the principles which the Chicago anarchists gave
their lives defending."_ [Salvatore Salerno, **Red November, Black November**,
p. 51 and p. 79] See [section H.2.8](secH2.html#sech28) for a discussion of
why Marxist claims that syndicalism and anarchism are unrelated are obviously
false.

(We must stress that we are **not** arguing that Bakunin "invented"
syndicalism. Far from it. Rather, we are arguing that Bakunin expressed ideas
already developed in working class circles and became, if you like, the
"spokesperson" for these libertarian tendencies in the labour movement as well
as helping to clarifying these ideas in many ways. As Emma Goldman argued, the
_"feature which distinguishes Syndicalism from most philosophies is that it
represents the revolutionary philosophy of labour conceived and born in the
actual struggle and experience of workers themselves -- not in universities,
colleges, libraries, or in the brain of some scientists."_ [**Op. Cit.**, pp.
88-9] This applies equally to Bakunin and the first International).

Given this, we must also point out here that while syndicalism has anarchist
roots, not all syndicalists are anarchists. A few Marxists have been
syndicalists, particularly in the USA where the followers of Daniel De Leon
supported Industrial Unionism and helped form the **Industrial Workers of the
World**. The Irish socialist James Connelly was also a Marxist-syndicalist, as
was Big Bill Haywood who was a leader of the IWW and a leading member of the
US Socialist Party. Marxist-syndicalists are generally in favour of more
centralisation within syndicalist unions (the IWW was by far the most
centralised syndicalist union) and often argue that a political party is
required to complement the work of the union. Needless to say, anarcho-
syndicalists disagree, arguing that centralisation kills the spirit of revolt
and weakens a unions real strength and that political parties are both
ineffective when compared to militant unionism and a constant source of
corruption. [Rocker, **Op. Cit.**, pp. 55-60] So not all syndicalists are
anarchists, leading those anarchists who are syndicalists to often use the
term "anarcho-syndicalism" to indicate that they are both anarchists and
syndicalists as well as to stress the libertarian roots of syndicalism. In
addition, not all anarchists are syndicalists. We discuss the reasons for this
in the [next section](secJ3.html#secj39).

For more information on anarcho-syndicalist ideas, Rudolf Rocker's **Anarcho-
Syndicalism** is still the classic introduction to the subject. The collection
of articles by British syndicalist Tom Brown entitled **Syndicalism** is also
worth reading. Daniel Guerin's **No Gods, No Masters** contains articles by
leading French syndicalist thinkers.

## J.3.9 Why are many anarchists not anarcho-syndicalists?

Before discussing why many anarchists are not anarcho-syndicalists, we must
clarify a few points first. Let us be clear, non-syndicalist anarchists
usually support the ideas of workplace organisation and struggle, of direct
action, of solidarity and so on. Thus most non-syndicalist anarchists do not
disagree with anarcho-syndicalists on these issues. Indeed, many even support
the creation of syndicalist unions. Thus many anarcho-communists like
Alexander Berkman, Errico Malatesta and Emma Goldman supported anarcho-
syndicalist organisations and even, like Malatesta, helped form such
revolutionary union federations (namely, the FORA in Argentina) and urged
anarchists to take a leading role in organising unions. So when we use the
term "non-syndicalist anarchist" we are not suggesting that these anarchists
reject all aspects of anarcho-syndicalism. Rather, they are critical of
certain aspects of anarcho-syndicalist ideas while supporting the rest.

In the past, a few communist-anarchists **did** oppose the struggle for
improvements within capitalism as "reformist." However, these were few and far
between and with the rise of anarcho-syndicalism in the 1890s, the vast
majority of communist-anarchists recognised that only by encouraging the
struggle for reforms would people take them seriously as this showed the
benefits of anarchist tactics and organisation in practice so ensuring
anarchist ideas grow in influence. Thus syndicalism was a healthy response to
the rise of "abstract revolutionarism" that infected the anarchist movement
during the 1880s, particularly in France and Italy. Thus communist-anarchists
agree with syndicalists on the importance of struggling for and winning
reforms and improvements within capitalism by direct action and solidarity.

Similarly, anarchists like Malatesta also recognised the importance of mass
organisations like unions. As he argued, _"to encourage popular organisations
of all kinds is the logical consequence of our basic ideas . . . An
authoritarian party, which aims at capturing power to impose its ideas, has an
interest in the people remaining an amorphous mass, unable to act for
themselves and therefore easily dominated . . . But we anarchists do not want
to **emancipate** the people; we want the people to **emancipate themselves**
. . . we want the new way of life to emerge from the body of the people and
correspond to the state of their development and advance as they advance."_
[**Errico Malatesta: His Life and Ideas**, p. 90] This can only occur when
there are popular organisations, like trade unions, within which people can
express themselves, come to common agreements and act. Moreover, these
organisations must be autonomous, self-governing, be libertarian in nature
**and** be independent of all parties and organisations (including anarchist
ones). The similarity with anarcho-syndicalist ideas is striking.

So why, if this is the case, are many anarchists not anarcho-syndicalists?
There are two main reasons for this. First, there is the question of whether
unions are, by their nature, revolutionary organisations. Second, whether
syndicalist unions are sufficient to create anarchy by themselves. We will
discuss each in turn.

As can be seen from any country, the vast majority of unions are deeply
reformist and bureaucratic in nature. They are centralised, with power resting
at the top in the hands of officials. This suggests that in themselves unions
are not revolutionary. As Malatesta argued, this is to be expected for _"all
movements founded on material and immediate interests (and a mass working
class movement cannot be founded on anything else), if the ferment, the drive
and the unremitting efforts of men [and women] of ideas struggling and making
sacrifices for an ideal future are lacking, tend to adapt themselves to
circumstances, foster a conservative spirit, and fear of change in those who
manage to improve their conditions, and often end up by creating new
privileged classes and serving to support and consolidate the system one would
want to destroy."_ [**Op. Cit.**, pp. 113-4]

If we look at the **role** of the union within capitalist society we see that
in order for it to work, it must offer a reason for the boss to recognise and
negotiate with it. This means that the union must be able to offer the boss
something in return for any reforms it gets, namely labour discipline. In
return for an improvement in wages or conditions, the union must be able to
get workers to agree to submit to the contracts the union signs with their
boss. In other words, they must be able to control their members -- stop them
fighting the boss -- if they are to have anything with which to bargain with.
This results in the union becoming a third force in industry, with interests
separate than the workers which it claims to represent. The role of unionism
as a seller of labour power means that it often has to make compromises,
compromises it has to make its members agree to. This necessities a tendency
for power to be taken from the rank and file of the unions and centralised in
the hands of officials at the top of the organisation. This ensures that _"the
workers organisation becomes what it must perforce be in a capitalist society
-- a means not of refusing to recognise and overthrowing the bosses, but
simply for hedging round and limiting the bosses' power."_ [Errico Malatesta,
**The Anarchist Revolution**, p. 29]

Anarcho-syndicalists are aware of this problem. That is why their unions are
decentralised, self-managed and organised from the bottom up in a federal
manner. As Durruti argued:

> _"No anarchists in the union committees unless at the ground level. In these
committees, in case of conflict with the boss, the militant is forced to
compromise to arrive at an agreement. The contracts and activities which come
from being in this position, push the militant towards bureaucracy. Conscious
of this risk, we do not wish to run it. Our role is to analyse from the bottom
the different dangers which can beset a union organisation like ours. No
militant should prolong his job in committees, beyond the time allotted to
him. No permanent and indispensable people."_ [quoted by Abel Paz, **Durruti:
The People Armed**, p. 183]

However, structure is rarely enough in itself to undermine the bureaucratic
tendencies created by the role of unions in the capitalist economy. While such
libertarian structures can slow down the tendency towards bureaucracy, non-
syndicalist anarchists argue that they cannot stop it. They point to the
example of the French CGT which had become reformist by 1914 (the majority of
other syndicalist unions were crushed by fascism or communism before they had
a chance to develop fully). Even the Spanish CNT (by far the most successful
anarcho-syndicalist union) suffered from the problem of reformism, causing the
anarchists in the union to organise the FAI in 1927 to combat it (which it
did, very successfully). According to Jose Peirats, the _"participation of the
anarchist group in the mass movement CNT helped to ensure the CNT's
revolutionary nature."_ This indicates the validity of Malatesta's arguments
concerning the need for anarchists to remain distinct of the unions
organisationally while working within them -- just as Peirat's comment that
_"[b]linkered by participation in union committees, the FAI became incapable
of a wider vision"_ indicates the validity of Malatesta's warnings against
anarchists taking positions of responsibility in unions! [**Anarchists in the
Spanish Revolution**, p. 241 and pp. 239-40]

Moreover, even the structure of syndicalist unions can cause problems: _"In
modelling themselves structurally on the bourgeois economy, the syndicalist
unions tended to become the organisational counterparts of the very
centralised apparatus they professed to oppose. By pleading the need to deal
effectively with the tightly knit bourgeoisie and state machinery, reformist
leaders in syndicalist unions often had little difficulty in shifting
organisational control from the bottom to the top."_ [Murray Bookchin, **The
Spanish Anarchists**, p. 123]

In addition, as the syndicalist unions grow in size and influence their
initial radicalism is usually watered-down. This is because, _"since the
unions must remain open to all those who desire to win from the masters better
conditions of life, whatever their opinions may be . . ., they are naturally
led to moderate their aspirations, first so that they should not frighten away
those they wish to have with them, and because, in proportion as numbers
increase, those with ideas who have initiated the movement remain buried in a
majority that is only occupied with the petty interests of the moment."_
[Errico Malatesta, **Anarchism and Syndicalism**, p. 150] Which, ironically
given that increased self-management is seen as a way of reducing tendencies
towards bureaucracy, means that syndicalist unions have a tendency towards
reformism simply because the majority of their members will be non-
revolutionary if the union grows in size in non-revolutionary times (as can be
seen from the development of the Swedish syndicalist union the SAC).

So, if the union's militant strategy succeeds in winning reforms, more and
more workers will join it. This influx of non-libertarians must, in a self-
managed organisation, exert a de-radicalising influence on the unions politics
and activities in non-revolutionary times. The syndicalist would argue that
the process of struggling for reforms combined with the educational effects of
participation and self-management will reduce this influence and, of course,
they are right. However, non-syndicalist anarchists would counter this by
arguing that the libertarian influences generated by struggle and
participation would be strengthened by the work of anarchist groups and,
without this work, the de-radicalising influences would outweigh the
libertarian ones. In addition, the success of a syndicalist union must be
partly determined by the general level of class struggle. In periods of great
struggle, the membership will be more radical than in quiet periods and it is
quiet periods which cause the most difficulties for syndicalist unions. With a
moderate membership the revolutionary aims and tactics of the union will also
become moderate. As one academic writer on French syndicalism put it,
syndicalism _"was always based on workers acting in the economic arena to
better their conditions, build class consciousness, and prepare for
revolution. The need to survive and build a working-class movement had always
forced syndicalists to adapt themselves to the exigencies of the moment."_
[Barbara Mitchell, _"French Syndicalism: An Experiment in Practical
Anarchism"_, pp. 25-41, **Revolutionary Syndicalism**, Marcel van der Linden
and Wayne Thorpe (eds.), p. 25]

As can be seen from the history of many syndicalist unions (and, obviously,
mainstream unions too) this seems to be the case -- the libertarian tendencies
are outweighed by the de-radicalising ones. This can also be seen from the
issue of collective bargaining:

> _"The problem of collective bargaining foreshadowed the difficulty of
maintaining syndicalist principles in developed capitalist societies. Many
organisations within the international syndicalist movement initially
repudiated collective agreements with employers on the grounds that by a
collaborative sharing of responsibility for work discipline, such agreements
would expand bureaucratisation within the unions, undermine revolutionary
spirit, and restrict the freedom of action that workers were always to
maintain against the class enemy. From an early date, however, sometimes after
a period of suspicion and resistance, many workers gave up this position. In
the early decades of the century it became clear that to maintain or gain a
mass membership, syndicalist unions had to accept collective bargaining."_
[Marcel van der Linden and Wayne Thorpe, **Op. Cit.**, p. 19]

Thus, for most anarchists, _"the Trade Unions are, by their very nature
reformist and never revolutionary. The revolutionary spirit must be
introduced, developed and maintained by the constant actions of
revolutionaries who work from within their ranks as well as from outside, but
it cannot be the normal, natural definition of the Trade Unions function."_
[Malatesta, **Errico Malatesta: His Life and Ideas**, p. 117]

This does not mean that anarchists should not work within labour
organisations. Nor does it mean rejecting anarcho-syndicalist unions as an
anarchist tactic. Far from it. Rather it is a case of recognising these
organisations for what they are, reformist organisations which are not an end
in themselves but one (albeit, important) means of preparing the way for the
achievement of anarchism. Neither does it mean that anarchists should not try
to make labour organisations as anarchistic as possible or have anarchist
objectives. Working within the labour movement (at the rank and file level, of
course) is essential to gain influence for anarchist ideas, just as is working
with unorganised workers. But this does not mean that the unions are
revolutionary by their very nature, as syndicalism implies. As history shows,
and as syndicalists themselves are aware, the vast majority of unions are
reformist. Non-syndicalist anarchists argue there is a reason for that and
syndicalist unions are not immune to these tendencies just because they call
themselves revolutionary. Due to these tendencies, non-syndicalist anarchists
stress the need to organise as anarchists first and foremost in order to
influence the class struggle and encourage the creation of autonomous
workplace and community organisations to fight that struggle. Rather than fuse
the anarchist and working class movement, non-syndicalist anarchists stress
the importance of anarchists organising as anarchists to influence the working
class movement.

All this does not mean that purely anarchist organisations or individual
anarchists cannot become reformist. Of course they can (just look at the
Spanish FAI which along with the CNT co-operated with the state during the
Spanish Revolution). However, unlike syndicalist unions, the anarchist
organisation is not pushed towards reformism due to its role within society.
That is an important difference -- the institutional factors are not present
for the anarchist federation as they are for the syndicalist union federation.

The second reason why many anarchists are not anarcho-syndicalists is the
question of whether syndicalist unions are sufficient in themselves to create
anarchy. Pierre Monatte, a French syndicalist, argued that _"Syndicalism, as
the [CGT's] Congress of Amiens proclaimed in 1906, is sufficient unto itself"_
as _"the working class, having at last attained majority, means to be self-
sufficient and to rely on no-one else for its emancipation."_ [**The Anarchist
Reader**, p. 219]

This idea of self-sufficiency means that the anarchist and the syndicalist
movement must be fused into one, with syndicalism taking the role of both
anarchist group and labour union. Thus a key difference between anarcho-
syndicalists and other anarchists is over the question of the need for a
specifically anarchist organisation. While most anarchists are sympathetic to
anarcho-syndicalism, few totally subscribe to anarcho-syndicalist ideas in
their pure form. This is because, in its pure form, syndicalism rejects the
idea of anarchist groups and instead considers the union as **the** focal
point of social struggle and anarchist activism. However, an anarcho-
syndicalist may support a specific anarchist federation to work within the
union and outside.

So anarchists critical of anarcho-syndicalism are also active in the labour
movement, working with the rank and file while keeping their own identity as
anarchists and organising as anarchists. Thus Malatesta: _"In the past I
deplored that the comrades isolated themselves from the working-class
movement. Today I deplore that many of us, falling into the contrary extreme,
let themselves be swallowed up in the same movement."_ [**Op. Cit.**, p. 225]
In the eyes of other anarchists anarcho-syndicalism in its "pure"
(revolutionary syndicalist) form makes the error of confusing the anarchist
and union movement and so ensures that the resulting movement can do neither
work well: _"Every fusion or confusion between the anarchist movement and the
trade union movement ends, either in rendering the later unable to carry out
its specific task or by weakening, distorting, or extinguishing the anarchist
spirit."_ [Malatesta, **Errico Malatesta: His Life and Ideas**, p. 123]

Most anarchists agree with Malatesta when he argued that _"anarchists must not
want the Trade Unions to be anarchist, but they must act within their ranks in
favour of anarchist aims, as individuals, as groups and as federations of
groups. . . [I]n the situation as it is, and recognising that the social
development of one's workmates is what it is, the anarchist groups should not
expect the workers' organisation to act as if they were anarchist, but should
make every effort to induce them to approximate as much as possible to the
anarchist method."_ [**Op. Cit.**, pp. 124-5] Given that it appears to be the
case that labour unions **are** by nature reformist, they cannot be expected
to be enough in themselves when creating a free society. Hence the need for
anarchists to organise **as anarchists** as well as alongside their fellow
workers as workers in order to spread anarchist ideas on tactics and aims.
This activity within existing unions does not necessarily mean attempting to
"reform" the union in a libertarian manner (although some anarchists would
support this approach). Rather it means working with the rank and file of the
unions and trying to create autonomous workplace organisations, independent of
the trade union bureaucracy and organised in a libertarian way.

This involves creating anarchist organisations separate from but which (in
part) work within the labour movement for anarchist ends. Let us not forget
that the syndicalist organisation is the union, it organises all workers
regardless of their politics. A "union" which just let anarchists join would
not be a union, it would be an anarchist group organised in the workplace. As
anarcho-syndicalists themselves are aware, an anarcho-syndicalist union is not
the same as a union of anarcho-syndicalists. How can we expect an organisation
made up of non-anarchists be totally anarchist? Due to this, tendencies always
appeared within syndicalist unions that were reformist and because of this
most anarchists, including many anarcho-syndicalists we must note, argue that
there is a need for anarchists to work within the rank and file of the unions
to spread their anarchist ideals and aims, and this implies anarchist
organisations separate from the labour movement, even if that movement is
based on syndicalist unions.

As Bakunin argued, the anarchist organisation _"is the necessary complement to
the International [i.e. the union federation]. But the International and the
Alliance [the anarchist federation], while having the same ultimate aims,
perform different functions. The International endeavours to unify the working
masses . . . regardless of nationality or religious and political beliefs,
into one compact body: the Alliance, on the other hand, tries to give these
masses a really revolutionary direction."_ This did not mean that the Alliance
was imposing a foreign theory onto the members of the unions, because the
_"programs of one and the other . . . differ only in the degree of their
revolutionary development . . . The program of the Alliance represents the
fullest unfolding of the International."_ [**Bakunin on Anarchism**, p. 157]
Nor did it imply that anarchists think that unions and other forms of popular
organisations should be controlled by anarchists. Far from it! Anarchists are
the strongest supporters of the autonomy of all popular organisations. As we
indicated in [section J.3.6](secJ3.html#secj36), anarchists desire to
influence popular organisations by the strength of our ideas within the rank
and file and **not** by imposing our ideas on them.

In addition to these major points of disagreement, there are minor ones as
well. For example, many anarchists dislike the emphasis syndicalists place on
the workplace and see _"in syndicalism a shift in focus from the commune to
the trade union, from all of the oppressed to the industrial proletariat
alone, from the streets to the factories, and, in emphasis at least, from
insurrection to the general strike."_ [Bookchin, **Op. Cit.**, p. 123]
However, most anarcho-syndicalists are well aware that life exists outside the
workplace and so this disagreement is largely one of emphasis. Similarly, many
anarchists disagreed with the early syndicalist argument that a general strike
was enough to create a revolution. They argued, with Malatesta in the
forefront, that while a general strike would be _"an excellent means for
starting the social revolution"_ it would be wrong to think that it made
_"armed insurrection unnecessary"_ since the _"first to die of hunger during a
general strike would not be the bourgeois, who dispose of all the stores, but
the workers."_ In order for this **not** to occur, the workers would need to
_"take over production"_ which are protected by the police and armed forces
and this meant _"insurrection."_ [Malatesta, **The Anarchist Reader**, pp.
223-4] Again, however, most modern syndicalists accept this to be the case and
see the _"expropriatory general strike,"_ in the words of French syndicalist
Pierre Besnard, as _"clearly **insurrectional.**"_ [quoted by Vernon Richards,
**Errico Malatesta: His Life and Ideas**, p. 288] We mention this purely to
counter Leninist claims that syndicalists subscribe to the same ideas they did
in the 1890s.

Despite our criticisms we should recognise that the difference between
anarchists and anarcho-syndicalists are slight and (often) just a case of
emphasis. Most anarchists support anarcho-syndicalist unions where they exist
and often take a key role in creating and organising them. Similarly, many
self-proclaimed anarcho-syndicalists also support specific organisations of
anarchists to work within and outwith the syndicalist union. Syndicalist
unions, where they exist, are far more progressive than any other union. Not
only are they democratic unions and create an atmosphere where anarchist ideas
are listened to with respect but they also organise and fight in a way that
breaks down the divisions into leaders and led, doers and watchers. On its own
this is very good but not good enough. For non-syndicalist anarchists, the
missing element is an organisation winning support for anarchist ideas and
tactics both within revolutionary unions and everywhere else working class
people come together.

For a further information on the anarchist criticism of syndicalism, we can
suggest no better source than the writings of Errico Malatesta. The books
**Errico Malatesta: His Life and Ideas** and **The Anarchist Revolution**
contain Malatesta's viewpoints on anarchism, syndicalism and how anarchists
should work within the labour movement. **The Anarchist Reader** contains the
famous debate between the syndicalist Pierre Monatte and Malatesta at the
International Anarchist conference in Amsterdam in 1907.

[‹ J.2 What is direct action?](/afaq/secJ2.html "Go to previous page" )
[up](/afaq/secJcon.html "Go to parent page" ) [J.4 What trends in society aid
anarchist activity? ›](/afaq/secJ4.html "Go to next page" )

