// Copyright 2018 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/app/chrome_packaged_service_manifests.h"

#include "base/no_destructor.h"
#include "build/build_config.h"
#include "chrome/common/buildflags.h"
#include "chrome/common/constants.mojom.h"
#include "chrome/services/file_util/manifest.h"
#include "chrome/services/noop/manifest.h"
#include "components/services/patch/manifest.h"
#include "components/services/unzip/manifest.h"
#include "components/spellcheck/common/spellcheck.mojom.h"
#include "components/startup_metric_utils/common/startup_metric.mojom.h"
#include "device/vr/buildflags/buildflags.h"
#include "extensions/buildflags/buildflags.h"
#include "printing/buildflags/buildflags.h"
#include "services/preferences/local_state_manifest.h"
#include "services/proxy_resolver/proxy_resolver_manifest.h"
#include "services/service_manager/public/cpp/manifest_builder.h"

#if defined(OS_CHROMEOS)
#include "ash/components/quick_launch/manifest.h"
#include "ash/components/shortcut_viewer/manifest.h"
#include "ash/components/tap_visualizer/manifest.h"
#include "ash/manifest.h"
#include "chrome/browser/chromeos/ash_pref_connector_manifest.h"
#include "chrome/services/cups_ipp_parser/manifest.h"
#include "chromeos/services/ime/manifest.h"
#include "chromeos/services/secure_channel/manifest.h"
#include "mash/public/mojom/launchable.mojom.h"  // nogncheck
#include "services/ws/public/mojom/input_devices/input_device_controller.mojom.h"
#include "ui/accessibility/manifest.h"  // nogncheck
#endif

#if defined(OS_MACOSX)
#include "components/spellcheck/common/spellcheck_panel.mojom.h"
#endif

#if defined(OS_WIN)
#include "chrome/services/util_win/manifest.h"
#include "chrome/services/wifi_util_win/manifest.h"
#endif

#if !defined(OS_ANDROID)
#include "chrome/utility/profile_import_manifest.h"
#include "components/mirroring/service/manifest.h"  // nogncheck
#endif

#if BUILDFLAG(ENABLE_EXTENSIONS)
#include "chrome/services/removable_storage_writer/manifest.h"
#endif

#if BUILDFLAG(ENABLE_EXTENSIONS) || defined(OS_ANDROID)
#include "chrome/services/media_gallery_util/manifest.h"
#endif

#if BUILDFLAG(ENABLE_PRINTING)
#include "components/services/pdf_compositor/pdf_compositor_manifest.h"  // nogncheck
#endif

#if BUILDFLAG(ENABLE_PRINT_PREVIEW)
#include "chrome/services/printing/manifest.h"
#endif

#if BUILDFLAG(ENABLE_ISOLATED_XR_SERVICE)
#include "chrome/services/isolated_xr_device/manifest.h"
#endif

#if BUILDFLAG(ENABLE_SIMPLE_BROWSER_SERVICE_IN_PROCESS) || \
    BUILDFLAG(ENABLE_SIMPLE_BROWSER_SERVICE_OUT_OF_PROCESS)
#include "services/content/simple_browser/manifest.h"  // nogncheck
#endif

namespace {

const service_manager::Manifest& GetChromeManifest() {
  static base::NoDestructor<service_manager::Manifest> manifest {
    service_manager::ManifestBuilder()
        .WithServiceName(chrome::mojom::kServiceName)
        .WithDisplayName("Chrome")
        .WithOptions(service_manager::ManifestOptionsBuilder()
                         .WithInstanceSharingPolicy(
                             service_manager::Manifest::InstanceSharingPolicy::
                                 kSharedAcrossGroups)
                         .CanConnectToInstancesWithAnyId(true)
                         .CanRegisterOtherServiceInstances(true)
                         .Build())
        .ExposeCapability("renderer",
                          service_manager::Manifest::InterfaceList<
#if defined(OS_MACOSX)
                              spellcheck::mojom::SpellCheckPanelHost,
#endif
                              spellcheck::mojom::SpellCheckHost,
                              startup_metric_utils::mojom::StartupMetricHost>())
#if defined(OS_CHROMEOS)
        // Only used in the classic Ash case.
        .ExposeCapability("input_device_controller",
                          service_manager::Manifest::InterfaceList<
                              ws::mojom::InputDeviceController>())
        .ExposeCapability(
            "mash:launchable",
            service_manager::Manifest::InterfaceList<mash::mojom::Launchable>())
#endif
        .RequireCapability(chrome::mojom::kRendererServiceName, "browser")
        .Build()
  };
  return *manifest;
}

#if defined(OS_ANDROID)
const service_manager::Manifest& GetAndroidDownloadManagerManifest() {
  static base::NoDestructor<service_manager::Manifest> manifest{
      service_manager::ManifestBuilder()
          .WithServiceName("download_manager")
          .WithDisplayName("Download Manager")
          .WithOptions(service_manager::ManifestOptionsBuilder()
                           .WithInstanceSharingPolicy(
                               service_manager::Manifest::
                                   InstanceSharingPolicy::kSingleton)
                           .Build())
          .RequireCapability("network", "network_service")
          .Build()};
  return *manifest;
}
#endif

}  // namespace

const std::vector<service_manager::Manifest>&
GetChromePackagedServiceManifests() {
  static base::NoDestructor<std::vector<service_manager::Manifest>> manifests{{
      GetChromeManifest(),
      patch_service::GetManifest(),
      unzip_service::GetManifest(),
      file_util::GetManifest(),
      proxy_resolver::GetManifest(),
      local_state::GetManifest(),
      noop::GetManifest(),
#if BUILDFLAG(ENABLE_EXTENSIONS)
      removable_storage_writer::GetManifest(),
#endif
#if BUILDFLAG(ENABLE_EXTENSIONS) || defined(OS_ANDROID)
      media_gallery_util::GetManifest(),
#endif
#if BUILDFLAG(ENABLE_PRINTING)
      pdf_compositor::GetManifest(),
#endif
#if BUILDFLAG(ENABLE_PRINT_PREVIEW)
      chrome_printing::GetManifest(),
#endif
#if BUILDFLAG(ENABLE_ISOLATED_XR_SERVICE)
      xr_device_service::GetManifest(),
#endif
#if BUILDFLAG(ENABLE_SIMPLE_BROWSER_SERVICE_IN_PROCESS) || \
    BUILDFLAG(ENABLE_SIMPLE_BROWSER_SERVICE_OUT_OF_PROCESS)
      simple_browser::GetManifest(),
#endif
#if defined(OS_WIN)
      util_win::GetManifest(),
      wifi_util_win::GetManifest(),
#endif
#if defined(OS_ANDROID)
      GetAndroidDownloadManagerManifest(),
#else
      mirroring::GetManifest(),
      profile_import::GetManifest(),
#endif
#if defined(OS_CHROMEOS)
      quick_launch_app::GetManifest(),
      shortcut_viewer_app::GetManifest(),
      tap_visualizer_app::GetManifest(),
      ash::GetManifest(),
      ash_pref_connector::GetManifest(),
      cups_ipp_parser::GetManifest(),
      ime::GetManifest(),
      secure_channel::GetManifest(),
      ax_host_service::GetManifest(),
#endif
  }};
  return *manifests;
}
