/* Generated by wayland-scanner 1.14.0 */

#ifndef AURA_SHELL_SERVER_PROTOCOL_H
#define AURA_SHELL_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_aura_shell The aura_shell protocol
 * @section page_ifaces_aura_shell Interfaces
 * - @subpage page_iface_zaura_shell - aura_shell
 * - @subpage page_iface_zaura_surface - aura shell interface to a wl_surface
 * - @subpage page_iface_zaura_output - aura shell interface to a wl_output
 * @section page_copyright_aura_shell Copyright
 * <pre>
 *
 * Copyright 2017 The Chromium Authors.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_output;
struct wl_surface;
struct zaura_output;
struct zaura_shell;
struct zaura_surface;

/**
 * @page page_iface_zaura_shell zaura_shell
 * @section page_iface_zaura_shell_desc Description
 *
 * The global interface exposing aura shell capabilities is used to
 * instantiate an interface extension for a wl_surface object.
 * This extended interface will then allow the client to use aura shell
 * specific functionality.
 * @section page_iface_zaura_shell_api API
 * See @ref iface_zaura_shell.
 */
/**
 * @defgroup iface_zaura_shell The zaura_shell interface
 *
 * The global interface exposing aura shell capabilities is used to
 * instantiate an interface extension for a wl_surface object.
 * This extended interface will then allow the client to use aura shell
 * specific functionality.
 */
extern const struct wl_interface zaura_shell_interface;
/**
 * @page page_iface_zaura_surface zaura_surface
 * @section page_iface_zaura_surface_desc Description
 *
 * An additional interface to a wl_surface object, which allows the
 * client to access aura shell specific functionality for surface.
 * @section page_iface_zaura_surface_api API
 * See @ref iface_zaura_surface.
 */
/**
 * @defgroup iface_zaura_surface The zaura_surface interface
 *
 * An additional interface to a wl_surface object, which allows the
 * client to access aura shell specific functionality for surface.
 */
extern const struct wl_interface zaura_surface_interface;
/**
 * @page page_iface_zaura_output zaura_output
 * @section page_iface_zaura_output_desc Description
 *
 * An additional interface to a wl_output object, which allows the
 * client to access aura shell specific functionality for output.
 * @section page_iface_zaura_output_api API
 * See @ref iface_zaura_output.
 */
/**
 * @defgroup iface_zaura_output The zaura_output interface
 *
 * An additional interface to a wl_output object, which allows the
 * client to access aura shell specific functionality for output.
 */
extern const struct wl_interface zaura_output_interface;

#ifndef ZAURA_SHELL_ERROR_ENUM
#define ZAURA_SHELL_ERROR_ENUM
enum zaura_shell_error {
	/**
	 * the surface already has an aura surface object associated
	 */
	ZAURA_SHELL_ERROR_AURA_SURFACE_EXISTS = 0,
	/**
	 * the output already has an aura output object associated
	 */
	ZAURA_SHELL_ERROR_AURA_OUTPUT_EXISTS = 1,
};
#endif /* ZAURA_SHELL_ERROR_ENUM */

/**
 * @ingroup iface_zaura_shell
 * @struct zaura_shell_interface
 */
struct zaura_shell_interface {
	/**
	 * extend surface interface for aura shell
	 *
	 * Instantiate an interface extension for the given wl_surface to
	 * provide aura shell functionality. If the given wl_surface is not
	 * associated with a shell surface, the shell_surface_missing
	 * protocol error is raised.
	 * @param id the new aura surface interface id
	 * @param surface the surface
	 */
	void (*get_aura_surface)(struct wl_client *client,
				 struct wl_resource *resource,
				 uint32_t id,
				 struct wl_resource *surface);
	/**
	 * extend output interface for aura shell
	 *
	 * Instantiate an interface extension for the given wl_output to
	 * provide aura shell functionality.
	 * @param id the new aura output interface id
	 * @param output the output
	 * @since 2
	 */
	void (*get_aura_output)(struct wl_client *client,
				struct wl_resource *resource,
				uint32_t id,
				struct wl_resource *output);
};


/**
 * @ingroup iface_zaura_shell
 */
#define ZAURA_SHELL_GET_AURA_SURFACE_SINCE_VERSION 1
/**
 * @ingroup iface_zaura_shell
 */
#define ZAURA_SHELL_GET_AURA_OUTPUT_SINCE_VERSION 2

#ifndef ZAURA_SURFACE_FRAME_TYPE_ENUM
#define ZAURA_SURFACE_FRAME_TYPE_ENUM
/**
 * @ingroup iface_zaura_surface
 * different frame types
 *
 * Frame types that can be used to decorate a surface.
 */
enum zaura_surface_frame_type {
	/**
	 * no frame
	 */
	ZAURA_SURFACE_FRAME_TYPE_NONE = 0,
	/**
	 * caption with shadow
	 */
	ZAURA_SURFACE_FRAME_TYPE_NORMAL = 1,
	/**
	 * shadow only
	 */
	ZAURA_SURFACE_FRAME_TYPE_SHADOW = 2,
};
#endif /* ZAURA_SURFACE_FRAME_TYPE_ENUM */

/**
 * @ingroup iface_zaura_surface
 * @struct zaura_surface_interface
 */
struct zaura_surface_interface {
	/**
	 * request a frame for surface
	 *
	 * Suggests a surface should use a specific frame.
	 * @param type the new frame type
	 */
	void (*set_frame)(struct wl_client *client,
			  struct wl_resource *resource,
			  uint32_t type);
	/**
	 * set the parent of this surface
	 *
	 * Set the "parent" of this surface. "x" and "y" arguments
	 * specify the initial position for surface relative to parent.
	 * @since 2
	 */
	void (*set_parent)(struct wl_client *client,
			   struct wl_resource *resource,
			   struct wl_resource *parent,
			   int32_t x,
			   int32_t y);
	/**
	 * set the frame colors of this surface
	 *
	 * Set the frame colors.
	 * @param active_color 32 bit ARGB color value, not premultiplied
	 * @param inactive_color 32 bit ARGB color value, not premultiplied
	 * @since 3
	 */
	void (*set_frame_colors)(struct wl_client *client,
				 struct wl_resource *resource,
				 uint32_t active_color,
				 uint32_t inactive_color);
	/**
	 * set the startup ID of this surface
	 *
	 * Set the startup ID.
	 * @since 4
	 */
	void (*set_startup_id)(struct wl_client *client,
			       struct wl_resource *resource,
			       const char *startup_id);
	/**
	 * set the application ID of this surface
	 *
	 * Set the application ID.
	 * @since 5
	 */
	void (*set_application_id)(struct wl_client *client,
				   struct wl_resource *resource,
				   const char *application_id);
	/**
	 * set the client surface ID of this surface
	 *
	 * Set the identifier of the surface assigned by the client.
	 * @since 7
	 */
	void (*set_client_surface_id)(struct wl_client *client,
				      struct wl_resource *resource,
				      int32_t client_surface_id);
};


/**
 * @ingroup iface_zaura_surface
 */
#define ZAURA_SURFACE_SET_FRAME_SINCE_VERSION 1
/**
 * @ingroup iface_zaura_surface
 */
#define ZAURA_SURFACE_SET_PARENT_SINCE_VERSION 2
/**
 * @ingroup iface_zaura_surface
 */
#define ZAURA_SURFACE_SET_FRAME_COLORS_SINCE_VERSION 3
/**
 * @ingroup iface_zaura_surface
 */
#define ZAURA_SURFACE_SET_STARTUP_ID_SINCE_VERSION 4
/**
 * @ingroup iface_zaura_surface
 */
#define ZAURA_SURFACE_SET_APPLICATION_ID_SINCE_VERSION 5
/**
 * @ingroup iface_zaura_surface
 */
#define ZAURA_SURFACE_SET_CLIENT_SURFACE_ID_SINCE_VERSION 7

#ifndef ZAURA_OUTPUT_SCALE_PROPERTY_ENUM
#define ZAURA_OUTPUT_SCALE_PROPERTY_ENUM
/**
 * @ingroup iface_zaura_output
 * scale information
 *
 * These flags describe properties of an output scale.
 * They are used in the flags bitfield of the scale event.
 */
enum zaura_output_scale_property {
	/**
	 * indicates this is the current scale
	 */
	ZAURA_OUTPUT_SCALE_PROPERTY_CURRENT = 0x1,
	/**
	 * indicates this is the preferred scale
	 */
	ZAURA_OUTPUT_SCALE_PROPERTY_PREFERRED = 0x2,
};
#endif /* ZAURA_OUTPUT_SCALE_PROPERTY_ENUM */

#ifndef ZAURA_OUTPUT_SCALE_FACTOR_ENUM
#define ZAURA_OUTPUT_SCALE_FACTOR_ENUM
enum zaura_output_scale_factor {
	ZAURA_OUTPUT_SCALE_FACTOR_0400 = 400,
	ZAURA_OUTPUT_SCALE_FACTOR_0500 = 500,
	ZAURA_OUTPUT_SCALE_FACTOR_0550 = 550,
	ZAURA_OUTPUT_SCALE_FACTOR_0600 = 600,
	ZAURA_OUTPUT_SCALE_FACTOR_0625 = 625,
	ZAURA_OUTPUT_SCALE_FACTOR_0650 = 650,
	ZAURA_OUTPUT_SCALE_FACTOR_0700 = 700,
	ZAURA_OUTPUT_SCALE_FACTOR_0750 = 750,
	ZAURA_OUTPUT_SCALE_FACTOR_0800 = 800,
	ZAURA_OUTPUT_SCALE_FACTOR_0850 = 850,
	ZAURA_OUTPUT_SCALE_FACTOR_0900 = 900,
	ZAURA_OUTPUT_SCALE_FACTOR_0950 = 950,
	ZAURA_OUTPUT_SCALE_FACTOR_1000 = 1000,
	ZAURA_OUTPUT_SCALE_FACTOR_1050 = 1050,
	ZAURA_OUTPUT_SCALE_FACTOR_1100 = 1100,
	ZAURA_OUTPUT_SCALE_FACTOR_1150 = 1150,
	ZAURA_OUTPUT_SCALE_FACTOR_1125 = 1125,
	ZAURA_OUTPUT_SCALE_FACTOR_1200 = 1200,
	ZAURA_OUTPUT_SCALE_FACTOR_1250 = 1250,
	ZAURA_OUTPUT_SCALE_FACTOR_1300 = 1300,
	ZAURA_OUTPUT_SCALE_FACTOR_1400 = 1400,
	ZAURA_OUTPUT_SCALE_FACTOR_1450 = 1450,
	ZAURA_OUTPUT_SCALE_FACTOR_1500 = 1500,
	ZAURA_OUTPUT_SCALE_FACTOR_1600 = 1600,
	ZAURA_OUTPUT_SCALE_FACTOR_1750 = 1750,
	ZAURA_OUTPUT_SCALE_FACTOR_1800 = 1800,
	ZAURA_OUTPUT_SCALE_FACTOR_2000 = 2000,
	ZAURA_OUTPUT_SCALE_FACTOR_2200 = 2200,
	ZAURA_OUTPUT_SCALE_FACTOR_2250 = 2250,
	ZAURA_OUTPUT_SCALE_FACTOR_2500 = 2500,
	ZAURA_OUTPUT_SCALE_FACTOR_2750 = 2750,
	ZAURA_OUTPUT_SCALE_FACTOR_3000 = 3000,
	ZAURA_OUTPUT_SCALE_FACTOR_3500 = 3500,
	ZAURA_OUTPUT_SCALE_FACTOR_4000 = 4000,
	ZAURA_OUTPUT_SCALE_FACTOR_4500 = 4500,
	ZAURA_OUTPUT_SCALE_FACTOR_5000 = 5000,
};
#endif /* ZAURA_OUTPUT_SCALE_FACTOR_ENUM */

#ifndef ZAURA_OUTPUT_CONNECTION_TYPE_ENUM
#define ZAURA_OUTPUT_CONNECTION_TYPE_ENUM
enum zaura_output_connection_type {
	ZAURA_OUTPUT_CONNECTION_TYPE_UNKNOWN = 0,
	ZAURA_OUTPUT_CONNECTION_TYPE_INTERNAL = 1,
};
#endif /* ZAURA_OUTPUT_CONNECTION_TYPE_ENUM */

#define ZAURA_OUTPUT_SCALE 0
#define ZAURA_OUTPUT_CONNECTION 1
#define ZAURA_OUTPUT_DEVICE_SCALE_FACTOR 2

/**
 * @ingroup iface_zaura_output
 */
#define ZAURA_OUTPUT_SCALE_SINCE_VERSION 2
/**
 * @ingroup iface_zaura_output
 */
#define ZAURA_OUTPUT_CONNECTION_SINCE_VERSION 5
/**
 * @ingroup iface_zaura_output
 */
#define ZAURA_OUTPUT_DEVICE_SCALE_FACTOR_SINCE_VERSION 5


/**
 * @ingroup iface_zaura_output
 * Sends an scale event to the client owning the resource.
 * @param resource_ The client's resource
 * @param flags bitfield of scale flags
 * @param scale output scale
 */
static inline void
zaura_output_send_scale(struct wl_resource *resource_, uint32_t flags, uint32_t scale)
{
	wl_resource_post_event(resource_, ZAURA_OUTPUT_SCALE, flags, scale);
}

/**
 * @ingroup iface_zaura_output
 * Sends an connection event to the client owning the resource.
 * @param resource_ The client's resource
 * @param connection output connection
 */
static inline void
zaura_output_send_connection(struct wl_resource *resource_, uint32_t connection)
{
	wl_resource_post_event(resource_, ZAURA_OUTPUT_CONNECTION, connection);
}

/**
 * @ingroup iface_zaura_output
 * Sends an device_scale_factor event to the client owning the resource.
 * @param resource_ The client's resource
 * @param scale output device scale factor
 */
static inline void
zaura_output_send_device_scale_factor(struct wl_resource *resource_, uint32_t scale)
{
	wl_resource_post_event(resource_, ZAURA_OUTPUT_DEVICE_SCALE_FACTOR, scale);
}

#ifdef  __cplusplus
}
#endif

#endif
